/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CompressedRefs {
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Int2ObjectMap<IntArrayList> myTags;
    @NotNull
    private final Int2ObjectMap<List<VcsRef>> myBranches;

    public CompressedRefs(@NotNull Set<VcsRef> refs, @NotNull VcsLogStorage storage2) {
        if (refs == null) {
            CompressedRefs.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            CompressedRefs.$$$reportNull$$$0(1);
        }
        this.myTags = new Int2ObjectOpenHashMap();
        this.myBranches = new Int2ObjectOpenHashMap();
        this.myStorage = storage2;
        Ref root2 = new Ref();
        refs.forEach(ref -> {
            assert (root2.get() == null || ((VirtualFile)root2.get()).equals(ref.getRoot())) : "All references are supposed to be from the single root";
            root2.set((Object)ref.getRoot());
            if (ref.getType().isBranch()) {
                CompressedRefs.putRef(this.myBranches, ref, this.myStorage);
            } else {
                CompressedRefs.putRefIndex(this.myTags, ref, this.myStorage);
            }
        });
        this.myTags.values().forEach(list2 -> list2.trim());
        this.myStorage.flush();
    }

    boolean contains(int index2) {
        return this.myBranches.containsKey(index2) || this.myTags.containsKey(index2);
    }

    @NotNull
    SmartList<VcsRef> refsToCommit(int index2) {
        IntList tags;
        SmartList result2 = new SmartList();
        if (this.myBranches.containsKey(index2)) {
            result2.addAll((Collection)this.myBranches.get(index2));
        }
        if ((tags = (IntList)this.myTags.get(index2)) != null) {
            tags.forEach(value2 -> result2.add((Object)this.myStorage.getVcsRef(value2)));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            CompressedRefs.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public Stream<VcsRef> streamBranches() {
        Stream<VcsRef> stream = this.myBranches.values().stream().flatMap(Collection::stream);
        if (stream == null) {
            CompressedRefs.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @NotNull
    private Stream<VcsRef> streamTags() {
        Stream<VcsRef> stream = this.myTags.values().stream().flatMapToInt(IntCollection::intStream).mapToObj(this.myStorage::getVcsRef);
        if (stream == null) {
            CompressedRefs.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    public Stream<VcsRef> stream() {
        Stream<VcsRef> stream = Stream.concat(this.streamBranches(), this.streamTags());
        if (stream == null) {
            CompressedRefs.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    public Collection<VcsRef> getRefs() {
        return new AbstractCollection<VcsRef>(){
            private final Supplier<Collection<VcsRef>> myLoadedRefs = Suppliers.memoize(() -> CompressedRefs.this.stream().collect(Collectors.toList()));

            @Override
            @NotNull
            public Iterator<VcsRef> iterator() {
                Iterator<VcsRef> iterator2 = ((Collection)this.myLoadedRefs.get()).iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            @Override
            public int size() {
                return ((Collection)this.myLoadedRefs.get()).size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs$1", "iterator"));
            }
        };
    }

    @NotNull
    public Collection<Integer> getCommits() {
        HashSet<Integer> result2 = new HashSet<Integer>();
        this.myBranches.keySet().intStream().forEach(result2::add);
        this.myTags.keySet().intStream().forEach(result2::add);
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            CompressedRefs.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static void putRef(@NotNull Int2ObjectMap<List<VcsRef>> map2, @NotNull VcsRef ref, @NotNull VcsLogStorage storage2) {
        int index2;
        List list2;
        if (map2 == null) {
            CompressedRefs.$$$reportNull$$$0(7);
        }
        if (ref == null) {
            CompressedRefs.$$$reportNull$$$0(8);
        }
        if (storage2 == null) {
            CompressedRefs.$$$reportNull$$$0(9);
        }
        if ((list2 = (List)map2.get(index2 = storage2.getCommitIndex(ref.getCommitHash(), ref.getRoot()))) == null) {
            list2 = new SmartList();
            map2.put(index2, (Object)list2);
        }
        list2.add(ref);
    }

    private static void putRefIndex(@NotNull Int2ObjectMap<IntArrayList> map2, @NotNull VcsRef ref, @NotNull VcsLogStorage storage2) {
        int index2;
        IntArrayList list2;
        if (map2 == null) {
            CompressedRefs.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            CompressedRefs.$$$reportNull$$$0(11);
        }
        if (storage2 == null) {
            CompressedRefs.$$$reportNull$$$0(12);
        }
        if ((list2 = (IntArrayList)map2.get(index2 = storage2.getCommitIndex(ref.getCommitHash(), ref.getRoot()))) == null) {
            list2 = new IntArrayList();
            map2.put(index2, (Object)list2);
        }
        list2.add(storage2.getRefIndex(ref));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/CompressedRefs";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/CompressedRefs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "refsToCommit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "streamBranches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "streamTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putRef";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putRefIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

