/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.StorageLockContext;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull StorageId storageId, @NotNull VcsLogStorage storage2, @NotNull Set<VirtualFile> roots2, @Nullable StorageLockContext storageLockContext, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(1);
        }
        if (roots2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(2);
        }
        if (fatalErrorHandler == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(3);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(4);
        }
        super(storageId, PATHS, new PathsIndexer(storage2, VcsLogPathsIndex.createPathsEnumerator(roots2, storageId, storageLockContext), VcsLogPathsIndex.createRenamesMap(storageId, storageLockContext)), new ChangeKindListKeyDescriptor(), storageLockContext, fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> fatalErrorHandler.consume(this, (Throwable)e)));
    }

    @NotNull
    private static PersistentEnumerator<LightFilePath> createPathsEnumerator(@NotNull Collection<VirtualFile> roots2, @NotNull StorageId storageId, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (roots2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(5);
        }
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(6);
        }
        Path storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        return new PersistentEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(roots2), Page.PAGE_SIZE, storageLockContext, storageId.getVersion());
    }

    @NotNull
    private static PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> createRenamesMap(@NotNull StorageId storageId, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(7);
        }
        Path storageFile = storageId.getStorageFile(RENAMES_MAP);
        return new PersistentHashMap(storageFile, (KeyDescriptor)new CoupleKeyDescriptor(), (DataExternalizer)new CollectionDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion(), storageLockContext);
    }

    @Nullable
    private FilePath getPath(int pathId, boolean isDirectory) {
        try {
            return VcsLogPathsIndex.toFilePath((LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId), isDirectory);
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child2, @NotNull VirtualFile root2, @NotNull FilePath path2, boolean isChildPath) throws IOException {
        Collection renames;
        if (root2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(8);
        }
        if (path2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(9);
        }
        if ((renames = (Collection)this.myPathsIndexer.myRenamesMap.get((Object)Couple.of((Object)parent, (Object)child2))) == null) {
            return null;
        }
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root2, path2));
        for (Couple rename2 : renames) {
            if ((!isChildPath || (Integer)rename2.second != pathId) && (isChildPath || (Integer)rename2.first != pathId)) continue;
            FilePath path1 = this.getPath((Integer)rename2.first, path2.isDirectory());
            FilePath path22 = this.getPath((Integer)rename2.second, path2.isDirectory());
            return new EdgeData<FilePath>(path1, path22);
        }
        return null;
    }

    public void iterateCommits(@NotNull VirtualFile root2, @NotNull FilePath path2, @NotNull ObjIntConsumer<? super List<ChangeKind>> consumer2) throws IOException, StorageException {
        if (root2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(11);
        }
        if (consumer2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(12);
        }
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root2, path2));
        this.iterateCommitIdsAndValues(pathId, consumer2);
    }

    @NotNull
    VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return new VcsLogIndexer.PathsEncoder(){

            @Override
            public int encode(@NotNull VirtualFile root2, @NotNull String relativePath, boolean isDirectory) {
                if (root2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (relativePath == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    return VcsLogPathsIndex.this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root2, relativePath));
                }
                catch (IOException e) {
                    VcsLogPathsIndex.this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
                    return 0;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "relativePath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$1";
                objectArray[2] = "encode";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.myRenamesMap.close();
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @Nullable
    private static FilePath toFilePath(@Nullable LightFilePath lightFilePath, boolean isDirectory) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)(lightFilePath.getRoot().getPath() + "/" + lightFilePath.getRelativePath()), (boolean)isDirectory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createPathsEnumerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamesMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findRename";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateCommits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CollectionDataExternalizer
    implements DataExternalizer<Collection<Couple<Integer>>> {
        private CollectionDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<Couple<Integer>> value2) throws IOException {
            if (out == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value2.size());
            for (Couple<Integer> v : value2) {
                out.writeInt((Integer)v.first);
                out.writeInt((Integer)v.second);
            }
        }

        public Collection<Couple<Integer>> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(1);
            }
            SmartList result2 = new SmartList();
            int size = in.readInt();
            for (int i2 = 0; i2 < size; ++i2) {
                result2.add(Couple.of((Object)in.readInt(), (Object)in.readInt()));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$CollectionDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CoupleKeyDescriptor
    implements KeyDescriptor<Couple<Integer>> {
        private CoupleKeyDescriptor() {
        }

        public int getHashCode(Couple<Integer> value2) {
            return value2.hashCode();
        }

        public boolean isEqual(Couple<Integer> val1, Couple<Integer> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Couple<Integer> value2) throws IOException {
            if (out == null) {
                CoupleKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.writeInt((Integer)value2.first);
            out.writeInt((Integer)value2.second);
        }

        public Couple<Integer> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CoupleKeyDescriptor.$$$reportNull$$$0(1);
            }
            return Couple.of((Object)in.readInt(), (Object)in.readInt());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$CoupleKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LightFilePathKeyDescriptor
    implements KeyDescriptor<LightFilePath> {
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final Object2IntMap<VirtualFile> myRootsReversed;

        private LightFilePathKeyDescriptor(@NotNull Collection<VirtualFile> roots2) {
            if (roots2 == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = ContainerUtil.sorted(roots2, Comparator.comparing(VirtualFile::getPath));
            this.myRootsReversed = new Object2IntOpenHashMap();
            for (int i2 = 0; i2 < this.myRoots.size(); ++i2) {
                this.myRootsReversed.put((Object)this.myRoots.get(i2), i2);
            }
        }

        public int getHashCode(LightFilePath path2) {
            return path2.hashCode();
        }

        public boolean isEqual(LightFilePath path1, LightFilePath path2) {
            return path1.equals(path2);
        }

        public void save(@NotNull DataOutput out, LightFilePath value2) throws IOException {
            if (out == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(1);
            }
            out.writeInt(this.myRootsReversed.getInt((Object)value2.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value2.getRelativePath());
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            int rootIndex;
            VirtualFile root2;
            if (in == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(2);
            }
            if ((root2 = this.myRoots.get(rootIndex = in.readInt())) == null) {
                throw new IOException("Can not read root for index " + rootIndex + ". All roots " + this.myRoots);
            }
            String path2 = IOUtil.readUTF((DataInput)in);
            return new LightFilePath(root2, path2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LightFilePath {
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final String myRelativePath;

        private LightFilePath(@NotNull VirtualFile root2, @NotNull String relativePath) {
            if (root2 == null) {
                LightFilePath.$$$reportNull$$$0(0);
            }
            if (relativePath == null) {
                LightFilePath.$$$reportNull$$$0(1);
            }
            this.myRoot = root2;
            this.myRelativePath = relativePath;
        }

        private LightFilePath(@NotNull VirtualFile root2, @NotNull FilePath filePath) {
            if (root2 == null) {
                LightFilePath.$$$reportNull$$$0(2);
            }
            if (filePath == null) {
                LightFilePath.$$$reportNull$$$0(3);
            }
            this(root2, VcsFileUtil.relativePath(root2, filePath));
        }

        @NotNull
        public VirtualFile getRoot() {
            VirtualFile virtualFile2 = this.myRoot;
            if (virtualFile2 == null) {
                LightFilePath.$$$reportNull$$$0(4);
            }
            return virtualFile2;
        }

        @NotNull
        public String getRelativePath() {
            String string = this.myRelativePath;
            if (string == null) {
                LightFilePath.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightFilePath path2 = (LightFilePath)o;
            return this.myRoot.equals(path2.myRoot) && this.myRelativePath.equals(path2.myRelativePath);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot, this.myRelativePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        NOT_CHANGED(1),
        ADDED(2),
        REMOVED(3);

        public final byte id;
        private static final ChangeKind[] KINDS;

        private ChangeKind(byte id2) {
            this.id = id2;
        }

        @NotNull
        public static ChangeKind getChangeKindById(byte id2) throws IOException {
            ChangeKind kind;
            ChangeKind changeKind = kind = id2 >= 0 && id2 < KINDS.length ? KINDS[id2] : null;
            if (kind == null) {
                throw new IOException("Change kind by id " + id2 + " not found.");
            }
            ChangeKind changeKind2 = kind;
            if (changeKind2 == null) {
                ChangeKind.$$$reportNull$$$0(0);
            }
            return changeKind2;
        }

        static {
            KINDS = new ChangeKind[4];
            ChangeKind[] changeKindArray = ChangeKind.values();
            int n = changeKindArray.length;
            for (int j = 0; j < n; ++j) {
                ChangeKind kind;
                ChangeKind.KINDS[kind.id] = kind = changeKindArray[j];
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind", "getChangeKindById"));
        }
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value2) throws IOException {
            if (out == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.size());
            for (ChangeKind data2 : value2) {
                out.writeByte(data2.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(1);
            }
            SmartList value2 = new SmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i2 = 0; i2 < size; ++i2) {
                value2.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKindListKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PathsIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final PersistentEnumerator<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> myRenamesMap;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer;

        private PathsIndexer(@NotNull VcsLogStorage storage2, @NotNull PersistentEnumerator<LightFilePath> enumerator2, @NotNull PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> renamesMap) {
            if (storage2 == null) {
                PathsIndexer.$$$reportNull$$$0(0);
            }
            if (enumerator2 == null) {
                PathsIndexer.$$$reportNull$$$0(1);
            }
            if (renamesMap == null) {
                PathsIndexer.$$$reportNull$$$0(2);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myStorage = storage2;
            this.myPathsEnumerator = enumerator2;
            this.myRenamesMap = renamesMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                PathsIndexer.$$$reportNull$$$0(3);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsLogIndexer.CompressedDetails inputData) {
            if (inputData == null) {
                PathsIndexer.$$$reportNull$$$0(4);
            }
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    SmartList renames = new SmartList();
                    for (Int2IntMap.Entry entry2 : inputData.getRenamedPaths(parentIndex).int2IntEntrySet()) {
                        renames.add(Couple.of((Object)entry2.getIntKey(), (Object)entry2.getIntValue()));
                        PathsIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<ChangeKind>>)result2, entry2.getIntKey(), parentsCount).set(parentIndex, ChangeKind.REMOVED);
                        PathsIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<ChangeKind>>)result2, entry2.getIntValue(), parentsCount).set(parentIndex, ChangeKind.ADDED);
                    }
                    if (renames.size() > 0) {
                        int commit2 = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int parent = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)Couple.of((Object)parent, (Object)commit2), (Object)renames);
                    }
                    for (Int2ObjectMap.Entry entry3 : inputData.getModifiedPaths(parentIndex).int2ObjectEntrySet()) {
                        PathsIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<ChangeKind>>)result2, entry3.getIntKey(), parentsCount).set(parentIndex, PathsIndexer.createChangeData((Change.Type)entry3.getValue()));
                    }
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.consume((Object)e);
                }
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = result2;
            if (int2ObjectOpenHashMap == null) {
                PathsIndexer.$$$reportNull$$$0(5);
            }
            return int2ObjectOpenHashMap;
        }

        @NotNull
        private static List<ChangeKind> getOrCreateChangeKindList(@NotNull Int2ObjectMap<List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            ArrayList<ChangeKind> changeDataList;
            if (pathIdToChangeDataListsMap == null) {
                PathsIndexer.$$$reportNull$$$0(6);
            }
            if ((changeDataList = (ArrayList<ChangeKind>)pathIdToChangeDataListsMap.get(pathId)) == null) {
                if (parentsCount == 1) {
                    changeDataList = new SmartList((Object)ChangeKind.NOT_CHANGED);
                } else {
                    changeDataList = new ArrayList<ChangeKind>(parentsCount);
                    for (int i2 = 0; i2 < parentsCount; ++i2) {
                        changeDataList.add(ChangeKind.NOT_CHANGED);
                    }
                }
                pathIdToChangeDataListsMap.put(pathId, changeDataList);
            }
            ArrayList<ChangeKind> arrayList = changeDataList;
            if (arrayList == null) {
                PathsIndexer.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        private static ChangeKind createChangeData(@NotNull Change.Type type) {
            if (type == null) {
                PathsIndexer.$$$reportNull$$$0(8);
            }
            switch (type) {
                case NEW: {
                    ChangeKind changeKind = ChangeKind.ADDED;
                    if (changeKind == null) {
                        PathsIndexer.$$$reportNull$$$0(9);
                    }
                    return changeKind;
                }
                case DELETED: {
                    ChangeKind changeKind = ChangeKind.REMOVED;
                    if (changeKind == null) {
                        PathsIndexer.$$$reportNull$$$0(10);
                    }
                    return changeKind;
                }
            }
            ChangeKind changeKind = ChangeKind.MODIFIED;
            if (changeKind == null) {
                PathsIndexer.$$$reportNull$$$0(11);
            }
            return changeKind;
        }

        @NotNull
        public PersistentEnumerator<LightFilePath> getPathsEnumerator() {
            PersistentEnumerator<LightFilePath> persistentEnumerator = this.myPathsEnumerator;
            if (persistentEnumerator == null) {
                PathsIndexer.$$$reportNull$$$0(12);
            }
            return persistentEnumerator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renamesMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathIdToChangeDataListsMap";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateChangeKindList";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangeData";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathsEnumerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateChangeKindList";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangeData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

