/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntToIntMap;

public abstract class AbstractIntToIntMap
implements IntToIntMap {
    @Override
    public int getShortIndex(int longIndex) {
        this.checkLongIndex(longIndex);
        if (this.shortSize() == 0 || this.getLongIndex(0) > longIndex) {
            return 0;
        }
        int a = 0;
        int b = this.shortSize() - 1;
        while (b > a + 1) {
            int middle2 = (a + b) / 2;
            if (this.getLongIndex(middle2) <= longIndex) {
                a = middle2;
                continue;
            }
            b = middle2;
        }
        return this.getLongIndex(b) <= longIndex ? b : a;
    }

    protected void checkLongIndex(int longIndex) {
        if (longIndex < 0 || longIndex >= this.longSize()) {
            throw new IndexOutOfBoundsException("LongSize is: " + this.longSize() + ", but longIndex: " + longIndex);
        }
    }

    protected void checkShortIndex(int shortIndex) {
        if (shortIndex < 0 || shortIndex >= this.shortSize()) {
            throw new IndexOutOfBoundsException("ShortSize is: " + this.shortSize() + ", but shortIndex: " + shortIndex);
        }
    }

    protected void checkUpdateParameters(int startLongIndex, int endLongIndex) {
        if (startLongIndex < 0 || endLongIndex < startLongIndex || endLongIndex >= this.longSize()) {
            throw new IllegalArgumentException("ShortSize is: " + this.shortSize() + ", but updateRequest is: (" + startLongIndex + ", " + endLongIndex + ")");
        }
    }
}

