/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChainBackedDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.actions.history.CompareRevisionsFromFileHistoryActionProvider;
import com.intellij.vcs.log.ui.frame.EditorDiffPreview;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryEditorDiffPreview;", "Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChainBackedDiffPreviewProvider;", "project", "Lcom/intellij/openapi/project/Project;", "fileHistoryPanel", "Lcom/intellij/vcs/log/history/FileHistoryPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/history/FileHistoryPanel;)V", "addSelectionListener", "", "listener", "Lkotlin/Function0;", "createDiffRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "getOwnerComponent", "Ljavax/swing/JComponent;", "updateAvailability", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
public final class FileHistoryEditorDiffPreview
extends EditorDiffPreview
implements ChainBackedDiffPreviewProvider {
    private final FileHistoryPanel fileHistoryPanel;

    @Override
    @NotNull
    public JComponent getOwnerComponent() {
        VcsLogGraphTable vcsLogGraphTable = this.fileHistoryPanel.getGraphTable();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"fileHistoryPanel.graphTable");
        return (JComponent)((Object)vcsLogGraphTable);
    }

    @Override
    @NotNull
    public String getEditorTabName(@Nullable DiffRequestProcessor processor2) {
        Object[] objectArray = new Object[1];
        FilePath filePath = this.fileHistoryPanel.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"fileHistoryPanel.filePath");
        objectArray[0] = filePath.getName();
        String string = VcsLogBundle.message((String)"file.history.diff.preview.editor.tab.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogBundle.message(\"fi\u2026storyPanel.filePath.name)");
        return string;
    }

    @Override
    public void addSelectionListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ListSelectionListener selectionListener2 = new ListSelectionListener(this, listener2){
            final /* synthetic */ FileHistoryEditorDiffPreview this$0;
            final /* synthetic */ Function0 $listener;

            public final void valueChanged(ListSelectionEvent it) {
                VcsLogGraphTable vcsLogGraphTable = FileHistoryEditorDiffPreview.access$getFileHistoryPanel$p(this.this$0).getGraphTable();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"fileHistoryPanel.graphTable");
                ListSelectionModel listSelectionModel = vcsLogGraphTable.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"fileHistoryPanel.graphTable.selectionModel");
                if (!listSelectionModel.isSelectionEmpty()) {
                    this.$listener.invoke();
                }
            }
            {
                this.this$0 = fileHistoryEditorDiffPreview;
                this.$listener = function0;
            }
        };
        VcsLogGraphTable vcsLogGraphTable = this.fileHistoryPanel.getGraphTable();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"fileHistoryPanel.graphTable");
        vcsLogGraphTable.getSelectionModel().addListSelectionListener(selectionListener2);
        Disposer.register((Disposable)this.getOwner(), (Disposable)new Disposable(this, selectionListener2){
            final /* synthetic */ FileHistoryEditorDiffPreview this$0;
            final /* synthetic */ ListSelectionListener $selectionListener;

            public final void dispose() {
                VcsLogGraphTable vcsLogGraphTable = FileHistoryEditorDiffPreview.access$getFileHistoryPanel$p(this.this$0).getGraphTable();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"fileHistoryPanel.graphTable");
                vcsLogGraphTable.getSelectionModel().removeListSelectionListener(this.$selectionListener);
            }
            {
                this.this$0 = fileHistoryEditorDiffPreview;
                this.$selectionListener = listSelectionListener;
            }
        });
    }

    @Override
    @NotNull
    public DiffRequestProcessor createDiffRequestProcessor() {
        FileHistoryDiffProcessor fileHistoryDiffProcessor = this.fileHistoryPanel.createDiffPreview(true);
        Intrinsics.checkNotNullExpressionValue((Object)fileHistoryDiffProcessor, (String)"fileHistoryPanel.createDiffPreview(true)");
        FileHistoryDiffProcessor preview2 = fileHistoryDiffProcessor;
        preview2.updatePreview(true);
        return preview2;
    }

    @Override
    @Nullable
    public DiffRequestChain createDiffRequestChain() {
        Change change = this.fileHistoryPanel.getSelectedChange();
        if (change == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"fileHistoryPanel.selectedChange ?: return null");
        Change change2 = change;
        ChangeDiffRequestProducer changeDiffRequestProducer = ChangeDiffRequestProducer.create(this.getProject(), change2);
        if (changeDiffRequestProducer == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)changeDiffRequestProducer, (String)"ChangeDiffRequestProduce\u2026t, change) ?: return null");
        ChangeDiffRequestProducer producer = changeDiffRequestProducer;
        return (DiffRequestChain)SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer);
    }

    @Override
    public void updateAvailability(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VcsLog vcsLog = (VcsLog)event.getData(VcsLogDataKeys.VCS_LOG);
        if (vcsLog == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLog, (String)"event.getData(VcsLogDataKeys.VCS_LOG) ?: return");
        VcsLog log = vcsLog;
        CompareRevisionsFromFileHistoryActionProvider.setTextAndDescription(event, log);
    }

    public FileHistoryEditorDiffPreview(@NotNull Project project, @NotNull FileHistoryPanel fileHistoryPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileHistoryPanel, (String)"fileHistoryPanel");
        super(project, fileHistoryPanel);
        this.fileHistoryPanel = fileHistoryPanel;
        this.init();
    }

    public static final /* synthetic */ FileHistoryPanel access$getFileHistoryPanel$p(FileHistoryEditorDiffPreview $this) {
        return $this.fileHistoryPanel;
    }
}

