/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.VcsLogFileRevision;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileHistoryModel {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogDiffHandler myDiffHandler;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryModel(@NotNull VcsLogData data2, @NotNull VcsLogDiffHandler handler2, @NotNull VirtualFile root2) {
        if (data2 == null) {
            FileHistoryModel.$$$reportNull$$$0(0);
        }
        if (handler2 == null) {
            FileHistoryModel.$$$reportNull$$$0(1);
        }
        if (root2 == null) {
            FileHistoryModel.$$$reportNull$$$0(2);
        }
        this.myLogData = data2;
        this.myDiffHandler = handler2;
        this.myRoot = root2;
    }

    @NotNull
    protected abstract VisiblePack getVisiblePack();

    @NotNull
    VcsLogDiffHandler getDiffHandler() {
        VcsLogDiffHandler vcsLogDiffHandler = this.myDiffHandler;
        if (vcsLogDiffHandler == null) {
            FileHistoryModel.$$$reportNull$$$0(3);
        }
        return vcsLogDiffHandler;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit2) {
        if (commit2 == null) {
            return null;
        }
        if (this.isFileDeletedInCommit((Hash)commit2.getId())) {
            return VcsFileRevision.NULL;
        }
        FilePath path2 = this.getPathInCommit((Hash)commit2.getId());
        if (path2 == null) {
            return null;
        }
        return new VcsLogFileRevision(commit2, this.myDiffHandler.createContentRevision(path2, (Hash)commit2.getId()), path2, false);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryModel.$$$reportNull$$$0(4);
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryPaths.filePath(this.getVisiblePack(), commitIndex);
    }

    private boolean isFileDeletedInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryModel.$$$reportNull$$$0(5);
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryPaths.isDeletedInCommit(this.getVisiblePack(), commitIndex);
    }

    @Nullable
    public Change getSelectedChange(int @NotNull [] rows) {
        if (rows == null) {
            FileHistoryModel.$$$reportNull$$$0(6);
        }
        if (rows.length == 0) {
            return null;
        }
        int row2 = rows[0];
        VisiblePack visiblePack = this.getVisiblePack();
        List<Integer> parentRows = rows.length == 1 ? (((Boolean)FileHistoryFilterer.NO_PARENTS_INFO.get((UserDataHolder)visiblePack, (Object)false)).booleanValue() && row2 + 1 < visiblePack.getVisibleGraph().getVisibleCommitCount() ? Collections.singletonList(row2 + 1) : visiblePack.getVisibleGraph().getRowInfo(row2).getAdjacentRows(true)) : Collections.singletonList(rows[rows.length - 1]);
        return FileHistoryUtil.createChangeToParents(row2, parentRows, visiblePack, this.myDiffHandler, this.myLogData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathInCommit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileDeletedInCommit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

