/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0013*\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017*\u00020\fH\u0007J\f\u0010\u0018\u001a\u00020\u0019*\u00020\fH\u0007J\u0014\u0010\u001a\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0005R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0005*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryPaths;", "", "()V", "FILE_HISTORY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/vcs/log/history/FileHistory;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "commitsToPathsMap", "", "", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "Lcom/intellij/vcs/log/VcsLogDataPack;", "getCommitsToPathsMap", "(Lcom/intellij/vcs/log/VcsLogDataPack;)Ljava/util/Map;", "fileHistory", "getFileHistory", "(Lcom/intellij/vcs/log/VcsLogDataPack;)Lcom/intellij/vcs/log/history/FileHistory;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "filePathOrDefault", "filePaths", "", "hasPathsInformation", "", "isDeletedInCommit", "withFileHistory", "Lcom/intellij/vcs/log/visible/VisiblePack;", "intellij.platform.vcs.log.impl"})
public final class FileHistoryPaths {
    private static final Key<FileHistory> FILE_HISTORY;
    @NotNull
    public static final FileHistoryPaths INSTANCE;

    @NotNull
    public final FileHistory getFileHistory(@NotNull VcsLogDataPack $this$fileHistory) {
        Intrinsics.checkNotNullParameter((Object)$this$fileHistory, (String)"$this$fileHistory");
        if (!($this$fileHistory instanceof VisiblePack)) {
            return FileHistory.Companion.getEMPTY$intellij_platform_vcs_log_impl();
        }
        FileHistory fileHistory = (FileHistory)FILE_HISTORY.get((UserDataHolder)$this$fileHistory);
        if (fileHistory == null) {
            fileHistory = FileHistory.Companion.getEMPTY$intellij_platform_vcs_log_impl();
        }
        return fileHistory;
    }

    private final Map<Integer, MaybeDeletedFilePath> getCommitsToPathsMap(VcsLogDataPack $this$commitsToPathsMap) {
        return this.getFileHistory($this$commitsToPathsMap).getCommitsToPathsMap();
    }

    @JvmStatic
    public static final boolean hasPathsInformation(@NotNull VcsLogDataPack $this$hasPathsInformation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPathsInformation, (String)"$this$hasPathsInformation");
        if (!($this$hasPathsInformation instanceof VisiblePack)) {
            return false;
        }
        return FILE_HISTORY.isIn((UserDataHolder)$this$hasPathsInformation);
    }

    @NotNull
    public final VisiblePack withFileHistory(@NotNull VisiblePack $this$withFileHistory, @NotNull FileHistory fileHistory) {
        Intrinsics.checkNotNullParameter((Object)$this$withFileHistory, (String)"$this$withFileHistory");
        Intrinsics.checkNotNullParameter((Object)fileHistory, (String)"fileHistory");
        $this$withFileHistory.putUserData(FILE_HISTORY, fileHistory);
        return $this$withFileHistory;
    }

    @JvmStatic
    @Nullable
    public static final FilePath filePath(@NotNull VcsLogDataPack $this$filePath, int commit2) {
        Intrinsics.checkNotNullParameter((Object)$this$filePath, (String)"$this$filePath");
        MaybeDeletedFilePath maybeDeletedFilePath = INSTANCE.getCommitsToPathsMap($this$filePath).get(commit2);
        return maybeDeletedFilePath != null ? maybeDeletedFilePath.getFilePath() : null;
    }

    @JvmStatic
    @Nullable
    public static final FilePath filePathOrDefault(@NotNull VcsLogDataPack $this$filePathOrDefault, int commit2) {
        Intrinsics.checkNotNullParameter((Object)$this$filePathOrDefault, (String)"$this$filePathOrDefault");
        MaybeDeletedFilePath maybeDeletedFilePath = INSTANCE.getCommitsToPathsMap($this$filePathOrDefault).get(commit2);
        if (maybeDeletedFilePath == null || (maybeDeletedFilePath = maybeDeletedFilePath.getFilePath()) == null) {
            VcsLogFilterCollection vcsLogFilterCollection = $this$filePathOrDefault.getFilters();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"filters");
            maybeDeletedFilePath = FileHistoryFilterer.Companion.getFilePath(vcsLogFilterCollection);
        }
        return maybeDeletedFilePath;
    }

    @JvmStatic
    public static final boolean isDeletedInCommit(@NotNull VcsLogDataPack $this$isDeletedInCommit, int commit2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeletedInCommit, (String)"$this$isDeletedInCommit");
        MaybeDeletedFilePath maybeDeletedFilePath = INSTANCE.getCommitsToPathsMap($this$isDeletedInCommit).get(commit2);
        return maybeDeletedFilePath != null ? maybeDeletedFilePath.getDeleted() : false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<FilePath> filePaths(@NotNull VcsLogDataPack $this$filePaths) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$filePaths, (String)"$this$filePaths");
        Iterable iterable = INSTANCE.getCommitsToPathsMap($this$filePaths).values();
        Collection destination$iv = CollectionFactory.createCustomHashingStrategySet(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            MaybeDeletedFilePath maybeDeletedFilePath = (MaybeDeletedFilePath)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            FilePath filePath = it.getFilePath();
            collection.add(filePath);
        }
        void v0 = var2_2;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"commitsToPathsMap.values\u2026TRATEGY)) { it.filePath }");
        return (Set)v0;
    }

    private FileHistoryPaths() {
    }

    static {
        FileHistoryPaths fileHistoryPaths;
        INSTANCE = fileHistoryPaths = new FileHistoryPaths();
        Key key = Key.create((String)"FILE_HISTORY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<FileHistory>(\"FILE_HISTORY\")");
        FILE_HISTORY = key;
    }
}

