/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0006\u0010\t\u001a\u00020\b\u001a2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002\u001a(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a,\u0010\u0016\u001a\u00020\u000b*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"getCorrectedPath", "Lcom/intellij/openapi/vcs/FilePath;", "project", "Lcom/intellij/openapi/project/Project;", "path", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRevisionHistory", "", "isNewHistoryEnabled", "selectRowWhenOpen", "", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "hash", "Lcom/intellij/vcs/log/Hash;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "firstTime", "triggerFileHistoryUsage", "paths", "", "jumpToNearestCommit", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "silently", "intellij.platform.vcs.log.impl"})
public final class VcsLogFileHistoryProviderImplKt {
    public static final boolean isNewHistoryEnabled() {
        return Registry.is((String)"vcs.new.history");
    }

    private static final void selectRowWhenOpen(VcsLogManager logManager, Hash hash, VirtualFile root2, VcsLogUiEx ui2, boolean firstTime) {
        if (hash != null) {
            VcsLogData vcsLogData = logManager.getDataManager();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
            VcsLogStorage vcsLogStorage = vcsLogData.getStorage();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"logManager.dataManager.storage");
            VcsLogFileHistoryProviderImplKt.jumpToNearestCommit(ui2, vcsLogStorage, hash, root2, true);
        } else if (firstTime) {
            VcsLogUtil.jumpToRow(ui2, 0, true);
        }
    }

    private static final void jumpToNearestCommit(VcsLogUiEx $this$jumpToNearestCommit, VcsLogStorage storage2, Hash hash, VirtualFile root2, boolean silently) {
        $this$jumpToNearestCommit.jumpTo(hash, (PairFunction)new PairFunction(storage2, root2){
            final /* synthetic */ VcsLogStorage $storage;
            final /* synthetic */ VirtualFile $root;

            public final Integer fun(@NotNull VisiblePack visiblePack, @Nullable Hash h) {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
                Hash hash = h;
                Intrinsics.checkNotNull((Object)hash);
                if (!this.$storage.containsCommit(new CommitId(hash, this.$root))) {
                    return -1;
                }
                int commitIndex = this.$storage.getCommitIndex(h, this.$root);
                Integer rowIndex = visiblePack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
                if (rowIndex == null) {
                    rowIndex = ReachableNodesUtilKt.findVisibleAncestorRow(commitIndex, visiblePack);
                }
                if ((n = rowIndex) == null) {
                    n = -2;
                }
                return n;
            }
            {
                this.$storage = vcsLogStorage;
                this.$root = virtualFile2;
            }
        }, (SettableFuture<? super Boolean>)SettableFuture.create(), silently, true);
    }

    private static final FilePath getCorrectedPath(Project project, FilePath path2, VirtualFile root2, boolean isRevisionHistory) {
        FilePath correctedPath = path2;
        if (Intrinsics.areEqual((Object)root2, (Object)VcsUtil.getVcsRootFor((Project)project, (FilePath)correctedPath)) ^ true && correctedPath.isDirectory()) {
            FilePath filePath = VcsUtil.getFilePath((String)correctedPath.getPath(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(correctedPath.path, false)");
            correctedPath = filePath;
        }
        if (!isRevisionHistory) {
            FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)correctedPath);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getLastCommitPath(project, correctedPath)");
            return filePath;
        }
        return correctedPath;
    }

    private static final void triggerFileHistoryUsage(Project project, Collection<? extends FilePath> paths2, Hash hash) {
        String kind = paths2.size() > 1 ? "multiple" : (((FilePath)CollectionsKt.first((Iterable)paths2)).isDirectory() ? "folder" : "file");
        VcsLogUsageTriggerCollector.triggerFileHistoryUsage(project, kind, hash != null);
    }

    public static final /* synthetic */ void access$triggerFileHistoryUsage(Project project, Collection paths2, Hash hash) {
        VcsLogFileHistoryProviderImplKt.triggerFileHistoryUsage(project, paths2, hash);
    }

    public static final /* synthetic */ void access$selectRowWhenOpen(VcsLogManager logManager, Hash hash, VirtualFile root2, VcsLogUiEx ui2, boolean firstTime) {
        VcsLogFileHistoryProviderImplKt.selectRowWhenOpen(logManager, hash, root2, ui2, firstTime);
    }

    public static final /* synthetic */ FilePath access$getCorrectedPath(Project project, FilePath path2, VirtualFile root2, boolean isRevisionHistory) {
        return VcsLogFileHistoryProviderImplKt.getCorrectedPath(project, path2, root2, isRevisionHistory);
    }
}

