/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CannotAddVcsLogWindowException;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PostponableLogRefresher
implements VcsLogRefresher {
    private static final Logger LOG = Logger.getInstance(PostponableLogRefresher.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Set<VirtualFile> myRootsToRefresh;
    @NotNull
    private final Set<VcsLogWindow> myLogWindows;
    @NotNull
    private final Map<String, Throwable> myCreationTraces;

    public PostponableLogRefresher(@NotNull VcsLogData logData) {
        if (logData == null) {
            PostponableLogRefresher.$$$reportNull$$$0(0);
        }
        this.myRootsToRefresh = new HashSet<VirtualFile>();
        this.myLogWindows = new HashSet<VcsLogWindow>();
        this.myCreationTraces = new HashMap<String, Throwable>();
        this.myLogData = logData;
        this.myLogData.addDataPackChangeListener(dataPack -> {
            LOG.debug("Refreshing log windows " + this.myLogWindows);
            for (VcsLogWindow window : this.myLogWindows) {
                PostponableLogRefresher.dataPackArrived(window.getRefresher(), window.isVisible());
            }
        });
    }

    @NotNull
    public Disposable addLogWindow(@NotNull VcsLogWindow window) {
        String windowId;
        if (window == null) {
            PostponableLogRefresher.$$$reportNull$$$0(1);
        }
        if (ContainerUtil.exists(this.myLogWindows, arg_0 -> PostponableLogRefresher.lambda$addLogWindow$1(windowId = window.getId(), arg_0))) {
            throw new CannotAddVcsLogWindowException("Log window with id '" + windowId + "' was already added. Existing windows:\n" + this.getLogWindowsInformation(), this.myCreationTraces.get(windowId));
        }
        this.myLogWindows.add(window);
        this.myCreationTraces.put(windowId, new Throwable("Creation trace for " + window));
        this.refresherActivated(window.getRefresher(), true);
        Disposable disposable2 = () -> {
            LOG.debug("Removing disposed log window " + window);
            this.myLogWindows.remove(window);
            this.myCreationTraces.remove(windowId);
        };
        if (disposable2 == null) {
            PostponableLogRefresher.$$$reportNull$$$0(2);
        }
        return disposable2;
    }

    public static boolean keepUpToDate() {
        return Registry.is((String)"vcs.log.keep.up.to.date") && !PowerSaveMode.isEnabled();
    }

    private boolean canRefreshNow() {
        if (PostponableLogRefresher.keepUpToDate()) {
            return true;
        }
        return this.isLogVisible();
    }

    public boolean isLogVisible() {
        for (VcsLogWindow window : this.myLogWindows) {
            if (!window.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void refresherActivated(@NotNull VisiblePackRefresher refresher, boolean firstTime) {
        if (refresher == null) {
            PostponableLogRefresher.$$$reportNull$$$0(3);
        }
        this.myLogData.initialize();
        if (!this.myRootsToRefresh.isEmpty()) {
            this.refreshPostponedRoots();
        } else {
            refresher.setValid(true, firstTime);
        }
    }

    private static void dataPackArrived(@NotNull VisiblePackRefresher refresher, boolean visible) {
        if (refresher == null) {
            PostponableLogRefresher.$$$reportNull$$$0(4);
        }
        refresher.setValid(visible, true);
    }

    public void refresh(@NotNull VirtualFile root2) {
        if (root2 == null) {
            PostponableLogRefresher.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.canRefreshNow()) {
                this.myLogData.refresh(Collections.singleton(root2));
            } else {
                LOG.debug("Postponed refresh for " + root2);
                this.myRootsToRefresh.add(root2);
            }
        }, ModalityState.any());
    }

    private void refreshPostponedRoots() {
        HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>(this.myRootsToRefresh);
        this.myRootsToRefresh.removeAll(toRefresh);
        this.myLogData.refresh(toRefresh);
    }

    @NotNull
    public Set<VcsLogWindow> getLogWindows() {
        Set<VcsLogWindow> set2 = this.myLogWindows;
        if (set2 == null) {
            PostponableLogRefresher.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @NotNull
    public String getLogWindowsInformation() {
        String string = StringUtil.join(this.myLogWindows, window -> {
            String isVisible2 = window.isVisible() ? " (visible)" : "";
            String isDisposed = Disposer.isDisposed((Disposable)window.getRefresher()) ? " (disposed)" : "";
            return window + isVisible2 + isDisposed;
        }, (String)"\n");
        if (string == null) {
            PostponableLogRefresher.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$addLogWindow$1(String windowId, VcsLogWindow w) {
        return w.getId().equals(windowId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/PostponableLogRefresher";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/PostponableLogRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addLogWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogWindows";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogWindowsInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addLogWindow";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refresherActivated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dataPackArrived";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VcsLogWindow {
        @NotNull
        private final String myId;
        @NotNull
        private final VisiblePackRefresher myRefresher;

        public VcsLogWindow(@NotNull String id2, @NotNull VisiblePackRefresher refresher) {
            if (id2 == null) {
                VcsLogWindow.$$$reportNull$$$0(0);
            }
            if (refresher == null) {
                VcsLogWindow.$$$reportNull$$$0(1);
            }
            this.myId = id2;
            this.myRefresher = refresher;
        }

        @NotNull
        public VisiblePackRefresher getRefresher() {
            VisiblePackRefresher visiblePackRefresher = this.myRefresher;
            if (visiblePackRefresher == null) {
                VcsLogWindow.$$$reportNull$$$0(2);
            }
            return visiblePackRefresher;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                VcsLogWindow.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "VcsLogWindow '" + this.myId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refresher";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefresher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

