/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final AbstractVcsLogUi myUi;

    public VcsLogImpl(@NotNull VcsLogData manager2, @NotNull AbstractVcsLogUi ui2) {
        if (manager2 == null) {
            VcsLogImpl.$$$reportNull$$$0(0);
        }
        if (ui2 == null) {
            VcsLogImpl.$$$reportNull$$$0(1);
        }
        this.myLogData = manager2;
        this.myUi = ui2;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        List<CommitId> list2 = this.myUi.getTable().getModel().getCommitIds(this.myUi.getTable().getSelectedRows());
        if (list2 == null) {
            VcsLogImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public List<VcsCommitMetadata> getSelectedShortDetails() {
        List<VcsCommitMetadata> list2 = this.myUi.getTable().getModel().getCommitMetadata(this.myUi.getTable().getSelectedRows());
        if (list2 == null) {
            VcsLogImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        List<VcsFullCommitDetails> list2 = this.myUi.getTable().getModel().getFullDetails(this.myUi.getTable().getSelectedRows());
        if (list2 == null) {
            VcsLogImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void requestSelectedDetails(@NotNull Consumer<? super List<VcsFullCommitDetails>> consumer2) {
        if (consumer2 == null) {
            VcsLogImpl.$$$reportNull$$$0(5);
        }
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.getTable().getModel().convertToCommitIds(rowsList), (Consumer)consumer2, EmptyConsumer.getInstance(), (ProgressIndicator)null);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root2) {
        if (commitHash == null) {
            VcsLogImpl.$$$reportNull$$$0(6);
        }
        if (root2 == null) {
            VcsLogImpl.$$$reportNull$$$0(7);
        }
        return this.myLogData.getContainingBranchesGetter().getContainingBranchesQuickly(root2, commitHash);
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToReference(@NotNull String reference2, boolean focus) {
        if (reference2 == null) {
            VcsLogImpl.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)reference2)) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            if (listenableFuture == null) {
                VcsLogImpl.$$$reportNull$$$0(9);
            }
            return listenableFuture;
        }
        SettableFuture future2 = SettableFuture.create();
        VcsLogRefs refs = this.myUi.getDataPack().getRefs();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List matchingRefs = refs.stream().filter(ref -> ref.getName().startsWith(reference2)).collect(Collectors.toList());
            ApplicationManager.getApplication().invokeLater(() -> {
                if (matchingRefs.isEmpty()) {
                    future2.setFuture(this.jumpToHash(reference2, focus));
                } else {
                    VcsRef ref = Collections.min(matchingRefs, new VcsGoToRefComparator(this.myUi.getDataPack().getLogProviders()));
                    future2.setFuture(this.jumpToCommit(ref.getCommitHash(), ref.getRoot(), focus));
                }
            });
        });
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            VcsLogImpl.$$$reportNull$$$0(10);
        }
        return settableFuture;
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root2, boolean focus) {
        if (commitHash == null) {
            VcsLogImpl.$$$reportNull$$$0(11);
        }
        if (root2 == null) {
            VcsLogImpl.$$$reportNull$$$0(12);
        }
        SettableFuture future2 = SettableFuture.create();
        this.myUi.jumpTo(commitHash, (visiblePack, hash) -> {
            if (!this.myLogData.getStorage().containsCommit(new CommitId(hash, root2))) {
                return -1;
            }
            return this.getCommitRow((VisiblePack)visiblePack, (Hash)hash, root2);
        }, (SettableFuture<? super Boolean>)future2, false, focus);
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            VcsLogImpl.$$$reportNull$$$0(13);
        }
        return settableFuture;
    }

    @NotNull
    private ListenableFuture<Boolean> jumpToHash(@NotNull String commitHash, boolean focus) {
        if (commitHash == null) {
            VcsLogImpl.$$$reportNull$$$0(14);
        }
        SettableFuture future2 = SettableFuture.create();
        String trimmed = StringUtil.trim((String)commitHash, ch -> !StringUtil.containsChar((String)"()'\"`", (char)ch));
        if (!VcsLogUtil.HASH_REGEX.matcher(trimmed).matches()) {
            VcsBalloonProblemNotifier.showOverChangesView(this.myUi.getLogData().getProject(), VcsLogBundle.message((String)"vcs.log.commit.or.reference.not.found", (Object[])new Object[]{commitHash}), MessageType.WARNING, new NamedRunnable[0]);
            future2.set((Object)false);
            SettableFuture settableFuture = future2;
            if (settableFuture == null) {
                VcsLogImpl.$$$reportNull$$$0(15);
            }
            return settableFuture;
        }
        this.myUi.jumpTo(trimmed, this::getCommitRow, (SettableFuture<? super Boolean>)future2, false, focus);
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            VcsLogImpl.$$$reportNull$$$0(16);
        }
        return settableFuture;
    }

    private int getCommitRow(@NotNull VisiblePack visiblePack, @NotNull String partialHash) {
        if (visiblePack == null) {
            VcsLogImpl.$$$reportNull$$$0(17);
        }
        if (partialHash == null) {
            VcsLogImpl.$$$reportNull$$$0(18);
        }
        if (partialHash.length() == 40) {
            int row2 = -1;
            Hash candidateHash = HashImpl.build(partialHash);
            for (VirtualFile candidateRoot : this.myLogData.getRoots()) {
                if (!this.myLogData.getStorage().containsCommit(new CommitId(candidateHash, candidateRoot))) continue;
                int candidateRow = this.getCommitRow(visiblePack, candidateHash, candidateRoot);
                if (candidateRow >= 0) {
                    return candidateRow;
                }
                if (row2 != -1) continue;
                row2 = candidateRow;
            }
            return row2;
        }
        IntRef row3 = new IntRef(-1);
        this.myLogData.getStorage().iterateCommits(candidate -> {
            if (CommitIdByStringCondition.matches(candidate, partialHash)) {
                int candidateRow = this.getCommitRow(visiblePack, candidate.getHash(), candidate.getRoot());
                if (row3.get() == -1) {
                    row3.set(candidateRow);
                }
                return candidateRow < 0;
            }
            return true;
        });
        return row3.get();
    }

    private int getCommitRow(@NotNull VisiblePack visiblePack, @NotNull Hash hash, @NotNull VirtualFile root2) {
        if (visiblePack == null) {
            VcsLogImpl.$$$reportNull$$$0(19);
        }
        if (hash == null) {
            VcsLogImpl.$$$reportNull$$$0(20);
        }
        if (root2 == null) {
            VcsLogImpl.$$$reportNull$$$0(21);
        }
        int commitIndex = this.myLogData.getCommitIndex(hash, root2);
        VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
        if (visibleGraph instanceof VisibleGraphImpl) {
            int nodeId = ((VisibleGraphImpl)visibleGraph).getPermanentGraph().getPermanentCommitsInfo().getNodeId(commitIndex);
            if (nodeId == -1) {
                return -1;
            }
            if (nodeId < 0) {
                return -2;
            }
            Integer rowIndex = ((VisibleGraphImpl)visibleGraph).getLinearGraph().getNodeIndex(nodeId);
            return rowIndex == null ? -2 : rowIndex;
        }
        Integer rowIndex = visibleGraph.getVisibleRowIndex((Object)commitIndex);
        return rowIndex == null ? -2 : rowIndex;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myLogData.getLogProviders();
        if (map2 == null) {
            VcsLogImpl.$$$reportNull$$$0(22);
        }
        return map2;
    }

    @NotNull
    private VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myUi.getTable();
        if (vcsLogGraphTable == null) {
            VcsLogImpl.$$$reportNull$$$0(23);
        }
        return vcsLogGraphTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 7: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialHash";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCommits";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedShortDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDetails";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToCommit";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToHash";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestSelectedDetails";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "jumpToReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "jumpToCommit";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "jumpToHash";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCommitRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

