/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 52\u00020\u00012\u00020\u00022\u00020\u0003:\u00015B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\u001aJ \u0010\u001b\u001a\u00020\u00182\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\u001aJ\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0014J\u001b\u0010'\u001a\u00020\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a2\u0006\u0002\b)J\u0014\u0010*\u001a\u00020\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020+0\u000fJ\u0010\u0010,\u001a\u00020\u00182\b\b\u0001\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001dJ\u0006\u00102\u001a\u00020\u0018J\u0006\u00103\u001a\u00020\u0018J\u0006\u00104\u001a\u00020\u0018R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "createDetailsPanel", "Lkotlin/Function0;", "Lcom/intellij/vcs/log/ui/details/commit/CommitDetailsPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "detailsPanel", "Ljavax/swing/JPanel;", "displayedCommits", "", "Lcom/intellij/vcs/log/CommitId;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "statusText", "Lcom/intellij/util/ui/StatusText;", "viewPanel", "Lcom/intellij/openapi/roots/ui/componentsList/components/ScrollablePanel;", "forEachPanel", "", "consumer", "Lkotlin/Function2;", "forEachPanelIndexed", "f", "", "getEmptyText", "getMinimumSize", "Ljava/awt/Dimension;", "globalSchemeChange", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "paintChildren", "g", "Ljava/awt/Graphics;", "rebuildPanel", "commits", "rebuildPanel$intellij_platform_vcs_log_impl", "setCommits", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "setStatusText", "text", "", "showOverflowLabelIfNeeded", "max", "requested", "startLoadingDetails", "stopLoadingDetails", "update", "Companion", "intellij.platform.vcs.log.impl"})
public final class CommitDetailsListPanel
extends BorderLayoutPanel
implements EditorColorsListener,
ComponentWithEmptyText {
    private List<? extends CommitId> displayedCommits;
    private final StatusText statusText;
    private final JPanel detailsPanel;
    private final ScrollablePanel viewPanel;
    private final JBLoadingPanel loadingPanel;
    private final Project project;
    private final Function0<CommitDetailsPanel> createDetailsPanel;
    private static final int MIN_SIZE = 20;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void startLoadingDetails() {
        this.loadingPanel.startLoading();
    }

    public final void stopLoadingDetails() {
        this.loadingPanel.stopLoading();
    }

    public final void setStatusText(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.statusText.setText(text2);
    }

    /*
     * WARNING - void declaration
     */
    public final void rebuildPanel$intellij_platform_vcs_log_impl(@NotNull List<? extends CommitId> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        int oldRowsCount = this.displayedCommits.size();
        this.displayedCommits = commits;
        int newRowsCount = this.displayedCommits.size();
        int n = oldRowsCount;
        int n2 = newRowsCount;
        while (n < n2) {
            void i2;
            CommitDetailsPanel panel2 = (CommitDetailsPanel)this.createDetailsPanel.invoke();
            if (i2 != false) {
                this.detailsPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            }
            this.detailsPanel.add(panel2);
            ++i2;
        }
        while (this.detailsPanel.getComponentCount() != 0 && this.detailsPanel.getComponentCount() > 2 * newRowsCount - 1) {
            this.detailsPanel.remove(this.detailsPanel.getComponentCount() - 1);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public final void showOverflowLabelIfNeeded(int max, int requested) {
        int componentCount = this.viewPanel.getComponentCount();
        if (componentCount > 1) {
            this.viewPanel.remove(componentCount - 1);
        }
        if (requested > max) {
            void $this$apply;
            JPanel jPanel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply2 = jPanel2;
            boolean bl3 = false;
            $this$apply2.setOpaque(false);
            $this$apply2.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            JBLabel jBLabel = new JBLabel(VcsLogBundle.message((String)"vcs.log.details.showing.selected.commits", (Object[])new Object[]{max, requested}));
            boolean bl4 = false;
            boolean bl5 = false;
            JBLabel jBLabel2 = jBLabel;
            JPanel jPanel3 = $this$apply2;
            boolean bl6 = false;
            $this$apply.setFont(FontUtil.getCommitMetadataFont());
            $this$apply.setBorder((Border)JBUI.Borders.emptyLeft((int)14));
            Unit unit = Unit.INSTANCE;
            jPanel3.add((Component)jBLabel);
            JPanel overflowLabelPanel = jPanel2;
            this.viewPanel.add((Component)overflowLabelPanel, "South");
        }
        this.viewPanel.revalidate();
        this.viewPanel.repaint();
    }

    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.statusText.paint((Component)((Object)this), g);
        super.paintChildren(g);
    }

    public final void forEachPanelIndexed(@NotNull Function2<? super Integer, ? super CommitDetailsPanel, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        int idx = 0;
        Component[] componentArray = this.detailsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"detailsPanel.components");
        Component[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        Component[] componentArray2 = $this$forEach$iv;
        int n = componentArray2.length;
        for (int j = 0; j < n; ++j) {
            Component element$iv;
            Component it = element$iv = componentArray2[j];
            boolean bl = false;
            if (!(it instanceof CommitDetailsPanel)) continue;
            f.invoke((Object)idx, (Object)it);
            int n2 = idx;
            idx = n2 + 1;
        }
        this.update();
    }

    public final void forEachPanel(@NotNull Function2<? super CommitId, ? super CommitDetailsPanel, Unit> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        this.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<Integer, CommitDetailsPanel, Unit>(this, consumer2){
            final /* synthetic */ CommitDetailsListPanel this$0;
            final /* synthetic */ Function2 $consumer;

            public final void invoke(int idx, @NotNull CommitDetailsPanel panel2) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                this.$consumer.invoke(CommitDetailsListPanel.access$getDisplayedCommits$p(this.this$0).get(idx), (Object)panel2);
            }
            {
                this.this$0 = commitDetailsListPanel;
                this.$consumer = function2;
                super(2);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void setCommits(@NotNull List<? extends VcsCommitMetadata> commits) {
        Collection<CommitId> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Iterable iterable = commits;
        CommitDetailsListPanel commitDetailsListPanel = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CommitId commitId2 = new CommitId((Hash)it.getId(), it.getRoot());
            collection.add(commitId2);
        }
        collection = (List)destination$iv$iv;
        commitDetailsListPanel.rebuildPanel$intellij_platform_vcs_log_impl((List<? extends CommitId>)collection);
        this.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<Integer, CommitDetailsPanel, Unit>(this, commits){
            final /* synthetic */ CommitDetailsListPanel this$0;
            final /* synthetic */ List $commits;

            public final void invoke(int i2, @NotNull CommitDetailsPanel panel2) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                VcsCommitMetadata commit2 = (VcsCommitMetadata)this.$commits.get(i2);
                boolean bl = false;
                CommitPresentationUtil.CommitPresentation commitPresentation = CommitPresentationUtil.buildPresentation(CommitDetailsListPanel.access$getProject$p(this.this$0), commit2, (Set<? super String>)new LinkedHashSet<E>());
                Intrinsics.checkNotNullExpressionValue((Object)commitPresentation, (String)"CommitPresentationUtil.b\u2026, commit, mutableSetOf())");
                CommitPresentationUtil.CommitPresentation presentation2 = commitPresentation;
                panel2.setCommit(presentation2);
            }
            {
                this.this$0 = commitDetailsListPanel;
                this.$commits = list2;
                super(2);
            }
        }));
    }

    public final void update() {
        Component[] componentArray = this.detailsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"detailsPanel.components");
        Component[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        Component[] componentArray2 = $this$forEach$iv;
        int n = componentArray2.length;
        for (int j = 0; j < n; ++j) {
            Component element$iv;
            Component it = element$iv = componentArray2[j];
            boolean bl = false;
            if (!(it instanceof CommitDetailsPanel)) continue;
            ((CommitDetailsPanel)it).update();
        }
    }

    @NotNull
    public StatusText getEmptyText() {
        return this.statusText;
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme2) {
        this.update();
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        int n = minimumSize.width;
        int n2 = JBUIScale.scale((int)20);
        boolean bl = false;
        int n3 = Math.max(n, n2);
        n = minimumSize.height;
        n2 = JBUIScale.scale((int)20);
        bl = false;
        return new Dimension(n3, Math.max(n, n2));
    }

    @JvmOverloads
    public CommitDetailsListPanel(@NotNull Project project, @NotNull Disposable parent, @NotNull Function0<CommitDetailsPanel> createDetailsPanel) {
        JPanel $this$apply;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(createDetailsPanel, (String)"createDetailsPanel");
        this.project = project;
        this.createDetailsPanel = createDetailsPanel;
        this.displayedCommits = CollectionsKt.emptyList();
        this.statusText = new StatusText(this, (JComponent)((Object)this)){
            final /* synthetic */ CommitDetailsListPanel this$0;

            protected boolean isStatusVisible() {
                return CommitDetailsListPanel.access$getDisplayedCommits$p(this.this$0).isEmpty();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        JPanel jPanel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        boolean bl = false;
        boolean bl2 = false;
        JPanel jPanel3 = jPanel2;
        CommitDetailsListPanel commitDetailsListPanel = this;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        Unit unit = Unit.INSTANCE;
        commitDetailsListPanel.detailsPanel = jPanel2;
        jPanel2 = new ScrollablePanel(new BorderLayout());
        bl = false;
        bl2 = false;
        $this$apply = jPanel2;
        commitDetailsListPanel = this;
        boolean bl4 = false;
        $this$apply.setOpaque(false);
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        $this$apply.add((Component)this.detailsPanel, "Center");
        unit = Unit.INSTANCE;
        commitDetailsListPanel.viewPanel = jPanel2;
        jPanel2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), parent, 300);
        bl = false;
        bl2 = false;
        $this$apply = jPanel2;
        commitDetailsListPanel = this;
        boolean bl5 = false;
        $this$apply.setOpaque(false);
        JBScrollPane jBScrollPane = new JBScrollPane((Component)this.viewPanel, 20, 31);
        boolean bl6 = false;
        boolean bl7 = false;
        JBScrollPane $this$apply2 = jBScrollPane;
        boolean bl8 = false;
        $this$apply2.setBorder((Border)JBUI.Borders.empty());
        $this$apply2.setViewportBorder((Border)JBUI.Borders.empty());
        $this$apply2.setOpaque(false);
        JViewport jViewport = $this$apply2.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"viewport");
        jViewport.setOpaque(false);
        JBScrollPane scrollPane = jBScrollPane;
        $this$apply.add((Component)scrollPane, "Center");
        unit = Unit.INSTANCE;
        commitDetailsListPanel.loadingPanel = jPanel2;
        this.project.getMessageBus().connect(parent).subscribe(CommitMessageInspectionProfile.TOPIC, (Object)new CommitMessageInspectionProfile.ProfileListener(){

            @Override
            public final void profileChanged() {
                this.update();
            }
        });
        String string = VcsLogBundle.message((String)"vcs.log.commit.details.status", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogBundle.message(\"vc\u2026g.commit.details.status\")");
        this.setStatusText(string);
        this.setBackground(CommitDetailsPanelKt.getCommitDetailsBackground());
        this.addToCenter((Component)this.loadingPanel);
    }

    public /* synthetic */ CommitDetailsListPanel(Project project, Disposable disposable2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(project, disposable2, (Function0<CommitDetailsPanel>)function0);
    }

    @JvmOverloads
    public CommitDetailsListPanel(@NotNull Project project, @NotNull Disposable parent) {
        this(project, parent, null, 4, null);
    }

    public static final /* synthetic */ List access$getDisplayedCommits$p(CommitDetailsListPanel $this) {
        return $this.displayedCommits;
    }

    public static final /* synthetic */ void access$setDisplayedCommits$p(CommitDetailsListPanel $this, List list2) {
        $this.displayedCommits = list2;
    }

    public static final /* synthetic */ Project access$getProject$p(CommitDetailsListPanel $this) {
        return $this.project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel$Companion;", "", "()V", "MIN_SIZE", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

