/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ClickListener;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.vcs.log.VcsLogBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.function.Supplier;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogPopupComponent
extends JPanel {
    private static final int GAP_BEFORE_ARROW = 3;
    protected static final int BORDER_SIZE = 2;
    protected static final int ARC_SIZE = 10;
    private final PopupState<JBPopup> myPopupState;
    private final @NotNull Supplier<@NlsContexts.Label String> myDisplayName;
    @Nullable
    private JLabel myNameLabel;
    @NotNull
    private JLabel myValueLabel;

    protected VcsLogPopupComponent(@NotNull Supplier<@NlsContexts.Label String> displayName) {
        if (displayName == null) {
            VcsLogPopupComponent.$$$reportNull$$$0(0);
        }
        this.myPopupState = PopupState.forPopup();
        this.myDisplayName = displayName;
    }

    public JComponent initUi() {
        this.myNameLabel = this.shouldDrawLabel() ? new DynamicLabel(() -> this.myDisplayName.get() + ": ") : null;
        this.myValueLabel = new DynamicLabel(this::getCurrentText);
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(VcsLogPopupComponent.wrapBorder(this.createUnfocusedBorder()));
        this.setLayout(new BoxLayout(this, 0));
        if (this.myNameLabel != null) {
            this.add(this.myNameLabel);
        }
        this.add(this.myValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.installChangeListener(() -> {
            this.myValueLabel.revalidate();
            this.myValueLabel.repaint();
        });
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        if (this.shouldIndicateHovering()) {
            this.indicateHovering();
        }
        this.indicateFocusing();
        return this;
    }

    public abstract String getCurrentText();

    public abstract void installChangeListener(@NotNull Runnable var1);

    @NotNull
    protected Color getDefaultSelectorForeground() {
        Color color = StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor().darker().darker();
        if (color == null) {
            VcsLogPopupComponent.$$$reportNull$$$0(1);
        }
        return color;
    }

    protected boolean shouldIndicateHovering() {
        return true;
    }

    protected boolean shouldDrawLabel() {
        return true;
    }

    protected abstract ActionGroup createActionGroup();

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogPopupComponent.this.setBorder(VcsLogPopupComponent.wrapBorder(VcsLogPopupComponent.createFocusedBorder()));
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogPopupComponent.this.setBorder(VcsLogPopupComponent.wrapBorder(VcsLogPopupComponent.this.createUnfocusedBorder()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    VcsLogPopupComponent.this.showPopupMenu();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$2", "keyPressed"));
            }
        });
    }

    private void showPopupMenuOnClick() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                VcsLogPopupComponent.this.showPopupMenu();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$3", "onClick"));
            }
        }.installOn((Component)this);
    }

    private void indicateHovering() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                VcsLogPopupComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                VcsLogPopupComponent.this.setDefaultForeground();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setDefaultForeground() {
        if (this.myNameLabel != null) {
            this.myNameLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        }
        this.myValueLabel.setForeground(this.getDefaultSelectorForeground());
    }

    private void setOnHoverForeground() {
        if (this.myNameLabel != null) {
            this.myNameLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        }
        this.myValueLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    void showPopupMenu() {
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        ListPopup popup2 = this.createPopupMenu();
        this.myPopupState.prepareToShow((Object)popup2);
        popup2.showUnderneathOf((Component)this);
    }

    @NotNull
    protected ListPopup createPopupMenu() {
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, ActionGroupUtil.forceRecursiveUpdateInBackground(this.createActionGroup()), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        if (listPopup == null) {
            VcsLogPopupComponent.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    private static Border createFocusedBorder() {
        return new FilledRoundedBorder(UIUtil.getFocusedBorderColor(), 10, 2);
    }

    protected Border createUnfocusedBorder() {
        return JBUI.Borders.empty((int)2);
    }

    private static Border wrapBorder(Border outerBorder) {
        return BorderFactory.createCompoundBorder(outerBorder, JBUI.Borders.empty((int)2));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleVcsLogPopupComponent(super.getAccessibleContext());
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSelectorForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AccessibleVcsLogPopupComponent
    extends AccessibleContextDelegate {
        AccessibleVcsLogPopupComponent(AccessibleContext context2) {
            super(context2);
        }

        protected Container getDelegateParent() {
            return null;
        }

        public String getAccessibleName() {
            return VcsLogBundle.message((String)"vcs.log.Accessibility.filter.label", (Object[])new Object[]{VcsLogPopupComponent.this.myNameLabel.getText(), VcsLogPopupComponent.this.myValueLabel.getText()});
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    private static final class DynamicLabel
    extends JLabel {
        private final Supplier<@NlsContexts.Label String> myText;

        private DynamicLabel(@NotNull Supplier<@NlsContexts.Label String> text2) {
            if (text2 == null) {
                DynamicLabel.$$$reportNull$$$0(0);
            }
            this.myText = text2;
        }

        @Override
        @NlsContexts.Label
        public String getText() {
            if (this.myText == null) {
                return "";
            }
            return this.myText.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$DynamicLabel", "<init>"));
        }
    }

    public static class FilledRoundedBorder
    implements Border {
        private final Color myColor;
        private final int myThickness;
        private final int myArcSize;

        public FilledRoundedBorder(@NotNull Color color, int arcSize, int thickness) {
            if (color == null) {
                FilledRoundedBorder.$$$reportNull$$$0(0);
            }
            this.myColor = color;
            this.myThickness = thickness;
            this.myArcSize = arcSize;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.myColor);
            int thickness = JBUI.scale((int)this.myThickness);
            int arcSize = JBUI.scale((int)this.myArcSize);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, arcSize, arcSize));
            int innerArc = Math.max(arcSize - thickness, 0);
            area.subtract(new Area(new RoundRectangle2D.Double(x + thickness, y + thickness, width - 2 * thickness, height - 2 * thickness, innerArc, innerArc)));
            ((Graphics2D)g).fill(area);
            config2.restore();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBUI.insets((int)this.myThickness);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$FilledRoundedBorder", "<init>"));
        }
    }
}

