/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsCommitExternalStatus;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.util.VcsCommitsDataLoader;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$requestData$;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00043456B'\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0016J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0014J\b\u0010$\u001a\u00020\u0019H\u0014J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020\u0019H\u0014J\b\u0010)\u001a\u00020\u0019H\u0014J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0014J\u0015\u0010,\u001a\u00020\u00192\u000b\u0010-\u001a\u00070!\u00a2\u0006\u0002\b.H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u00020002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails;", "Lcom/intellij/vcs/log/ui/table/CommitSelectionListener;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Lcom/intellij/openapi/Disposable;", "graphTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "parentDisposable", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;Lcom/intellij/vcs/log/ui/VcsLogColorManager;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;Lcom/intellij/openapi/Disposable;)V", "containingBranchesLoader", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ContainingBranchesAsyncLoader;", "currentSelection", "", "externalStatusesLoader", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader;", "hashesResolver", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$CommitDataLoader;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "Lorg/jetbrains/annotations/NotNull;", "refsLoader", "cancelLoading", "", "dispose", "doResolveHashes", "", "Lcom/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation;", "presentations", "unResolvedHashes", "", "", "onDetailsLoaded", "detailsList", "onEmptySelection", "onError", "error", "", "onLoadingStarted", "onLoadingStopped", "onSelection", "selection", "setEmpty", "text", "Lorg/jetbrains/annotations/Nls;", "sortRefs", "Lcom/intellij/vcs/log/VcsRef;", "refs", "", "CommitDataLoader", "Companion", "ContainingBranchesAsyncLoader", "ExternalStatusesAsyncLoader", "intellij.platform.vcs.log.impl"})
public final class VcsLogCommitSelectionListenerForDetails
extends CommitSelectionListener<VcsCommitMetadata>
implements Disposable {
    private final VcsLogData logData;
    private final CommitDataLoader refsLoader;
    private final CommitDataLoader hashesResolver;
    private final ContainingBranchesAsyncLoader containingBranchesLoader;
    private final ExternalStatusesAsyncLoader externalStatusesLoader;
    private int[] currentSelection;
    private final VcsLogColorManager colorManager;
    private final CommitDetailsListPanel detailsPanel;
    private static final int MAX_COMMITS_TO_LOAD = 50;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected int[] onSelection(@NotNull int[] selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        this.cancelLoading();
        this.currentSelection = selection;
        int[] nArray = selection;
        int n = selection.length;
        int n2 = 50;
        boolean bl = false;
        n = Math.min(n, n2);
        n2 = 0;
        int[] nArray2 = Arrays.copyOf(nArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onDetailsLoaded(@NotNull List<? extends VcsCommitMetadata> detailsList) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(detailsList, (String)"detailsList");
        Iterable $this$map$iv = detailsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new CommitId((Hash)it.getId(), it.getRoot());
            collection.add(object);
        }
        List commitIds = (List)destination$iv$iv;
        this.detailsPanel.rebuildPanel$intellij_platform_vcs_log_impl(commitIds);
        this.detailsPanel.showOverflowLabelIfNeeded(50, this.currentSelection.length);
        $i$f$map = false;
        Set unResolvedHashes = new LinkedHashSet();
        Iterable $this$map$iv2 = detailsList;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = CommitPresentationUtil.buildPresentation(this.logData.getProject(), (VcsCommitMetadata)it, unResolvedHashes);
            collection.add(object);
        }
        List presentations = (List)destination$iv$iv2;
        this.detailsPanel.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<Integer, CommitDetailsPanel, Unit>(this, presentations, commitIds){
            final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;
            final /* synthetic */ List $presentations;
            final /* synthetic */ List $commitIds;

            public final void invoke(int idx, @NotNull CommitDetailsPanel panel2) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                E e = this.$presentations.get(idx);
                Intrinsics.checkNotNullExpressionValue(e, (String)"presentations[idx]");
                CommitPresentationUtil.CommitPresentation presentation2 = (CommitPresentationUtil.CommitPresentation)e;
                panel2.setCommit(presentation2);
                CommitId commit2 = (CommitId)this.$commitIds.get(idx);
                VirtualFile virtualFile2 = commit2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"commit.root");
                VirtualFile root2 = virtualFile2;
                if (VcsLogCommitSelectionListenerForDetails.access$getColorManager$p(this.this$0).hasMultiplePaths()) {
                    JBColor jBColor = VcsLogGraphTable.getRootBackgroundColor(root2, VcsLogCommitSelectionListenerForDetails.access$getColorManager$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"VcsLogGraphTable.getRoot\u2026Color(root, colorManager)");
                    panel2.setRoot(new CommitDetailsPanel.RootColor(root2, (Color)jBColor));
                } else {
                    panel2.setRoot(null);
                }
            }
            {
                this.this$0 = vcsLogCommitSelectionListenerForDetails;
                this.$presentations = list2;
                this.$commitIds = list3;
                super(2);
            }
        }));
        this.refsLoader.loadData((Function1)new Function1<ProgressIndicator, List<? extends List<VcsRef>>>(this){
            final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<List<VcsRef>> invoke(@NotNull ProgressIndicator it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int[] nArray = VcsLogCommitSelectionListenerForDetails.access$getCurrentSelection$p(this.this$0);
                VcsLogGraphTable vcsLogGraphTable = VcsLogCommitSelectionListenerForDetails.access$getMyGraphTable$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"myGraphTable");
                GraphTableModel graphTableModel = vcsLogGraphTable.getModel();
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var8_8 = $this$mapTo$iv$iv;
                int n = ((void)var8_8).length;
                for (int j = 0; j < n; ++j) {
                    void p1;
                    void item$iv$iv;
                    void var12_12 = item$iv$iv = var8_8[j];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List<VcsRef> list2 = graphTableModel.getRefsAtRow((int)p1);
                    collection.add(list2);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = vcsLogCommitSelectionListenerForDetails;
                super(1);
            }
        }, (Function2)new Function2<CommitDetailsPanel, List<VcsRef>, Unit>(this){
            final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;

            public final void invoke(@NotNull CommitDetailsPanel panel2, @NotNull List<VcsRef> refs) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                Intrinsics.checkNotNullParameter(refs, (String)"refs");
                panel2.setRefs(VcsLogCommitSelectionListenerForDetails.access$sortRefs(this.this$0, refs));
            }
            {
                this.this$0 = vcsLogCommitSelectionListenerForDetails;
                super(2);
            }
        });
        ContainingBranchesAsyncLoader.requestData$default(this.containingBranchesLoader, commitIds, false, 2, null);
        this.externalStatusesLoader.requestData(commitIds);
        iterable = unResolvedHashes;
        boolean bl = false;
        if (!iterable.isEmpty()) {
            this.hashesResolver.loadData((Function1)new Function1<ProgressIndicator, List<? extends CommitPresentationUtil.CommitPresentation>>(this, presentations, unResolvedHashes){
                final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;
                final /* synthetic */ List $presentations;
                final /* synthetic */ Set $unResolvedHashes;

                @NotNull
                public final List<CommitPresentationUtil.CommitPresentation> invoke(@NotNull ProgressIndicator it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VcsLogCommitSelectionListenerForDetails.access$doResolveHashes(this.this$0, this.$presentations, this.$unResolvedHashes);
                }
                {
                    this.this$0 = vcsLogCommitSelectionListenerForDetails;
                    this.$presentations = list2;
                    this.$unResolvedHashes = set2;
                    super(1);
                }
            }, onDetailsLoaded.5.INSTANCE);
        }
    }

    private final List<VcsRef> sortRefs(Collection<? extends VcsRef> refs) {
        VcsRef vcsRef = (VcsRef)CollectionsKt.firstOrNull((Iterable)refs);
        if (vcsRef == null || (vcsRef = vcsRef.getRoot()) == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsRef, (String)"refs.firstOrNull()?.root ?: return emptyList()");
        VcsRef root2 = vcsRef;
        Iterable iterable = refs;
        VcsLogProvider vcsLogProvider = this.logData.getLogProvider((VirtualFile)root2);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogProvider, (String)"logData.getLogProvider(root)");
        VcsLogRefManager vcsLogRefManager = vcsLogProvider.getReferenceManager();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogRefManager, (String)"logData.getLogProvider(root).referenceManager");
        Comparator comparator2 = vcsLogRefManager.getLabelsOrderComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"logData.getLogProvider(r\u2026ger.labelsOrderComparator");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
    }

    @Override
    protected void onEmptySelection() {
        this.cancelLoading();
        String string = VcsLogBundle.message((String)"vcs.log.changes.details.no.commits.selected.status", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogBundle.message(\"vc\u2026commits.selected.status\")");
        this.setEmpty(string);
    }

    @Override
    protected void onLoadingStarted() {
        this.detailsPanel.startLoadingDetails();
    }

    @Override
    protected void onLoadingStopped() {
        this.detailsPanel.stopLoadingDetails();
    }

    @Override
    protected void onError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        String string = VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogBundle.message(\"vc\u2026og.error.loading.status\")");
        this.setEmpty(string);
    }

    private final void setEmpty(String text2) {
        this.detailsPanel.setStatusText(text2);
        this.currentSelection = new int[0];
        this.detailsPanel.rebuildPanel$intellij_platform_vcs_log_impl(CollectionsKt.emptyList());
        this.detailsPanel.showOverflowLabelIfNeeded(50, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommitPresentationUtil.CommitPresentation> doResolveHashes(List<? extends CommitPresentationUtil.CommitPresentation> presentations, Set<String> unResolvedHashes) {
        void $this$mapTo$iv$iv;
        Object hash;
        Object fullHash2;
        Object it;
        void $this$filterTo$iv$iv;
        MultiMap resolvedHashes = new MultiMap();
        Iterable $this$filter$iv = unResolvedHashes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((String)it).length() == 40)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fullHashes = (List)destination$iv$iv;
        for (Object fullHash2 : fullHashes) {
            Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)fullHash2), (String)"HashImpl.build(fullHash)");
            for (VirtualFile root2 : this.logData.getRoots()) {
                CommitId id2 = new CommitId(hash, root2);
                if (!this.logData.getStorage().containsCommit(id2)) continue;
                resolvedHashes.putValue(fullHash2, (Object)id2);
            }
            unResolvedHashes.remove(fullHash2);
        }
        fullHash2 = unResolvedHashes;
        $i$f$filter = false;
        if (!fullHash2.isEmpty()) {
            this.logData.getStorage().iterateCommits(new Predicate(unResolvedHashes, resolvedHashes){
                final /* synthetic */ Set $unResolvedHashes;
                final /* synthetic */ MultiMap $resolvedHashes;

                public final boolean test(@NotNull CommitId commitId2) {
                    Intrinsics.checkNotNullParameter((Object)commitId2, (String)"commitId");
                    for (String hashString : this.$unResolvedHashes) {
                        String string = commitId2.getHash().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commitId.hash.asString()");
                        if (!StringsKt.startsWith((String)string, (String)hashString, (boolean)true)) continue;
                        this.$resolvedHashes.putValue((Object)hashString, (Object)commitId2);
                    }
                    return true;
                }
                {
                    this.$unResolvedHashes = set2;
                    this.$resolvedHashes = multiMap;
                }
            });
        }
        Iterable $this$map$iv = presentations;
        boolean $i$f$map = false;
        hash = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommitPresentationUtil.CommitPresentation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CommitPresentationUtil.CommitPresentation commitPresentation = ((CommitPresentationUtil.CommitPresentation)it).resolve((MultiMap<String, CommitId>)resolvedHashes);
            collection.add(commitPresentation);
        }
        return (List)destination$iv$iv;
    }

    private final void cancelLoading() {
        this.hashesResolver.cancelLoading();
        this.refsLoader.cancelLoading();
        ContainingBranchesAsyncLoader.requestData$default(this.containingBranchesLoader, CollectionsKt.emptyList(), false, 2, null);
        this.externalStatusesLoader.requestData(CollectionsKt.emptyList());
    }

    public void dispose() {
        this.cancelLoading();
    }

    private VcsLogCommitSelectionListenerForDetails(VcsLogGraphTable graphTable, VcsLogColorManager colorManager, CommitDetailsListPanel detailsPanel, Disposable parentDisposable) {
        Object it;
        VcsLogData vcsLogData = graphTable.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"graphTable.logData");
        super(graphTable, vcsLogData.getMiniDetailsGetter());
        this.colorManager = colorManager;
        this.detailsPanel = detailsPanel;
        VcsLogData vcsLogData2 = graphTable.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData2, (String)"graphTable.logData");
        this.logData = vcsLogData2;
        this.refsLoader = new CommitDataLoader();
        this.hashesResolver = new CommitDataLoader();
        ContainingBranchesGetter containingBranchesGetter = this.logData.getContainingBranchesGetter();
        Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"logData.containingBranchesGetter");
        Object object = new ContainingBranchesAsyncLoader(containingBranchesGetter, this.detailsPanel);
        boolean bl = false;
        boolean bl2 = false;
        ContainingBranchesAsyncLoader containingBranchesAsyncLoader = object;
        VcsLogCommitSelectionListenerForDetails vcsLogCommitSelectionListenerForDetails = this;
        boolean bl3 = false;
        Disposer.register((Disposable)this, (Disposable)it);
        Unit unit = Unit.INSTANCE;
        vcsLogCommitSelectionListenerForDetails.containingBranchesLoader = object;
        Project project = this.logData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"logData.project");
        object = new ExternalStatusesAsyncLoader(project, this.detailsPanel);
        bl = false;
        bl2 = false;
        it = object;
        vcsLogCommitSelectionListenerForDetails = this;
        boolean bl4 = false;
        Disposer.register((Disposable)this, (Disposable)it);
        unit = Unit.INSTANCE;
        vcsLogCommitSelectionListenerForDetails.externalStatusesLoader = object;
        this.currentSelection = new int[0];
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public static final /* synthetic */ CommitDetailsListPanel access$getDetailsPanel$p(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.detailsPanel;
    }

    public static final /* synthetic */ VcsLogColorManager access$getColorManager$p(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.colorManager;
    }

    public static final /* synthetic */ int[] access$getCurrentSelection$p(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.currentSelection;
    }

    public static final /* synthetic */ void access$setCurrentSelection$p(VcsLogCommitSelectionListenerForDetails $this, int[] nArray) {
        $this.currentSelection = nArray;
    }

    public static final /* synthetic */ VcsLogGraphTable access$getMyGraphTable$p(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.myGraphTable;
    }

    public static final /* synthetic */ List access$sortRefs(VcsLogCommitSelectionListenerForDetails $this, Collection refs) {
        return $this.sortRefs(refs);
    }

    public static final /* synthetic */ List access$doResolveHashes(VcsLogCommitSelectionListenerForDetails $this, List presentations, Set unResolvedHashes) {
        return $this.doResolveHashes(presentations, unResolvedHashes);
    }

    public /* synthetic */ VcsLogCommitSelectionListenerForDetails(VcsLogGraphTable graphTable, VcsLogColorManager colorManager, CommitDetailsListPanel detailsPanel, Disposable parentDisposable, DefaultConstructorMarker $constructor_marker) {
        this(graphTable, colorManager, detailsPanel, parentDisposable);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable2, @NotNull VcsLogColorManager colorManager) {
        Companion.install(graphTable, detailsPanel, disposable2, colorManager);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable2) {
        com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails$Companion.install$default(Companion, graphTable, detailsPanel, disposable2, null, 8, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J@\u0010\u0007\u001a\u00020\u0006\"\u0004\b\u0000\u0010\b2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\n0\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00060\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$CommitDataLoader;", "", "(Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "cancelLoading", "", "loadData", "T", "Lkotlin/Function1;", "", "setData", "Lkotlin/Function2;", "Lcom/intellij/vcs/log/ui/details/commit/CommitDetailsPanel;", "intellij.platform.vcs.log.impl"})
    private final class CommitDataLoader {
        private ProgressIndicator progressIndicator;

        public final <T> void loadData(@NotNull Function1<? super ProgressIndicator, ? extends List<? extends T>> loadData2, @NotNull Function2<? super CommitDetailsPanel, ? super T, Unit> setData) {
            Intrinsics.checkNotNullParameter(loadData2, (String)"loadData");
            Intrinsics.checkNotNullParameter(setData, (String)"setData");
            this.progressIndicator = BackgroundTaskUtil.executeOnPooledThread(VcsLogCommitSelectionListenerForDetails.this, new Runnable(this, loadData2, setData){
                final /* synthetic */ CommitDataLoader this$0;
                final /* synthetic */ Function1 $loadData;
                final /* synthetic */ Function2 $setData;

                public final void run() {
                    ProgressIndicator indicator2;
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = indicator2 = progressManager.getProgressIndicator();
                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"indicator");
                    List loaded = (List)this.$loadData.invoke((Object)progressIndicator);
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, loaded){
                        final /* synthetic */ loadData.1 this$0;
                        final /* synthetic */ List $loaded;

                        public final void run() {
                            CommitDataLoader.access$setProgressIndicator$p(this.this$0.this$0, null);
                            VcsLogCommitSelectionListenerForDetails.access$getDetailsPanel$p(this.this$0.this$0.VcsLogCommitSelectionListenerForDetails.this).forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<Integer, CommitDetailsPanel, Unit>(this){
                                final /* synthetic */ CommitDataLoader.loadData.1 this$0;

                                public final void invoke(int i2, @NotNull CommitDetailsPanel panel2) {
                                    Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                                    this.this$0.this$0.$setData.invoke((Object)panel2, this.this$0.$loaded.get(i2));
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2);
                                }
                            }));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$loaded = list2;
                        }
                    }, new Condition(indicator2){
                        final /* synthetic */ ProgressIndicator $indicator;

                        public final boolean value(Object it) {
                            ProgressIndicator progressIndicator = this.$indicator;
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"indicator");
                            return progressIndicator.isCanceled();
                        }
                        {
                            this.$indicator = progressIndicator;
                        }
                    });
                }
                {
                    this.this$0 = commitDataLoader;
                    this.$loadData = function1;
                    this.$setData = function2;
                }
            });
        }

        public final void cancelLoading() {
            if (this.progressIndicator != null) {
                ProgressIndicator progressIndicator = this.progressIndicator;
                Intrinsics.checkNotNull((Object)progressIndicator);
                progressIndicator.cancel();
                this.progressIndicator = null;
            }
        }

        public static final /* synthetic */ ProgressIndicator access$getProgressIndicator$p(CommitDataLoader $this) {
            return $this.progressIndicator;
        }

        public static final /* synthetic */ void access$setProgressIndicator$p(CommitDataLoader $this, ProgressIndicator progressIndicator) {
            $this.progressIndicator = progressIndicator;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ContainingBranchesAsyncLoader;", "Lcom/intellij/openapi/Disposable;", "getter", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;)V", "requestedCommits", "", "Lcom/intellij/vcs/log/CommitId;", "branchesChanged", "", "dispose", "requestData", "commits", "fromCache", "", "intellij.platform.vcs.log.impl"})
    private static final class ContainingBranchesAsyncLoader
    implements Disposable {
        private List<? extends CommitId> requestedCommits;
        private final ContainingBranchesGetter getter;
        private final CommitDetailsListPanel detailsPanel;

        private final void branchesChanged() {
            this.requestData(this.requestedCommits, true);
        }

        public final void requestData(@NotNull List<? extends CommitId> commits, boolean fromCache) {
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            boolean bl = false;
            Map result2 = new LinkedHashMap();
            for (CommitId commitId2 : commits) {
                List<String> branches;
                List<String> list2;
                if (fromCache) {
                    VirtualFile virtualFile2 = commitId2.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"commit.root");
                    Hash hash = commitId2.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commit.hash");
                    list2 = this.getter.getContainingBranchesFromCache(virtualFile2, hash);
                } else {
                    VirtualFile virtualFile3 = commitId2.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"commit.root");
                    Hash hash = commitId2.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commit.hash");
                    list2 = this.getter.requestContainingBranches(virtualFile3, hash);
                }
                if ((branches = list2) == null) continue;
                result2.put(commitId2, branches);
            }
            Map map2 = result2;
            boolean bl2 = false;
            if (!map2.isEmpty()) {
                this.detailsPanel.forEachPanel((Function2<? super CommitId, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<CommitId, CommitDetailsPanel, Unit>(result2){
                    final /* synthetic */ Map $result;

                    public final void invoke(@NotNull CommitId commit2, @NotNull CommitDetailsPanel panel2) {
                        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
                        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                        panel2.setBranches((List)this.$result.get(commit2));
                    }
                    {
                        this.$result = map2;
                        super(2);
                    }
                }));
            }
            this.requestedCommits = commits;
        }

        public static /* synthetic */ void requestData$default(ContainingBranchesAsyncLoader containingBranchesAsyncLoader, List list2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            containingBranchesAsyncLoader.requestData(list2, bl);
        }

        public void dispose() {
        }

        public ContainingBranchesAsyncLoader(@NotNull ContainingBranchesGetter getter, @NotNull CommitDetailsListPanel detailsPanel) {
            Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            this.getter = getter;
            this.detailsPanel = detailsPanel;
            this.requestedCommits = CollectionsKt.emptyList();
            final Runnable containingBranchesListener2 = new Runnable(this){
                final /* synthetic */ ContainingBranchesAsyncLoader this$0;

                public final void run() {
                    ContainingBranchesAsyncLoader.access$branchesChanged(this.this$0);
                }
                {
                    this.this$0 = containingBranchesAsyncLoader;
                }
            };
            this.getter.addTaskCompletedListener(containingBranchesListener2);
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public final void dispose() {
                    getter.removeTaskCompletedListener(containingBranchesListener2);
                }
            });
        }

        public static final /* synthetic */ void access$branchesChanged(ContainingBranchesAsyncLoader $this) {
            $this.branchesChanged();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J\u0014\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;)V", "loaders", "", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader;", "loadersDisposable", "statuses", "", "Lcom/intellij/vcs/log/CommitId;", "", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "dispose", "", "getLoaders", "requestData", "commits", "ProviderLoader", "intellij.platform.vcs.log.impl"})
    private static final class ExternalStatusesAsyncLoader
    implements Disposable {
        private Disposable loadersDisposable;
        private List<? extends ProviderLoader<?>> loaders;
        private Map<CommitId, Map<String, VcsCommitExternalStatusPresentation>> statuses;
        private final Project project;
        private final CommitDetailsListPanel detailsPanel;

        public final void requestData(@NotNull List<? extends CommitId> commits) {
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            boolean bl = false;
            this.statuses = new LinkedHashMap();
            if (commits.isEmpty()) {
                List<? extends ProviderLoader<?>> list2 = this.loaders;
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProviderLoader it = (ProviderLoader)element$iv;
                        boolean bl2 = false;
                        it.requestData(CollectionsKt.emptyList(), (Function1<Map<CommitId, VcsCommitExternalStatusPresentation>, Unit>)((Function1)requestData.1.1.INSTANCE));
                    }
                }
                return;
            }
            Iterable $this$forEach$iv = this.getLoaders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProviderLoader loader = (ProviderLoader)element$iv;
                boolean bl3 = false;
                loader.requestData(commits, (Function1<Map<CommitId, VcsCommitExternalStatusPresentation>, Unit>)((Function1)new Function1<Map<CommitId, ? extends VcsCommitExternalStatusPresentation>, Unit>(loader, this, commits){
                    final /* synthetic */ ProviderLoader $loader;
                    final /* synthetic */ ExternalStatusesAsyncLoader this$0;
                    final /* synthetic */ List $commits$inlined;
                    {
                        this.$loader = providerLoader;
                        this.this$0 = externalStatusesAsyncLoader;
                        this.$commits$inlined = list2;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Map<CommitId, ? extends VcsCommitExternalStatusPresentation> result2) {
                        Intrinsics.checkNotNullParameter(result2, (String)"result");
                        CommitId commitId2 = result2;
                        boolean bl = false;
                        Iterator<Map.Entry<CommitId, ? extends VcsCommitExternalStatusPresentation>> iterator2 = commitId2.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Object object;
                            void commit2;
                            Map.Entry<CommitId, ? extends VcsCommitExternalStatusPresentation> entry2;
                            Map.Entry<CommitId, ? extends VcsCommitExternalStatusPresentation> entry3 = entry2 = iterator2.next();
                            boolean bl2 = false;
                            commitId2 = entry3.getKey();
                            entry3 = entry2;
                            bl2 = false;
                            VcsCommitExternalStatusPresentation statusPresentation = entry3.getValue();
                            Map $this$getOrPut$iv = ExternalStatusesAsyncLoader.access$getStatuses$p(this.this$0);
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(commit2);
                            if (value$iv == null) {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                Map answer$iv = new LinkedHashMap<K, V>();
                                $this$getOrPut$iv.put(commit2, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            Map presentations = (Map)object;
                            if (statusPresentation == null) {
                                presentations.remove(this.$loader.getId());
                                continue;
                            }
                            presentations.put(this.$loader.getId(), statusPresentation);
                        }
                        ExternalStatusesAsyncLoader.access$getDetailsPanel$p(this.this$0).forEachPanel((Function2<? super CommitId, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<CommitId, CommitDetailsPanel, Unit>(this){
                            final /* synthetic */ ExternalStatusesAsyncLoader$requestData$$inlined$forEach$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }

                            public final void invoke(@NotNull CommitId commit2, @NotNull CommitDetailsPanel panel2) {
                                Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
                                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                                Object object = (Map)ExternalStatusesAsyncLoader.access$getStatuses$p(this.this$0.this$0).get(commit2);
                                List list2 = object != null && (object = object.values()) != null ? CollectionsKt.toList((Iterable)((Iterable)object)) : null;
                                boolean bl = false;
                                List list3 = list2;
                                if (list3 == null) {
                                    list3 = CollectionsKt.emptyList();
                                }
                                panel2.setStatuses(list3);
                            }
                        }));
                    }
                }));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<ProviderLoader<?>> getLoaders() {
            if (this.loaders == null && !Disposer.isDisposed((Disposable)this)) {
                Collection collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Disposable disposable2 = Disposer.newDisposable((Disposable)this, (String)"Status loaders");
                Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable(this, \"Status loaders\")");
                Disposable disposable3 = disposable2;
                Object[] objectArray = VcsCommitExternalStatusProvider.Companion.getEP$intellij_platform_vcs_log_impl().getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"VcsCommitExternalStatusProvider.EP.extensions");
                Object[] objectArray2 = objectArray;
                ExternalStatusesAsyncLoader externalStatusesAsyncLoader = this;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void provider2;
                    VcsCommitExternalStatusProvider vcsCommitExternalStatusProvider = (VcsCommitExternalStatusProvider)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v2 = provider2;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"provider");
                    ProviderLoader providerLoader = new ProviderLoader(this.project, v2);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ProviderLoader it = providerLoader;
                    boolean bl4 = false;
                    Disposer.register((Disposable)disposable3, (Disposable)it);
                    ProviderLoader providerLoader2 = providerLoader;
                    collection.add(providerLoader2);
                }
                collection = (List)destination$iv$iv;
                externalStatusesAsyncLoader.loaders = collection;
                this.loadersDisposable = disposable3;
            }
            List<ProviderLoader<?>> list2 = this.loaders;
            Intrinsics.checkNotNull(list2);
            return list2;
        }

        public void dispose() {
        }

        public ExternalStatusesAsyncLoader(@NotNull Project project, @NotNull CommitDetailsListPanel detailsPanel) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            this.project = project;
            this.detailsPanel = detailsPanel;
            boolean bl = false;
            this.statuses = new LinkedHashMap();
            VcsCommitExternalStatusProvider.Companion.addProviderListChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    Disposable disposable2 = loadersDisposable;
                    if (disposable2 != null) {
                        Disposable disposable3 = disposable2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Disposable it = disposable3;
                        boolean bl3 = false;
                        Disposer.dispose((Disposable)it);
                    }
                    loaders = null;
                    this.requestData(CollectionsKt.toList((Iterable)statuses.keySet()));
                }
            }));
        }

        public static final /* synthetic */ void access$setStatuses$p(ExternalStatusesAsyncLoader $this, Map map2) {
            $this.statuses = map2;
        }

        public static final /* synthetic */ CommitDetailsListPanel access$getDetailsPanel$p(ExternalStatusesAsyncLoader $this) {
            return $this.detailsPanel;
        }

        public static final /* synthetic */ void access$setLoadersDisposable$p(ExternalStatusesAsyncLoader $this, Disposable disposable2) {
            $this.loadersDisposable = disposable2;
        }

        public static final /* synthetic */ List access$getLoaders$p(ExternalStatusesAsyncLoader $this) {
            return $this.loaders;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132 \u0010\u0015\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017\u0012\u0004\u0012\u00020\u00100\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader;", "T", "Lcom/intellij/vcs/log/data/VcsCommitExternalStatus;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;)V", "id", "", "getId", "()Ljava/lang/String;", "loader", "Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;", "dispose", "", "requestData", "commits", "", "Lcom/intellij/vcs/log/CommitId;", "onChange", "Lkotlin/Function1;", "", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "intellij.platform.vcs.log.impl"})
        private static final class ProviderLoader<T extends VcsCommitExternalStatus>
        implements Disposable {
            @NotNull
            private final String id;
            private final VcsCommitsDataLoader<T> loader;
            private final Project project;
            private final VcsCommitExternalStatusProvider<T> provider;

            @NotNull
            public final String getId() {
                return this.id;
            }

            public final void requestData(@NotNull List<? extends CommitId> commits, @NotNull Function1<? super Map<CommitId, ? extends VcsCommitExternalStatusPresentation>, Unit> onChange) {
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
                this.loader.loadData(commits, (Function1)new Function1<Map<CommitId, ? extends T>, Unit>(this, onChange){
                    final /* synthetic */ ProviderLoader this$0;
                    final /* synthetic */ Function1 $onChange;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Map<CommitId, ? extends T> it) {
                        void $this$mapValuesTo$iv$iv;
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        Map<CommitId, T> $this$mapValues$iv = it;
                        boolean $i$f$mapValues = false;
                        Map<CommitId, T> map2 = $this$mapValues$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        boolean $i$f$mapValuesTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void commit2;
                            void $dstr$commit$status;
                            void it$iv$iv;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            Map map3 = destination$iv$iv;
                            boolean bl = false;
                            K k = it$iv$iv.getKey();
                            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                            K k2 = k;
                            Map map4 = map3;
                            boolean bl2 = false;
                            void var18_17 = $dstr$commit$status;
                            boolean bl3 = false;
                            CommitId commitId2 = (CommitId)var18_17.getKey();
                            var18_17 = $dstr$commit$status;
                            bl3 = false;
                            VcsCommitExternalStatus status = (VcsCommitExternalStatus)var18_17.getValue();
                            VcsCommitExternalStatusPresentation vcsCommitExternalStatusPresentation = ProviderLoader.access$getProvider$p(this.this$0).getPresentation(ProviderLoader.access$getProject$p(this.this$0), (CommitId)commit2, status);
                            map4.put(k2, vcsCommitExternalStatusPresentation);
                        }
                        Map presentations = destination$iv$iv;
                        this.$onChange.invoke((Object)presentations);
                    }
                    {
                        this.this$0 = providerLoader;
                        this.$onChange = function1;
                        super(1);
                    }
                });
            }

            public void dispose() {
            }

            /*
             * WARNING - void declaration
             */
            public ProviderLoader(@NotNull Project project, @NotNull VcsCommitExternalStatusProvider<T> provider2) {
                void it;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(provider2, (String)"provider");
                this.project = project;
                this.provider = provider2;
                this.id = this.provider.getId();
                VcsCommitsDataLoader<T> vcsCommitsDataLoader = this.provider.createLoader(this.project);
                boolean bl = false;
                boolean bl2 = false;
                VcsCommitsDataLoader<T> vcsCommitsDataLoader2 = vcsCommitsDataLoader;
                ProviderLoader providerLoader = this;
                boolean bl3 = false;
                Disposer.register((Disposable)this, (Disposable)((Disposable)it));
                Unit unit = Unit.INSTANCE;
                providerLoader.loader = vcsCommitsDataLoader;
            }

            public static final /* synthetic */ VcsCommitExternalStatusProvider access$getProvider$p(ProviderLoader $this) {
                return $this.provider;
            }

            public static final /* synthetic */ Project access$getProject$p(ProviderLoader $this) {
                return $this.project;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$Companion;", "", "()V", "MAX_COMMITS_TO_LOAD", "", "install", "", "graphTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        public final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable2, @NotNull VcsLogColorManager colorManager) {
            Intrinsics.checkNotNullParameter((Object)graphTable, (String)"graphTable");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            VcsLogCommitSelectionListenerForDetails listener2 = new VcsLogCommitSelectionListenerForDetails(graphTable, colorManager, detailsPanel, disposable2, null);
            graphTable.getSelectionModel().addListSelectionListener(listener2);
        }

        public static /* synthetic */ void install$default(Companion companion, VcsLogGraphTable vcsLogGraphTable, CommitDetailsListPanel commitDetailsListPanel, Disposable disposable2, VcsLogColorManager vcsLogColorManager, int n, Object object) {
            if ((n & 8) != 0) {
                VcsLogColorManager vcsLogColorManager2 = vcsLogGraphTable.getColorManager();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogColorManager2, (String)"graphTable.colorManager");
                vcsLogColorManager = vcsLogColorManager2;
            }
            companion.install(vcsLogGraphTable, commitDetailsListPanel, disposable2, vcsLogColorManager);
        }

        @JvmStatic
        @JvmOverloads
        public final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable2) {
            com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails$Companion.install$default(this, graphTable, detailsPanel, disposable2, null, 8, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

