/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogSpeedSearch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/ui/table/IndexSpeedSearch;", "Lcom/intellij/vcs/log/ui/table/VcsLogSpeedSearch;", "project", "Lcom/intellij/openapi/project/Project;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "component", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/index/VcsLogIndex;Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "matchResult", "Lcom/intellij/vcs/log/ui/table/IndexSpeedSearch$MatchResult;", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "getCommitSubject", "", "row", "", "getElementText", "", "isMatchingElement", "", "pattern", "isSpeedSearchEnabled", "matchUsers", "oldMatchResult", "newPattern", "MatchResult", "SimpleVcsLogUserFilter", "intellij.platform.vcs.log.impl"})
public class IndexSpeedSearch
extends VcsLogSpeedSearch {
    private final VcsUserRegistry userRegistry;
    private MatchResult matchResult;
    private final VcsLogIndex index;

    /*
     * WARNING - void declaration
     */
    private final MatchResult matchUsers(MatchResult oldMatchResult, String newPattern) {
        void $this$filterTo$iv$iv;
        Collection<VcsUser> collection;
        String oldPattern;
        IndexDataGetter dataGetter = this.index.getDataGetter();
        CharSequence charSequence = newPattern;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0 || dataGetter == null) {
            return null;
        }
        MatchResult matchResult = oldMatchResult;
        String string = oldPattern = matchResult != null ? matchResult.getPattern() : null;
        if (oldPattern != null && StringsKt.contains$default((CharSequence)newPattern, (CharSequence)oldPattern, (boolean)false, (int)2, null)) {
            collection = oldMatchResult.getMatchingUsers();
        } else {
            Set set2 = this.userRegistry.getUsers();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"userRegistry.users");
            collection = set2;
        }
        Collection<VcsUser> usersToExamine = collection;
        Iterable $this$filter$iv = usersToExamine;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsUser user = (VcsUser)element$iv$iv;
            boolean bl3 = false;
            if (!this.compare(VcsUserUtil.getShortPresentation(user), newPattern)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchedUsers = (List)destination$iv$iv;
        if (matchedUsers.isEmpty()) {
            return null;
        }
        Set<Integer> set3 = dataGetter.filter(CollectionsKt.listOf((Object)new SimpleVcsLogUserFilter(matchedUsers)));
        Intrinsics.checkNotNullExpressionValue(set3, (String)"dataGetter.filter(listOf\u2026serFilter(matchedUsers)))");
        Set<Integer> matchedByUserCommits = set3;
        return new MatchResult(newPattern, matchedByUserCommits, matchedUsers);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        if (super.isSpeedSearchEnabled()) {
            boolean bl;
            block4: {
                JComponent jComponent = this.myComponent;
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
                GraphTableModel graphTableModel = ((VcsLogGraphTable)((Object)jComponent)).getModel();
                Intrinsics.checkNotNullExpressionValue((Object)graphTableModel, (String)"myComponent.model");
                VisiblePack visiblePack = graphTableModel.getVisiblePack();
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"myComponent.model.visiblePack");
                VisiblePack visiblePack2 = visiblePack;
                Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)visiblePack2.getLogProviders().keySet(), visiblePack2.getFilters());
                Intrinsics.checkNotNullExpressionValue(set2, (String)"VcsLogUtil.getAllVisible\u2026eys, visiblePack.filters)");
                Iterable $this$all$iv = set2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (this.index.isIndexed(it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    @Override
    @Nullable
    protected String getElementText(@NotNull Object row2) {
        Intrinsics.checkNotNullParameter((Object)row2, (String)"row");
        throw (Throwable)new UnsupportedOperationException("Getting row text in a Log is unsupported since we match commit subject and author separately.");
    }

    private final String getCommitSubject(int row2) {
        IndexDataGetter indexDataGetter = this.index.getDataGetter();
        if (indexDataGetter == null) {
            return super.getElementText(row2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)indexDataGetter, (String)"index.dataGetter ?: retu\u2026super.getElementText(row)");
        IndexDataGetter dataGetter = indexDataGetter;
        JComponent jComponent = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
        Integer n = ((VcsLogGraphTable)((Object)jComponent)).getModel().getIdAtRow(row2);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"myComponent.model.getIdAtRow(row)");
        int id2 = n;
        String string = dataGetter.getFullMessage(id2);
        if (string == null) {
            return super.getElementText(row2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataGetter.getFullMessag\u2026super.getElementText(row)");
        String message2 = string;
        return IndexedDetails.Companion.getSubject(message2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isMatchingElement(@NotNull Object row2, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)row2, (String)"row");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String str = this.getCommitSubject((Integer)row2);
        if (str != null && this.compare(str, pattern)) {
            return true;
        }
        MatchResult matchResult = this.matchResult;
        if (matchResult == null) return false;
        MatchResult matchResult2 = matchResult;
        boolean bl = false;
        boolean bl2 = false;
        MatchResult $this$run = matchResult2;
        boolean bl3 = false;
        Collection collection = $this$run.getCommitsForUsers();
        boolean bl4 = false;
        if (collection.isEmpty()) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        Set<Integer> set2 = $this$run.getCommitsForUsers();
        JComponent jComponent = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
        if (!set2.contains(((VcsLogGraphTable)((Object)jComponent)).getModel().getIdAtRow(((Number)row2).intValue()))) return false;
        return true;
    }

    public IndexSpeedSearch(@NotNull Project project, @NotNull VcsLogIndex index2, @NotNull VcsLogGraphTable component2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        super(component2);
        this.index = index2;
        Object object = project.getService(VcsUserRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(VcsUserRegistry::class.java)");
        this.userRegistry = (VcsUserRegistry)object;
        this.addChangeListener(new PropertyChangeListener(){

            @Override
            public final void propertyChange(@NotNull PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"enteredPrefix")) {
                    MatchResult matchResult = matchResult;
                    Object object = evt.getNewValue();
                    if (!(object instanceof String)) {
                        object = null;
                    }
                    matchResult = this.matchUsers(matchResult, (String)object);
                }
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/ui/table/IndexSpeedSearch$MatchResult;", "", "pattern", "", "commitsForUsers", "", "", "matchingUsers", "", "Lcom/intellij/vcs/log/VcsUser;", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Collection;)V", "getCommitsForUsers", "()Ljava/util/Set;", "getMatchingUsers", "()Ljava/util/Collection;", "getPattern", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.vcs.log.impl"})
    private static final class MatchResult {
        @NotNull
        private final String pattern;
        @NotNull
        private final Set<Integer> commitsForUsers;
        @NotNull
        private final Collection<VcsUser> matchingUsers;

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Set<Integer> getCommitsForUsers() {
            return this.commitsForUsers;
        }

        @NotNull
        public final Collection<VcsUser> getMatchingUsers() {
            return this.matchingUsers;
        }

        public MatchResult(@NotNull String pattern, @NotNull Set<Integer> commitsForUsers, @NotNull Collection<? extends VcsUser> matchingUsers) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(commitsForUsers, (String)"commitsForUsers");
            Intrinsics.checkNotNullParameter(matchingUsers, (String)"matchingUsers");
            this.pattern = pattern;
            this.commitsForUsers = commitsForUsers;
            this.matchingUsers = matchingUsers;
        }

        public /* synthetic */ MatchResult(String string, Set set2, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 4) != 0) {
                collection = SetsKt.emptySet();
            }
            this(string, set2, collection);
        }

        @NotNull
        public final String component1() {
            return this.pattern;
        }

        @NotNull
        public final Set<Integer> component2() {
            return this.commitsForUsers;
        }

        @NotNull
        public final Collection<VcsUser> component3() {
            return this.matchingUsers;
        }

        @NotNull
        public final MatchResult copy(@NotNull String pattern, @NotNull Set<Integer> commitsForUsers, @NotNull Collection<? extends VcsUser> matchingUsers) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(commitsForUsers, (String)"commitsForUsers");
            Intrinsics.checkNotNullParameter(matchingUsers, (String)"matchingUsers");
            return new MatchResult(pattern, commitsForUsers, matchingUsers);
        }

        public static /* synthetic */ MatchResult copy$default(MatchResult matchResult, String string, Set set2, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                string = matchResult.pattern;
            }
            if ((n & 2) != 0) {
                set2 = matchResult.commitsForUsers;
            }
            if ((n & 4) != 0) {
                collection = matchResult.matchingUsers;
            }
            return matchResult.copy(string, set2, collection);
        }

        @NotNull
        public String toString() {
            return "MatchResult(pattern=" + this.pattern + ", commitsForUsers=" + this.commitsForUsers + ", matchingUsers=" + this.matchingUsers + ")";
        }

        public int hashCode() {
            String string = this.pattern;
            Set<Integer> set2 = this.commitsForUsers;
            Collection<VcsUser> collection = this.matchingUsers;
            return ((string != null ? string.hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MatchResult)) break block3;
                    MatchResult matchResult = (MatchResult)object;
                    if (!Intrinsics.areEqual((Object)this.pattern, (Object)matchResult.pattern) || !Intrinsics.areEqual(this.commitsForUsers, matchResult.commitsForUsers) || !Intrinsics.areEqual(this.matchingUsers, matchResult.matchingUsers)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter;", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "users", "", "Lcom/intellij/vcs/log/VcsUser;", "(Ljava/util/Collection;)V", "getUsers", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getValuesAsText", "", "matches", "", "details", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "intellij.platform.vcs.log.impl"})
    private static final class SimpleVcsLogUserFilter
    implements VcsLogUserFilter {
        private final Collection<VcsUser> users;

        @NotNull
        public Collection<VcsUser> getUsers(@NotNull VirtualFile root2) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            return this.users;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Collection<String> getValuesAsText() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.users;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsUser vcsUser = (VcsUser)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = VcsUserUtil.toExactString((VcsUser)it);
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        public boolean matches(@NotNull VcsCommitMetadata details2) {
            Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
            return this.users.contains(details2.getAuthor());
        }

        public SimpleVcsLogUserFilter(@NotNull Collection<? extends VcsUser> users) {
            Intrinsics.checkNotNullParameter(users, (String)"users");
            this.users = users;
        }
    }
}

