/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/ui/table/column/Commit;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell;", "()V", "createTableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "getStubValue", "model", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "getValue", "row", "", "intellij.platform.vcs.log.impl"})
public final class Commit
extends VcsLogDefaultColumn<GraphCommitCell> {
    @NotNull
    public static final Commit INSTANCE;

    @Override
    @NotNull
    public GraphCommitCell getValue(@NotNull GraphTableModel model2, int row2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        VcsCommitMetadata vcsCommitMetadata = model2.getCommitMetadata(row2);
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"model.getCommitMetadata(row)");
        String string = vcsCommitMetadata.getSubject();
        Collection collection = model2.getRefsAtRow(row2);
        VisiblePack visiblePack = model2.getVisiblePack();
        Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"model.visiblePack");
        RowInfo rowInfo = visiblePack.getVisibleGraph().getRowInfo(row2);
        Intrinsics.checkNotNullExpressionValue((Object)rowInfo, (String)"model.visiblePack.visibleGraph.getRowInfo(row)");
        return new GraphCommitCell(string, collection, rowInfo.getPrintElements());
    }

    @Override
    @NotNull
    public TableCellRenderer createTableCellRenderer(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        GraphCellPainter graphCellPainter2 = new SimpleGraphCellPainter(table, new DefaultColorGenerator()){
            final /* synthetic */ VcsLogGraphTable $table;

            protected int getRowHeight() {
                return this.$table.getRowHeight();
            }
            {
                this.$table = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        GraphCommitCellRenderer commitCellRenderer = new GraphCommitCellRenderer(table.getLogData(), graphCellPainter2, table);
        Boolean bl = table.getProperties().get(CommonUiProperties.COMPACT_REFERENCES_VIEW);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"table.properties[CommonU\u2026.COMPACT_REFERENCES_VIEW]");
        commitCellRenderer.setCompactReferencesView(bl);
        Boolean bl2 = table.getProperties().get(CommonUiProperties.SHOW_TAG_NAMES);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"table.properties[CommonU\u2026roperties.SHOW_TAG_NAMES]");
        commitCellRenderer.setShowTagsNames(bl2);
        Boolean bl3 = table.getProperties().get(CommonUiProperties.LABELS_LEFT_ALIGNED);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"table.properties[CommonU\u2026ties.LABELS_LEFT_ALIGNED]");
        commitCellRenderer.setLeftAligned(bl3);
        VcsLogDefaultColumnKt.access$doOnPropertyChange(table, new Function1<VcsLogUiProperties.VcsLogUiProperty<?>, Unit>(commitCellRenderer, table){
            final /* synthetic */ GraphCommitCellRenderer $commitCellRenderer;
            final /* synthetic */ VcsLogGraphTable $table;

            public final void invoke(@NotNull VcsLogUiProperties.VcsLogUiProperty<?> property2) {
                Intrinsics.checkNotNullParameter(property2, (String)"property");
                if (Intrinsics.areEqual(CommonUiProperties.COMPACT_REFERENCES_VIEW, property2)) {
                    Boolean bl = this.$table.getProperties().get(CommonUiProperties.COMPACT_REFERENCES_VIEW);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"table.properties[CommonU\u2026.COMPACT_REFERENCES_VIEW]");
                    this.$commitCellRenderer.setCompactReferencesView(bl);
                    this.$table.repaint();
                } else if (Intrinsics.areEqual(CommonUiProperties.SHOW_TAG_NAMES, property2)) {
                    Boolean bl = this.$table.getProperties().get(CommonUiProperties.SHOW_TAG_NAMES);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"table.properties[CommonU\u2026roperties.SHOW_TAG_NAMES]");
                    this.$commitCellRenderer.setShowTagsNames(bl);
                    this.$table.repaint();
                } else if (Intrinsics.areEqual(CommonUiProperties.LABELS_LEFT_ALIGNED, property2)) {
                    Boolean bl = this.$table.getProperties().get(CommonUiProperties.LABELS_LEFT_ALIGNED);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"table.properties[CommonU\u2026ties.LABELS_LEFT_ALIGNED]");
                    this.$commitCellRenderer.setLeftAligned(bl);
                    this.$table.repaint();
                }
            }
            {
                this.$commitCellRenderer = graphCommitCellRenderer;
                this.$table = vcsLogGraphTable;
                super(1);
            }
        });
        VcsLogDefaultColumnKt.access$updateTableOnCommitDetailsLoaded(this, table);
        return commitCellRenderer;
    }

    @Override
    @NotNull
    public GraphCommitCell getStubValue(@NotNull GraphTableModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new GraphCommitCell("", CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private Commit() {
        String string = VcsLogBundle.message((String)"vcs.log.column.subject", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogBundle.message(\"vcs.log.column.subject\")");
        super("Default.Subject", string, false, null);
    }

    static {
        Commit commit2;
        INSTANCE = commit2 = new Commit();
    }
}

