/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsUser;
import it.unimi.dsi.fastutil.Hash;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsUserUtil {
    @NotNull
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w+)[\\p{Punct}\\s](\\w+)");
    @NotNull
    private static final Pattern PRINTABLE_ASCII_PATTERN = Pattern.compile("[ -~]*");

    @NotNull
    @NlsSafe
    public static String toExactString(@NotNull VcsUser user) {
        if (user == null) {
            VcsUserUtil.$$$reportNull$$$0(0);
        }
        return VcsUserUtil.getString(user.getName(), user.getEmail());
    }

    @NotNull
    private static String getString(@NotNull String name2, @NotNull String email) {
        if (name2 == null) {
            VcsUserUtil.$$$reportNull$$$0(1);
        }
        if (email == null) {
            VcsUserUtil.$$$reportNull$$$0(2);
        }
        if (name2.isEmpty()) {
            String string = email;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (email.isEmpty()) {
            String string = name2;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = name2 + " <" + email + ">";
        if (string == null) {
            VcsUserUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isSamePerson(@NotNull VcsUser user1, @NotNull VcsUser user2) {
        if (user1 == null) {
            VcsUserUtil.$$$reportNull$$$0(6);
        }
        if (user2 == null) {
            VcsUserUtil.$$$reportNull$$$0(7);
        }
        return VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user1)).equals(VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user2)));
    }

    @NotNull
    @NlsSafe
    public static String getShortPresentation(@NotNull VcsUser user) {
        if (user == null) {
            VcsUserUtil.$$$reportNull$$$0(8);
        }
        return VcsUserUtil.getName(user);
    }

    @NotNull
    @NlsSafe
    private static String getName(@NotNull VcsUser user) {
        if (user == null) {
            VcsUserUtil.$$$reportNull$$$0(9);
        }
        return VcsUserUtil.getUserName(user.getName(), user.getEmail());
    }

    @NotNull
    public static String getUserName(@NotNull String name2, @NotNull String email) {
        if (name2 == null) {
            VcsUserUtil.$$$reportNull$$$0(10);
        }
        if (email == null) {
            VcsUserUtil.$$$reportNull$$$0(11);
        }
        if (!name2.isEmpty()) {
            String string = name2;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String emailNamePart = VcsUserUtil.getNameFromEmail(email);
        if (emailNamePart != null) {
            String string = emailNamePart;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = email;
        if (string == null) {
            VcsUserUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static String getNameFromEmail(@NotNull String email) {
        if (email == null) {
            VcsUserUtil.$$$reportNull$$$0(15);
        }
        int at = email.indexOf(64);
        String emailNamePart = null;
        if (at > 0) {
            emailNamePart = email.substring(0, at);
        }
        return emailNamePart;
    }

    @NotNull
    public static String getNameInStandardForm(@NotNull String name2) {
        Couple<String> firstAndLastName;
        if (name2 == null) {
            VcsUserUtil.$$$reportNull$$$0(16);
        }
        if ((firstAndLastName = VcsUserUtil.getFirstAndLastName(name2)) != null) {
            String string = StringUtil.toLowerCase((String)((String)firstAndLastName.first)) + " " + StringUtil.toLowerCase((String)((String)firstAndLastName.second));
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        return VcsUserUtil.nameToLowerCase(name2);
    }

    @Nullable
    public static Couple<String> getFirstAndLastName(@NotNull String name2) {
        Matcher matcher;
        if (name2 == null) {
            VcsUserUtil.$$$reportNull$$$0(18);
        }
        if ((matcher = NAME_PATTERN.matcher(name2)).matches()) {
            return Couple.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    @NotNull
    public static String nameToLowerCase(@NotNull String name2) {
        if (name2 == null) {
            VcsUserUtil.$$$reportNull$$$0(19);
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name2).matches()) {
            String string = name2;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = StringUtil.toLowerCase((String)name2);
        if (string == null) {
            VcsUserUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String capitalizeName(@NotNull String name2) {
        if (name2 == null) {
            VcsUserUtil.$$$reportNull$$$0(22);
        }
        if (name2.isEmpty()) {
            String string = name2;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name2).matches()) {
            String string = name2;
            if (string == null) {
                VcsUserUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = StringUtil.toUpperCase((String)name2.substring(0, 1)) + name2.substring(1);
        if (string == null) {
            VcsUserUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String emailToLowerCase(@NotNull String email) {
        if (email == null) {
            VcsUserUtil.$$$reportNull$$$0(26);
        }
        String string = StringUtil.toLowerCase((String)email);
        if (string == null) {
            VcsUserUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 1: 
            case 10: 
            case 16: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 11: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "email";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsUserUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsUserUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameInStandardForm";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToLowerCase";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "emailToLowerCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toExactString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSamePerson";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getShortPresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromEmail";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNameInStandardForm";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAndLastName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "nameToLowerCase";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "emailToLowerCase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VcsUserHashingStrategy
    implements Hash.Strategy<VcsUser> {
        public int hashCode(@Nullable VcsUser user) {
            return user != null ? VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user)).hashCode() : 0;
        }

        public boolean equals(@Nullable VcsUser user1, @Nullable VcsUser user2) {
            if (user1 == user2) {
                return true;
            }
            if (user1 == null || user2 == null) {
                return false;
            }
            return VcsUserUtil.isSamePerson(user1, user2);
        }
    }
}

