/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.FilterByDetailsResult;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001fBA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ6\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002JH\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J<\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016JP\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u001c2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00103\u001a\u000204H\u0002JD\u00105\u001a\b\u0012\u0004\u0012\u0002060-2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u001cH\u0002J>\u0010<\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00010$0\u00112\u0006\u0010=\u001a\u00020>2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\b\u0010.\u001a\u0004\u0018\u00010\u001cH\u0002J@\u0010?\u001a\u00020*2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001f082\u0006\u0010+\u001a\u00020(2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010.\u001a\u0004\u0018\u00010\u001cH\u0002J2\u0010A\u001a\b\u0012\u0004\u0012\u0002060-2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u001fH\u0002J.\u0010E\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u00042\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002060\u0011H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\u001fH\u0002J$\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040-H\u0002J,\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u0006\u0010%\u001a\u00020OH\u0002J:\u0010K\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010P\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040-2\b\u0010Q\u001a\u0004\u0018\u00010O2\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J,\u0010K\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010P\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u0006\u0010+\u001a\u00020(J$\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u0006\u0010%\u001a\u00020SH\u0002JD\u0010T\u001a\b\u0012\u0004\u0012\u0002HV0U\"\u0004\b\u0000\u0010V2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u0018\u0010W\u001a\u0014\u0012\u0004\u0012\u00020Y\u0012\n\u0012\b\u0012\u0004\u0012\u0002HV0Z0XH\u0002J<\u0010[\u001a\u0002002\u0006\u0010\\\u001a\u00020I2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0002J.\u0010]\u001a\u0002002\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f082\u0006\u0010\\\u001a\u00020I2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0002J\"\u0010^\u001a\u0004\u0018\u0001062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u00042\u0006\u0010_\u001a\u00020`H\u0002J.\u0010a\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000206\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020bH\u0002J\u0018\u0010c\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\b\u0012\u0004\u0012\u0002060-H\u0002J\u0018\u0010d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\b\u0012\u0004\u0012\u00020e0-H\u0002R\u0016\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "topCommitsDetailsCache", "Lcom/intellij/vcs/log/data/TopCommitsCache;", "commitDetailsGetter", "Lcom/intellij/vcs/log/data/DataGetter;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "(Ljava/util/Map;Lcom/intellij/vcs/log/data/VcsLogStorage;Lcom/intellij/vcs/log/data/TopCommitsCache;Lcom/intellij/vcs/log/data/DataGetter;Lcom/intellij/vcs/log/data/index/VcsLogIndex;)V", "applyHashFilter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "hashFilter", "Lcom/intellij/vcs/log/VcsLogHashFilter;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "collectCommitsReachableFromHeads", "Lit/unimi/dsi/fastutil/ints/IntSet;", "matchingHeads", "", "", "createVisibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "matchingCommits", "fileHistoryData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "filter", "oldVisiblePack", "allFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "filterByDetails", "Lcom/intellij/vcs/log/visible/FilterByDetailsResult;", "filters", "visibleRoots", "", "commitCandidates", "forceFilterByVcs", "", "filterByRange", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult;", "rangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "filterDetailsInMemory", "Lcom/intellij/vcs/log/CommitId;", "permanentGraph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "detailsFilters", "", "Lcom/intellij/vcs/log/VcsLogDetailsFilter;", "filterWithIndex", "dataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "filterWithVcs", "graph", "filteredDetailsInVcs", "providers", "filterCollection", "maxCount", "getCommitsByRange", "root", "range", "getDetailsFromCache", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitIndex", "getMatchingHeads", "refsModel", "Lcom/intellij/vcs/log/data/RefsModel;", "roots", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "refs", "branchFilter", "revisionFilter", "Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "mapRefsForRoots", "", "T", "mapping", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "", "matchesAllFilters", "commit", "matchesAnyHead", "resolveCommit", "refName", "", "resolveCommits", "Lcom/intellij/vcs/log/VcsLogRangeFilter$RefRange;", "toCommitIndexes", "toReferencedCommitIndexes", "Lcom/intellij/vcs/log/VcsRef;", "RangeFilterResult", "intellij.platform.vcs.log.impl"})
public final class VcsLogFiltererImpl
implements VcsLogFilterer {
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    private final VcsLogStorage storage;
    private final TopCommitsCache topCommitsDetailsCache;
    private final DataGetter<? extends VcsFullCommitDetails> commitDetailsGetter;
    private final VcsLogIndex index;

    @Override
    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection allFilters, @NotNull CommitCountStage commitCount) {
        Pair<VisiblePack, CommitCountStage> hashFilterResult;
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)allFilters, (String)"allFilters");
        Intrinsics.checkNotNullParameter((Object)((Object)commitCount), (String)"commitCount");
        VcsLogHashFilter hashFilter = (VcsLogHashFilter)allFilters.get(VcsLogFilterCollection.HASH_FILTER);
        VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.HASH_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"VcsLogFilterCollection.HASH_FILTER");
        VcsLogFilterCollection filters = VcsLogFiltersKt.without(allFilters, filterKey);
        long start2 = System.currentTimeMillis();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty() && (hashFilterResult = this.applyHashFilter(dataPack, hashFilter, sortType, commitCount)) != null) {
            VcsLogFiltererImplKt.access$getLOG$p().debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for filtering by " + ((VisiblePack)hashFilterResult.getFirst()).getFilters() + ", sort type " + sortType);
            return hashFilterResult;
        }
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)dataPack.getLogProviders().keySet(), filters);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"VcsLogUtil.getAllVisible\u2026gProviders.keys, filters)");
        Set<VirtualFile> visibleRoots = set2;
        RefsModel refsModel = dataPack.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
        Set<Integer> matchingHeads = this.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)visibleRoots, filters);
        VcsLogRangeFilter rangeFilters = (VcsLogRangeFilter)allFilters.get(VcsLogFilterCollection.RANGE_FILTER);
        IntSet commitCandidates = null;
        boolean forceFilterByVcs = false;
        if (rangeFilters != null) {
            VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER);
            VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
            RefsModel refsModel2 = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"dataPack.refsModel");
            Set<Integer> explicitMatchingHeads = this.getMatchingHeads(refsModel2, (Collection<? extends VirtualFile>)visibleRoots, branchFilter, revisionFilter);
            IntSet commitsReachableFromHeads = explicitMatchingHeads != null ? this.collectCommitsReachableFromHeads(dataPack, explicitMatchingHeads) : (IntSet)new IntOpenHashSet();
            RangeFilterResult commitsForRangeFilter = this.filterByRange(dataPack, rangeFilters);
            if (commitsForRangeFilter instanceof RangeFilterResult.Commits) {
                commitCandidates = IntCollectionUtil.union(CollectionsKt.listOf((Object[])new IntSet[]{commitsReachableFromHeads, ((RangeFilterResult.Commits)commitsForRangeFilter).getCommits()}));
                forceFilterByVcs = false;
            } else if (commitsForRangeFilter instanceof RangeFilterResult.Error) {
                commitCandidates = null;
                forceFilterByVcs = true;
            } else if (commitsForRangeFilter instanceof RangeFilterResult.InvalidRange) {
                commitCandidates = null;
                forceFilterByVcs = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            RefsModel refsModel3 = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel3, (String)"dataPack.refsModel");
            Set<Integer> matchingHeadsFromRoots = this.getMatchingHeads(refsModel3, (Collection<? extends VirtualFile>)visibleRoots);
            matchingHeads = matchingHeadsFromRoots;
        } else {
            commitCandidates = null;
            forceFilterByVcs = false;
        }
        try {
            FilterByDetailsResult filterResult = this.filterByDetails(dataPack, filters, commitCount, (Collection<? extends VirtualFile>)visibleRoots, matchingHeads, commitCandidates, forceFilterByVcs);
            VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, filterResult.getMatchingCommits(), filterResult.getFileHistoryData());
            VisiblePack visiblePack = new VisiblePack(dataPack, visibleGraph, filterResult.getCanRequestMore(), filters);
            VcsLogFiltererImplKt.access$getLOG$p().debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for filtering by " + filters + ", sort type " + sortType);
            return new Pair((Object)visiblePack, (Object)filterResult.getCommitCount());
        }
        catch (VcsException e) {
            return new Pair((Object)new VisiblePack.ErrorVisiblePack(dataPack, filters, e), (Object)commitCount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IntSet collectCommitsReachableFromHeads(DataPack dataPack, Set<Integer> matchingHeads) {
        void $this$mapTo$iv$iv;
        PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
        if (!(permanentGraph instanceof PermanentGraphInfo)) {
            permanentGraph = null;
        }
        PermanentGraphInfo permanentGraphInfo = (PermanentGraphInfo)permanentGraph;
        if (permanentGraphInfo == null) {
            return (IntSet)new IntOpenHashSet();
        }
        PermanentGraphInfo permanentGraph2 = permanentGraphInfo;
        Iterable $this$map$iv = matchingHeads;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = permanentGraph2.getPermanentCommitsInfo().getNodeId((int)it);
            collection.add(n2);
        }
        List startIds = (List)destination$iv$iv;
        IntOpenHashSet result2 = new IntOpenHashSet();
        Collection collection = startIds;
        LinearGraph linearGraph = permanentGraph2.getLinearGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"permanentGraph.linearGraph");
        new DfsWalk(collection, linearGraph).walk(true, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(result2, permanentGraph2){
            final /* synthetic */ IntOpenHashSet $result;
            final /* synthetic */ PermanentGraphInfo $permanentGraph;

            public final boolean invoke(int node2) {
                CommitId CommitId2 = this.$permanentGraph.getPermanentCommitsInfo().getCommitId(node2);
                Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"permanentGraph.permanent\u2026itsInfo.getCommitId(node)");
                this.$result.add(((Number)CommitId2).intValue());
                return true;
            }
            {
                this.$result = intOpenHashSet;
                this.$permanentGraph = permanentGraphInfo;
                super(1);
            }
        }));
        return (IntSet)result2;
    }

    private final VisibleGraph<Integer> createVisibleGraph(DataPack dataPack, PermanentGraph.SortType sortType, Set<Integer> matchingHeads, Set<Integer> matchingCommits, FileHistoryData fileHistoryData) {
        PermanentGraph<Integer> permanentGraph;
        block5: {
            Set set2;
            block7: {
                block6: {
                    if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || VcsLogFiltererImplKt.matchesNothing(matchingCommits)) {
                        VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
                        Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"EmptyVisibleGraph.getInstance()");
                        return visibleGraph;
                    }
                    PermanentGraph<Integer> permanentGraph2 = dataPack.getPermanentGraph();
                    Intrinsics.checkNotNullExpressionValue(permanentGraph2, (String)"dataPack.permanentGraph");
                    permanentGraph = permanentGraph2;
                    if (!(permanentGraph instanceof PermanentGraphImpl) || fileHistoryData == null) {
                        VisibleGraph visibleGraph = permanentGraph.createVisibleGraph(sortType, matchingHeads, matchingCommits);
                        Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"permanentGraph.createVis\u2026ngHeads, matchingCommits)");
                        return visibleGraph;
                    }
                    if (fileHistoryData.getStartPaths$intellij_platform_vcs_log_impl().size() != 1 || !((FilePath)CollectionsKt.single((Iterable)fileHistoryData.getStartPaths$intellij_platform_vcs_log_impl())).isDirectory()) break block5;
                    set2 = matchingCommits;
                    if (set2 == null) break block6;
                    Set set3 = set2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Set it = set3;
                    boolean bl3 = false;
                    set2 = CollectionsKt.subtract((Iterable)fileHistoryData.getCommitsWithRenames(), (Iterable)it);
                    if (set2 != null) break block7;
                }
                set2 = SetsKt.emptySet();
            }
            Set unmatchedRenames = set2;
            FileHistoryBuilder preprocessor2 = new FileHistoryBuilder(null, (FilePath)CollectionsKt.single((Iterable)fileHistoryData.getStartPaths$intellij_platform_vcs_log_impl()), fileHistoryData, FileHistory.Companion.getEMPTY$intellij_platform_vcs_log_impl(), unmatchedRenames, FileHistoryBuilder.Companion.isRemoveTrivialMerges$intellij_platform_vcs_log_impl(), FileHistoryBuilder.Companion.isRefine$intellij_platform_vcs_log_impl());
            Set set4 = matchingCommits;
            VisibleGraph<Integer> visibleGraph = ((PermanentGraphImpl)permanentGraph).createVisibleGraph(sortType, matchingHeads, set4 != null ? CollectionsKt.union((Iterable)set4, (Iterable)unmatchedRenames) : null, preprocessor2);
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"permanentGraph.createVis\u2026edRenames), preprocessor)");
            return visibleGraph;
        }
        BiConsumer preprocessor3 = new BiConsumer(fileHistoryData){
            final /* synthetic */ FileHistoryData $fileHistoryData;

            public final void accept(LinearGraphController controller, PermanentGraphInfo<Integer> permanentGraphInfo) {
                LinearGraphController linearGraphController = controller;
                Intrinsics.checkNotNullExpressionValue((Object)linearGraphController, (String)"controller");
                PermanentGraphInfo<Integer> permanentGraphInfo2 = permanentGraphInfo;
                Intrinsics.checkNotNullExpressionValue(permanentGraphInfo2, (String)"permanentGraphInfo");
                FileHistoryKt.removeTrivialMerges(linearGraphController, permanentGraphInfo2, this.$fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)createVisibleGraph.preprocessor.1.INSTANCE));
            }
            {
                this.$fileHistoryData = fileHistoryData;
            }
        };
        VisibleGraph<Integer> visibleGraph = ((PermanentGraphImpl)permanentGraph).createVisibleGraph(sortType, matchingHeads, matchingCommits, preprocessor3);
        Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"permanentGraph.createVis\u2026ingCommits, preprocessor)");
        return visibleGraph;
    }

    /*
     * WARNING - void declaration
     */
    private final FilterByDetailsResult filterByDetails(DataPack dataPack, VcsLogFilterCollection filters, CommitCountStage commitCount, Collection<? extends VirtualFile> visibleRoots, Set<Integer> matchingHeads, IntSet commitCandidates, boolean forceFilterByVcs) throws VcsException {
        Set<Integer> set2;
        VcsLogFilterCollection filtersForVcs;
        void filteredWithIndex;
        Pair<Set<Integer>, FileHistoryData> pair;
        void rootsForIndex;
        Pair pair2;
        Collection first$iv;
        List list2 = filters.getDetailsFilters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"filters.detailsFilters");
        List detailsFilters = list2;
        if (!forceFilterByVcs && detailsFilters.isEmpty()) {
            return new FilterByDetailsResult((Set)commitCandidates, false, commitCount, null, 8, null);
        }
        IndexDataGetter dataGetter = this.index.getDataGetter();
        if (dataGetter != null && dataGetter.canFilter(detailsFilters) && !forceFilterByVcs) {
            Iterable $this$partition$iv = visibleRoots;
            boolean $i$f$partition = false;
            first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (this.index.isIndexed(it)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            pair2 = new Pair(first$iv, second$iv);
        } else {
            pair2 = new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.toList((Iterable)visibleRoots));
        }
        Object object = pair2;
        List list3 = (List)object.component1();
        List rootsForVcs = (List)object.component2();
        first$iv = (Collection)rootsForIndex;
        boolean second$iv = false;
        if (!first$iv.isEmpty()) {
            IndexDataGetter indexDataGetter = dataGetter;
            Intrinsics.checkNotNull((Object)indexDataGetter);
            pair = this.filterWithIndex(indexDataGetter, detailsFilters, commitCandidates);
        } else {
            pair = new Pair<Set<Integer>, FileHistoryData>(null, null);
        }
        Pair<Set<Integer>, FileHistoryData> $i$f$partition = pair;
        object = (Set)$i$f$partition.component1();
        FileHistoryData historyData = (FileHistoryData)$i$f$partition.component2();
        if (rootsForVcs.isEmpty()) {
            return new FilterByDetailsResult((Set<Integer>)filteredWithIndex, false, commitCount, historyData);
        }
        boolean filterAllWithVcs = rootsForVcs.containsAll(visibleRoots);
        VcsLogFilterCollection vcsLogFilterCollection = filtersForVcs = filterAllWithVcs ? filters : VcsLogFiltersKt.with(filters, (VcsLogFilter)VcsLogFilterObject.fromRoots(rootsForVcs));
        if (filterAllWithVcs) {
            set2 = matchingHeads;
        } else {
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
            set2 = this.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)rootsForVcs, filtersForVcs);
        }
        Set<Integer> headsForVcs = set2;
        PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
        Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"dataPack.permanentGraph");
        FilterByDetailsResult filteredWithVcs = this.filterWithVcs(permanentGraph, filtersForVcs, headsForVcs, commitCount, commitCandidates);
        Set<Integer> filteredCommits = VcsLogFiltererImplKt.union(filteredWithIndex, filteredWithVcs.getMatchingCommits());
        return new FilterByDetailsResult(filteredCommits, filteredWithVcs.getCanRequestMore(), filteredWithVcs.getCommitCount(), historyData);
    }

    private final RangeFilterResult filterByRange(DataPack dataPack, VcsLogRangeFilter rangeFilter) {
        IntOpenHashSet set2 = new IntOpenHashSet();
        for (VcsLogRangeFilter.RefRange range2 : rangeFilter.getRanges()) {
            boolean rangeResolvedAnywhere = false;
            Map<VirtualFile, VcsLogProvider> map2 = this.logProviders;
            boolean bl = false;
            Iterator<Map.Entry<VirtualFile, VcsLogProvider>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<VirtualFile, VcsLogProvider> entry2;
                Map.Entry<VirtualFile, VcsLogProvider> entry3 = entry2 = iterator2.next();
                boolean bl2 = false;
                VirtualFile root2 = entry3.getKey();
                Pair<CommitId, CommitId> resolvedRange = this.resolveCommits(dataPack, root2, range2);
                if (resolvedRange == null) continue;
                IntSet commits = this.getCommitsByRange(dataPack, root2, resolvedRange);
                if (commits == null) {
                    return RangeFilterResult.Error.INSTANCE;
                }
                set2.addAll((IntCollection)commits);
                rangeResolvedAnywhere = true;
            }
            if (rangeResolvedAnywhere) continue;
            VcsLogFiltererImplKt.access$getLOG$p().warn("Range limits unresolved for: " + range2);
            return RangeFilterResult.InvalidRange.INSTANCE;
        }
        return new RangeFilterResult.Commits((IntSet)set2);
    }

    private final Pair<CommitId, CommitId> resolveCommits(DataPack dataPack, VirtualFile root2, VcsLogRangeFilter.RefRange range2) {
        CommitId from2 = this.resolveCommit(dataPack, root2, range2.getExclusiveRef());
        CommitId to = this.resolveCommit(dataPack, root2, range2.getInclusiveRef());
        if (from2 == null || to == null) {
            VcsLogFiltererImplKt.access$getLOG$p().debug("Range limits unresolved for: " + range2 + " in " + root2);
            return null;
        }
        return TuplesKt.to((Object)from2, (Object)to);
    }

    private final IntSet getCommitsByRange(DataPack dataPack, VirtualFile root2, Pair<? extends CommitId, ? extends CommitId> range2) {
        int fromIndex = this.storage.getCommitIndex(((CommitId)range2.getFirst()).getHash(), root2);
        int toIndex = this.storage.getCommitIndex(((CommitId)range2.getSecond()).getHash(), root2);
        return DataPackUtilKt.subgraphDifference(dataPack, toIndex, fromIndex);
    }

    private final CommitId resolveCommit(DataPack dataPack, VirtualFile root2, String refName) {
        if (VcsLogUtil.isFullHash(refName)) {
            CommitId commitId2 = new CommitId(HashImpl.build(refName), root2);
            return this.storage.containsCommit(commitId2) ? commitId2 : null;
        }
        RefsModel refsModel = dataPack.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
        VcsRef ref = DataPackUtilKt.findBranch(refsModel, refName, root2);
        return ref != null ? new CommitId(ref.getCommitHash(), root2) : (refName.length() >= 8 && VcsLogUtil.HASH_REGEX.matcher(refName).matches() ? this.storage.findCommitId(new CommitIdByStringCondition(refName)) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Set<Integer>, FileHistoryData> filterWithIndex(IndexDataGetter dataGetter, List<? extends VcsLogDetailsFilter> detailsFilters, IntSet commitCandidates) {
        void $this$filterNotTo$iv$iv;
        VcsLogStructureFilter vcsLogStructureFilter = (VcsLogStructureFilter)CollectionsKt.singleOrNull((List)CollectionsKt.filterIsInstance((Iterable)detailsFilters, VcsLogStructureFilter.class));
        if (vcsLogStructureFilter == null) {
            return new Pair((Object)dataGetter.filter(detailsFilters, commitCandidates), null);
        }
        VcsLogStructureFilter structureFilter = vcsLogStructureFilter;
        FileHistoryData historyData = dataGetter.createFileHistoryData(structureFilter.getFiles()).build();
        IntSet candidates = IntCollectionUtil.intersect(historyData.getCommits(), commitCandidates);
        Iterable $this$filterNot$iv = detailsFilters;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            VcsLogDetailsFilter it = (VcsLogDetailsFilter)element$iv$iv;
            boolean bl = false;
            if (it instanceof VcsLogStructureFilter) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtersWithoutStructure = (List)destination$iv$iv;
        if (filtersWithoutStructure.isEmpty()) {
            return new Pair((Object)candidates, (Object)historyData);
        }
        return new Pair((Object)dataGetter.filter(filtersWithoutStructure, candidates), (Object)historyData);
    }

    private final FilterByDetailsResult filterWithVcs(PermanentGraph<Integer> graph2, VcsLogFilterCollection filters, Set<Integer> matchingHeads, CommitCountStage commitCount, IntSet commitCandidates) throws VcsException {
        Set<Integer> commitsFromVcs;
        CommitCountStage commitCountToTry = commitCount;
        if (commitCountToTry == CommitCountStage.INITIAL) {
            if (filters.get(VcsLogFilterCollection.RANGE_FILTER) == null) {
                List list2 = filters.getDetailsFilters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"filters.detailsFilters");
                Set<Integer> commitsFromMemory = this.toCommitIndexes(this.filterDetailsInMemory(graph2, list2, matchingHeads, commitCandidates));
                if (commitsFromMemory.size() >= commitCountToTry.getCount()) {
                    return new FilterByDetailsResult(commitsFromMemory, true, commitCountToTry, null, 8, null);
                }
            }
            CommitCountStage commitCountStage = commitCountToTry.next();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commitCountStage), (String)"commitCountToTry.next()");
            commitCountToTry = commitCountStage;
        }
        return new FilterByDetailsResult(commitsFromVcs, (commitsFromVcs = this.toCommitIndexes(this.filteredDetailsInVcs(this.logProviders, filters, commitCountToTry.getCount()))).size() >= commitCountToTry.getCount(), commitCountToTry, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CommitId> filteredDetailsInVcs(Map<VirtualFile, ? extends VcsLogProvider> providers, VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        boolean bl = false;
        List commits = new ArrayList();
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)providers.keySet(), filterCollection);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"VcsLogUtil.getAllVisible\u2026s.keys, filterCollection)");
        Set<VirtualFile> visibleRoots = set2;
        Iterator<VirtualFile> iterator2 = visibleRoots.iterator();
        while (iterator2.hasNext()) {
            Collection<CommitId> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List matchingCommits;
            void exclusiveRef;
            VcsLogFilterCollection vcsLogFilterCollection;
            Set<FilePath> filesForRoot;
            VirtualFile root2;
            VirtualFile virtualFile2 = root2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"root");
            VcsLogProvider provider2 = (VcsLogProvider)MapsKt.getValue(providers, (Object)virtualFile2);
            VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
            if (userFilter != null && userFilter.getUsers(root2).isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue(VcsLogUtil.getFilteredFilesForRoot(root2, filterCollection), (String)"VcsLogUtil.getFilteredFi\u2026t(root, filterCollection)");
            if (filesForRoot.isEmpty()) {
                VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.STRUCTURE_FILTER;
                Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"VcsLogFilterCollection.STRUCTURE_FILTER");
                vcsLogFilterCollection = VcsLogFiltersKt.without(filterCollection, filterKey);
            } else {
                vcsLogFilterCollection = VcsLogFiltersKt.with(filterCollection, (VcsLogFilter)VcsLogFilterObject.fromPaths((Collection<? extends FilePath>)filesForRoot));
            }
            VcsLogFilterCollection actualFilterCollection = vcsLogFilterCollection;
            VcsLogRangeFilter rangeFilter = (VcsLogRangeFilter)filterCollection.get(VcsLogFilterCollection.RANGE_FILTER);
            if (rangeFilter != null) {
                boolean bl2 = false;
                List resolvedRanges = new ArrayList();
                for (VcsLogRangeFilter.RefRange refRange : rangeFilter.getRanges()) {
                    String string = refRange.component1();
                    String inclusiveRef = refRange.component2();
                    Hash exclusiveHash = provider2.resolveReference((String)exclusiveRef, root2);
                    Hash inclusiveHash = provider2.resolveReference(inclusiveRef, root2);
                    if (exclusiveHash == null || inclusiveHash == null) continue;
                    String string2 = exclusiveHash.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"exclusiveHash.asString()");
                    String string3 = inclusiveHash.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"inclusiveHash.asString()");
                    resolvedRanges.add(new VcsLogRangeFilter.RefRange(string2, string3));
                }
                if (resolvedRanges.isEmpty()) continue;
                VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.RANGE_FILTER;
                Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"VcsLogFilterCollection.RANGE_FILTER");
                actualFilterCollection = VcsLogFiltersKt.with(VcsLogFiltersKt.without(filterCollection, filterKey), (VcsLogFilter)VcsLogFilterObject.fromRange(resolvedRanges));
            }
            Intrinsics.checkNotNullExpressionValue((Object)provider2.getCommitsMatchingFilter(root2, actualFilterCollection, maxCount), (String)"provider.getCommitsMatch\u2026lterCollection, maxCount)");
            Iterable iterable = matchingCommits;
            List list2 = commits;
            boolean $i$f$map = false;
            exclusiveRef = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void commit2;
                TimedVcsCommit timedVcsCommit = (TimedVcsCommit)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                void v7 = commit2;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"commit");
                CommitId commitId2 = new CommitId((Hash)v7.getId(), root2);
                collection.add(commitId2);
            }
            collection = (List)destination$iv$iv;
            list2.addAll((Collection)collection);
        }
        return commits;
    }

    private final Pair<VisiblePack, CommitCountStage> applyHashFilter(DataPack dataPack, VcsLogHashFilter hashFilter, PermanentGraph.SortType sortType, CommitCountStage commitCount) {
        Collection collection = hashFilter.getHashes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"hashFilter.hashes");
        Collection hashes = collection;
        boolean bl = false;
        HashSet<Integer> hashFilterResult = new HashSet<Integer>();
        for (String partOfHash : hashes) {
            if (partOfHash.length() == 40) {
                Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build(partOfHash), (String)"HashImpl.build(partOfHash)");
                for (VirtualFile root2 : dataPack.getLogProviders().keySet()) {
                    Hash hash;
                    if (!this.storage.containsCommit(new CommitId(hash, root2))) continue;
                    hashFilterResult.add(this.storage.getCommitIndex(hash, root2));
                }
                continue;
            }
            CommitId commitId2 = this.storage.findCommitId(new CommitIdByStringCondition(partOfHash));
            if (commitId2 == null) continue;
            hashFilterResult.add(this.storage.getCommitIndex(commitId2.getHash(), commitId2.getRoot()));
        }
        boolean filterMessages = Registry.is((String)"vcs.log.filter.messages.by.hash");
        if (!filterMessages || commitCount == CommitCountStage.INITIAL) {
            if (hashFilterResult.isEmpty()) {
                return null;
            }
            VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, (Set)hashFilterResult);
            Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"dataPack.permanentGraph.\u2026, null, hashFilterResult)");
            VisibleGraph visibleGraph2 = visibleGraph;
            VisiblePack visiblePack = new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph2, filterMessages, VcsLogFilterObject.collection((VcsLogFilter)hashFilter));
            CommitCountStage commitCountStage = filterMessages ? commitCount.next() : CommitCountStage.ALL;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commitCountStage), (String)"if (filterMessages) comm\u2026else CommitCountStage.ALL");
            return new Pair((Object)visiblePack, (Object)commitCountStage);
        }
        VcsLogTextFilter textFilter = VcsLogFilterObject.fromPatternsList(new ArrayList(hashes), false);
        try {
            FilterByDetailsResult textFilterResult = this.filterByDetails(dataPack, VcsLogFilterObject.collection((VcsLogFilter)textFilter), commitCount, (Collection<? extends VirtualFile>)dataPack.getLogProviders().keySet(), null, null, false);
            if (hashFilterResult.isEmpty() && VcsLogFiltererImplKt.matchesNothing((Collection)textFilterResult.getMatchingCommits())) {
                return null;
            }
            Set<Integer> filterResult = VcsLogFiltererImplKt.union(textFilterResult.getMatchingCommits(), (Set)hashFilterResult);
            VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, filterResult);
            Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"dataPack.permanentGraph.\u2026Type, null, filterResult)");
            VisibleGraph visibleGraph3 = visibleGraph;
            VisiblePack visiblePack = new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph3, textFilterResult.getCanRequestMore(), VcsLogFilterObject.collection((VcsLogFilter)hashFilter, (VcsLogFilter)textFilter));
            return new Pair((Object)visiblePack, (Object)textFilterResult.getCommitCount());
        }
        catch (VcsException e) {
            return new Pair((Object)new VisiblePack.ErrorVisiblePack(dataPack, VcsLogFilterObject.collection((VcsLogFilter)hashFilter, (VcsLogFilter)textFilter), e), (Object)commitCount);
        }
    }

    @Nullable
    public final Set<Integer> getMatchingHeads(@NotNull RefsModel refs, @NotNull Collection<? extends VirtualFile> roots2, @NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER);
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        if (branchFilter == null && revisionFilter == null && filters.get(VcsLogFilterCollection.ROOT_FILTER) == null && filters.get(VcsLogFilterCollection.STRUCTURE_FILTER) == null) {
            return null;
        }
        if (revisionFilter != null) {
            if (branchFilter == null) {
                return this.getMatchingHeads(roots2, revisionFilter);
            }
            return CollectionsKt.union((Iterable)this.getMatchingHeads(refs, roots2, branchFilter), (Iterable)this.getMatchingHeads(roots2, revisionFilter));
        }
        if (branchFilter == null) {
            return this.getMatchingHeads(refs, roots2);
        }
        return this.getMatchingHeads(refs, roots2, branchFilter);
    }

    private final Set<Integer> getMatchingHeads(RefsModel refs, Collection<? extends VirtualFile> roots2, VcsLogBranchFilter branchFilter, VcsLogRevisionFilter revisionFilter) {
        if (branchFilter == null && revisionFilter == null) {
            return null;
        }
        Set<Integer> branchMatchingHeads = branchFilter != null ? this.getMatchingHeads(refs, roots2, branchFilter) : SetsKt.emptySet();
        Set<Integer> revisionMatchingHeads = revisionFilter != null ? this.getMatchingHeads(roots2, revisionFilter) : SetsKt.emptySet();
        return CollectionsKt.union((Iterable)branchMatchingHeads, (Iterable)revisionMatchingHeads);
    }

    private final Set<Integer> getMatchingHeads(RefsModel refsModel, Collection<? extends VirtualFile> roots2, VcsLogBranchFilter filter) {
        return this.toReferencedCommitIndexes(this.mapRefsForRoots(refsModel, roots2, (Function1)new Function1<CompressedRefs, Iterable<? extends VcsRef>>(filter){
            final /* synthetic */ VcsLogBranchFilter $filter;

            @NotNull
            public final Iterable<VcsRef> invoke(@NotNull CompressedRefs refs) {
                Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
                List<T> list2 = refs.streamBranches().filter(new Predicate(this){
                    final /* synthetic */ getMatchingHeads.1 this$0;

                    public final boolean test(VcsRef it) {
                        VcsLogBranchFilter vcsLogBranchFilter = this.this$0.$filter;
                        VcsRef vcsRef = it;
                        Intrinsics.checkNotNullExpressionValue((Object)vcsRef, (String)"it");
                        return vcsLogBranchFilter.matches(vcsRef.getName());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list2, (String)"refs.streamBranches().fi\u2026lect(Collectors.toList())");
                return list2;
            }
            {
                this.$filter = vcsLogBranchFilter;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getMatchingHeads(Collection<? extends VirtualFile> roots2, VcsLogRevisionFilter filter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection collection = filter.getHeads();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"filter.heads");
        Iterable iterable = collection;
        VcsLogFiltererImpl vcsLogFiltererImpl = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CommitId it = (CommitId)element$iv$iv;
            boolean bl = false;
            CommitId commitId2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)commitId2, (String)"it");
            if (!roots2.contains(commitId2.getRoot())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return vcsLogFiltererImpl.toCommitIndexes(list2);
    }

    private final Set<Integer> getMatchingHeads(RefsModel refsModel, Collection<? extends VirtualFile> roots2) {
        return this.mapRefsForRoots(refsModel, roots2, getMatchingHeads.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Set<T> mapRefsForRoots(RefsModel refsModel, Collection<? extends VirtualFile> roots2, Function1<? super CompressedRefs, ? extends Iterable<? extends T>> mapping2) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Map<VirtualFile, CompressedRefs> map2 = refsModel.getAllRefsByRoot();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"refsModel.allRefsByRoot");
        Object $this$filterKeys$iv = map2;
        boolean $i$f$filterKeys22 = false;
        LinkedHashMap<VirtualFile, CompressedRefs> result$iv = new LinkedHashMap<VirtualFile, CompressedRefs>();
        Object object = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<VirtualFile, CompressedRefs> entry$iv : object.entrySet()) {
            VirtualFile it = entry$iv.getKey();
            boolean bl2 = false;
            if (!roots2.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = ((Map)result$iv).values();
        $i$f$filterKeys22 = false;
        Collection $i$f$filterKeys22 = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Iterable list$iv = (Iterable)mapping2.invoke(element$iv);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    private final Collection<CommitId> filterDetailsInMemory(PermanentGraph<Integer> permanentGraph, List<? extends VcsLogDetailsFilter> detailsFilters, Set<Integer> matchingHeads, IntSet commitCandidates) {
        boolean bl = false;
        List result2 = new ArrayList();
        for (GraphCommit commit2 : permanentGraph.getAllCommits()) {
            VcsCommitMetadata data2;
            if (commitCandidates != null) {
                GraphCommit graphCommit = commit2;
                Intrinsics.checkNotNullExpressionValue((Object)graphCommit, (String)"commit");
                Object object = graphCommit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commit.id");
                if (!commitCandidates.contains(((Number)object).intValue())) continue;
            }
            GraphCommit graphCommit = commit2;
            Intrinsics.checkNotNullExpressionValue((Object)graphCommit, (String)"commit");
            Object object = graphCommit.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commit.id");
            if (this.getDetailsFromCache(((Number)object).intValue()) == null) {
                break;
            }
            if (!this.matchesAllFilters(data2, permanentGraph, detailsFilters, matchingHeads)) continue;
            result2.add(new CommitId((Hash)data2.getId(), data2.getRoot()));
        }
        return result2;
    }

    private final boolean matchesAllFilters(VcsCommitMetadata commit2, PermanentGraph<Integer> permanentGraph, List<? extends VcsLogDetailsFilter> detailsFilters, Set<Integer> matchingHeads) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = detailsFilters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VcsLogDetailsFilter filter = (VcsLogDetailsFilter)element$iv;
                    boolean bl2 = false;
                    if (filter.matches(commit2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        boolean matchesAllDetails = bl;
        return matchesAllDetails && this.matchesAnyHead(permanentGraph, commit2, matchingHeads);
    }

    private final boolean matchesAnyHead(PermanentGraph<Integer> permanentGraph, VcsCommitMetadata commit2, Set<Integer> matchingHeads) {
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.storage.getCommitIndex((Hash)commit2.getId(), commit2.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), (Collection)matchingHeads);
    }

    private final VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        VcsCommitMetadata vcsCommitMetadata = this.topCommitsDetailsCache.get(commitIndex);
        if (vcsCommitMetadata == null) {
            vcsCommitMetadata = (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable(this, commitIndex){
                final /* synthetic */ VcsLogFiltererImpl this$0;
                final /* synthetic */ int $commitIndex;

                public final VcsCommitMetadata compute() {
                    return (VcsCommitMetadata)VcsLogFiltererImpl.access$getCommitDetailsGetter$p(this.this$0).getCommitDataIfAvailable(this.$commitIndex);
                }
                {
                    this.this$0 = vcsLogFiltererImpl;
                    this.$commitIndex = n;
                }
            });
        }
        return vcsCommitMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> toCommitIndexes(Collection<? extends CommitId> $this$toCommitIndexes) {
        void var3_4;
        void $this$mapTo$iv;
        Iterable iterable = $this$toCommitIndexes;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void commitId2;
            CommitId commitId3 = (CommitId)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            Integer n = this.storage.getCommitIndex(commitId2.getHash(), commitId2.getRoot());
            collection.add(n);
        }
        return (Set)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> toReferencedCommitIndexes(Collection<? extends VcsRef> $this$toReferencedCommitIndexes) {
        void var3_4;
        void $this$mapTo$iv;
        Iterable iterable = $this$toReferencedCommitIndexes;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void ref;
            VcsRef vcsRef = (VcsRef)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            Integer n = this.storage.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            collection.add(n);
        }
        return (Set)var3_4;
    }

    public VcsLogFiltererImpl(@NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull VcsLogStorage storage2, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull DataGetter<? extends VcsFullCommitDetails> commitDetailsGetter, @NotNull VcsLogIndex index2) {
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)topCommitsDetailsCache, (String)"topCommitsDetailsCache");
        Intrinsics.checkNotNullParameter(commitDetailsGetter, (String)"commitDetailsGetter");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        this.logProviders = logProviders;
        this.storage = storage2;
        this.topCommitsDetailsCache = topCommitsDetailsCache;
        this.commitDetailsGetter = commitDetailsGetter;
        this.index = index2;
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return VcsLogFilterer.DefaultImpls.canFilterEmptyPack(this, filters);
    }

    public static final /* synthetic */ DataGetter access$getCommitDetailsGetter$p(VcsLogFiltererImpl $this) {
        return $this.commitDetailsGetter;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult;", "", "()V", "Commits", "Error", "InvalidRange", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult$Commits;", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult$InvalidRange;", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult$Error;", "intellij.platform.vcs.log.impl"})
    private static abstract class RangeFilterResult {
        private RangeFilterResult() {
        }

        public /* synthetic */ RangeFilterResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult$Commits;", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult;", "commits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "(Lit/unimi/dsi/fastutil/ints/IntSet;)V", "getCommits", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "intellij.platform.vcs.log.impl"})
        public static final class Commits
        extends RangeFilterResult {
            @NotNull
            private final IntSet commits;

            @NotNull
            public final IntSet getCommits() {
                return this.commits;
            }

            public Commits(@NotNull IntSet commits) {
                Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
                super(null);
                this.commits = commits;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult$InvalidRange;", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult;", "()V", "intellij.platform.vcs.log.impl"})
        public static final class InvalidRange
        extends RangeFilterResult {
            @NotNull
            public static final InvalidRange INSTANCE;

            private InvalidRange() {
                super(null);
            }

            static {
                InvalidRange invalidRange;
                INSTANCE = invalidRange = new InvalidRange();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult$Error;", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl$RangeFilterResult;", "()V", "intellij.platform.vcs.log.impl"})
        public static final class Error
        extends RangeFilterResult {
            @NotNull
            public static final Error INSTANCE;

            private Error() {
                super(null);
            }

            static {
                Error error;
                INSTANCE = error = new Error();
            }
        }
    }
}

