/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.watcher;

import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootsChangeListener;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.EntityWithVirtualFileUrl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.RootsChangeWatcher;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.VirtualFileUrlWatcher;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR:\u0010\n\u001a.\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f \u0007*\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f0\u000e\u00a2\u0006\u0002\b\r0\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectFilePaths", "", "", "Lorg/jetbrains/annotations/NotNull;", "", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "virtualFileUrlWatcher", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/VirtualFileUrlWatcher;", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class RootsChangeWatcher {
    private final ModuleManager moduleManager;
    private final Set<String> projectFilePaths;
    private final VirtualFileUrlManager virtualFileManager;
    private final VirtualFileUrlWatcher virtualFileUrlWatcher;
    @NotNull
    private final Project project;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RootsChangeWatcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.moduleManager = ModuleManager.getInstance((Project)this.project);
        Set set2 = CollectionFactory.createFilePathSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.createFilePathSet()");
        this.projectFilePaths = set2;
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.virtualFileUrlWatcher = VirtualFileUrlWatcher.Companion.getInstance(this.project);
        IProjectStore store = ProjectKt.getStateStore(this.project);
        Path path2 = store.getProjectFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"store.projectFilePath");
        Path projectFilePath = path2;
        Path path3 = projectFilePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"projectFilePath.parent");
        Path path4 = path3.getFileName();
        if (Intrinsics.areEqual((Object)".idea", (Object)(path4 != null ? ((Object)path4).toString() : null)) ^ true) {
            this.projectFilePaths.add(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)((Object)projectFilePath).toString())));
            this.projectFilePaths.add(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)((Object)store.getWorkspacePath()).toString())));
        }
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){
            private final ConcurrentList<Pair<String, String>> changedUrlsList;
            private final ConcurrentList<Pair<Module, Path>> changedModuleStorePaths;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Companion.EntityChangeStorage entityChanges = new Companion.EntityChangeStorage();
                this.changedUrlsList.clear();
                this.changedModuleStorePaths.clear();
                WorkspaceEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(this.getProject()).getEntityStorage().getCurrent();
                Iterable $this$forEach$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void oldUrl;
                    Pair<String, String> pair;
                    String parentUrl;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    VFileEvent vFileEvent = event;
                    if (vFileEvent instanceof VFileDeleteEvent) {
                        VirtualFileUrlManager virtualFileUrlManager = virtualFileManager;
                        VirtualFile virtualFile2 = ((VFileDeleteEvent)event).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
                        String string = virtualFile2.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.file.url");
                        this.calculateEntityChangesIfNeeded(entityChanges, entityStorage, virtualFileUrlManager.fromUrl(string), true);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCreateEvent) {
                        String string;
                        VirtualFile virtualFile3 = ((VFileCreateEvent)event).getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"event.parent");
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3.getUrl(), (String)"event.parent.url");
                        int protocolEnd = StringsKt.indexOf$default((CharSequence)parentUrl, (String)"://", (int)0, (boolean)false, (int)6, null);
                        if (protocolEnd != -1) {
                            StringBuilder stringBuilder = new StringBuilder();
                            String string2 = parentUrl;
                            int n = 0;
                            boolean bl2 = false;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.substring(n, protocolEnd);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            string = stringBuilder.append(string4).append("://").append(((VFileCreateEvent)event).getPath()).toString();
                        } else {
                            String string5 = VfsUtilCore.pathToUrl((String)((VFileCreateEvent)event).getPath());
                            string = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"VfsUtilCore.pathToUrl(event.path)");
                        }
                        String url = string;
                        VirtualFileUrl virtualFileUrl = virtualFileManager.fromUrl(url);
                        this.calculateEntityChangesIfNeeded(entityChanges, entityStorage, virtualFileUrl, false);
                        if (!StringsKt.startsWith$default((String)url, (String)"file", (boolean)false, (int)2, null)) continue;
                        if (!((VFileCreateEvent)event).isDirectory()) {
                            String string6 = ((VFileCreateEvent)event).getChildName();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"event.childName");
                            if (!StringsKt.endsWith$default((String)string6, (String)".jar", (boolean)false, (int)2, null)) continue;
                        }
                        String suffix = ((VFileCreateEvent)event).isDirectory() ? "" : "!/";
                        String jarFileUrl = "jar://" + VfsUtil.urlToPath((String)url) + suffix;
                        VirtualFileUrl jarVirtualFileUrl = virtualFileManager.fromUrl(jarFileUrl);
                        this.calculateEntityChangesIfNeeded(entityChanges, entityStorage, jarVirtualFileUrl, false);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCopyEvent) {
                        VirtualFileUrlManager virtualFileUrlManager = virtualFileManager;
                        String string = VfsUtilCore.pathToUrl((String)((VFileCopyEvent)event).getPath());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.path)");
                        this.calculateEntityChangesIfNeeded(entityChanges, entityStorage, virtualFileUrlManager.fromUrl(string), false);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
                    if (event instanceof VFilePropertyChangeEvent) {
                        this.propertyChanged((VFilePropertyChangeEvent)event);
                    }
                    if (this.getUrls(event) == null) {
                        continue;
                    }
                    parentUrl = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    if (!(Intrinsics.areEqual((Object)oldUrl, (Object)newUrl) ^ true)) continue;
                    this.calculateEntityChangesIfNeeded(entityChanges, entityStorage, virtualFileManager.fromUrl((String)oldUrl), true);
                    this.calculateEntityChangesIfNeeded(entityChanges, entityStorage, virtualFileManager.fromUrl(newUrl), false);
                    this.changedUrlsList.add((Object)new Pair((Object)oldUrl, (Object)newUrl));
                }
                return new AsyncFileListener.ChangeApplier(this, entityChanges){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ Companion.EntityChangeStorage $entityChanges;

                    /*
                     * WARNING - void declaration
                     */
                    public void beforeVfsChange() {
                        Iterable $this$forEach$iv = (Iterable)1.access$getChangedUrlsList$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void oldUrl;
                            Pair $dstr$oldUrl$newUrl = (Pair)element$iv;
                            boolean bl = false;
                            String string = (String)$dstr$oldUrl$newUrl.component1();
                            String newUrl = (String)$dstr$oldUrl$newUrl.component2();
                            RootsChangeWatcher.access$getVirtualFileUrlWatcher$p(this.this$0.this).onVfsChange((String)oldUrl, newUrl);
                        }
                        1.access$fireRootsChangeEvent(this.this$0, true, this.$entityChanges);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void afterVfsChange() {
                        Module oldUrl;
                        Iterable $this$forEach$iv = (Iterable)1.access$getChangedUrlsList$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Pair $dstr$oldUrl$newUrl = (Pair)element$iv;
                            boolean bl = false;
                            String string = (String)$dstr$oldUrl$newUrl.component1();
                            String newUrl = (String)$dstr$oldUrl$newUrl.component2();
                            1.access$updateModuleName(this.this$0, (String)oldUrl, newUrl);
                        }
                        $this$forEach$iv = (Iterable)1.access$getChangedModuleStorePaths$p(this.this$0);
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void module;
                            Pair $dstr$module$path = (Pair)element$iv;
                            boolean bl = false;
                            oldUrl = (Module)$dstr$module$path.component1();
                            Path path2 = (Path)$dstr$module$path.component2();
                            ServiceKt.getStateStore((ComponentManager)module).setPath(path2);
                            ClasspathStorage.modulePathChanged((Module)module);
                        }
                        Collection collection = (Collection)1.access$getChangedModuleStorePaths$p(this.this$0);
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            RootsChangeWatcher.access$getModuleManager$p(this.this$0.this).incModificationCount();
                        }
                        1.fireRootsChangeEvent$default(this.this$0, false, this.$entityChanges, 1, null);
                    }
                    {
                        this.this$0 = this$0;
                        this.$entityChanges = $captured_local_variable$1;
                    }
                };
            }

            private final VirtualFileUrl getIncludingJarDirectory(WorkspaceEntityStorage storage2, VirtualFileUrl virtualFileUrl) {
                VirtualFileUrlIndex virtualFileUrlIndex = storage2.getVirtualFileUrlIndex();
                if (virtualFileUrlIndex == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex");
                }
                Set<VirtualFileUrl> indexedJarDirectories = ((VirtualFileIndex)virtualFileUrlIndex).getIndexedJarDirectories();
                VirtualFileUrl parentVirtualFileUrl = virtualFileUrl;
                while (parentVirtualFileUrl != null && !indexedJarDirectories.contains(parentVirtualFileUrl)) {
                    parentVirtualFileUrl = virtualFileManager.getParentVirtualUrl(parentVirtualFileUrl);
                }
                return parentVirtualFileUrl != null && indexedJarDirectories.contains(parentVirtualFileUrl) ? parentVirtualFileUrl : null;
            }

            /*
             * WARNING - void declaration
             */
            private final void calculateEntityChangesIfNeeded(Companion.EntityChangeStorage entityChanges, WorkspaceEntityStorage storage2, VirtualFileUrl virtualFileUrl, boolean allRootsWereRemoved) {
                boolean bl;
                List affectedEntities;
                block10: {
                    VirtualFileUrl includingJarDirectory = this.getIncludingJarDirectory(storage2, virtualFileUrl);
                    if (includingJarDirectory != null) {
                        Collection<WorkspaceEntity> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        List entities2 = allRootsWereRemoved ? CollectionsKt.emptyList() : SequencesKt.toList(storage2.getVirtualFileUrlIndex().findEntitiesByUrl(includingJarDirectory));
                        Iterable iterable = entities2;
                        Companion.EntityChangeStorage entityChangeStorage = entityChanges;
                        boolean $i$f$map = false;
                        void var9_16 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void pair;
                            Pair pair2 = (Pair)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            WorkspaceEntity workspaceEntity = (WorkspaceEntity)pair.getFirst();
                            collection.add(workspaceEntity);
                        }
                        collection = (List)destination$iv$iv;
                        entityChangeStorage.addAll((Collection<? extends WorkspaceEntity>)collection);
                        return;
                    }
                    boolean $this$map$iv = false;
                    affectedEntities = new ArrayList();
                    VirtualFileUrlWatcher.Companion.calculateAffectedEntities$intellij_platform_lang_impl(storage2, virtualFileUrl, affectedEntities);
                    List<VirtualFileUrl> list2 = virtualFileUrl.getSubTreeFileUrls();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"virtualFileUrl.subTreeFileUrls");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VirtualFileUrl fileUrl = (VirtualFileUrl)element$iv;
                        boolean bl3 = false;
                        VirtualFileUrl virtualFileUrl2 = fileUrl;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2, (String)"fileUrl");
                        VirtualFileUrlWatcher.Companion.calculateAffectedEntities$intellij_platform_lang_impl(storage2, virtualFileUrl2, affectedEntities);
                    }
                    Iterable $this$any$iv = affectedEntities;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            EntityWithVirtualFileUrl it = (EntityWithVirtualFileUrl)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"entitySource") ^ true && ProjectRootsChangeListener.Companion.shouldFireRootsChanged$intellij_platform_lang_impl(it.getEntity(), this.getProject()))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl || projectFilePaths.contains(virtualFileUrl.getUrl())) {
                    List list3;
                    if (allRootsWereRemoved) {
                        list3 = CollectionsKt.emptyList();
                    } else {
                        void $this$mapTo$iv$iv;
                        Object element$iv;
                        Iterable $this$map$iv = affectedEntities;
                        boolean $i$f$map = false;
                        element$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            EntityWithVirtualFileUrl bl2 = (EntityWithVirtualFileUrl)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl5 = false;
                            WorkspaceEntity workspaceEntity = it.getEntity();
                            collection.add(workspaceEntity);
                        }
                        list3 = (List)destination$iv$iv;
                    }
                    List changes = list3;
                    entityChanges.addAll(changes);
                }
            }

            private final boolean isRootChangeForbidden() {
                if (this.getProject().isDisposed()) {
                    return true;
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.getProject());
                if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
                    return true;
                }
                return ((ProjectRootManagerBridge)projectRootManager).isFiringEvent();
            }

            private final void fireRootsChangeEvent(boolean beforeRootsChanged, Companion.EntityChangeStorage entityChangesStorage) {
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                ProjectRootsChangeListener.WorkspaceEventIndexingInfo indexingInfo = entityChangesStorage.createIndexingInfo();
                if (indexingInfo != null && !this.isRootChangeForbidden()) {
                    ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.getProject());
                    if (projectRootManager == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge");
                    }
                    ProjectRootManagerBridge projectRootManager2 = (ProjectRootManagerBridge)projectRootManager;
                    if (beforeRootsChanged) {
                        projectRootManager2.getRootsChanged().beforeRootsChanged();
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("Roots changed: changed urls = " + this.changedUrlsList + ", changed module store paths = " + this.changedModuleStorePaths);
                        }
                        projectRootManager2.getRootsChanged().rootsChanged(indexingInfo);
                    }
                }
            }

            static /* synthetic */ void fireRootsChangeEvent$default(1 var0, boolean bl, Companion.EntityChangeStorage entityChangeStorage, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                var0.fireRootsChangeEvent(bl, entityChangeStorage);
            }

            private final void updateModuleName(String oldUrl, String newUrl) {
                String newModuleName;
                if (!this.isImlFile(oldUrl) || !this.isImlFile(newUrl)) {
                    return;
                }
                String oldModuleName = ModulePathKt.getModuleNameByFilePath(oldUrl);
                if (Intrinsics.areEqual((Object)oldModuleName, (Object)(newModuleName = ModulePathKt.getModuleNameByFilePath(newUrl)))) {
                    return;
                }
                WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.getProject());
                ModuleEntity moduleEntity = (ModuleEntity)workspaceModel.getEntityStorage().getCurrent().resolve(new ModuleId(oldModuleName));
                if (moduleEntity == null) {
                    return;
                }
                ModuleEntity moduleEntity2 = moduleEntity;
                workspaceModel.updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, ModuleEntity>(moduleEntity2, newModuleName){
                    final /* synthetic */ ModuleEntity $moduleEntity;
                    final /* synthetic */ String $newModuleName;

                    @NotNull
                    public final ModuleEntity invoke(@NotNull WorkspaceEntityStorageBuilder diff) {
                        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
                        return (ModuleEntity)diff.modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)this.$moduleEntity, (Function1)new Function1<ModifiableModuleEntity, Unit>(this){
                            final /* synthetic */ updateModuleName.1 this$0;

                            public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                                $this$modifyEntity.setName(this.this$0.$newModuleName);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.$moduleEntity = moduleEntity;
                        this.$newModuleName = string;
                        super(1);
                    }
                });
            }

            private final void propertyChanged(VFilePropertyChangeEvent event) {
                VirtualFile virtualFile2 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
                if (!virtualFile2.isDirectory() || event.getRequestor() instanceof StateStorage || Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name") ^ true) {
                    return;
                }
                VirtualFile virtualFile3 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"event.file");
                Object object = virtualFile3.getParent();
                if (object == null || (object = object.getPath()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.file.parent?.path ?: return");
                Object parentPath = object;
                String newAncestorPath = (String)parentPath + '/' + event.getNewValue();
                String oldAncestorPath = (String)parentPath + '/' + event.getOldValue();
                ModuleManager moduleManager = moduleManager;
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"moduleManager");
                Module[] moduleArray = moduleManager.getModules();
                int n = moduleArray.length;
                for (int j = 0; j < n; ++j) {
                    String moduleFilePath;
                    Module module;
                    Module module2 = module = moduleArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                    if (!module2.isLoaded() || module.isDisposed()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)module.getModuleFilePath(), (String)"module.moduleFilePath");
                    if (!FileUtil.isAncestor((String)oldAncestorPath, (String)moduleFilePath, (boolean)true)) continue;
                    this.changedModuleStorePaths.add((Object)new Pair((Object)module, (Object)Paths.get(newAncestorPath, FileUtil.getRelativePath((String)oldAncestorPath, (String)moduleFilePath, (char)'/'))));
                }
            }

            private final boolean isImlFile(String $this$isImlFile) {
                return Intrinsics.areEqual((Object)Files.getFileExtension((String)$this$isImlFile), (Object)"iml");
            }

            private final Pair<String, String> getUrls(VFileEvent event) {
                String oldUrl = null;
                String newUrl = null;
                VFileEvent vFileEvent = event;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    String string = VfsUtilCore.pathToUrl((String)((VFilePropertyChangeEvent)event).getOldPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string2 = VfsUtilCore.pathToUrl((String)((VFilePropertyChangeEvent)event).getNewPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string2;
                } else if (vFileEvent instanceof VFileMoveEvent) {
                    String string = VfsUtilCore.pathToUrl((String)((VFileMoveEvent)event).getOldPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string3 = VfsUtilCore.pathToUrl((String)((VFileMoveEvent)event).getNewPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string3;
                } else {
                    return null;
                }
                return TuplesKt.to((Object)oldUrl, (Object)newUrl);
            }
            {
                ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"ContainerUtil.createConc\u2026t<Pair<String, String>>()");
                this.changedUrlsList = concurrentList;
                ConcurrentList concurrentList2 = ContainerUtil.createConcurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)concurrentList2, (String)"ContainerUtil.createConc\u2026ist<Pair<Module, Path>>()");
                this.changedModuleStorePaths = concurrentList2;
            }

            public static final /* synthetic */ ConcurrentList access$getChangedUrlsList$p(1 $this) {
                return $this.changedUrlsList;
            }

            public static final /* synthetic */ void access$fireRootsChangeEvent(1 $this, boolean beforeRootsChanged, Companion.EntityChangeStorage entityChangesStorage) {
                $this.fireRootsChangeEvent(beforeRootsChanged, entityChangesStorage);
            }

            public static final /* synthetic */ void access$updateModuleName(1 $this, String oldUrl, String newUrl) {
                $this.updateModuleName(oldUrl, newUrl);
            }

            public static final /* synthetic */ ConcurrentList access$getChangedModuleStorePaths$p(1 $this) {
                return $this.changedModuleStorePaths;
            }
        }, (Disposable)this.project);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RootsChangeWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    public static final /* synthetic */ VirtualFileUrlWatcher access$getVirtualFileUrlWatcher$p(RootsChangeWatcher $this) {
        return $this.virtualFileUrlWatcher;
    }

    @JvmStatic
    @NotNull
    public static final RootsChangeWatcher getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "EntityChangeStorage", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RootsChangeWatcher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getComponent(RootsChangeWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getComponent(Roo\u2026hangeWatcher::class.java)");
            return (RootsChangeWatcher)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/RootsChangeWatcher$Companion$EntityChangeStorage;", "", "()V", "entities", "", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "addAll", "", "addedEntities", "", "createIndexingInfo", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener$WorkspaceEventIndexingInfo;", "initChanges", "intellij.platform.lang.impl"})
        private static final class EntityChangeStorage {
            private List<WorkspaceEntity> entities;

            private final List<WorkspaceEntity> initChanges() {
                List list2 = this.entities;
                if (list2 == null) {
                    boolean bl = false;
                    List list3 = new ArrayList();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    List it = list3;
                    boolean bl4 = false;
                    this.entities = it;
                    list2 = list3;
                }
                return list2;
            }

            public final void addAll(@NotNull Collection<? extends WorkspaceEntity> addedEntities) {
                Intrinsics.checkNotNullParameter(addedEntities, (String)"addedEntities");
                this.initChanges().addAll(addedEntities);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ProjectRootsChangeListener.WorkspaceEventIndexingInfo createIndexingInfo() {
                ProjectRootsChangeListener.WorkspaceEventIndexingInfo workspaceEventIndexingInfo;
                List<WorkspaceEntity> list2 = this.entities;
                if (list2 != null) {
                    Collection<EntityChange.Added<void>> collection;
                    void $this$mapTo$iv$iv;
                    List<WorkspaceEntity> list3 = list2;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<WorkspaceEntity> it = list3;
                    boolean bl3 = false;
                    Iterable $this$map$iv = it;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void entity;
                        WorkspaceEntity workspaceEntity = (WorkspaceEntity)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        EntityChange.Added<void> added2 = new EntityChange.Added<void>(entity);
                        collection.add(added2);
                    }
                    collection = (List)destination$iv$iv;
                    List list4 = collection;
                    workspaceEventIndexingInfo = new ProjectRootsChangeListener.WorkspaceEventIndexingInfo(list4);
                } else {
                    workspaceEventIndexingInfo = null;
                }
                return workspaceEventIndexingInfo;
            }
        }
    }
}

