/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.attach.XAttachHost;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WslAttachHost
implements XAttachHost {
    private final WSLDistribution myWsl;

    public WslAttachHost(@NotNull WSLDistribution wsl) {
        if (wsl == null) {
            WslAttachHost.$$$reportNull$$$0(0);
        }
        this.myWsl = wsl;
    }

    @NotNull
    public WSLDistribution getWsl() {
        WSLDistribution wSLDistribution = this.myWsl;
        if (wSLDistribution == null) {
            WslAttachHost.$$$reportNull$$$0(1);
        }
        return wSLDistribution;
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        ArrayList<ProcessInfo> result2 = new ArrayList<ProcessInfo>();
        ProcessOutput ps = this.myWsl.executeOnWsl(10000, "ps", "--no-headers", "-e", "-w", "-w", "-o", "pid,comm,command");
        for (String line : ps.getStdoutLines()) {
            List parts = StringUtil.split((String)StringUtil.trim((String)line), (String)" ");
            if (parts.size() < 3) continue;
            try {
                int pid2 = Integer.valueOf((String)parts.get(0));
                String executableName = (String)parts.get(1);
                List command = parts.subList(2, parts.size());
                String commandLine = StringUtil.join(command, (String)" ");
                String executablePath = (String)ContainerUtil.getFirstItem(command);
                String args = command.size() > 1 ? StringUtil.join(command.subList(1, command.size()), (String)" ") : "";
                result2.add(new ProcessInfo(pid2, commandLine, executableName, args, executablePath));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ArrayList<ProcessInfo> arrayList = result2;
        if (arrayList == null) {
            WslAttachHost.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/attach/WslAttachHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/attach/WslAttachHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWsl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

