/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNodeCache;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.breakpoints.BreakpointListProvider;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016H\u0016J\u0012\u0010\u0017\u001a\f0\f\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u0019H\u0016J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u00020\"2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\u00020\f8\u0002X\u0083D\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "root", "Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode;", "getRoot", "()Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode;", "root$delegate", "Lkotlin/Lazy;", "rootNameKey", "", "getRootNameKey$annotations", "()V", "canDelete", "", "selection", "", "canEdit", "", "createNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getDeleteActionText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "node", "getEditActionText", "getProject", "getWeight", "", "performDelete", "", "parent", "Ljavax/swing/JComponent;", "performEdit", "GroupNode", "ItemNode", "RootNode", "intellij.platform.debugger.impl"})
public final class BreakpointListProvider
implements BookmarksListProvider {
    @PropertyKey(resourceBundle="messages.XDebuggerBundle")
    private final String rootNameKey;
    private final Lazy root$delegate;
    private final Project project;

    private static /* synthetic */ void getRootNameKey$annotations() {
    }

    private final RootNode getRoot() {
        Lazy lazy = this.root$delegate;
        BreakpointListProvider breakpointListProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (RootNode)lazy.getValue();
    }

    public int getWeight() {
        return 200;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public AbstractTreeNode<?> createNode() {
        return this.getRoot().hasVisibleBreakpoints() ? (AbstractTreeNode)this.getRoot() : null;
    }

    @Nullable
    public OpenFileDescriptor getDescriptor(@NotNull AbstractTreeNode<?> node2) {
        OpenFileDescriptor openFileDescriptor;
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Object object = node2.getEqualityObject();
        if (!(object instanceof BreakpointItem)) {
            object = null;
        }
        BreakpointItem breakpointItem = (BreakpointItem)object;
        if (breakpointItem == null) {
            return null;
        }
        BreakpointItem item = breakpointItem;
        Object object2 = item.getBreakpoint();
        if (!(object2 instanceof XBreakpoint)) {
            object2 = null;
        }
        XBreakpoint xBreakpoint = (XBreakpoint)object2;
        if (xBreakpoint == null) {
            return null;
        }
        XBreakpoint breakpoint = xBreakpoint;
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition != null) {
            XSourcePosition xSourcePosition2 = xSourcePosition;
            boolean bl = false;
            boolean bl2 = false;
            XSourcePosition it = xSourcePosition2;
            boolean bl3 = false;
            XSourcePosition xSourcePosition3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)xSourcePosition3, (String)"it");
            openFileDescriptor = new OpenFileDescriptor(this.project, xSourcePosition3.getFile(), it.getLine(), 0);
        } else {
            openFileDescriptor = null;
        }
        return openFileDescriptor;
    }

    @NotNull
    public String getEditActionText() {
        String string = ActionsBundle.actionText((String)"EditBreakpoint");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ActionsBundle.actionText(\"EditBreakpoint\")");
        return string;
    }

    public boolean canEdit(@NotNull Object selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return selection instanceof ItemNode;
    }

    public void performEdit(@NotNull Object selection, @NotNull JComponent parent) {
        int n;
        int n2;
        int n3;
        Rectangle $this$run;
        Rectangle rectangle;
        boolean bl;
        boolean bl2;
        Rectangle rectangle2;
        Rectangle rectangle3;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object object = selection;
        if (!(object instanceof ItemNode)) {
            object = null;
        }
        ItemNode itemNode = (ItemNode)((Object)object);
        if (itemNode == null) {
            return;
        }
        ItemNode node2 = itemNode;
        BreakpointItem breakpointItem = (BreakpointItem)node2.getValue();
        if (breakpointItem == null) {
            return;
        }
        BreakpointItem breakpoint = breakpointItem;
        DebuggerSupport debuggerSupport = XBreakpointUtil.getDebuggerSupport(this.project, breakpoint);
        if (debuggerSupport == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)debuggerSupport, (String)"XBreakpointUtil.getDebug\u2026ct, breakpoint) ?: return");
        DebuggerSupport support = debuggerSupport;
        JComponent jComponent = parent;
        if (!(jComponent instanceof JTree)) {
            jComponent = null;
        }
        JTree jTree = (JTree)jComponent;
        if (jTree != null) {
            JTree jTree2 = jTree;
            boolean bl4 = false;
            bl3 = false;
            JTree $this$run2 = jTree2;
            boolean bl5 = false;
            rectangle3 = $this$run2.getPathBounds($this$run2.getLeadSelectionPath());
        } else {
            rectangle3 = null;
        }
        Rectangle bounds2 = rectangle3;
        Rectangle rectangle4 = parent.getVisibleRect();
        bl3 = false;
        boolean bl6 = false;
        Rectangle $this$apply = rectangle4;
        boolean bl7 = false;
        Rectangle rectangle5 = $this$apply;
        Rectangle rectangle6 = bounds2;
        if (rectangle6 != null) {
            rectangle2 = rectangle6;
            bl2 = false;
            bl = false;
            Rectangle rectangle7 = rectangle2;
            rectangle = rectangle5;
            boolean bl8 = false;
            n3 = $this$run.x + $this$run.width;
            rectangle5 = rectangle;
            n2 = RangesKt.coerceIn((int)n3, (int)$this$apply.x, (int)($this$apply.x + $this$apply.width));
        } else {
            n2 = $this$apply.x + $this$apply.width / 2;
        }
        rectangle5.x = n2;
        Rectangle rectangle8 = $this$apply;
        Rectangle rectangle9 = bounds2;
        if (rectangle9 != null) {
            rectangle2 = rectangle9;
            bl2 = false;
            bl = false;
            $this$run = rectangle2;
            rectangle = rectangle8;
            boolean bl9 = false;
            n3 = $this$run.y + $this$run.height / 2;
            rectangle8 = rectangle;
            n = RangesKt.coerceIn((int)n3, (int)$this$apply.y, (int)($this$apply.y + $this$apply.height));
        } else {
            n = $this$apply.y + $this$apply.height / 2;
        }
        rectangle8.y = n;
        Rectangle visible = rectangle4;
        EditBreakpointActionHandler editBreakpointActionHandler = support.getEditBreakpointAction();
        Rectangle rectangle10 = visible;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle10, (String)"visible");
        editBreakpointActionHandler.editBreakpoint(this.project, parent, rectangle10.getLocation(), breakpoint);
    }

    @NotNull
    public String getDeleteActionText() {
        String string = XDebuggerBundle.message((String)"xdebugger.remove.line.breakpoint.action.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"xdebugger.remov\u2026.breakpoint.action.text\")");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDelete(@NotNull List<?> selection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Iterable $this$all$iv = selection;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            Object it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (!(it instanceof ItemNode)) return false;
            BreakpointItem breakpointItem = (BreakpointItem)((ItemNode)((Object)it)).getValue();
            if (breakpointItem == null) return false;
            if (!breakpointItem.canNavigate()) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Iterable $this$forEach$iv = selection;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            ItemNode node2;
            Object object;
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            Object t = it;
            if (!(t instanceof ItemNode)) {
                t = null;
            }
            if ((object = (node2 = (ItemNode)((Object)t))) == null || (object = (BreakpointItem)object.getValue()) == null) continue;
            object.removed(this.project);
        }
    }

    public BreakpointListProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rootNameKey = "xbreakpoints.dialog.title";
        this.root$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RootNode>(this){
            final /* synthetic */ BreakpointListProvider this$0;

            @NotNull
            public final RootNode invoke() {
                return new RootNode(BreakpointListProvider.access$getProject$p(this.this$0), BreakpointListProvider.access$getRootNameKey$p(this.this$0));
            }
            {
                this.this$0 = breakpointListProvider;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(BreakpointListProvider $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$getRootNameKey$p(BreakpointListProvider $this) {
        return $this.rootNameKey;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u00042\b\u0012\u0004\u0012\u00020\u00060\u0005B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0018H\u0016J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\u0014\u001aV\u0012$\u0012\"\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00030\u0003 \u0017*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0016\u00a8\u0006\u00010\u0016\u00a8\u0006\u0001 \u0017**\u0012$\u0012\"\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00030\u0003 \u0017*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0016\u00a8\u0006\u00010\u0016\u00a8\u0006\u0001\u0018\u00010\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode;", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointPanelProvider$BreakpointsListener;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "key", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "breakpointsUpdater", "Lcom/intellij/util/SingleAlarm;", "cache", "Lcom/intellij/ide/util/treeView/AbstractTreeNodeCache;", "icon16x12", "Lcom/intellij/ui/SizedIcon;", "Lorg/jetbrains/annotations/NotNull;", "map", "", "providers", "", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointPanelProvider;", "kotlin.jvm.PlatformType", "", "valid", "Ljava/util/concurrent/atomic/AtomicBoolean;", "breakpointsChanged", "", "compare", "", "o1", "o2", "getChildren", "getKeys", "value", "hasVisibleBreakpoints", "", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.debugger.impl"})
    private static final class RootNode
    extends AbstractTreeNode<String>
    implements BreakpointPanelProvider.BreakpointsListener,
    Comparator<Object> {
        private final Map<Object, Object> map;
        private final AtomicBoolean valid;
        private final List<BreakpointPanelProvider<Object>> providers;
        private final SizedIcon icon16x12;
        private final AbstractTreeNodeCache<Object, AbstractTreeNode<?>> cache;
        private final SingleAlarm breakpointsUpdater;

        public final boolean hasVisibleBreakpoints() {
            return this.valid.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<Object> getKeys(@NotNull Object value2) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Map<Object, Object> map2 = this.map;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (map2) {
                void $this$mapNotNullTo$iv$iv;
                boolean bl3 = false;
                Map<Object, Object> $this$mapNotNull$iv = this.map;
                boolean $i$f$mapNotNull = false;
                Map<Object, Object> map3 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                void var13_15 = $this$forEach$iv$iv$iv;
                boolean bl4 = false;
                Iterator iterator2 = var13_15.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Object e;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl5 = false;
                    Map.Entry it = element$iv$iv;
                    boolean bl6 = false;
                    if ((Intrinsics.areEqual(it.getValue(), (Object)value2) ? (Object)it.getKey() : null) == null) continue;
                    e = e;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Object it$iv$iv = e;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            return CollectionsKt.sortedWith((Iterable)list2, (Comparator)this);
        }

        @Override
        public int compare(@Nullable Object o1, @Nullable Object o2) {
            int n;
            if (o1 instanceof BreakpointItem && o2 instanceof BreakpointItem) {
                boolean default1 = ((BreakpointItem)o1).isDefaultBreakpoint();
                boolean default2 = ((BreakpointItem)o2).isDefaultBreakpoint();
                n = default1 && !default2 ? -1 : (!default1 && default2 ? 1 : ((BreakpointItem)o1).compareTo(o2));
            } else {
                n = o1 instanceof XBreakpointGroup && o2 instanceof XBreakpointGroup ? ((XBreakpointGroup)o1).compareTo((XBreakpointGroup)o2) : (o1 instanceof XBreakpointGroup ? -1 : 1);
            }
            return n;
        }

        @Override
        public void breakpointsChanged() {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.breakpointsUpdater, (boolean)false, (int)1, null);
        }

        @NotNull
        public List<AbstractTreeNode<?>> getChildren() {
            String string = (String)this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
            return this.cache.getNodes((Collection)this.getKeys(string));
        }

        protected void update(@NotNull PresentationData presentation2) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            presentation2.setIcon((Icon)this.icon16x12);
            presentation2.setPresentableText(XDebuggerBundle.message((String)((String)this.getValue()), (Object[])new Object[0]));
        }

        /*
         * WARNING - void declaration
         */
        public RootNode(@NotNull Project project, @NotNull String key) {
            void $this$onEach$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(project, (Object)key);
            boolean bl = false;
            this.map = new LinkedHashMap();
            this.valid = new AtomicBoolean();
            Iterable iterable = XBreakpointUtil.collectPanelProviders();
            RootNode rootNode = this;
            boolean $i$f$onEach = false;
            void var5_7 = $this$onEach$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            void $this$apply$iv = var5_7;
            boolean bl4 = false;
            for (Object element$iv : $this$apply$iv) {
                BreakpointPanelProvider it = (BreakpointPanelProvider)element$iv;
                boolean bl5 = false;
                it.addListener(this, project, (Disposable)project);
            }
            void var15_16 = var5_7;
            rootNode.providers = (List)var15_16;
            JBScalableIcon jBScalableIcon = JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)new SizedIcon(AllIcons.Debugger.Db_set_breakpoint, 16, 12)));
            Intrinsics.checkNotNullExpressionValue((Object)jBScalableIcon, (String)"JBUIScale.scaleIcon(Size\u2026_set_breakpoint, 16, 12))");
            this.icon16x12 = (SizedIcon)jBScalableIcon;
            this.cache = new AbstractTreeNodeCache((AbstractTreeNode)this, new Function1<Object, AbstractTreeNode<?>>(project){
                final /* synthetic */ Project $project;

                @Nullable
                public final AbstractTreeNode<?> invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it instanceof BreakpointItem ? (AbstractTreeNode)new ItemNode(this.$project, (BreakpointItem)it) : (AbstractTreeNode)(it instanceof XBreakpointGroup ? new GroupNode(this.$project, (XBreakpointGroup)it) : null);
                }
                {
                    this.$project = project;
                    super(1);
                }
            });
            this.breakpointsUpdater = SingleAlarm.Companion.pooledThreadSingleAlarm(50, (Disposable)project, (Function0)new Function0<Unit>(this, project){
                final /* synthetic */ RootNode this$0;
                final /* synthetic */ Project $project;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    boolean bl;
                    block10: {
                        if (this.$project.isDisposed()) {
                            return;
                        }
                        boolean bl2 = false;
                        Map breakpoints = new LinkedHashMap<K, V>();
                        ReadAction.run((ThrowableRunnable)new ThrowableRunnable(this, breakpoints){
                            final /* synthetic */ breakpointsUpdater.1 this$0;
                            final /* synthetic */ Map $breakpoints;

                            /*
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            public final void run() {
                                var2_1 = false;
                                items = new ArrayList<E>();
                                v0 = RootNode.access$getProviders$p(this.this$0.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"providers");
                                $this$forEach$iv = v0;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (BreakpointPanelProvider)element$iv;
                                    $i$a$-forEach-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$1 = false;
                                    it.provideBreakpointItems(this.this$0.$project, items);
                                }
                                v1 = XDebuggerManager.getInstance((Project)this.this$0.$project);
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"XDebuggerManager.getInstance(project)");
                                v2 = v1.getBreakpointManager();
                                if (!(v2 instanceof XBreakpointManagerImpl)) {
                                    v2 = null;
                                }
                                selectedRules = (v3 = (manager = (XBreakpointManagerImpl)v2)) != null && (v3 = v3.getBreakpointsDialogSettings()) != null ? v3.getSelectedGroupingRules() : null;
                                element$iv = false;
                                element$iv /* !! */  = new ArrayList<E>();
                                it = false;
                                $i$a$-forEach-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$1 = false;
                                $this$apply = element$iv /* !! */ ;
                                $i$a$-apply-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$1 = false;
                                v4 = RootNode.access$getProviders$p(this.this$0.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"providers");
                                $this$forEach$iv = v4;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (BreakpointPanelProvider)element$iv;
                                    $i$a$-forEach-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$1$1 = false;
                                    it.createBreakpointsGroupingRules($this$apply);
                                }
                                it = false;
                                $i$a$-forEach-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$1 = false;
                                $this$apply = element$iv /* !! */ ;
                                $i$a$-apply-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$2 = false;
                                v5 = XBreakpointGroupingRule.EP;
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"XBreakpointGroupingRule.EP");
                                v6 = v5.getExtensionList();
                                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"XBreakpointGroupingRule.EP.extensionList");
                                $this$apply.addAll(v6);
                                element$iv /* !! */  = element$iv /* !! */ ;
                                $i$f$filter = false;
                                $i$a$-forEach-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$1 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                var10_18 = $this$filterTo$iv$iv.iterator();
                                while (var10_18.hasNext()) {
                                    element$iv$iv = var10_18.next();
                                    it = (XBreakpointGroupingRule)element$iv$iv;
                                    $i$a$-filter-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$3 = false;
                                    if (it.isAlwaysEnabled()) ** GOTO lbl-1000
                                    v7 = selectedRules;
                                    if (v7 != null) {
                                        ** if (!v7.contains((Object)it.getId())) goto lbl-1000
                                    }
                                    ** GOTO lbl-1000
lbl-1000:
                                    // 2 sources

                                    {
                                        v8 = true;
                                        ** GOTO lbl62
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        v8 = false;
                                    }
lbl62:
                                    // 2 sources

                                    if (!v8) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                v9 = (List)destination$iv$iv;
                                v10 = XBreakpointGroupingRule.PRIORITY_COMPARATOR;
                                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"XBreakpointGroupingRule.PRIORITY_COMPARATOR");
                                enabledRules = CollectionsKt.toSortedSet((Iterable)v9, (Comparator)v10);
                                for (BreakpointItem item : items) {
                                    if (!item.canNavigate() && !Registry.is((String)"ide.bookmark.show.all.breakpoints", (boolean)false)) continue;
                                    v11 = item;
                                    if (v11 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                                    }
                                    any = v11;
                                    for (XBreakpointGroupingRule rule : enabledRules) {
                                        if (rule.getGroup(item.getBreakpoint(), (Collection)CollectionsKt.emptyList()) == null) continue;
                                        var11_19 = false;
                                        var12_22 = false;
                                        it = var10_18;
                                        $i$a$-let-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$2 = false;
                                        v12 = it;
                                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"it");
                                        this.$breakpoints.put(any, v12);
                                        any = it;
                                    }
                                    v13 = (String)this.this$0.this$0.getValue();
                                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"value");
                                    this.$breakpoints.put(any, v13);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$breakpoints = map2;
                            }
                        });
                        Map map2 = RootNode.access$getMap$p(this.this$0);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        synchronized (map2) {
                            boolean bl5 = false;
                            RootNode.access$getMap$p(this.this$0).clear();
                            RootNode.access$getMap$p(this.this$0).putAll(breakpoints);
                            Unit unit = Unit.INSTANCE;
                        }
                        Map $this$any$iv = breakpoints;
                        boolean $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl = false;
                        } else {
                            Map map3 = $this$any$iv;
                            boolean bl6 = false;
                            Iterator<Map.Entry<K, V>> iterator2 = map3.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> it = element$iv = iterator2.next();
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual(it.getValue(), (Object)this.this$0.getValue())) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    boolean newValid = bl;
                    boolean oldValid = RootNode.access$getValid$p(this.this$0).getAndSet(newValid);
                    if (oldValid != newValid) {
                        ((BookmarksListener)this.$project.getMessageBus().syncPublisher(BookmarksListener.TOPIC)).structureChanged(null);
                    } else if (newValid) {
                        ((BookmarksListener)this.$project.getMessageBus().syncPublisher(BookmarksListener.TOPIC)).structureChanged((Object)this.this$0);
                    }
                }
                {
                    this.this$0 = rootNode;
                    this.$project = project;
                    super(0);
                }
            });
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.breakpointsUpdater, (boolean)false, (int)1, null);
        }

        public static final /* synthetic */ List access$getProviders$p(RootNode $this) {
            return $this.providers;
        }

        public static final /* synthetic */ Map access$getMap$p(RootNode $this) {
            return $this.map;
        }

        public static final /* synthetic */ AtomicBoolean access$getValid$p(RootNode $this) {
            return $this.valid;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$GroupNode;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointGroup;", "project", "Lcom/intellij/openapi/project/Project;", "value", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointGroup;)V", "cache", "Lcom/intellij/ide/util/treeView/AbstractTreeNodeCache;", "", "getChildren", "", "getKeys", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.debugger.impl"})
    private static final class GroupNode
    extends AbstractTreeNode<XBreakpointGroup> {
        private final AbstractTreeNodeCache<Object, AbstractTreeNode<?>> cache;

        private final List<Object> getKeys() {
            for (AbstractTreeNode node2 = this.getParent(); node2 != null; node2 = node2.getParent()) {
                if (!(node2 instanceof RootNode)) continue;
                RootNode rootNode = (RootNode)node2;
                XBreakpointGroup xBreakpointGroup = (XBreakpointGroup)this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)xBreakpointGroup, (String)"value");
                return rootNode.getKeys(xBreakpointGroup);
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<AbstractTreeNode<?>> getChildren() {
            return this.cache.getNodes((Collection)this.getKeys());
        }

        protected void update(@NotNull PresentationData presentation2) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            presentation2.setIcon(((XBreakpointGroup)this.getValue()).getIcon(true));
            XBreakpointGroup xBreakpointGroup = (XBreakpointGroup)this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)xBreakpointGroup, (String)"value");
            presentation2.setPresentableText(xBreakpointGroup.getName());
        }

        public GroupNode(@NotNull Project project, @NotNull XBreakpointGroup value2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(project, (Object)value2);
            this.cache = new AbstractTreeNodeCache((AbstractTreeNode)this, new Function1<Object, AbstractTreeNode<?>>(project){
                final /* synthetic */ Project $project;

                @Nullable
                public final AbstractTreeNode<?> invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it instanceof BreakpointItem ? (AbstractTreeNode)new ItemNode(this.$project, (BreakpointItem)it) : (AbstractTreeNode)(it instanceof XBreakpointGroup ? new GroupNode(this.$project, (XBreakpointGroup)it) : null);
                }
                {
                    this.$project = project;
                    super(1);
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$ItemNode;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointItem;", "project", "Lcom/intellij/openapi/project/Project;", "item", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointItem;)V", "canNavigate", "", "canNavigateToSource", "getChildren", "", "isAlwaysLeaf", "navigate", "", "requestFocus", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.debugger.impl"})
    private static final class ItemNode
    extends AbstractTreeNode<BreakpointItem> {
        public boolean canNavigate() {
            return ((BreakpointItem)this.getValue()).canNavigate();
        }

        public boolean canNavigateToSource() {
            return ((BreakpointItem)this.getValue()).canNavigateToSource();
        }

        public void navigate(boolean requestFocus) {
            ((BreakpointItem)this.getValue()).navigate(requestFocus);
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        @NotNull
        public Collection<AbstractTreeNode<?>> getChildren() {
            return CollectionsKt.emptyList();
        }

        protected void update(@NotNull PresentationData presentation2) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            BreakpointItem breakpointItem = (BreakpointItem)this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)breakpointItem, (String)"value");
            presentation2.setIcon(breakpointItem.getIcon());
            BreakpointItem breakpointItem2 = (BreakpointItem)this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)breakpointItem2, (String)"value");
            presentation2.setPresentableText(breakpointItem2.getDisplayText());
            BreakpointItem breakpointItem3 = (BreakpointItem)this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)breakpointItem3, (String)"value");
            if (!breakpointItem3.isEnabled()) {
                presentation2.setForcedTextForeground(UIUtil.getInactiveTextColor());
            }
        }

        public ItemNode(@NotNull Project project, @NotNull BreakpointItem item) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            super(project, (Object)item);
        }
    }
}

