/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsStatisticsCollectorKt;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointsUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.platform.debugger.impl"})
public final class BreakpointsUsageCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final BooleanEventField WITHIN_SESSION_FIELD;
    @NotNull
    private static final StringEventField TYPE_FIELD;
    private static final VarargEventId BREAKPOINT_ADDED;
    private static final EventId1<Long> BREAKPOINT_VERIFIED;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("debugger.breakpoints.usage", 3);
        WITHIN_SESSION_FIELD = EventFields.Boolean((String)"within_session");
        TYPE_FIELD = EventFields.StringValidatedByCustomRule((String)"type", (String)"breakpoint");
        BREAKPOINT_ADDED = GROUP.registerVarargEvent("breakpoint.added", new EventField[]{(EventField)WITHIN_SESSION_FIELD, (EventField)EventFields.PluginInfo, (EventField)TYPE_FIELD});
        BREAKPOINT_VERIFIED = GROUP.registerEvent("breakpoint.verified", (EventField)EventFields.Long((String)"time"));
    }

    @JvmStatic
    public static final void reportNewBreakpoint(@NotNull XBreakpoint<?> breakpoint, @NotNull XBreakpointType<?, ?> type, boolean withinSession) {
        Companion.reportNewBreakpoint(breakpoint, type, withinSession);
    }

    @JvmStatic
    public static final void reportBreakpointVerified(@NotNull XBreakpoint<?> breakpoint, long time) {
        Companion.reportBreakpointVerified(breakpoint, time);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J,\u0010\u0015\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointsUsageCollector$Companion;", "", "()V", "BREAKPOINT_ADDED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "BREAKPOINT_VERIFIED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getTYPE_FIELD", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "WITHIN_SESSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "reportBreakpointVerified", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "time", "reportNewBreakpoint", "type", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType;", "withinSession", "", "intellij.platform.debugger.impl"})
    public static final class Companion {
        @NotNull
        public final StringEventField getTYPE_FIELD() {
            return TYPE_FIELD;
        }

        @JvmStatic
        public final void reportNewBreakpoint(@NotNull XBreakpoint<?> breakpoint, @NotNull XBreakpointType<?, ?> type, boolean withinSession) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            if (breakpoint instanceof XBreakpointBase) {
                boolean bl = false;
                List data2 = new ArrayList();
                data2.addAll((Collection)BreakpointsStatisticsCollectorKt.getType(type));
                data2.add(WITHIN_SESSION_FIELD.with((Object)withinSession));
                BREAKPOINT_ADDED.log(((XBreakpointBase)breakpoint).getProject(), data2);
            }
        }

        @JvmStatic
        public final void reportBreakpointVerified(@NotNull XBreakpoint<?> breakpoint, long time) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            if (breakpoint instanceof XBreakpointBase) {
                BREAKPOINT_VERIFIED.log(((XBreakpointBase)breakpoint).getProject(), (Object)time);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

