/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XQuickEvaluateHandler
extends QuickEvaluateHandler {
    private static final Logger LOG = Logger.getInstance(XQuickEvaluateHandler.class);

    @Override
    public boolean isEnabled(@NotNull Project project) {
        XDebugSession session2;
        if (project == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(0);
        }
        return (session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && session2.getDebugProcess().getEvaluator() != null;
    }

    @Override
    @Nullable
    public AbstractValueHint createValueHint(@NotNull Project project, @NotNull Editor editor2, @NotNull Point point, ValueHintType type) {
        if (project == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(2);
        }
        if (point == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    @NotNull
    public Promise<AbstractValueHint> createValueHintAsync(@NotNull Project project, @NotNull Editor editor2, @NotNull Point point, ValueHintType type) {
        XDebugSession session2;
        if (project == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(5);
        }
        if (point == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(6);
        }
        if ((session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession()) == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                XQuickEvaluateHandler.$$$reportNull$$$0(7);
            }
            return promise;
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                XQuickEvaluateHandler.$$$reportNull$$$0(8);
            }
            return promise;
        }
        int offset = AbstractValueHint.calculateOffset(editor2, point);
        Promise promise = XQuickEvaluateHandler.getExpressionInfo(evaluator, project, type, editor2, offset).thenAsync(expressionInfo -> {
            AsyncPromise resultPromise = new AsyncPromise();
            UIUtil.invokeLaterIfNeeded(() -> {
                int textLength = editor2.getDocument().getTextLength();
                if (expressionInfo == null) {
                    resultPromise.setResult(null);
                    return;
                }
                TextRange range2 = expressionInfo.getTextRange();
                if (range2.getStartOffset() > range2.getEndOffset() || range2.getStartOffset() < 0 || range2.getEndOffset() > textLength) {
                    LOG.error("invalid range: " + range2 + ", text length = " + textLength + ", evaluator: " + evaluator);
                    resultPromise.setResult(null);
                    return;
                }
                resultPromise.setResult((Object)new XValueHint(project, editor2, point, type, (ExpressionInfo)expressionInfo, evaluator, session2, false));
            });
            return resultPromise;
        });
        if (promise == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(9);
        }
        return promise;
    }

    @NotNull
    private static Promise<ExpressionInfo> getExpressionInfo(XDebuggerEvaluator evaluator, Project project, ValueHintType type, @NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(10);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionModel.hasSelection() && selectionStart <= offset && offset <= selectionEnd) {
            Promise promise = Promises.resolvedPromise((Object)new ExpressionInfo(new TextRange(selectionStart, selectionEnd)));
            if (promise == null) {
                XQuickEvaluateHandler.$$$reportNull$$$0(11);
            }
            return promise;
        }
        Promise promise = evaluator.getExpressionInfoAtOffsetAsync(project, editor2.getDocument(), offset, type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT);
        if (promise == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(12);
        }
        return promise;
    }

    @Override
    public boolean canShowHint(@NotNull Project project) {
        if (project == null) {
            XQuickEvaluateHandler.$$$reportNull$$$0(13);
        }
        return this.isEnabled(project);
    }

    @Override
    public int getValueLookupDelay(Project project) {
        return XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueHintAsync";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValueHint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createValueHintAsync";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canShowHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

