/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.DebuggerEvaluationStatisticsCollector;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.actions.XToggleEvaluateExpressionFieldAction;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNode;
import com.intellij.xdebugger.impl.inline.InlineWatchesRootNode;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerEmbeddedComboBox;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XWatchTransferable;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XWatchesViewImpl
extends XVariablesView
implements DnDNativeTarget,
XWatchesView,
XInlineWatchesView {
    protected WatchesRootNode myRootNode;
    private XDebuggerExpressionComboBox myEvaluateComboBox;
    private final CompositeDisposable myDisposables;
    private final boolean myWatchesInVariables;
    private final boolean inlineWatchesEnabled;

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(0);
        }
        this(session2, watchesInVariables, watchesInVariables);
    }

    protected XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables, boolean vertical) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(1);
        }
        this(session2, watchesInVariables, vertical, true);
    }

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables, boolean vertical, boolean withToolbar) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(2);
        }
        super(session2);
        this.myDisposables = new CompositeDisposable();
        this.myWatchesInVariables = watchesInVariables;
        this.inlineWatchesEnabled = Registry.is((String)"debugger.watches.inline.enabled");
        XDebuggerTree tree = this.getTree();
        this.createNewRootNode(null);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.NewWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.RemoveWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.EditWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        EmptyAction.registerWithShortcutSet((String)"XDebugger.NewWatch", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)((Object)tree));
        EmptyAction.registerWithShortcutSet((String)"XDebugger.RemoveWatch", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)tree));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree));
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object contents;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contents = CopyPasteManager.getInstance().getContents(XWatchTransferable.EXPRESSIONS_FLAVOR)) instanceof List) {
                    for (Object item : (List)contents) {
                        if (!(item instanceof XExpression)) continue;
                        XWatchesViewImpl.this.addWatchExpression((XExpression)item, -1, true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getPaste(), (JComponent)((Object)tree), (Disposable)this.myDisposables);
        if (withToolbar) {
            ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", DebuggerSessionTabBase.getCustomizedActionGroup("XDebugger.Watches.Tree.Toolbar"), !vertical);
            toolbar.setBorder((Border)new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, vertical ? 0 : 1, vertical ? 1 : 0));
            toolbar.setTargetComponent((JComponent)((Object)tree));
            this.getPanel().add((Component)toolbar.getComponent(), vertical ? "West" : "North");
        }
        if (!this.myWatchesInVariables) {
            this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
        }
        this.installEditListeners();
    }

    @Override
    protected JPanel createMainPanel(@NotNull JComponent localsPanelComponent) {
        JComponent top;
        if (localsPanelComponent == null) {
            XWatchesViewImpl.$$$reportNull$$$0(3);
        }
        if ((top = this.createTopPanel()) == null) {
            return super.createMainPanel(localsPanelComponent);
        }
        LayoutManager layout = localsPanelComponent.getLayout();
        boolean canAddComponentToTheRightOfToolbar = layout instanceof BorderLayout;
        if (canAddComponentToTheRightOfToolbar) {
            BorderLayoutPanel panel2 = new BorderLayoutPanel().addToCenter(((BorderLayout)layout).getLayoutComponent("Center")).addToTop((Component)top);
            localsPanelComponent.add((Component)panel2, "Center");
            return super.createMainPanel(localsPanelComponent);
        }
        return new BorderLayoutPanel().addToCenter((Component)localsPanelComponent).addToTop((Component)top);
    }

    @Nullable
    private JComponent createTopPanel() {
        final XDebuggerTree tree = this.getTree();
        final Ref addToWatchesActionRef = new Ref();
        XDebuggerEditorsProvider provider2 = tree.getEditorsProvider();
        if (!provider2.isEvaluateExpressionFieldEnabled()) {
            return null;
        }
        this.myEvaluateComboBox = new XDebuggerExpressionComboBox(tree.getProject(), provider2, "evaluateExpression", null, false, true){

            @Override
            protected ComboBox<XExpression> createComboBox(CollectionComboBoxModel<XExpression> model2, int width) {
                DumbAwareAction addToWatchesAction = new DumbAwareAction(ActionsBundle.actionText((String)"Debugger.AddToWatch"), null, AllIcons.Debugger.AddToWatch){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        XWatchesViewImpl.this.myEvaluateComboBox.saveTextInHistory();
                        XWatchesViewImpl.this.addWatchExpression(this.getExpression(), -1, false);
                        DebuggerEvaluationStatisticsCollector.WATCH_FROM_INLINE_ADD.log((Object)e);
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        e.getPresentation().setEnabled(!XDebuggerUtilImpl.isEmptyExpression(this.getExpression()));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerVariablesEvaluate", (ActionGroup)new DefaultActionGroup(new AnAction[]{addToWatchesAction}), true);
                addToWatchesActionRef.set((Object)addToWatchesAction);
                toolbar.setOpaque(false);
                toolbar.setReservePlaceAutoPopupIcon(false);
                toolbar.setTargetComponent((JComponent)((Object)tree));
                XDebuggerEmbeddedComboBox<XExpression> comboBox2 = new XDebuggerEmbeddedComboBox<XExpression>((ComboBoxModel<XExpression>)model2, width);
                comboBox2.setExtension(toolbar);
                return comboBox2;
            }

            @Override
            protected void prepareEditor(EditorEx editor2) {
                super.prepareEditor(editor2);
                editor2.setPlaceholder(XDebuggerBundle.message((String)"debugger.evaluate.expression.or.add.a.watch.hint", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null)), KeymapUtil.getShortcutText((Shortcut)new KeyboardShortcut(XDebuggerEvaluationDialog.ADD_WATCH_KEYSTROKE, null))}));
                editor2.addFocusListener(new FocusChangeListener(){
                    private final Set<FocusEvent.Cause> myCauses = Set.of(FocusEvent.Cause.UNKNOWN, FocusEvent.Cause.TRAVERSAL_FORWARD, FocusEvent.Cause.TRAVERSAL_BACKWARD);

                    @Override
                    public void focusGained(@NotNull Editor editor2, @NotNull FocusEvent event) {
                        boolean shouldBeIgnored;
                        if (editor2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (this.myCauses.contains((Object)event.getCause()) && !(shouldBeIgnored = XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().isPopupVisible())) {
                            DebuggerEvaluationStatisticsCollector.INPUT_FOCUS.log(XWatchesViewImpl.this.getTree().getProject());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2$2";
                        objectArray[2] = "focusGained";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        };
        JComponent editorComponent = this.myEvaluateComboBox.getEditorComponent();
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterStroke");
        editorComponent.getActionMap().put("enterStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().isPopupVisible()) {
                    XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().setPopupVisible(false);
                } else {
                    XWatchesViewImpl.this.addExpressionResultNode();
                }
            }
        });
        this.myEvaluateComboBox.getComboBox().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            private int selectedIndexOnPopupOpen = -1;

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.selectedIndexOnPopupOpen = XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().getSelectedIndex();
                XWatchesViewImpl.this.myEvaluateComboBox.requestFocusInEditor();
                DebuggerEvaluationStatisticsCollector.HISTORY_SHOW.log(XWatchesViewImpl.this.getTree().getProject());
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().getSelectedIndex() != this.selectedIndexOnPopupOpen) {
                    DebuggerEvaluationStatisticsCollector.HISTORY_CHOOSE.log(XWatchesViewImpl.this.getTree().getProject());
                }
            }
        });
        ((AnAction)addToWatchesActionRef.get()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(XDebuggerEvaluationDialog.ADD_WATCH_KEYSTROKE), editorComponent);
        JComponent component2 = this.myEvaluateComboBox.getComponent();
        component2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        if (!Registry.is((String)"debugger.new.tool.window.layout")) {
            XToggleEvaluateExpressionFieldAction.markAsEvaluateExpressionField(component2);
        }
        return component2;
    }

    @Override
    protected void beforeTreeBuild(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            XWatchesViewImpl.$$$reportNull$$$0(4);
        }
        if (event != XDebugView.SessionEvent.SETTINGS_CHANGED) {
            this.myRootNode.removeResultNode();
        }
    }

    private void addExpressionResultNode() {
        XExpression expression = this.myEvaluateComboBox.getExpression();
        if (!XDebuggerUtilImpl.isEmptyExpression(expression)) {
            this.myEvaluateComboBox.saveTextInHistory();
            XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
            this.myRootNode.addResultNode(session2 != null ? session2.getCurrentStackFrame() : null, expression);
            DebuggerEvaluationStatisticsCollector.INLINE_EVALUATE.log(this.getTree().getProject());
        }
    }

    @Override
    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            XWatchesViewImpl.$$$reportNull$$$0(5);
        }
        super.buildTreeAndRestoreState(stackFrame);
        if (this.myEvaluateComboBox != null) {
            this.myEvaluateComboBox.setSourcePosition(stackFrame.getSourcePosition());
        }
    }

    private void installEditListeners() {
        final XDebuggerTree watchTree = this.getTree();
        final Alarm quitePeriod = new Alarm();
        final Alarm editAlarm = new Alarm();
        final ClickListener mouseListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!SwingUtilities.isLeftMouseButton(event) || (event.getModifiers() & 0xF) != 0) {
                    return false;
                }
                boolean sameRow = XWatchesViewImpl.isAboveSelectedItem(event, watchTree, false);
                if (!sameRow || clickCount > 1) {
                    editAlarm.cancelAllRequests();
                    return false;
                }
                AnAction editWatchAction = ActionManager.getInstance().getAction("XDebugger.EditWatch");
                Presentation presentation2 = editWatchAction.getTemplatePresentation().clone();
                DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                AnActionEvent actionEvent = new AnActionEvent(null, context2, "WATCH_TREE", presentation2, ActionManager.getInstance(), 0);
                Runnable runnable2 = () -> editWatchAction.actionPerformed(actionEvent);
                if (editAlarm.isEmpty() && quitePeriod.isEmpty()) {
                    editAlarm.addRequest(runnable2, UIUtil.getMultiClickInterval());
                } else {
                    editAlarm.cancelAllRequests();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$5", "onClick"));
            }
        };
        DoubleClickListener mouseEmptySpaceListener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!XWatchesViewImpl.isAboveSelectedItem(event, watchTree, true)) {
                    XWatchesViewImpl.this.myRootNode.addNewWatch();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$6", "onDoubleClick"));
            }
        };
        ListenerUtil.addClickListener((Component)((Object)watchTree), mouseListener);
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseEmptySpaceListener);
        FocusListener focusListener2 = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                editAlarm.cancelAllRequests();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListenerUtil.addFocusListener((Component)((Object)watchTree), focusListener2);
        TreeSelectionListener selectionListener2 = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$8", "valueChanged"));
            }
        };
        watchTree.addTreeSelectionListener(selectionListener2);
        this.myDisposables.add(new Disposable((ClickListener)mouseEmptySpaceListener, focusListener2, selectionListener2){
            final /* synthetic */ ClickListener val$mouseEmptySpaceListener;
            final /* synthetic */ FocusListener val$focusListener;
            final /* synthetic */ TreeSelectionListener val$selectionListener;
            {
                this.val$mouseEmptySpaceListener = clickListener2;
                this.val$focusListener = focusListener2;
                this.val$selectionListener = treeSelectionListener;
            }

            public void dispose() {
                ListenerUtil.removeClickListener((Component)((Object)watchTree), mouseListener);
                ListenerUtil.removeClickListener((Component)((Object)watchTree), this.val$mouseEmptySpaceListener);
                ListenerUtil.removeFocusListener((Component)((Object)watchTree), this.val$focusListener);
                watchTree.removeTreeSelectionListener(this.val$selectionListener);
            }
        });
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposables);
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.getTree()));
        super.dispose();
    }

    private static boolean isAboveSelectedItem(MouseEvent event, XDebuggerTree watchTree, boolean fullWidth) {
        Rectangle bounds2 = watchTree.getRowBounds(watchTree.getLeadSelectionRow());
        if (bounds2 != null) {
            if (fullWidth) {
                bounds2.x = 0;
            }
            bounds2.width = watchTree.getWidth();
            if (bounds2.contains(event.getPoint())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addWatchExpression(@NotNull XExpression expression, int index2, boolean navigateToWatchNode) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(6);
        }
        this.addWatchExpression(expression, index2, navigateToWatchNode, false);
    }

    public void addWatchExpression(@NotNull XExpression expression, int index2, boolean navigateToWatchNode, boolean noDuplicates) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        boolean found = false;
        if (noDuplicates) {
            for (WatchNode watchNode : this.myRootNode.getWatchChildren()) {
                if (!watchNode.getExpression().equals(expression)) continue;
                TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)watchNode);
                found = true;
            }
        }
        if (!found) {
            this.myRootNode.addWatchExpression(session2 != null ? session2.getCurrentStackFrame() : null, expression, index2, navigateToWatchNode);
            this.updateSessionData();
        }
        if (navigateToWatchNode && session2 != null) {
            XDebugSessionTab.showWatchesView((XDebugSessionImpl)session2);
        }
    }

    public void computeWatches() {
        this.myRootNode.computeWatches();
    }

    @Override
    protected XValueContainerNode doCreateNewRootNode(@Nullable XStackFrame stackFrame) {
        this.myRootNode = this.inlineWatchesEnabled ? new InlineWatchesRootNode(this.getTree(), this, this.getExpressions(), this.getInlineExpressions(), stackFrame, this.myWatchesInVariables) : new WatchesRootNode(this.getTree(), this, this.getExpressions(), stackFrame, this.myWatchesInVariables);
        return this.myRootNode;
    }

    @NotNull
    private List<InlineWatch> getInlineExpressions() {
        List<InlineWatch> list2 = this.getWatchesManager().getInlineWatches();
        if (list2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private XDebuggerWatchesManager getWatchesManager() {
        return ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.getTree().getProject())).getWatchesManager();
    }

    @Override
    public void addInlineWatchExpression(@NotNull InlineWatch watch, int index2, boolean navigateToWatchNode) {
        if (watch == null) {
            XWatchesViewImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        ((InlineWatchesRootNode)this.myRootNode).addInlineWatchExpression(session2 != null ? session2.getCurrentStackFrame() : null, watch, index2, navigateToWatchNode);
        if (navigateToWatchNode && session2 != null) {
            XDebugSessionTab.showWatchesView((XDebugSessionImpl)session2);
        }
    }

    @Override
    public void removeInlineWatches(Collection<InlineWatch> watches) {
        InlineWatchesRootNode rootNode = (InlineWatchesRootNode)this.myRootNode;
        List nodesToRemove = ContainerUtil.filter(rootNode.getInlineWatchChildren(), node2 -> watches.contains(node2.getWatch()));
        if (!nodesToRemove.isEmpty()) {
            this.removeInlineNodes(nodesToRemove, false);
        }
    }

    private void removeInlineNodes(List<? extends XDebuggerTreeNode> inlineWatches, boolean updateManager) {
        InlineWatchesRootNode rootNode = (InlineWatchesRootNode)this.myRootNode;
        List<? extends InlineWatchNode> inlineWatchChildren = rootNode.getInlineWatchChildren();
        int[] minIndex = new int[]{Integer.MAX_VALUE};
        ArrayList<InlineWatchNode> toRemoveInlines = new ArrayList<InlineWatchNode>();
        inlineWatches.forEach(node2 -> {
            int index2 = inlineWatchChildren.indexOf(node2);
            if (index2 != -1) {
                toRemoveInlines.add((InlineWatchNode)((Object)node2));
                minIndex[0] = Math.min(minIndex[0], index2);
            }
        });
        rootNode.removeInlineChildren(toRemoveInlines);
        List<? extends InlineWatchNode> newChildren = rootNode.getInlineWatchChildren();
        if (!newChildren.isEmpty()) {
            InlineWatchNode node3 = newChildren.get(Math.min(minIndex[0], newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)node3);
        }
        if (updateManager) {
            this.getWatchesManager().inlineWatchesRemoved(ContainerUtil.map(toRemoveInlines, node2 -> node2.getWatch()), this);
        }
    }

    @Override
    protected void addEmptyMessage(XValueContainerNode root2) {
        if (this.myWatchesInVariables) {
            super.addEmptyMessage(root2);
        }
    }

    @NotNull
    protected List<XExpression> getExpressions() {
        XDebuggerTreeNode root2;
        XDebuggerTree tree = this.getTree();
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)tree));
        List<Object> expressions = session2 != null ? ((XDebugSessionImpl)session2).getSessionData().getWatchExpressions() : ((root2 = tree.getRoot()) instanceof WatchesRootNode ? ((WatchesRootNode)root2).getWatchExpressions() : Collections.emptyList());
        List<XExpression> list2 = expressions;
        if (list2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            XWatchesViewImpl.$$$reportNull$$$0(11);
        }
        if (XWatchesView.DATA_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List ordinaryWatches = ContainerUtil.filter(nodes, node2 -> !(node2 instanceof InlineWatchNode));
        List inlineWatches = ContainerUtil.filter(nodes, node2 -> node2 instanceof InlineWatchNode);
        if (!inlineWatches.isEmpty()) {
            this.removeInlineNodes(inlineWatches, true);
        }
        if (ordinaryWatches.isEmpty()) {
            return;
        }
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove2 = new ArrayList<XDebuggerTreeNode>();
        for (TreeNode node3 : ordinaryWatches) {
            int index2 = children2.indexOf(node3);
            if (index2 == -1) continue;
            toRemove2.add((XDebuggerTreeNode)node3);
            minIndex = Math.min(minIndex, index2);
        }
        this.myRootNode.removeChildren(toRemove2);
        List<? extends WatchNode> newChildren = this.myRootNode.getWatchChildren();
        if (!newChildren.isEmpty()) {
            TreeNode node3;
            node3 = newChildren.get(Math.min(minIndex, newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)node3);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        List<? extends InlineWatchNode> children2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.inlineWatchesEnabled && !(children2 = ((InlineWatchesRootNode)this.myRootNode).getInlineWatchChildren()).isEmpty()) {
            this.removeInlineNodes(children2, true);
        }
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    public void moveWatchUp(WatchNode node2) {
        this.myRootNode.moveUp(node2);
        this.updateSessionData();
    }

    public void moveWatchDown(WatchNode node2) {
        this.myRootNode.moveDown(node2);
        this.updateSessionData();
    }

    public void updateSessionData() {
        XDebugSession session2 = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        if (session2 != null) {
            ((XDebugSessionImpl)session2).setWatchExpressions(this.myRootNode.getWatchExpressions());
        } else {
            XDebugSessionData data2 = XWatchesViewImpl.getData(XDebugSessionData.DATA_KEY, (Component)((Object)this.getTree()));
            if (data2 != null) {
                data2.setWatchExpressions(this.myRootNode.getWatchExpressions());
            }
        }
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
            if (((XValueNodeImpl[])object).length == 1) {
                Point point = aEvent.getPoint();
                XDebuggerTree tree = this.getTree();
                TreePath path2 = tree.getClosestPathForLocation(point.x, point.y);
                if (path2 != null && path2.getLastPathComponent() == ((XValueNodeImpl[])object)[0]) {
                    Rectangle pathBounds = tree.getPathBounds(path2);
                    possible = pathBounds != null && pathBounds.y + pathBounds.height < point.y;
                }
            }
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text2;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            for (XValueNodeImpl node2 : (XValueNodeImpl[])object) {
                DebuggerUIUtil.addToWatches(this, node2);
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text2 = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(XExpressionImpl.fromText(text2), -1, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localsPanelComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrame";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineExpressions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeTreeBuild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTreeAndRestoreState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addWatchExpression";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addInlineWatchExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

