/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.inline.XDebuggerTreeInlayPopup;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineDebugRenderer
implements EditorCustomElementRenderer {
    public static final String NAME_VALUE_SEPARATION = ": ";
    public static final String INDENT = "  ";
    boolean myPopupIsShown;
    private final boolean myCustomNode;
    private final XDebugSession mySession;
    private final XValueNodeImpl myValueNode;
    private final XDebuggerTreeCreator myTreeCreator;
    private boolean isHovered;
    private int myRemoveXCoordinate;
    private int myTextStartXCoordinate;
    private final XSourcePosition myPosition;
    private SimpleColoredText myPresentation;
    private static final float BACKGROUND_ALPHA = 0.55f;

    InlineDebugRenderer(XValueNodeImpl valueNode, @NotNull XSourcePosition position, @NotNull XDebugSession session2) {
        if (position == null) {
            InlineDebugRenderer.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            InlineDebugRenderer.$$$reportNull$$$0(1);
        }
        this.myPopupIsShown = false;
        this.isHovered = false;
        this.myRemoveXCoordinate = Integer.MAX_VALUE;
        this.myPosition = position;
        this.mySession = session2;
        this.myCustomNode = valueNode instanceof InlineWatchNodeImpl;
        this.myValueNode = valueNode;
        this.updatePresentation();
        this.myTreeCreator = new XDebuggerTreeCreator(session2.getProject(), session2.getDebugProcess().getEditorsProvider(), session2.getCurrentPosition(), ((XDebugSessionImpl)session2).getValueMarkers());
    }

    public void updatePresentation() {
        TextAttributes attributes2 = XDebuggerEditorLinePainter.getAttributes(this.myPosition.getLine(), this.myPosition.getFile(), this.mySession);
        SimpleColoredText valuePresentation = XDebuggerEditorLinePainter.createPresentation(this.myValueNode);
        this.myPresentation = XDebuggerEditorLinePainter.computeVariablePresentationWithChanges(this.myValueNode, this.myValueNode.getName(), valuePresentation, attributes2, this.myPosition.getLine(), this.mySession.getProject());
    }

    private boolean isInExecutionPointHighlight() {
        XSourcePosition debuggerPosition = this.mySession.getCurrentPosition();
        if (debuggerPosition != null) {
            XDebuggerManagerImpl debuggerManager = (XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.mySession.getProject());
            return XSourcePosition.isOnTheSameLine((XSourcePosition)this.myPosition, (XSourcePosition)debuggerPosition) && debuggerManager.isFullLineHighlighter();
        }
        return false;
    }

    private static Font getFont(@NotNull Editor editor2) {
        if (editor2 == null) {
            InlineDebugRenderer.$$$reportNull$$$0(2);
        }
        EditorColorsScheme colorsScheme = editor2.getColorsScheme();
        TextAttributes attributes2 = editor2.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
        int fontStyle = attributes2 == null ? 0 : attributes2.getFontType();
        return UIUtil.getFontWithFallback((Font)colorsScheme.getFont(EditorFontType.forJavaStyle((int)fontStyle)));
    }

    public void onClick(Inlay inlay, @NotNull EditorMouseEvent event) {
        boolean isRemoveIconClick;
        if (event == null) {
            InlineDebugRenderer.$$$reportNull$$$0(3);
        }
        int x = event.getMouseEvent().getX();
        boolean bl = isRemoveIconClick = this.myCustomNode && x >= this.myRemoveXCoordinate;
        if (isRemoveIconClick) {
            XDebugSessionTab tab = ((XDebugSessionImpl)this.mySession).getSessionTab();
            if (tab != null) {
                tab.getWatchesView().removeWatches(Collections.singletonList(this.myValueNode));
            }
            inlay.update();
        } else if (x >= this.myTextStartXCoordinate) {
            this.handleClick(inlay);
        }
    }

    private void handleClick(Inlay inlay) {
        InlineDebugRenderer inlayRenderer = (InlineDebugRenderer)inlay.getRenderer();
        if (inlayRenderer.myPopupIsShown) {
            return;
        }
        String name2 = "valueName";
        XValue container = (XValue)this.myValueNode.getValueContainer();
        if (container instanceof XNamedValue) {
            name2 = ((XNamedValue)container).getName();
        }
        Pair descriptor2 = Pair.create((Object)container, (Object)name2);
        Rectangle bounds2 = inlay.getBounds();
        Point point = new Point(bounds2.x, bounds2.y + bounds2.height);
        inlayRenderer.myPopupIsShown = true;
        XDebuggerTreeInlayPopup.showTreePopup(this.myTreeCreator, (Pair<XValue, String>)descriptor2, this.myValueNode, inlay.getEditor(), point, this.myPosition, this.mySession, () -> ApplicationManager.getApplication().invokeLater(() -> {
            inlayRenderer.myPopupIsShown = false;
        }));
    }

    public void onMouseExit(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(4);
        }
        this.setHovered(false, inlay);
    }

    public void onMouseMove(@NotNull Inlay inlay, @NotNull EditorMouseEvent event) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(5);
        }
        if (event == null) {
            InlineDebugRenderer.$$$reportNull$$$0(6);
        }
        this.setHovered(event.getMouseEvent().getX() >= this.myTextStartXCoordinate, inlay);
    }

    private void setHovered(boolean active2, @NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(7);
        }
        boolean oldState = this.isHovered;
        this.isHovered = active2;
        Cursor cursor = active2 ? Cursor.getPredefinedCursor(12) : null;
        ((EditorEx)inlay.getEditor()).setCustomCursor(InlineDebugRenderer.class, cursor);
        if (oldState != active2) {
            inlay.update();
        }
    }

    @Nullable
    public ActionGroup getContextMenuGroup(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(8);
        }
        return null;
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(9);
        }
        int width = this.getInlayTextWidth(inlay);
        width += this.myCustomNode ? AllIcons.Actions.Close.getIconWidth() : AllIcons.General.LinkDropTriangle.getIconWidth();
        if (this.myCustomNode) {
            width += AllIcons.Debugger.Watch.getIconWidth();
        }
        return width;
    }

    private int getInlayTextWidth(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(10);
        }
        Font font = InlineDebugRenderer.getFont(inlay.getEditor());
        Object text2 = this.isErrorMessage() ? this.myPresentation.getTexts().get(0) : this.myPresentation.toString() + NAME_VALUE_SEPARATION;
        return InlineDebugRenderer.getFontMetrics(font, inlay.getEditor()).stringWidth((String)text2 + INDENT);
    }

    @NotNull
    private static FontMetrics getFontMetrics(Font font, @NotNull Editor editor2) {
        if (editor2 == null) {
            InlineDebugRenderer.$$$reportNull$$$0(11);
        }
        FontMetrics fontMetrics = FontInfo.getFontMetrics(font, FontInfo.getFontRenderContext(editor2.getContentComponent()));
        if (fontMetrics == null) {
            InlineDebugRenderer.$$$reportNull$$$0(12);
        }
        return fontMetrics;
    }

    private static int getIconY(Icon icon2, Rectangle r) {
        return r.y + r.height / 2 - icon2.getIconHeight() / 2;
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        EditorImpl editor2;
        TextAttributes inlineAttributes;
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(13);
        }
        if (g == null) {
            InlineDebugRenderer.$$$reportNull$$$0(14);
        }
        if (r == null) {
            InlineDebugRenderer.$$$reportNull$$$0(15);
        }
        if (textAttributes == null) {
            InlineDebugRenderer.$$$reportNull$$$0(16);
        }
        if ((inlineAttributes = this.getAttributes(editor2 = (EditorImpl)inlay.getEditor())) == null || inlineAttributes.getForegroundColor() == null) {
            return;
        }
        Font font = InlineDebugRenderer.getFont(editor2);
        g.setFont(font);
        FontMetrics metrics = InlineDebugRenderer.getFontMetrics(font, editor2);
        int gap = 1;
        int margin = metrics.charWidth(' ') / 4;
        Color backgroundColor = inlineAttributes.getBackgroundColor();
        int curX = r.x + metrics.charWidth(' ');
        if (backgroundColor != null) {
            float alpha = 0.55f;
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha);
            g.setColor(backgroundColor);
            g.fillRoundRect(curX + margin, r.y + gap, r.width - 2 * margin - metrics.charWidth(' '), r.height - gap * 2, 6, 6);
            config2.restore();
        }
        curX += 2 * margin;
        if (this.myCustomNode) {
            Icon watchIcon = AllIcons.Debugger.Watch;
            watchIcon.paintIcon(inlay.getEditor().getComponent(), g, curX, InlineDebugRenderer.getIconY(watchIcon, r));
            curX += watchIcon.getIconWidth() + margin * 2;
        }
        this.myTextStartXCoordinate = curX;
        for (int i2 = 0; i2 < this.myPresentation.getTexts().size(); ++i2) {
            Object curText = this.myPresentation.getTexts().get(i2);
            if (i2 == 0 && !this.isErrorMessage()) {
                curText = (String)curText + NAME_VALUE_SEPARATION;
            }
            SimpleTextAttributes attr = this.myPresentation.getAttributes().get(i2);
            Color fgColor = this.isHovered ? inlineAttributes.getForegroundColor() : attr.getFgColor();
            g.setColor(fgColor);
            g.drawString((String)curText, curX, r.y + inlay.getEditor().getAscent());
            curX += metrics.stringWidth((String)curText);
            if (this.isErrorMessage()) break;
        }
        if (this.isHovered) {
            Icon icon2;
            if (this.myCustomNode) {
                icon2 = AllIcons.Actions.Close;
                this.myRemoveXCoordinate = curX;
            } else {
                icon2 = AllIcons.General.LinkDropTriangle;
            }
            icon2.paintIcon(inlay.getEditor().getComponent(), g, curX, InlineDebugRenderer.getIconY(icon2, r));
        }
        InlineDebugRenderer.paintEffects(g, r, editor2, inlineAttributes, font, metrics);
    }

    private boolean isErrorMessage() {
        return XDebuggerUIConstants.ERROR_MESSAGE_ICON.equals(this.myValueNode.getIcon());
    }

    private static void paintEffects(@NotNull Graphics g, @NotNull Rectangle r, EditorImpl editor2, TextAttributes inlineAttributes, Font font, FontMetrics metrics) {
        if (g == null) {
            InlineDebugRenderer.$$$reportNull$$$0(17);
        }
        if (r == null) {
            InlineDebugRenderer.$$$reportNull$$$0(18);
        }
        Color effectColor = inlineAttributes.getEffectColor();
        EffectType effectType = inlineAttributes.getEffectType();
        if (effectColor != null) {
            g.setColor(effectColor);
            Graphics2D g2d = (Graphics2D)g;
            int xStart = r.x;
            int xEnd = r.x + r.width;
            int y = r.y + metrics.getAscent();
            if (effectType == EffectType.LINE_UNDERSCORE) {
                EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.STRIKEOUT) {
                EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, editor2.getCharHeight(), (Object)font);
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            }
        }
    }

    private TextAttributes getAttributes(Editor editor2) {
        TextAttributesKey key = this.isInExecutionPointHighlight() ? DebuggerColors.INLINED_VALUES_EXECUTION_LINE : DebuggerColors.INLINED_VALUES;
        EditorColorsScheme scheme2 = editor2.getColorsScheme();
        TextAttributes inlinedAttributes = scheme2.getAttributes(key);
        if (this.isHovered) {
            Color foregroundColor;
            TextAttributes hoveredInlineAttr = new TextAttributes();
            hoveredInlineAttr.copyFrom(inlinedAttributes);
            Color hoveredAndSelectedColor = scheme2.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES).getForegroundColor();
            Color color = foregroundColor = this.isInExecutionPointHighlight() ? hoveredAndSelectedColor : scheme2.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor();
            if (foregroundColor == null) {
                foregroundColor = scheme2.getDefaultForeground();
            }
            hoveredInlineAttr.setForegroundColor(foregroundColor);
            return hoveredInlineAttr;
        }
        return inlinedAttributes;
    }

    boolean isCustomNode() {
        return this.myCustomNode;
    }

    XValueNodeImpl getValueNode() {
        return this.myValueNode;
    }

    XSourcePosition getPosition() {
        return this.myPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onMouseExit";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHovered";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInlayTextWidth";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFontMetrics";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "paintEffects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

