/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineWatch {
    @NotNull
    private final XExpression myExpression;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private XSourcePosition myPosition;
    @Nullable
    private RangeMarker myRangeMarker;

    public InlineWatch(@NotNull XExpression expression, @NotNull XSourcePosition position) {
        if (expression == null) {
            InlineWatch.$$$reportNull$$$0(0);
        }
        if (position == null) {
            InlineWatch.$$$reportNull$$$0(1);
        }
        this.myExpression = expression;
        this.myFile = position.getFile();
        this.myPosition = position;
    }

    @NotNull
    public XExpression getExpression() {
        XExpression xExpression = this.myExpression;
        if (xExpression == null) {
            InlineWatch.$$$reportNull$$$0(2);
        }
        return xExpression;
    }

    @NotNull
    public XSourcePosition getPosition() {
        XSourcePosition xSourcePosition = this.myPosition;
        if (xSourcePosition == null) {
            InlineWatch.$$$reportNull$$$0(3);
        }
        return xSourcePosition;
    }

    public boolean isValid() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid();
    }

    public int getLine() {
        return this.myPosition.getLine();
    }

    public void updatePosition() {
        int line;
        if (this.myRangeMarker != null && this.myRangeMarker.isValid() && (line = this.myRangeMarker.getDocument().getLineNumber(this.myRangeMarker.getStartOffset())) != this.myPosition.getLine()) {
            this.myPosition = Objects.requireNonNull(XDebuggerUtil.getInstance().createPosition(this.myFile, line));
        }
    }

    public void setMarker() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (document == null) {
            return;
        }
        int offset = document.getLineEndOffset(this.myPosition.getLine());
        this.myRangeMarker = document.createRangeMarker(offset, offset, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

