/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.ui.InplaceEditor;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InlineWatchInplaceEditor
extends InplaceEditor {
    private final XSourcePosition myPresentationPosition;
    private final XDebugSession mySession;
    private final Editor myHostEditor;
    private final XExpression myInitialExpression;
    private XDebuggerExpressionComboBox myInplaceEditor;

    public InlineWatchInplaceEditor(XSourcePosition presentationPosition, @NotNull XDebugSession session2, @NotNull Editor editor2) {
        if (session2 == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(1);
        }
        this(presentationPosition, session2, editor2, null);
    }

    public InlineWatchInplaceEditor(XSourcePosition presentationPosition, @NotNull XDebugSession session2, @NotNull Editor editor2, XExpression expression) {
        if (session2 == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(3);
        }
        this.myPresentationPosition = presentationPosition;
        this.mySession = session2;
        this.myHostEditor = editor2;
        this.myInitialExpression = expression;
    }

    @Override
    protected void beforeShow() {
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        this.myInplaceEditor = new XDebuggerExpressionComboBox(this.mySession.getProject(), this.mySession.getDebugProcess().getEditorsProvider(), "inlineWatch", this.mySession.getCurrentPosition(), false, true);
        if (this.myInitialExpression != null) {
            this.myInplaceEditor.setExpression(this.myInitialExpression);
        }
        return this.myInplaceEditor.getComponent();
    }

    @Override
    protected JComponent getPreferredFocusedComponent() {
        return this.myInplaceEditor.getPreferredFocusedComponent();
    }

    @Override
    public Editor getEditor() {
        return this.myInplaceEditor.getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myInplaceEditor.getEditorComponent();
    }

    protected XExpression getExpression() {
        return this.myInplaceEditor.getExpression();
    }

    @Override
    public void doOKAction() {
        XExpression expression = this.getExpression();
        this.myInplaceEditor.saveTextInHistory();
        super.doOKAction();
        if (!XDebuggerUtilImpl.isEmptyExpression(expression)) {
            XDebuggerWatchesManager watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.mySession.getProject())).getWatchesManager();
            watchesManager.addInlineWatchExpression(expression, -1, this.myPresentationPosition, false);
        }
    }

    @Override
    public void cancelEditing() {
        super.cancelEditing();
        if (this.myInitialExpression != null) {
            XDebuggerWatchesManager watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.mySession.getProject())).getWatchesManager();
            watchesManager.addInlineWatchExpression(this.myInitialExpression, -1, this.myPresentationPosition, false);
        }
    }

    @Override
    protected JComponent getHostComponent() {
        return this.myHostEditor.getContentComponent();
    }

    @Override
    protected Project getProject() {
        return this.mySession.getProject();
    }

    @Override
    protected Rectangle getEditorBounds() {
        int caretOffset = this.myHostEditor.getCaretModel().getOffset();
        Point caretPoint = this.myHostEditor.offsetToXY(caretOffset);
        int width = this.myHostEditor.getContentComponent().getWidth() - (caretPoint.x - this.myHostEditor.getContentComponent().getX());
        int height = this.myHostEditor.getLineHeight();
        Rectangle bounds2 = this.myHostEditor.getContentComponent().getVisibleRect();
        Rectangle lineBounds = new Rectangle(caretPoint.x, caretPoint.y, width, height);
        if (bounds2 == null) {
            return null;
        }
        if (bounds2.y > lineBounds.y || bounds2.y + bounds2.height < lineBounds.y + lineBounds.height) {
            return null;
        }
        bounds2.y = lineBounds.y;
        bounds2.height = lineBounds.height;
        if (lineBounds.x > bounds2.x) {
            bounds2.width = bounds2.width - lineBounds.x + bounds2.x - UIUtil.getScrollBarWidth();
            bounds2.x = lineBounds.x;
        }
        return bounds2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/inline/InlineWatchInplaceEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

