/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.EDT;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class XDebuggerInlayUtil {
    public static final String INLINE_HINTS_DELIMETER = ":";
    @NotNull
    private final Project myProject;

    public static XDebuggerInlayUtil getInstance(Project project) {
        return (XDebuggerInlayUtil)project.getService(XDebuggerInlayUtil.class);
    }

    XDebuggerInlayUtil(final Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

            public void processStopped(@NotNull XDebugProcess debugProcess) {
                if (debugProcess == null) {
                    1.$$$reportNull$$$0(0);
                }
                XVariablesView.InlineVariablesInfo.set(debugProcess.getSession(), null);
            }

            public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    XVariablesView.InlineVariablesInfo info2;
                    if (previousSession != null && !previousSession.isStopped() && (info2 = XVariablesView.InlineVariablesInfo.get(previousSession)) != null) {
                        info2.setInlays(XDebuggerInlayUtil.clearInlaysInt(project));
                    }
                    if (currentSession != null && (info2 = XVariablesView.InlineVariablesInfo.get(currentSession)) != null) {
                        info2.getInlays().forEach(renderer2 -> XDebuggerInlayUtil.createInlayInt(currentSession, renderer2));
                    }
                    DebuggerUIUtil.repaintCurrentEditor(project);
                }, project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$1", "processStopped"));
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                XDebuggerInlayUtil.clearInlaysInEditor(event.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$2", "editorReleased"));
            }
        }, (Disposable)project);
    }

    public boolean createLineEndInlay(@NotNull XValueNodeImpl valueNode, @NotNull XDebugSession session2, @NotNull XSourcePosition position) {
        if (valueNode == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(1);
        }
        if (position == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(2);
        }
        if (valueNode.getValuePresentation() != null) {
            ApplicationManager.getApplication().invokeLater(() -> XDebuggerInlayUtil.createInlayInt(session2, new InlineDebugRenderer(valueNode, position, session2)), session2.getProject().getDisposed());
            return true;
        }
        return false;
    }

    private static void createInlayInt(@NotNull XDebugSession session2, final InlineDebugRenderer renderer2) {
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(3);
        }
        EDT.assertIsEdt();
        XSourcePosition position = renderer2.getPosition();
        FileEditor editor2 = FileEditorManager.getInstance((Project)session2.getProject()).getSelectedEditor(position.getFile());
        if (editor2 instanceof TextEditor) {
            Editor e = ((TextEditor)editor2).getEditor();
            int offset = e.getDocument().getLineEndOffset(position.getLine());
            final Inlay inlay = e.getInlayModel().addAfterLineEndElement(offset, new InlayProperties().disableSoftWrapping(true).priority(renderer2.isCustomNode() ? 0 : -1), (EditorCustomElementRenderer)renderer2);
            if (inlay == null) {
                return;
            }
            final XValueNodeImpl valueNode = renderer2.getValueNode();
            valueNode.getTree().addTreeListener(new XDebuggerTreeListener(){

                @Override
                public void nodeLoaded(@NotNull RestorableStateNode node2, @NotNull String name2) {
                    if (node2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (name2 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (node2 == valueNode) {
                        renderer2.updatePresentation();
                        inlay.update();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "name";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$3";
                    objectArray[2] = "nodeLoaded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)inlay);
            if (renderer2.isCustomNode()) {
                ((InlineWatchNodeImpl)valueNode).inlayCreated((Inlay<InlineDebugRenderer>)inlay);
            }
        }
    }

    public void clearInlays() {
        ApplicationManager.getApplication().invokeLater(() -> XDebuggerInlayUtil.clearInlaysInt(this.myProject), this.myProject.getDisposed());
    }

    private static List<Inlay> clearInlaysInEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(4);
        }
        EDT.assertIsEdt();
        List inlays = editor2.getInlayModel().getAfterLineEndElementsInRange(0, editor2.getDocument().getTextLength(), InlineDebugRenderer.class);
        inlays.forEach(Disposer::dispose);
        return inlays;
    }

    private static List<InlineDebugRenderer> clearInlaysInt(@NotNull Project project) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(5);
        }
        return StreamEx.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).select(TextEditor.class).flatCollection(textEditor -> XDebuggerInlayUtil.clearInlaysInEditor(textEditor.getEditor())).map(Inlay::getRenderer).select(InlineDebugRenderer.class).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineEndInlay";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createInlayInt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlaysInEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlaysInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

