/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextViewer
extends EditorTextField {
    private final boolean myEmbeddedIntoDialogWrapper;

    public TextViewer(@NotNull String initialText, @NotNull Project project, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(1);
        }
        this(TextViewer.createDocument(initialText, viewer), project, true, viewer);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(2);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(3);
        }
        this(initialText, project, true);
    }

    public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean viewer) {
        if (document == null) {
            TextViewer.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(5);
        }
        super(document, project, (FileType)FileTypes.PLAIN_TEXT, viewer, false);
        this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
        this.setFontInheritedFromLAF(false);
    }

    private static Document createDocument(@NotNull String initialText, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(6);
        }
        if (TextViewer.needSlashRSupport(initialText, viewer)) {
            return ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(initialText, true, false);
        }
        return EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)initialText));
    }

    @Override
    public void setText(@Nullable String text2) {
        if (text2 != null) {
            if (TextViewer.needSlashRSupport(text2, this.isViewer())) {
                Editor editor2;
                if (!((DocumentImpl)this.getDocument()).setAcceptSlashR(true) && (editor2 = this.getEditor()) instanceof EditorEx) {
                    ((EditorEx)editor2).reinitSettings();
                }
            } else {
                text2 = StringUtil.convertLineSeparators((String)text2);
            }
        }
        super.setText(text2);
    }

    private static boolean needSlashRSupport(String text2, boolean viewer) {
        return !viewer && text2.contains("\r");
    }

    @Override
    @NotNull
    protected EditorEx createEditor() {
        EditorEx editor2 = super.createEditor();
        editor2.setHorizontalScrollbarVisible(true);
        editor2.setCaretEnabled(true);
        editor2.getScrollPane().setVerticalScrollBarPolicy(20);
        editor2.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
        editor2.getComponent().setPreferredSize(null);
        editor2.getSettings().setUseSoftWraps(true);
        editor2.setColorsScheme(DebuggerUIUtil.getColorScheme());
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            TextViewer.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/TextViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/TextViewer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

