/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlXmlExtension
extends DefaultXmlExtension {
    @Override
    public boolean isAvailable(PsiFile file2) {
        return file2.getFileType() == HtmlFileType.INSTANCE;
    }

    @Override
    public String[] @Nullable [] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        String[][] namespaces = super.getNamespacesFromDocument(parent, false);
        if (namespaces == null || !HtmlUtil.isHtml5Document(parent)) {
            return namespaces;
        }
        for (String[] namespace : namespaces) {
            if (!"xlink".equals(namespace[0])) continue;
            return namespaces;
        }
        String[][] newNamespaces = new String[namespaces.length + 1][2];
        System.arraycopy(namespaces, 0, newNamespaces, 0, namespaces.length);
        newNamespaces[namespaces.length] = new String[]{"xlink", "http://www.w3.org/1999/xlink"};
        return newNamespaces;
    }

    @Override
    public boolean isSelfClosingTagAllowed(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            HtmlXmlExtension.$$$reportNull$$$0(0);
        }
        for (XmlTag parent = tag2; parent != null; parent = parent.getParentTag()) {
            if (!"svg".equals(parent.getName()) && !"math".equals(parent.getName())) continue;
            return true;
        }
        return super.isSelfClosingTagAllowed(tag2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/HtmlXmlExtension", "isSelfClosingTagAllowed"));
    }
}

