/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlExtension {
    public static final ExtensionPointName<XmlExtension> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlExtension");

    public static XmlExtension getExtension(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlExtension.$$$reportNull$$$0(0);
        }
        return (XmlExtension)CachedValuesManager.getCachedValue((PsiElement)file2, () -> CachedValueProvider.Result.create((Object)XmlExtension.calcExtension(file2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static XmlExtension calcExtension(PsiFile file2) {
        for (XmlExtension extension2 : EP_NAME.getExtensionList()) {
            if (!extension2.isAvailable(file2)) continue;
            return extension2;
        }
        return DefaultXmlExtension.DEFAULT_EXTENSION;
    }

    public static XmlExtension getExtensionByElement(PsiElement element2) {
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile != null) {
            return XmlExtension.getExtension(psiFile);
        }
        return null;
    }

    public abstract boolean isAvailable(PsiFile var1);

    @NotNull
    public abstract List<TagInfo> getAvailableTagNames(@NotNull XmlFile var1, @NotNull XmlTag var2);

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag);
    }

    public String[] @Nullable [] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        return declarationsExist ? null : XmlUtil.getDefaultNamespaces(parent);
    }

    public boolean canBeDuplicated(XmlAttribute attribute) {
        return false;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag2, String attrName) {
        return false;
    }

    public HighlightInfoType getHighlightInfoType(XmlFile file2) {
        return HighlightInfoType.ERROR;
    }

    @Nullable
    public abstract SchemaPrefix getPrefixDeclaration(XmlTag var1, String var2);

    public SearchScope getNsPrefixScope(XmlAttribute declaration) {
        return new LocalSearchScope((PsiElement)declaration.getParent());
    }

    public boolean shouldBeHighlightedAsTag(XmlTag tag2) {
        return true;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag tag2, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        return parentDescriptor.getElementDescriptor(tag2, contextTag);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element2, String namespace, boolean strict) {
        return element2.getNSDescriptor(namespace, strict);
    }

    @NotNull
    public XmlNSDescriptor wrapNSDescriptor(@NotNull XmlTag element2, @NotNull String namespacePrefix, @NotNull XmlNSDescriptor descriptor2) {
        if (element2 == null) {
            XmlExtension.$$$reportNull$$$0(1);
        }
        if (namespacePrefix == null) {
            XmlExtension.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            XmlExtension.$$$reportNull$$$0(3);
        }
        if (element2 instanceof HtmlTag && !(descriptor2 instanceof HtmlNSDescriptorImpl)) {
            XmlFile obj2 = descriptor2.getDescriptorFile();
            XmlNSDescriptor result2 = obj2 == null ? null : XmlDocumentImpl.getCachedHtmlNsDescriptor(obj2, namespacePrefix);
            XmlNSDescriptor xmlNSDescriptor = result2 == null ? new HtmlNSDescriptorImpl(descriptor2) : result2;
            if (xmlNSDescriptor == null) {
                XmlExtension.$$$reportNull$$$0(4);
            }
            return xmlNSDescriptor;
        }
        XmlNSDescriptor xmlNSDescriptor = descriptor2;
        if (xmlNSDescriptor == null) {
            XmlExtension.$$$reportNull$$$0(5);
        }
        return xmlNSDescriptor;
    }

    @Nullable
    public XmlTag getParentTagForNamespace(XmlTag tag2, XmlNSDescriptor namespace) {
        return tag2.getParentTag();
    }

    @Nullable
    public XmlFile getContainingFile(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile psiFile = element2.getContainingFile();
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile containingFile, XmlNSDescriptor descr) {
        return descr;
    }

    public boolean hasDynamicComponents(PsiElement element2) {
        return false;
    }

    public boolean isIndirectSyntax(XmlAttributeDescriptor descriptor2) {
        return false;
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor2) {
        return descriptor2.isRequired();
    }

    public boolean shouldCompleteTag(XmlTag context2) {
        return true;
    }

    @NotNull
    public AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlTag tag2, @NotNull String attributeName, final @NotNull String defaultAttributeQuote) {
        if (attributeName == null) {
            XmlExtension.$$$reportNull$$$0(6);
        }
        if (defaultAttributeQuote == null) {
            XmlExtension.$$$reportNull$$$0(7);
        }
        return new AttributeValuePresentation(){

            @Override
            @NotNull
            public String getPrefix() {
                String string = defaultAttributeQuote;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getPostfix() {
                String string = defaultAttributeQuote;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/xml/XmlExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPostfix";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public boolean isCustomTagAllowed(XmlTag tag2) {
        return false;
    }

    public boolean useXmlTagInsertHandler() {
        return true;
    }

    public boolean isCollapsibleTag(XmlTag tag2) {
        return false;
    }

    public boolean isSelfClosingTagAllowed(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlExtension.$$$reportNull$$$0(8);
        }
        return false;
    }

    public boolean isSingleTagException(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlExtension.$$$reportNull$$$0(9);
        }
        return false;
    }

    public boolean isValidTagNameChar(char c) {
        return false;
    }

    @NotNull
    public @NotNull List<@NotNull XmlFile> getCharEntitiesDTDs(@NotNull XmlFile file2) {
        XmlDocument document;
        if (file2 == null) {
            XmlExtension.$$$reportNull$$$0(10);
        }
        if (HtmlUtil.isHtml5Document(document = file2.getDocument())) {
            List list2 = ContainerUtil.packNullables((Object[])new XmlFile[]{XmlUtil.findXmlFile((PsiFile)file2, Html5SchemaProvider.getCharsDtdLocation())});
            if (list2 == null) {
                XmlExtension.$$$reportNull$$$0(11);
            }
            return list2;
        }
        if (document != null) {
            FileType ft;
            String namespace;
            XmlNSDescriptor nsDescriptor;
            XmlElementDescriptor descriptor2;
            XmlTag rootTag = document.getRootTag();
            if (rootTag != null && (descriptor2 = rootTag.getDescriptor()) != null && !(descriptor2 instanceof AnyXmlElementDescriptor)) {
                PsiFile containingFile;
                PsiElement element2 = descriptor2.getDeclaration();
                PsiFile psiFile = containingFile = element2 != null ? element2.getContainingFile() : null;
                if (containingFile instanceof XmlFile) {
                    List<XmlFile> list3 = Collections.singletonList((XmlFile)containingFile);
                    if (list3 == null) {
                        XmlExtension.$$$reportNull$$$0(12);
                    }
                    return list3;
                }
            }
            if ((nsDescriptor = document.getDefaultNSDescriptor(namespace = (ft = file2.getFileType()) == XHtmlFileType.INSTANCE || ft == StdFileTypes.JSPX ? "http://www.w3.org/1999/xhtml" : "http://www.w3.org/1999/html", true)) != null) {
                List list4 = ContainerUtil.packNullables((Object[])new XmlFile[]{nsDescriptor.getDescriptorFile()});
                if (list4 == null) {
                    XmlExtension.$$$reportNull$$$0(13);
                }
                return list4;
            }
        }
        List<XmlFile> list5 = Collections.emptyList();
        if (list5 == null) {
            XmlExtension.$$$reportNull$$$0(14);
        }
        return list5;
    }

    public static boolean shouldIgnoreSelfClosingTag(@NotNull XmlTag tag2) {
        XmlExtension extension2;
        if (tag2 == null) {
            XmlExtension.$$$reportNull$$$0(15);
        }
        return (extension2 = XmlExtension.getExtensionByElement((PsiElement)tag2)) != null && extension2.isSelfClosingTagAllowed(tag2);
    }

    public static boolean isCollapsible(XmlTag tag2) {
        XmlExtension extension2 = XmlExtension.getExtensionByElement((PsiElement)tag2);
        return extension2 == null || extension2.isCollapsibleTag(tag2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/XmlExtension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributeQuote";
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/XmlExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapNSDescriptor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharEntitiesDTDs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapNSDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelfClosingTagAllowed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSingleTagException";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCharEntitiesDTDs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreSelfClosingTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TagInfo {
        public final String name;
        public final String namespace;

        public TagInfo(String name2, String namespace) {
            this.name = name2;
            this.namespace = namespace;
        }

        @Nullable
        public PsiElement getDeclaration() {
            return null;
        }
    }

    public static interface AttributeValuePresentation {
        @NotNull
        public String getPrefix();

        @NotNull
        public String getPostfix();

        default public boolean showAutoPopup() {
            return true;
        }
    }
}

