/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.jetbrains.annotations.NotNull;

public class Xsd2InstanceUtils {
    public static String generate(String[] args) {
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> opts = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("dl");
        flags.add("noupa");
        flags.add("nopvr");
        flags.add("partial");
        opts.add("name");
        CommandLine cl = new CommandLine(args, flags, opts);
        String[] badOpts = cl.getBadOpts();
        if (badOpts.length > 0) {
            throw new IllegalArgumentException("Unrecognized option: " + badOpts[0]);
        }
        boolean dl = cl.getOpt("dl") != null;
        boolean nopvr = cl.getOpt("nopvr") != null;
        boolean noupa = cl.getOpt("noupa") != null;
        File[] schemaFiles = cl.filesEndingWith(".xsd");
        String rootName = cl.getOpt("name");
        if (rootName == null) {
            throw new IllegalArgumentException("Required option \"-name\" must be present");
        }
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (File schemaFile : schemaFiles) {
            try {
                sdocs.add(XmlObject.Factory.parse((File)schemaFile, (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not load schema file: " + schemaFile + ": " + e.getLocalizedMessage());
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[0]);
        SchemaTypeSystem sts = null;
        if (schemas.length > 0) {
            XmlOptions compileOptions = new XmlOptions();
            if (dl) {
                compileOptions.setCompileDownloadUrls();
            }
            if (nopvr) {
                compileOptions.setCompileNoPvrRule();
            }
            if (noupa) {
                compileOptions.setCompileNoUpaRule();
            }
            try {
                sts = XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)compileOptions);
            }
            catch (XmlException e) {
                StringBuilder out = new StringBuilder("Schema compilation errors: ");
                Collection errors2 = e.getErrors();
                for (Object error : errors2) {
                    out.append("\n").append(error);
                }
                throw new IllegalArgumentException(out.toString());
            }
        }
        if (sts == null) {
            throw new IllegalArgumentException("No Schemas to process.");
        }
        SchemaType[] globalElems = sts.documentTypes();
        SchemaType elem = null;
        for (SchemaType globalElem : globalElems) {
            if (!rootName.equals(globalElem.getDocumentElementName().getLocalPart())) continue;
            elem = globalElem;
            break;
        }
        if (elem == null) {
            throw new IllegalArgumentException("Could not find a global element with name \"" + rootName + "\"");
        }
        return SampleXmlUtil.createSampleForType(elem);
    }

    public static XmlElementDescriptor getDescriptor(XmlTag tag2, String elementName) {
        PsiMetaData metaData = tag2.getMetaData();
        if (metaData instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
            return nsDescriptor.getElementDescriptor(elementName, nsDescriptor.getDefaultNamespace());
        }
        return null;
    }

    public static List<String> addVariantsFromRootTag(XmlTag rootTag) {
        PsiMetaData metaData = rootTag.getMetaData();
        if (metaData instanceof XmlNSDescriptorImpl) {
            XmlElementDescriptor[] rootElementsDescriptors;
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
            ArrayList<String> elementDescriptors = new ArrayList<String>();
            for (XmlElementDescriptor e : rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)rootTag, XmlDocument.class))) {
                elementDescriptors.add(e.getName());
            }
            return elementDescriptors;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static String processAndSaveAllSchemas(@NotNull XmlFile file2, final @NotNull Map<String, String> scannedToFileName, final @NotNull SchemaReferenceProcessor schemaReferenceProcessor) {
        byte[] bytes;
        String fileName;
        String previous;
        if (file2 == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(0);
        }
        if (scannedToFileName == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(1);
        }
        if (schemaReferenceProcessor == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(2);
        }
        if ((previous = scannedToFileName.get(fileName = file2.getName())) != null) {
            String string = previous;
            if (string == null) {
                Xsd2InstanceUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        scannedToFileName.put(fileName, fileName);
        final StringBuilder result2 = new StringBuilder();
        file2.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(psiElement);
                if (psiElement instanceof LeafPsiElement) {
                    String text2 = psiElement.getText();
                    result2.append(text2);
                }
            }

            public void visitXmlAttribute(XmlAttribute xmlAttribute) {
                PsiElement psiElement;
                Object[] references;
                PsiReference reference2;
                boolean replaced = false;
                if (xmlAttribute.isNamespaceDeclaration()) {
                    XmlNSDescriptor nsDescriptor;
                    replaced = true;
                    String value2 = xmlAttribute.getValue();
                    result2.append(xmlAttribute.getText()).append(" ");
                    if (!scannedToFileName.containsKey(value2) && (nsDescriptor = xmlAttribute.getParent().getNSDescriptor(value2, true)) != null) {
                        Xsd2InstanceUtils.processAndSaveAllSchemas(nsDescriptor.getDescriptorFile(), scannedToFileName, schemaReferenceProcessor);
                    }
                } else if ("schemaLocation".equals(xmlAttribute.getName()) && (reference2 = (PsiReference)ArrayUtil.getLastElement((Object[])(references = xmlAttribute.getValueElement().getReferences()))) != null && (psiElement = reference2.resolve()) instanceof XmlFile) {
                    String s = Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)psiElement, scannedToFileName, schemaReferenceProcessor);
                    result2.append(xmlAttribute.getName()).append("='").append(s).append('\'');
                    replaced = true;
                }
                if (!replaced) {
                    result2.append(xmlAttribute.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/xml/actions/xmlbeans/Xsd2InstanceUtils$1", "visitElement"));
            }
        });
        VirtualFile virtualFile2 = file2.getVirtualFile();
        String content2 = result2.toString();
        if (virtualFile2 != null) {
            bytes = content2.getBytes(virtualFile2.getCharset());
        } else {
            try {
                String charsetName = XmlUtil.extractXmlEncodingFromProlog(content2.getBytes(StandardCharsets.UTF_8));
                bytes = charsetName != null ? content2.getBytes(charsetName) : content2.getBytes(StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                bytes = content2.getBytes(StandardCharsets.UTF_8);
            }
        }
        schemaReferenceProcessor.processSchema(fileName, bytes);
        String string = fileName;
        if (string == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scannedToFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaReferenceProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/actions/xmlbeans/Xsd2InstanceUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/actions/xmlbeans/Xsd2InstanceUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processAndSaveAllSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAndSaveAllSchemas";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SchemaReferenceProcessor {
        public void processSchema(String var1, byte[] var2);
    }
}

