/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.FieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementsGroupProcessor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplexTypeDescriptor
extends TypeDescriptor {
    protected final XmlNSDescriptorImpl myDocumentDescriptor;
    private static final FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myElementDescriptorsCache = new FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected XmlElementDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement context2) {
            return complexTypeDescriptor.doCollectElements(context2);
        }

        protected XmlElementDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            return complexTypeDescriptor.myElementDescriptors;
        }

        protected void putValue(XmlElementDescriptor[] xmlElementDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            complexTypeDescriptor.myElementDescriptors = xmlElementDescriptors;
        }
    };
    private static final FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myAttributeDescriptorsCache = new FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected XmlAttributeDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p) {
            return complexTypeDescriptor.doCollectAttributes();
        }

        protected XmlAttributeDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object o) {
            return complexTypeDescriptor.myAttributeDescriptors;
        }

        protected void putValue(XmlAttributeDescriptor[] xmlAttributeDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            complexTypeDescriptor.myAttributeDescriptors = xmlAttributeDescriptors;
        }
    };
    private final Map<String, CachedValue<CanContainAttributeType>> myAnyAttributeCache = ConcurrentFactoryMap.createMap(key -> CachedValuesManager.getManager((Project)this.myTag.getProject()).createCachedValue(() -> {
        HashSet<Object> dependencies2 = new HashSet<Object>();
        CanContainAttributeType type = this._canContainAttribute((String)key, this.myTag, null, (Set<String>)new HashSet<String>(), (Set<Object>)dependencies2);
        if (dependencies2.isEmpty()) {
            dependencies2.add(this.myTag.getContainingFile());
        }
        if (DumbService.isDumb((Project)this.myTag.getProject())) {
            dependencies2.add(DumbService.getInstance((Project)this.myTag.getProject()).getModificationTracker());
        }
        return CachedValueProvider.Result.create((Object)((Object)type), (Object[])ArrayUtil.toObjectArray(dependencies2));
    }, false));
    private volatile XmlElementDescriptor[] myElementDescriptors;
    private volatile XmlAttributeDescriptor[] myAttributeDescriptors;
    @NonNls
    private static final String PROHIBITED_ATTR_VALUE = "prohibited";
    @NonNls
    private static final String OTHER_NAMESPACE_ATTR_VALUE = "##other";
    @NonNls
    private static final String TRUE_ATTR_VALUE = "true";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    private boolean myHasAnyInContentModel;
    @NonNls
    private static final String RESTRICTION_TAG_NAME = "restriction";
    @NonNls
    private static final String EXTENSION_TAG_NAME = "extension";
    @NonNls
    private static final String BASE_ATTR_NAME = "base";

    public ComplexTypeDescriptor(XmlNSDescriptorImpl documentDescriptor, XmlTag tag2) {
        super(tag2);
        this.myDocumentDescriptor = documentDescriptor;
    }

    @Override
    @NotNull
    public XmlTag getDeclaration() {
        XmlTag xmlTag = super.getDeclaration();
        if (xmlTag == null) {
            ComplexTypeDescriptor.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return XmlElementsGroupProcessor.computeGroups(this.myDocumentDescriptor, this.myTag);
    }

    public XmlElementDescriptor[] getElements(XmlElement context2) {
        return (XmlElementDescriptor[])myElementDescriptorsCache.get(null, (Object)this, (Object)context2);
    }

    private XmlElementDescriptor[] doCollectElements(XmlElement context2) {
        LinkedHashMap<String, XmlElementDescriptor> map2 = new LinkedHashMap<String, XmlElementDescriptor>(5);
        XmlNSDescriptor descriptor2 = null;
        if (context2 instanceof XmlTag) {
            descriptor2 = ((XmlTag)context2).getNSDescriptor(this.myDocumentDescriptor.getDefaultNamespace(), true);
        }
        this.processElements(this.createProcessor(map2, descriptor2 instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)descriptor2 : this.myDocumentDescriptor), map2);
        return map2.values().toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    protected void processElements(XmlSchemaTagsProcessor processor2, Map<String, XmlElementDescriptor> map2) {
        processor2.startProcessing(this.myTag);
        ComplexTypeDescriptor.addSubstitutionGroups(map2, this.myDocumentDescriptor, new HashSet());
        ComplexTypeDescriptor.filterAbstractElements(map2);
    }

    protected XmlSchemaTagsProcessor createProcessor(final Map<String, XmlElementDescriptor> map2, XmlNSDescriptorImpl nsDescriptor) {
        return new XmlSchemaTagsProcessor(nsDescriptor, new String[0]){

            @Override
            protected void tagStarted(XmlTag tag2, String tagName, XmlTag context2, @Nullable XmlTag ref) {
                String refName = ref == null ? null : ref.getAttributeValue(ComplexTypeDescriptor.REF_ATTR_NAME);
                ComplexTypeDescriptor.this.addElementDescriptor(tag2, tagName, map2, refName, ComplexTypeDescriptor.this.myDocumentDescriptor);
            }
        };
    }

    protected void addElementDescriptor(XmlTag tag2, String tagName, Map<String, XmlElementDescriptor> map2, @Nullable String refName, XmlNSDescriptorImpl nsDescriptor) {
        if (ELEMENT_TAG_NAME.equals(tagName) && tag2.getAttribute(NAME_ATTR_NAME) != null) {
            XmlElementDescriptor element2 = nsDescriptor.createElementDescriptor(tag2);
            String name2 = refName == null ? element2.getName() : refName;
            ComplexTypeDescriptor.addElementDescriptor(map2, element2, name2);
        }
    }

    private static void addSubstitutionGroups(Map<String, XmlElementDescriptor> result2, XmlNSDescriptorImpl nsDescriptor, Set<? super XmlNSDescriptorImpl> visited) {
        block0: while (true) {
            for (XmlElementDescriptor xmlElementDescriptor : result2.values()) {
                XmlElementDescriptorImpl descriptor2 = (XmlElementDescriptorImpl)xmlElementDescriptor;
                XmlElementDescriptor[] substitutes = nsDescriptor.getSubstitutes(descriptor2.getName(), descriptor2.getNamespace());
                boolean toContinue = false;
                for (XmlElementDescriptor substitute : substitutes) {
                    if (result2.get(substitute.getName()) != null) continue;
                    toContinue = true;
                    result2.put(substitute.getName(), substitute);
                }
                if (!toContinue) continue;
                continue block0;
            }
            break;
        }
        visited.add(nsDescriptor);
        for (XmlTag tag2 : nsDescriptor.getTag().getSubTags()) {
            PsiMetaData metaData;
            XmlDocument document;
            PsiFileSystemItem element2;
            XmlAttributeValue valueElement;
            XmlAttribute location;
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, "include") && !XmlNSDescriptorImpl.equalsToSchemaName(tag2, "import") || (location = tag2.getAttribute("schemaLocation")) == null || (valueElement = location.getValueElement()) == null || !((element2 = new FileReferenceSet((PsiElement)valueElement).resolve()) instanceof XmlFile) || (document = ((XmlFile)element2).getDocument()) == null || !((metaData = document.getMetaData()) instanceof XmlNSDescriptorImpl) || visited.contains(metaData)) continue;
            ComplexTypeDescriptor.addSubstitutionGroups(result2, (XmlNSDescriptorImpl)metaData, visited);
        }
    }

    private static void filterAbstractElements(Map<String, XmlElementDescriptor> result2) {
        Iterator<XmlElementDescriptor> iterator2 = result2.values().iterator();
        while (iterator2.hasNext()) {
            XmlElementDescriptorImpl descriptor2 = (XmlElementDescriptorImpl)iterator2.next();
            if (!descriptor2.isAbstract()) continue;
            iterator2.remove();
        }
    }

    public XmlAttributeDescriptor[] getAttributes(@Nullable XmlElement context2) {
        return (XmlAttributeDescriptor[])myAttributeDescriptorsCache.get(null, (Object)this, (Object)context2);
    }

    private XmlAttributeDescriptor[] doCollectAttributes() {
        final ArrayList result2 = new ArrayList();
        XmlSchemaTagsProcessor processor2 = new XmlSchemaTagsProcessor(this.myDocumentDescriptor, new String[]{ELEMENT_TAG_NAME}){

            @Override
            protected void tagStarted(XmlTag tag2, String tagName, XmlTag context2, XmlTag ref) {
                if (ComplexTypeDescriptor.ATTRIBUTE_TAG_NAME.equals(tagName)) {
                    String name2 = tag2.getAttributeValue(ComplexTypeDescriptor.NAME_ATTR_NAME);
                    if (name2 == null) {
                        return;
                    }
                    String use2 = null;
                    if (ComplexTypeDescriptor.ATTRIBUTE_TAG_NAME.equals(context2.getLocalName())) {
                        use2 = context2.getAttributeValue("use");
                    }
                    if (use2 == null) {
                        use2 = tag2.getAttributeValue("use");
                    }
                    if (ComplexTypeDescriptor.PROHIBITED_ATTR_VALUE.equals(use2)) {
                        ComplexTypeDescriptor.removeAttributeDescriptor(result2, name2, null);
                    } else {
                        XmlAttributeDescriptorImpl descriptor2 = new XmlAttributeDescriptorImpl(tag2);
                        descriptor2.myUse = use2;
                        if (ref != null) {
                            descriptor2.myReferenceName = ref.getAttributeValue(ComplexTypeDescriptor.REF_ATTR_NAME);
                        }
                        ComplexTypeDescriptor.addAttributeDescriptor(result2, descriptor2);
                    }
                }
            }
        };
        processor2.startProcessing(this.myTag);
        return result2.toArray(XmlAttributeDescriptor.EMPTY);
    }

    public XmlNSDescriptorImpl getNsDescriptor() {
        return this.myDocumentDescriptor;
    }

    protected static void addElementDescriptor(Map<String, XmlElementDescriptor> result2, XmlElementDescriptor element2, String name2) {
        result2.remove(name2);
        result2.put(name2, element2);
    }

    private static void removeAttributeDescriptor(List<XmlAttributeDescriptorImpl> result2, String name2, String referenceName) {
        Iterator<XmlAttributeDescriptorImpl> iterator2 = result2.iterator();
        while (iterator2.hasNext()) {
            XmlAttributeDescriptorImpl descriptor2 = iterator2.next();
            if (!descriptor2.getName().equals(name2) || referenceName != null && !referenceName.equals(descriptor2.myReferenceName)) continue;
            iterator2.remove();
        }
    }

    private static void addAttributeDescriptor(List<XmlAttributeDescriptorImpl> result2, XmlAttributeDescriptorImpl descriptor2) {
        ComplexTypeDescriptor.removeAttributeDescriptor(result2, descriptor2.getName(), descriptor2.myReferenceName);
        result2.add(descriptor2);
    }

    public boolean canContainTag(String localName, String namespace, XmlElement context2) {
        return this._canContainTag(localName, namespace, this.myTag, context2, new HashSet<XmlTag>(5), new CurrentContextInfo(this.myDocumentDescriptor, this.myDocumentDescriptor.getDefaultNamespace()), false);
    }

    static CurrentContextInfo getContextInfo(CurrentContextInfo info2, String ref) {
        XmlTag rootTag = info2.documentDescriptor.getTag();
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, ref, info2.documentDescriptor);
        String ns = nsDescriptor == info2.documentDescriptor ? rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(ref)) : nsDescriptor.getDefaultNamespace();
        if (Objects.equals(info2.expectedDefaultNs, ns) && info2.documentDescriptor == nsDescriptor) {
            return info2;
        }
        return new CurrentContextInfo(nsDescriptor, ns);
    }

    private boolean _canContainTag(String localName, String namespace, XmlTag tag2, XmlElement context2, Set<XmlTag> visited, CurrentContextInfo info2, boolean restriction) {
        String ref;
        if (visited.contains(tag2)) {
            return false;
        }
        visited.add(tag2);
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, "any")) {
            if (!restriction) {
                this.myHasAnyInContentModel = true;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(tag2.getAttributeValue("namespace"))) {
                return namespace == null || !namespace.equals(info2.expectedDefaultNs);
            }
            return true;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, "group")) {
            XmlTag groupTag;
            ref = tag2.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && (groupTag = info2.documentDescriptor.findGroup(ref)) != null && this._canContainTag(localName, namespace, groupTag, context2, visited, ComplexTypeDescriptor.getContextInfo(info2, ref), restriction)) {
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag2, EXTENSION_TAG_NAME)) {
            ComplexTypeDescriptor complexTypeDescriptor;
            TypeDescriptor descriptor2;
            String base = tag2.getAttributeValue(BASE_ATTR_NAME);
            if (base != null && (descriptor2 = info2.documentDescriptor.findTypeDescriptor(base)) instanceof ComplexTypeDescriptor && (complexTypeDescriptor = (ComplexTypeDescriptor)descriptor2)._canContainTag(localName, namespace, complexTypeDescriptor.myTag, context2, visited, ComplexTypeDescriptor.getContextInfo(info2, base), restriction || XmlNSDescriptorImpl.equalsToSchemaName(tag2, RESTRICTION_TAG_NAME))) {
                this.myHasAnyInContentModel |= complexTypeDescriptor.myHasAnyInContentModel;
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, ELEMENT_TAG_NAME)) {
            PsiElement psiElement;
            XmlAttributeValue element2;
            ref = tag2.getAttribute(REF_ATTR_NAME);
            XmlTag descriptorTag = tag2;
            if (ref != null && (element2 = ref.getValueElement()) != null && (psiElement = SchemaReferencesProvider.createTypeOrElementOrAttributeReference((PsiElement)element2).resolve()) instanceof XmlTag) {
                descriptorTag = (XmlTag)psiElement;
            }
            if (TRUE_ATTR_VALUE.equals(descriptorTag.getAttributeValue("abstract"))) {
                String substitutionValue;
                XmlNSDescriptor _nsDescriptor = tag2.getNSDescriptor(namespace, true);
                if (_nsDescriptor == null && context2 instanceof XmlTag) {
                    _nsDescriptor = ((XmlTag)context2).getNSDescriptor(namespace, true);
                }
                XmlNSDescriptorImpl nsDescriptor = _nsDescriptor instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)_nsDescriptor : null;
                XmlElementDescriptor descriptor3 = nsDescriptor != null ? nsDescriptor.getElementDescriptor(localName, namespace) : null;
                String name2 = descriptorTag.getAttributeValue(NAME_ATTR_NAME);
                if (descriptor3 != null && name2 != null && (substitutionValue = ((XmlTag)descriptor3.getDeclaration()).getAttributeValue("substitutionGroup")) != null && name2.equals(XmlUtil.findLocalNameByQualifiedName(substitutionValue))) {
                    return true;
                }
            }
        }
        for (XmlTag subTag : tag2.getSubTags()) {
            if (!this._canContainTag(localName, namespace, subTag, context2, visited, info2, restriction)) continue;
            return true;
        }
        return false;
    }

    public CanContainAttributeType canContainAttribute(String namespace, @Nullable String qName) {
        if (qName == null) {
            return (CanContainAttributeType)((Object)this.myAnyAttributeCache.get(namespace).getValue());
        }
        return this._canContainAttribute(namespace, this.myTag, qName, new HashSet<String>(), null);
    }

    private CanContainAttributeType _canContainAttribute(String namespace, @NotNull XmlTag tag2, @Nullable String qName, Set<String> visited, @Nullable Set<Object> dependencies2) {
        XmlTag[] subTags;
        String base;
        if (tag2 == null) {
            ComplexTypeDescriptor.$$$reportNull$$$0(1);
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, "anyAttribute")) {
            if (dependencies2 != null) {
                dependencies2.add(tag2.getContainingFile());
            }
            String ns = tag2.getAttributeValue("namespace");
            CanContainAttributeType canContainAttributeType = CanContainAttributeType.CanContainButDoNotSkip;
            if ("skip".equals(tag2.getAttributeValue("processContents"))) {
                canContainAttributeType = CanContainAttributeType.CanContainButSkip;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(ns)) {
                return !namespace.equals(this.myDocumentDescriptor.getDefaultNamespace()) ? canContainAttributeType : CanContainAttributeType.CanNotContain;
            }
            if (ns == null || "##any".equals(ns)) {
                return CanContainAttributeType.CanContainAny;
            }
            return canContainAttributeType;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, "attributeGroup")) {
            String ref = tag2.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && !visited.contains(ref)) {
                visited.add(ref);
                XmlTag groupTag = this.myDocumentDescriptor.findAttributeGroup(ref);
                if (groupTag != null) {
                    CanContainAttributeType containAttributeType;
                    if (dependencies2 != null) {
                        dependencies2.add(groupTag.getContainingFile());
                    }
                    if ((containAttributeType = this._canContainAttribute(namespace, groupTag, qName, visited, dependencies2)) != CanContainAttributeType.CanNotContain) {
                        return containAttributeType;
                    }
                }
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, ATTRIBUTE_TAG_NAME)) {
            if (qName != null && qName.equals(tag2.getAttributeValue(REF_ATTR_NAME))) {
                return CanContainAttributeType.CanContainButDoNotSkip;
            }
        } else if ((XmlNSDescriptorImpl.equalsToSchemaName(tag2, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag2, EXTENSION_TAG_NAME)) && (base = tag2.getAttributeValue(BASE_ATTR_NAME)) != null && !visited.contains(base)) {
            visited.add(base);
            TypeDescriptor descriptor2 = this.myDocumentDescriptor.findTypeDescriptor(base);
            if (descriptor2 instanceof ComplexTypeDescriptor) {
                CanContainAttributeType containAttributeType;
                ComplexTypeDescriptor complexTypeDescriptor = (ComplexTypeDescriptor)descriptor2;
                if (dependencies2 != null) {
                    XmlTag declaration = complexTypeDescriptor.getDeclaration();
                    dependencies2.add(declaration.getContainingFile());
                }
                if ((containAttributeType = complexTypeDescriptor._canContainAttribute(namespace, complexTypeDescriptor.getDeclaration(), qName, visited, dependencies2)) != CanContainAttributeType.CanNotContain) {
                    return containAttributeType;
                }
            }
        }
        for (XmlTag subTag : subTags = tag2.getSubTags()) {
            CanContainAttributeType containAttributeType = this._canContainAttribute(namespace, subTag, qName, visited, dependencies2);
            if (containAttributeType == CanContainAttributeType.CanNotContain) continue;
            return containAttributeType;
        }
        return CanContainAttributeType.CanNotContain;
    }

    public boolean hasAnyInContentModel() {
        return this.myHasAnyInContentModel;
    }

    public int getContentType() {
        if ("simpleType".equals(this.myTag.getLocalName()) || TRUE_ATTR_VALUE.equals(this.myTag.getAttributeValue("mixed"))) {
            return 3;
        }
        if (this.getElements(null).length > 0) {
            return 2;
        }
        for (XmlTag tag2 : this.myTag.getSubTags()) {
            if (!"simpleContent".equals(tag2.getLocalName())) continue;
            return 3;
        }
        return 0;
    }

    public String getTypeName() {
        return this.myTag.getAttributeValue(NAME_ATTR_NAME);
    }

    public String toString() {
        return this.getTypeName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/schema/ComplexTypeDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/schema/ComplexTypeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_canContainAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum CanContainAttributeType {
        CanContainButSkip,
        CanContainButDoNotSkip,
        CanContainAny,
        CanNotContain;

    }

    static class CurrentContextInfo {
        final XmlNSDescriptorImpl documentDescriptor;
        final String expectedDefaultNs;

        CurrentContextInfo(XmlNSDescriptorImpl _nsDescriptor, String _ns) {
            this.documentDescriptor = _nsDescriptor;
            this.expectedDefaultNs = _ns;
        }
    }
}

