/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.Stack;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.impl.schema.XmlElementsGroupImpl;
import com.intellij.xml.impl.schema.XmlElementsGroupLeaf;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;

public final class XmlElementsGroupProcessor
extends XmlSchemaTagsProcessor {
    final Stack<XmlElementsGroup> myGroups = new Stack();

    public static XmlElementsGroup computeGroups(XmlNSDescriptorImpl descriptor2, XmlTag tag2) {
        XmlElementsGroupProcessor processor2 = new XmlElementsGroupProcessor(descriptor2);
        processor2.startProcessing(tag2);
        return processor2.getRootGroup();
    }

    private XmlElementsGroup getRootGroup() {
        return (XmlElementsGroup)this.myGroups.get(0);
    }

    private XmlElementsGroupProcessor(XmlNSDescriptorImpl nsDescriptor) {
        super(nsDescriptor, "attribute");
        this.myGroups.push((Object)new XmlElementsGroupImpl(null, null, null){

            @Override
            public XmlElementsGroup.Type getGroupType() {
                return XmlElementsGroup.Type.GROUP;
            }

            @Override
            public String toString() {
                return "root";
            }
        });
    }

    @Override
    protected void tagStarted(XmlTag tag2, String tagName, XmlTag context2, XmlTag ref) {
        XmlElementsGroup.Type type = XmlElementsGroupImpl.getTagType(tag2);
        if (type != null) {
            XmlElementsGroupImpl group2 = new XmlElementsGroupImpl(tag2, (XmlElementsGroup)this.myGroups.peek(), ref);
            this.addSubGroup(group2);
            this.myGroups.push((Object)group2);
        } else if ("element".equals(tagName)) {
            XmlElementsGroupLeaf group3 = new XmlElementsGroupLeaf(tag2, this.myNsDescriptor.createElementDescriptor(tag2), (XmlElementsGroup)this.myGroups.peek(), ref);
            if (!this.myGroups.empty()) {
                this.addSubGroup(group3);
            } else {
                this.myGroups.push((Object)group3);
            }
        }
    }

    @Override
    protected void tagFinished(XmlTag tag2) {
        if (!this.myGroups.empty() && XmlElementsGroupImpl.getTagType(tag2) != null) {
            this.myGroups.pop();
        }
    }

    private void addSubGroup(XmlElementsGroup group2) {
        XmlElementsGroup last;
        if (!this.myGroups.empty() && (last = (XmlElementsGroup)this.myGroups.peek()) instanceof XmlElementsGroupImpl) {
            ((XmlElementsGroupImpl)last).addSubGroup(group2);
        }
    }
}

