/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.ExternalDocumentValidator;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.RedefinedElementDescriptor;
import com.intellij.xml.impl.schema.RedefinedTypeDescriptor;
import com.intellij.xml.impl.schema.SimpleTypeDescriptor;
import com.intellij.xml.impl.schema.StdTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorByType;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNSDescriptorImpl
implements XmlNSDescriptorEx,
Validator<XmlDocument>,
DumbAware,
XsdNsDescriptor {
    @NonNls
    public static final String XSD_PREFIX = "xsd";
    @NonNls
    public static final String SCHEMA_TAG_NAME = "schema";
    @NonNls
    public static final String IMPORT_TAG_NAME = "import";
    @NonNls
    static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String SEQUENCE_TAG_NAME = "sequence";
    private static final Logger LOG = Logger.getInstance(XmlNSDescriptorImpl.class);
    @NonNls
    private static final Set<String> STD_TYPES = new HashSet<String>();
    private static final Set<String> UNDECLARED_STD_TYPES = new HashSet<String>();
    @NonNls
    private static final String INCLUDE_TAG_NAME = "include";
    @NonNls
    private static final String REDEFINE_TAG_NAME = "redefine";
    private final Map<QNameKey, CachedValue<XmlElementDescriptor>> myDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private final Map<Pair<QNameKey, XmlTag>, CachedValue<TypeDescriptor>> myTypesMap = Collections.synchronizedMap(new HashMap());
    private XmlFile myFile;
    private XmlTag myTag;
    private String myTargetNamespace;
    private volatile Object[] dependencies;
    private MultiMap<String, XmlTag> mySubstitutions;

    public XmlNSDescriptorImpl(XmlFile file2) {
        this.init((PsiElement)file2.getDocument());
    }

    public XmlNSDescriptorImpl() {
    }

    private static void collectDependencies(@Nullable XmlTag myTag, @NotNull XmlFile myFile, @NotNull Set<PsiFile> visited) {
        XmlTag[] tags;
        if (myFile == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (visited == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (visited.contains(myFile)) {
            return;
        }
        visited.add((PsiFile)myFile);
        if (myTag == null) {
            return;
        }
        for (XmlTag tag2 : tags = myTag.getSubTags()) {
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag2, IMPORT_TAG_NAME)) {
                String schemaLocation = tag2.getAttributeValue("schemaLocation");
                if (schemaLocation == null) continue;
                XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)myFile, schemaLocation);
                XmlNSDescriptorImpl.addDependency(xmlFile, visited);
                continue;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, REDEFINE_TAG_NAME)) continue;
            RecursionManager.doPreventingRecursion((Object)tag2, (boolean)false, () -> {
                XmlFile file2 = XmlNSDescriptorImpl.getRedefinedElementDescriptorFile(tag2);
                XmlNSDescriptorImpl.addDependency(file2, visited);
                return null;
            });
        }
        String schemaLocationDeclaration = myTag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                PsiFile resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(tokenizer.nextToken(), (PsiFile)myFile, null);
                if (resourceLocation == null) {
                    resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(uri, (PsiFile)myFile, null);
                }
                if (!(resourceLocation instanceof XmlFile)) continue;
                XmlNSDescriptorImpl.addDependency((XmlFile)resourceLocation, visited);
            }
        }
    }

    private static void addDependency(XmlFile file2, Set<PsiFile> visited) {
        if (file2 != null) {
            XmlDocument document = file2.getDocument();
            XmlNSDescriptorImpl.collectDependencies(document != null ? document.getRootTag() : null, file2, visited);
        }
    }

    private static boolean checkSchemaNamespace(@NotNull String name2, @NotNull XmlTag context2) {
        String namespace;
        if (name2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(3);
        }
        if ((namespace = context2.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(name2))).length() > 0) {
            return XmlNSDescriptorImpl.checkSchemaNamespace(namespace);
        }
        return XSD_PREFIX.equals(XmlUtil.findPrefixByQualifiedName(name2));
    }

    public static boolean checkSchemaNamespace(String namespace) {
        return "http://www.w3.org/2001/XMLSchema".equals(namespace) || "http://www.w3.org/1999/XMLSchema".equals(namespace) || "http://www.w3.org/2000/10/XMLSchema".equals(namespace);
    }

    public static boolean checkSchemaNamespace(@NotNull XmlTag context2) {
        if (context2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(context2.isValid());
        String namespace = context2.getNamespace();
        if (namespace.length() > 0) {
            return XmlNSDescriptorImpl.checkSchemaNamespace(namespace);
        }
        return StringUtil.startsWithConcatenation((String)context2.getName(), (String[])new String[]{XSD_PREFIX, ":"});
    }

    @NotNull
    static XmlNSDescriptorImpl getNSDescriptorToSearchIn(XmlTag rootTag, String name2, XmlNSDescriptorImpl defaultNSDescriptor) {
        String namespace;
        XmlNSDescriptor nsDescriptor;
        if (name2 == null) {
            XmlNSDescriptorImpl xmlNSDescriptorImpl = defaultNSDescriptor;
            if (xmlNSDescriptorImpl == null) {
                XmlNSDescriptorImpl.$$$reportNull$$$0(5);
            }
            return xmlNSDescriptorImpl;
        }
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name2);
        if (namespacePrefix.length() > 0 && (nsDescriptor = rootTag.getNSDescriptor(namespace = rootTag.getNamespaceByPrefix(namespacePrefix), true)) instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl xmlNSDescriptorImpl = (XmlNSDescriptorImpl)nsDescriptor;
            if (xmlNSDescriptorImpl == null) {
                XmlNSDescriptorImpl.$$$reportNull$$$0(6);
            }
            return xmlNSDescriptorImpl;
        }
        XmlNSDescriptorImpl xmlNSDescriptorImpl = defaultNSDescriptor;
        if (xmlNSDescriptorImpl == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(7);
        }
        return xmlNSDescriptorImpl;
    }

    @Nullable
    private static XmlElementDescriptor getDescriptorFromParent(XmlTag tag2, XmlElementDescriptor elementDescriptor) {
        XmlElementDescriptor descriptor2;
        PsiElement parent = tag2.getParent();
        if (parent instanceof XmlTag && (descriptor2 = ((XmlTag)parent).getDescriptor()) != null) {
            elementDescriptor = descriptor2.getElementDescriptor(tag2, (XmlTag)parent);
        }
        return elementDescriptor;
    }

    @Override
    public final boolean processTagsInNamespace(String[] tagNames, PsiElementProcessor<? super XmlTag> processor2) {
        return XmlNSDescriptorImpl.processTagsInNamespaceInner(this.myTag, tagNames, processor2, null);
    }

    private static boolean processTagsInNamespaceInner(@NotNull XmlTag rootTag, String[] tagNames, PsiElementProcessor<? super XmlTag> processor2, Set<? super XmlTag> visitedTags) {
        XmlTag[] tags;
        if (rootTag == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(8);
        }
        if (visitedTags == null) {
            visitedTags = new HashSet<XmlTag>(3);
        } else if (visitedTags.contains(rootTag)) {
            return true;
        }
        visitedTags.add((XmlTag)rootTag);
        block0: for (XmlTag tag2 : tags = rootTag.getSubTags()) {
            XmlDocument includedDocument;
            XmlFile xmlFile;
            String schemaLocation;
            for (String tagName : tagNames) {
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, tagName)) continue;
                String name2 = tag2.getAttributeValue("name");
                if (name2 == null || processor2.execute((PsiElement)tag2)) continue block0;
                return false;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, INCLUDE_TAG_NAME) || (schemaLocation = tag2.getAttributeValue("schemaLocation")) == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || XmlNSDescriptorImpl.processTagsInNamespaceInner(includedDocument.getRootTag(), tagNames, processor2, visitedTags)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsToSchemaName(@NotNull XmlTag tag2, @NonNls String schemaName) {
        if (tag2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(9);
        }
        return schemaName.equals(tag2.getLocalName()) && XmlNSDescriptorImpl.checkSchemaNamespace(tag2);
    }

    @Nullable
    private static XmlTag findSpecialTag(@NonNls String name2, @NonNls String specialName, XmlTag rootTag, XmlNSDescriptorImpl descriptor2, HashSet<XmlTag> visited) {
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, name2, descriptor2);
        if (nsDescriptor != descriptor2) {
            XmlDocument document;
            XmlDocument xmlDocument = document = nsDescriptor.getDescriptorFile() != null ? nsDescriptor.getDescriptorFile().getDocument() : null;
            if (document == null) {
                return null;
            }
            return XmlNSDescriptorImpl.findSpecialTag(XmlUtil.findLocalNameByQualifiedName(name2), specialName, document.getRootTag(), nsDescriptor, visited);
        }
        if (visited == null) {
            visited = new HashSet(1);
        } else if (visited.contains(rootTag)) {
            return null;
        }
        visited.add(rootTag);
        XmlTag[] tags = rootTag.getSubTags();
        return XmlNSDescriptorImpl.findSpecialTagIn(tags, specialName, name2, rootTag, descriptor2, visited);
    }

    private static XmlTag findSpecialTagIn(XmlTag[] tags, String specialName, String name2, XmlTag rootTag, XmlNSDescriptorImpl descriptor2, HashSet<XmlTag> visited) {
        for (XmlTag tag2 : tags) {
            XmlTag redefinedRootTag;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, specialName)) {
                String attribute = tag2.getAttributeValue("name");
                if (!name2.equals(attribute) && (!name2.contains(":") || !name2.substring(name2.indexOf(":") + 1).equals(attribute))) continue;
                return tag2;
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag2, IMPORT_TAG_NAME) && rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(name2)).equals(tag2.getAttributeValue("namespace"))) {
                XmlTag rTag;
                XmlDocument document;
                XmlFile xmlFile;
                String schemaLocation = tag2.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (document = xmlFile.getDocument()) == null || (rTag = XmlNSDescriptorImpl.findSpecialTag(name2, specialName, document.getRootTag(), descriptor2, visited)) == null) continue;
                return rTag;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, REDEFINE_TAG_NAME)) continue;
            XmlTag rTag = XmlNSDescriptorImpl.findSpecialTagIn(tag2.getSubTags(), specialName, name2, rootTag, descriptor2, visited);
            if (rTag != null) {
                return rTag;
            }
            XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag2);
            if (nsDescriptor == null || (rTag = XmlNSDescriptorImpl.findSpecialTagIn((redefinedRootTag = ((XmlDocument)nsDescriptor.getDeclaration()).getRootTag()).getSubTags(), specialName, name2, redefinedRootTag, nsDescriptor, visited)) == null) continue;
            return rTag;
        }
        return null;
    }

    public static XmlNSDescriptorImpl getRedefinedElementDescriptor(XmlTag parentTag) {
        XmlFile file2 = XmlNSDescriptorImpl.getRedefinedElementDescriptorFile(parentTag);
        if (file2 != null) {
            PsiMetaData metaData;
            XmlDocument document = file2.getDocument();
            PsiMetaData psiMetaData = metaData = document != null ? document.getMetaData() : null;
            if (metaData instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)metaData;
            }
        }
        return null;
    }

    private static XmlFile getRedefinedElementDescriptorFile(XmlTag parentTag) {
        XmlAttributeValue element2;
        PsiElement psiElement;
        XmlAttribute attribute = parentTag.getAttribute("schemaLocation");
        if (attribute != null && (psiElement = new URLReference((PsiElement)(element2 = attribute.getValueElement())).resolve()) instanceof XmlFile) {
            return (XmlFile)psiElement;
        }
        return null;
    }

    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public String getDefaultNamespace() {
        return this.myTargetNamespace != null ? this.myTargetNamespace : "";
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return this.getElementDescriptor(localName, namespace, new HashSet(), false);
    }

    @Override
    @Nullable
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace, Set<? super XmlNSDescriptorImpl> visited, boolean reference2) {
        XmlElementDescriptor value2;
        if (visited.contains(this)) {
            return null;
        }
        QNameKey pair = new QNameKey(namespace, localName);
        CachedValue<XmlElementDescriptor> descriptor2 = this.myDescriptorsMap.get((Object)pair);
        if (descriptor2 != null && ((value2 = (XmlElementDescriptor)descriptor2.getValue()) == null || value2.getDeclaration().isValid())) {
            return value2;
        }
        XmlTag rootTag = this.myTag;
        if (rootTag == null) {
            return null;
        }
        XmlTag[] tags = rootTag.getSubTags();
        visited.add(this);
        LOG.assertTrue(rootTag.isValid());
        for (XmlTag tag2 : tags) {
            XmlElementDescriptor xmlElementDescriptor;
            XmlNSDescriptorImpl nsDescriptor;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, ELEMENT_TAG_NAME)) {
                String name2 = tag2.getAttributeValue("name");
                if (name2 == null || !this.checkElementNameEquivalence(localName, namespace, name2, tag2)) continue;
                CachedValue cachedValue = CachedValuesManager.getManager((Project)tag2.getProject()).createCachedValue(() -> {
                    String name1 = tag2.getAttributeValue("name");
                    if (name1 != null && !name1.equals(pair.second)) {
                        this.myDescriptorsMap.remove((Object)pair);
                        return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                    XmlElementDescriptor xmlElementDescriptor = this.createElementDescriptor(tag2);
                    return new CachedValueProvider.Result((Object)xmlElementDescriptor, xmlElementDescriptor.getDependencies());
                }, false);
                this.myDescriptorsMap.put(pair, (CachedValue<XmlElementDescriptor>)cachedValue);
                return (XmlElementDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, INCLUDE_TAG_NAME) || reference2 && XmlNSDescriptorImpl.equalsToSchemaName(tag2, IMPORT_TAG_NAME) && (namespace.equals(tag2.getAttributeValue("namespace")) || namespace.length() == 0 && tag2.getAttributeValue("namespace") == null)) {
                XmlElementDescriptor elementDescriptor;
                PsiMetaData data2;
                XmlDocument includedDocument;
                XmlFile xmlFile;
                String schemaLocation = tag2.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || !((data2 = includedDocument.getMetaData()) instanceof XmlNSDescriptorImpl) || (elementDescriptor = ((XmlNSDescriptorImpl)data2).getElementDescriptor(localName, namespace, visited, reference2)) == null) continue;
                return elementDescriptor;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, REDEFINE_TAG_NAME) || (nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag2)) == null || !((xmlElementDescriptor = nsDescriptor.getElementDescriptor(localName, namespace, visited, reference2)) instanceof XmlElementDescriptorImpl)) continue;
            return new RedefinedElementDescriptor((XmlElementDescriptorImpl)xmlElementDescriptor, this, nsDescriptor);
        }
        return null;
    }

    protected XmlElementDescriptor createElementDescriptor(XmlTag tag2) {
        return new XmlElementDescriptorImpl(tag2);
    }

    private boolean checkElementNameEquivalence(String localName, String namespace, String fqn, XmlTag context2) {
        String localAttrName = XmlUtil.findLocalNameByQualifiedName(fqn);
        if (!localAttrName.equals(localName)) {
            return false;
        }
        String attrNamespace = context2.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(fqn));
        if (attrNamespace.equals(namespace)) {
            return true;
        }
        if (this.myTargetNamespace == null) {
            return "".equals(attrNamespace);
        }
        if (this.myTargetNamespace.equals(namespace)) {
            return true;
        }
        return context2.getNSDescriptor(namespace, true) == this;
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttribute(String localName, String namespace, XmlTag context2) {
        return this.getAttributeImpl(localName, namespace, null);
    }

    @Nullable
    private XmlAttributeDescriptor getAttributeImpl(String localName, String namespace, @Nullable Set<XmlTag> visited) {
        XmlTag[] tags;
        if (this.myTag == null) {
            return null;
        }
        XmlNSDescriptor nsDescriptor = this.myTag.getNSDescriptor(namespace, true);
        if (nsDescriptor != this && nsDescriptor instanceof XmlNSDescriptorImpl) {
            return ((XmlNSDescriptorImpl)nsDescriptor).getAttributeImpl(localName, namespace, visited);
        }
        if (visited == null) {
            visited = new HashSet<XmlTag>(1);
        } else if (visited.contains(this.myTag)) {
            return null;
        }
        visited.add(this.myTag);
        for (XmlTag tag2 : tags = this.myTag.getSubTags()) {
            XmlAttributeDescriptor attributeDescriptor;
            PsiMetaData data2;
            XmlDocument includedDocument;
            XmlFile xmlFile;
            String schemaLocation;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, ATTRIBUTE_TAG_NAME)) {
                String name2 = tag2.getAttributeValue("name");
                if (name2 == null || !this.checkElementNameEquivalence(localName, namespace, name2, tag2)) continue;
                return new XmlAttributeDescriptorImpl(tag2);
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, INCLUDE_TAG_NAME) && (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, IMPORT_TAG_NAME) || !namespace.equals(tag2.getAttributeValue("namespace"))) || (schemaLocation = tag2.getAttributeValue("schemaLocation")) == null || (xmlFile = XmlUtil.findNamespace(this.myTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || !((data2 = includedDocument.getMetaData()) instanceof XmlNSDescriptorImpl) || (attributeDescriptor = ((XmlNSDescriptorImpl)data2).getAttributeImpl(localName, namespace, visited)) == null) continue;
            CachedValue value2 = CachedValuesManager.getManager((Project)includedDocument.getProject()).createCachedValue(() -> {
                Object[] deps = attributeDescriptor.getDependencies();
                if (deps.length == 0) {
                    LOG.error(attributeDescriptor + " (" + attributeDescriptor.getClass() + ") returned no dependencies");
                }
                return new CachedValueProvider.Result((Object)attributeDescriptor, deps);
            }, false);
            return (XmlAttributeDescriptor)value2.getValue();
        }
        return null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        String type = descriptorTag.getAttributeValue("type");
        if (type != null) {
            return this.getTypeDescriptor(type, descriptorTag);
        }
        return this.findTypeDescriptorImpl(descriptorTag, null, null);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(@NotNull String name2, XmlTag context2) {
        String localNameByQualifiedName;
        if (name2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (XmlNSDescriptorImpl.checkSchemaNamespace(name2, context2) && STD_TYPES.contains(localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(name2)) && (name2.length() == localNameByQualifiedName.length() || UNDECLARED_STD_TYPES.contains(localNameByQualifiedName))) {
            return new StdTypeDescriptor(localNameByQualifiedName);
        }
        return this.findTypeDescriptor(name2, context2);
    }

    @Nullable
    public XmlElementDescriptor getDescriptorByType(String qName, XmlTag instanceTag) {
        if (this.myTag == null) {
            return null;
        }
        TypeDescriptor typeDescriptor = this.findTypeDescriptor(qName, instanceTag);
        if (!(typeDescriptor instanceof ComplexTypeDescriptor)) {
            return null;
        }
        return new XmlElementDescriptorByType(instanceTag, (ComplexTypeDescriptor)typeDescriptor);
    }

    @Nullable
    protected TypeDescriptor findTypeDescriptor(String qname) {
        return this.findTypeDescriptor(qname, this.myTag);
    }

    @Nullable
    private TypeDescriptor findTypeDescriptor(String qname, @NotNull XmlTag context2) {
        if (context2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(11);
        }
        String namespace = context2.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(qname));
        String localName = XmlUtil.findLocalNameByQualifiedName(qname);
        return this.findTypeDescriptorImpl(this.myTag, localName, namespace.isEmpty() ? this.getDefaultNamespace() : namespace);
    }

    @Override
    @Nullable
    public TypeDescriptor findTypeDescriptor(String localName, String namespace) {
        return this.findTypeDescriptorImpl(this.myTag, localName, namespace);
    }

    @Nullable
    private TypeDescriptor findTypeDescriptorImpl(@Nullable XmlTag rootTag, String name2, String namespace) {
        if (rootTag == null) {
            return null;
        }
        return (TypeDescriptor)RecursionManager.doPreventingRecursion((Object)Trinity.create((Object)rootTag, (Object)name2, (Object)namespace), (boolean)true, () -> {
            TypeDescriptor value2;
            XmlNSDescriptor nsDescriptor;
            XmlNSDescriptorImpl responsibleDescriptor = this;
            if (namespace != null && namespace.length() != 0 && !namespace.equals(this.getDefaultNamespace()) && (nsDescriptor = rootTag.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
                responsibleDescriptor = (XmlNSDescriptorImpl)nsDescriptor;
            }
            if (responsibleDescriptor != this) {
                return responsibleDescriptor.findTypeDescriptor(name2, namespace);
            }
            Pair pair = Pair.create((Object)((Object)new QNameKey(name2, namespace)), (Object)rootTag);
            CachedValue<TypeDescriptor> descriptor2 = this.myTypesMap.get(pair);
            if (descriptor2 != null && ((value2 = (TypeDescriptor)descriptor2.getValue()) == null || value2 instanceof ComplexTypeDescriptor && ((ComplexTypeDescriptor)value2).getDeclaration().isValid())) {
                return value2;
            }
            XmlTag[] tags = rootTag.getSubTags();
            return this.doFindIn(tags, name2, namespace, (Pair<QNameKey, XmlTag>)pair, rootTag);
        });
    }

    private TypeDescriptor doFindIn(XmlTag[] tags, String name2, String namespace, Pair<QNameKey, XmlTag> pair, XmlTag rootTag) {
        for (XmlTag tag2 : tags) {
            CachedValue<TypeDescriptor> cachedValue;
            String nameAttribute;
            CachedValue<TypeDescriptor> value2;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, COMPLEX_TYPE_TAG_NAME)) {
                if (name2 == null) {
                    value2 = this.createAndPutTypesCachedValue(tag2, pair);
                    return (TypeDescriptor)value2.getValue();
                }
                nameAttribute = tag2.getAttributeValue("name");
                if (!this.isSameName(name2, namespace, nameAttribute)) continue;
                cachedValue = this.createAndPutTypesCachedValue(tag2, pair);
                return (TypeDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, "simpleType")) {
                if (name2 == null) {
                    value2 = this.createAndPutTypesCachedValueSimpleType(tag2, pair);
                    return (TypeDescriptor)value2.getValue();
                }
                nameAttribute = tag2.getAttributeValue("name");
                if (!this.isSameName(name2, namespace, nameAttribute)) continue;
                cachedValue = this.createAndPutTypesCachedValue(tag2, pair);
                return (TypeDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag2, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag2, IMPORT_TAG_NAME) && (namespace == null || !namespace.equals(this.getDefaultNamespace()))) {
                CachedValue value3;
                TypeDescriptor type;
                XmlDocument document;
                XmlFile xmlFile;
                String schemaLocation = tag2.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (document = xmlFile.getDocument()) == null || (type = (TypeDescriptor)(value3 = CachedValuesManager.getManager((Project)tag2.getProject()).createCachedValue(() -> {
                    String currentName = tag2.getAttributeValue("name");
                    if (currentName != null && !currentName.equals(XmlUtil.findLocalNameByQualifiedName(name2)) || !xmlFile.isValid() || xmlFile.getDocument() == null) {
                        this.myTypesMap.remove(pair);
                        return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                    XmlDocument document1 = xmlFile.getDocument();
                    XmlNSDescriptorImpl nsDescriptor = this.findNSDescriptor(tag2, document1);
                    if (nsDescriptor == null) {
                        this.myTypesMap.remove(pair);
                        return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                    XmlTag rTag = document1.getRootTag();
                    TypeDescriptor complexTypeDescriptor = nsDescriptor.findTypeDescriptorImpl(rTag, name2, namespace);
                    return new CachedValueProvider.Result((Object)complexTypeDescriptor, new Object[]{rTag});
                }, false)).getValue()) == null) continue;
                this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value3);
                return type;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, REDEFINE_TAG_NAME)) continue;
            XmlTag[] subTags = tag2.getSubTags();
            TypeDescriptor descriptor2 = this.doFindIn(subTags, name2, namespace, pair, rootTag);
            if (descriptor2 != null) {
                return descriptor2;
            }
            XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag2);
            if (nsDescriptor == null) continue;
            XmlTag redefinedRootTag = ((XmlDocument)nsDescriptor.getDeclaration()).getRootTag();
            descriptor2 = this.doFindIn(redefinedRootTag.getSubTags(), name2, namespace, pair, redefinedRootTag);
            if (descriptor2 instanceof ComplexTypeDescriptor) {
                TypeDescriptor finalDescriptor = descriptor2;
                CachedValue value4 = CachedValuesManager.getManager((Project)tag2.getProject()).createCachedValue(() -> {
                    RedefinedTypeDescriptor typeDescriptor = new RedefinedTypeDescriptor((ComplexTypeDescriptor)finalDescriptor, this, nsDescriptor);
                    return CachedValueProvider.Result.create((Object)typeDescriptor, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                });
                this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value4);
                return (TypeDescriptor)value4.getValue();
            }
            if (descriptor2 == null) continue;
            return descriptor2;
        }
        return null;
    }

    private boolean isSameName(@NotNull String name2, String namespace, String nameAttribute) {
        if (name2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(12);
        }
        return nameAttribute != null && (nameAttribute.equals(name2) || name2.contains(":") && nameAttribute.equals(name2.substring(name2.indexOf(":") + 1))) && (namespace == null || namespace.length() == 0 || namespace.equals(this.getDefaultNamespace()));
    }

    private XmlNSDescriptorImpl findNSDescriptor(XmlTag tag2, XmlDocument document) {
        XmlNSDescriptor importedDescriptor;
        XmlNSDescriptorImpl nsDescriptor = IMPORT_TAG_NAME.equals(tag2.getLocalName()) ? ((importedDescriptor = (XmlNSDescriptor)document.getMetaData()) instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)importedDescriptor : this) : this;
        return nsDescriptor;
    }

    private CachedValue<TypeDescriptor> createAndPutTypesCachedValueSimpleType(XmlTag tag2, Pair<QNameKey, XmlTag> pair) {
        CachedValue value2 = CachedValuesManager.getManager((Project)tag2.getProject()).createCachedValue(() -> {
            SimpleTypeDescriptor simpleTypeDescriptor = new SimpleTypeDescriptor(tag2);
            return new CachedValueProvider.Result((Object)simpleTypeDescriptor, new Object[]{tag2});
        }, false);
        this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value2);
        return value2;
    }

    private CachedValue<TypeDescriptor> createAndPutTypesCachedValue(XmlTag tag2, Pair<QNameKey, XmlTag> pair) {
        CachedValue value2 = CachedValuesManager.getManager((Project)tag2.getProject()).createCachedValue(() -> {
            String name2 = tag2.getAttributeValue("name");
            if (name2 != null && pair.first != null && ((QNameKey)((Object)((Object)pair.first))).first != null && !name2.equals(XmlUtil.findLocalNameByQualifiedName((String)((QNameKey)((Object)((Object)pair.first))).first))) {
                this.myTypesMap.remove(pair);
                return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            ComplexTypeDescriptor complexTypeDescriptor = new ComplexTypeDescriptor(this, tag2);
            return new CachedValueProvider.Result((Object)complexTypeDescriptor, new Object[]{tag2});
        }, false);
        this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value2);
        return value2;
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(13);
        }
        PsiElement parent = tag2.getParent();
        String namespace = tag2.getNamespace();
        while (parent instanceof XmlTag && !namespace.equals(((XmlTag)parent).getNamespace())) {
            parent = parent.getContext();
        }
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null) {
                XmlElementDescriptor elementDescriptor;
                XmlElementDescriptor elementDescriptorFromParent = parentDescriptor.getElementDescriptor(tag2, parentTag);
                if (elementDescriptorFromParent == null) {
                    elementDescriptorFromParent = XmlNSDescriptorImpl.getDescriptorFromParent(tag2, null);
                }
                if (elementDescriptorFromParent instanceof AnyXmlElementDescriptor && (elementDescriptor = this.getElementDescriptor(tag2.getLocalName(), namespace)) != null) {
                    return elementDescriptor;
                }
                return elementDescriptorFromParent;
            }
            return null;
        }
        XmlElementDescriptor elementDescriptor = this.getElementDescriptor(tag2.getLocalName(), tag2.getNamespace());
        if (elementDescriptor == null) {
            elementDescriptor = XmlNSDescriptorImpl.getDescriptorFromParent(tag2, null);
        }
        return elementDescriptor;
    }

    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        class CollectElementsProcessor
        implements PsiElementProcessor<XmlTag> {
            final List<XmlElementDescriptor> result = new ArrayList<XmlElementDescriptor>();

            CollectElementsProcessor() {
            }

            public boolean execute(@NotNull XmlTag element2) {
                if (element2 == null) {
                    CollectElementsProcessor.$$$reportNull$$$0(0);
                }
                ContainerUtil.addIfNotNull(this.result, (Object)XmlNSDescriptorImpl.this.getElementDescriptor(element2.getAttributeValue("name"), XmlNSDescriptorImpl.this.getDefaultNamespace()));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XmlNSDescriptorImpl.ELEMENT_TAG_NAME, "com/intellij/xml/impl/schema/XmlNSDescriptorImpl$1CollectElementsProcessor", "execute"));
            }
        }
        CollectElementsProcessor processor2 = new CollectElementsProcessor(){
            {
            }

            @Override
            public boolean execute(@NotNull XmlTag element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!XmlElementDescriptorImpl.isAbstractDeclaration(element2).booleanValue()) {
                    return super.execute(element2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XmlNSDescriptorImpl.ELEMENT_TAG_NAME, "com/intellij/xml/impl/schema/XmlNSDescriptorImpl$1", "execute"));
            }
        };
        this.processTagsInNamespace(new String[]{ELEMENT_TAG_NAME}, processor2);
        XmlElementDescriptor[] xmlElementDescriptorArray = processor2.result.toArray(XmlElementDescriptor.EMPTY_ARRAY);
        if (xmlElementDescriptorArray == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(14);
        }
        return xmlElementDescriptorArray;
    }

    public XmlAttributeDescriptor[] getRootAttributeDescriptors(XmlTag context2) {
        if (this.myTag == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        return ((List)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myTag, XmlNSDescriptorImpl::computeAttributeDescriptors)).toArray(XmlAttributeDescriptor.EMPTY);
    }

    private static List<XmlAttributeDescriptor> computeAttributeDescriptors(XmlTag tag2) {
        ArrayList<XmlAttributeDescriptor> result2 = new ArrayList<XmlAttributeDescriptor>();
        XmlNSDescriptorImpl.processTagsInNamespaceInner(tag2, new String[]{ATTRIBUTE_TAG_NAME}, (PsiElementProcessor<? super XmlTag>)((PsiElementProcessor)element2 -> result2.add(new XmlAttributeDescriptorImpl((XmlTag)element2))), null);
        return result2;
    }

    @Override
    @Nullable
    public XmlTag findGroup(String name2) {
        return XmlNSDescriptorImpl.findSpecialTag(name2, "group", this.myTag, this, null);
    }

    @Override
    @Nullable
    public XmlTag findAttributeGroup(String name2) {
        return XmlNSDescriptorImpl.findSpecialTag(name2, "attributeGroup", this.myTag, this, null);
    }

    public synchronized XmlElementDescriptor[] getSubstitutes(String localName, String namespace) {
        if (!this.initSubstitutes()) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        Collection substitutions = this.mySubstitutions.get((Object)localName);
        if (substitutions.isEmpty()) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (XmlTag tag2 : substitutions) {
            String substAttr = tag2.getAttributeValue("substitutionGroup");
            if (substAttr == null || !this.checkElementNameEquivalence(localName, namespace, substAttr, tag2)) continue;
            result2.add(this.createElementDescriptor(tag2));
        }
        return result2.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    private boolean initSubstitutes() {
        if (this.mySubstitutions == null && this.myTag != null) {
            XmlTag[] tags;
            this.mySubstitutions = new MultiMap();
            if (this.myTag == null) {
                return false;
            }
            for (XmlTag tag2 : tags = this.myTag.getSubTags()) {
                String substAttr;
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag2, ELEMENT_TAG_NAME) || (substAttr = tag2.getAttributeValue("substitutionGroup")) == null) continue;
                String substLocalName = XmlUtil.findLocalNameByQualifiedName(substAttr);
                this.mySubstitutions.putValue((Object)substLocalName, (Object)tag2);
            }
        }
        return this.mySubstitutions != null;
    }

    public PsiElement getDeclaration() {
        return this.myFile.getDocument();
    }

    public String getName(PsiElement context2) {
        return this.getName();
    }

    public String getName() {
        return "";
    }

    public void init(PsiElement element2) {
        this.myFile = (XmlFile)element2.getContainingFile();
        if (element2 instanceof XmlTag) {
            this.myTag = (XmlTag)element2;
        } else {
            XmlDocument document = this.myFile.getDocument();
            if (document != null) {
                this.myTag = document.getRootTag();
            }
        }
        if (this.myTag != null) {
            this.myTargetNamespace = this.myTag.getAttributeValue("targetNamespace");
        }
        HashSet<PsiFile> dependenciesSet = new HashSet<PsiFile>();
        XmlNSDescriptorImpl.collectDependencies(this.myTag, this.myFile, dependenciesSet);
        this.dependencies = ArrayUtil.toObjectArray(dependenciesSet);
    }

    public Object @NotNull [] getDependencies() {
        if (this.dependencies == null) {
            Object[] objectArray;
            if (this.myFile == null) {
                objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.myFile;
            }
            this.dependencies = objectArray;
        }
        if (this.dependencies == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(15);
        }
        return this.dependencies;
    }

    @Override
    public void validate(@NotNull XmlDocument context2, @NotNull Validator.ValidationHost host) {
        if (context2 == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(16);
        }
        if (host == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(17);
        }
        ExternalDocumentValidator.doValidation(context2, host);
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public synchronized boolean hasSubstitutions() {
        this.initSubstitutes();
        return this.mySubstitutions != null && this.mySubstitutions.size() > 0;
    }

    public boolean isValid() {
        return this.myFile != null && this.getDeclaration().isValid();
    }

    static {
        STD_TYPES.add("string");
        STD_TYPES.add("normalizedString");
        STD_TYPES.add("token");
        STD_TYPES.add("byte");
        STD_TYPES.add("unsignedByte");
        STD_TYPES.add("base64Binary");
        STD_TYPES.add("hexBinary");
        STD_TYPES.add("integer");
        STD_TYPES.add("positiveInteger");
        STD_TYPES.add("negativeInteger");
        STD_TYPES.add("nonNegativeInteger");
        STD_TYPES.add("nonPositiveInteger");
        STD_TYPES.add("int");
        STD_TYPES.add("unsignedInt");
        STD_TYPES.add("long");
        STD_TYPES.add("unsignedLong");
        STD_TYPES.add("short");
        STD_TYPES.add("unsignedShort");
        STD_TYPES.add("decimal");
        STD_TYPES.add("float");
        STD_TYPES.add("double");
        STD_TYPES.add("boolean");
        STD_TYPES.add("time");
        STD_TYPES.add("dateTime");
        STD_TYPES.add("duration");
        STD_TYPES.add("date");
        STD_TYPES.add("gMonth");
        STD_TYPES.add("gYear");
        STD_TYPES.add("gYearMonth");
        STD_TYPES.add("gDay");
        STD_TYPES.add("gMonthDay");
        STD_TYPES.add("Name");
        STD_TYPES.add("QName");
        STD_TYPES.add("NCName");
        STD_TYPES.add("anyURI");
        STD_TYPES.add("language");
        STD_TYPES.add("ID");
        STD_TYPES.add("IDREF");
        STD_TYPES.add("IDREFS");
        STD_TYPES.add("ENTITY");
        STD_TYPES.add("ENTITIES");
        STD_TYPES.add("NOTATION");
        STD_TYPES.add("NMTOKEN");
        STD_TYPES.add("NMTOKENS");
        STD_TYPES.add("anySimpleType");
        UNDECLARED_STD_TYPES.add("anySimpleType");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/schema/XmlNSDescriptorImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/schema/XmlNSDescriptorImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNSDescriptorToSearchIn";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkSchemaNamespace";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTagsInNamespaceInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsToSchemaName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTypeDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSameName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class QNameKey
    extends Pair<String, String> {
        QNameKey(String name2, String namespace) {
            super((Object)name2, (Object)namespace);
        }
    }
}

