/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.index.SchemaTypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLValidator;
import org.jetbrains.annotations.NotNull;

public final class XsdComplexTypeInfoBuilder
implements NanoXmlBuilder {
    private static final String SIGN = "";
    public static final String HTTP_WWW_W3_ORG_2001_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final MultiMap<SchemaTypeInfo, SchemaTypeInfo> myMap = new MultiMap();
    private NameSpaceHelper myNameSpaceHelper;
    private String myCurrentElementName;
    private String myCurrentComplexTypeName;
    private String myCurrentSimpleTypeName;
    private boolean myInsideSchema;
    private boolean myInsideRestriction;
    private boolean myInsideExtension;
    private boolean myInsideContent;

    public void setNameSpaceHelper(NameSpaceHelper nameSpaceHelper) {
        this.myNameSpaceHelper = nameSpaceHelper;
    }

    public static MultiMap<SchemaTypeInfo, SchemaTypeInfo> parse(InputStream is) {
        return XsdComplexTypeInfoBuilder.parse(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiMap<SchemaTypeInfo, SchemaTypeInfo> parse(@NotNull Reader reader) {
        if (reader == null) {
            XsdComplexTypeInfoBuilder.$$$reportNull$$$0(0);
        }
        try {
            XsdComplexTypeInfoBuilder builder2 = new XsdComplexTypeInfoBuilder();
            NameSpaceHelper helper2 = new NameSpaceHelper();
            builder2.setNameSpaceHelper(helper2);
            NanoXmlUtil.parse(reader, (IXMLBuilder)builder2, (IXMLValidator)helper2);
            MultiMap<SchemaTypeInfo, SchemaTypeInfo> multiMap = builder2.getMap();
            return multiMap;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private XsdComplexTypeInfoBuilder() {
    }

    public MultiMap<SchemaTypeInfo, SchemaTypeInfo> getMap() {
        return this.myMap;
    }

    @Override
    public void startElement(String name2, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        if (!HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        this.myInsideSchema = false;
        if ("schema".equals(name2)) {
            this.myInsideSchema = true;
        } else if ("complexType".equals(name2)) {
            this.myCurrentComplexTypeName = SIGN;
        } else if ("simpleType".equals(name2)) {
            this.myCurrentSimpleTypeName = SIGN;
        } else if ("element".equals(name2)) {
            this.myCurrentElementName = SIGN;
        } else if ("restriction".equals(name2)) {
            this.myInsideRestriction = true;
        } else if ("extension".equals(name2)) {
            this.myInsideExtension = true;
        } else if ("simpleContent".equals(name2) || "complexContent".equals(name2)) {
            this.myInsideContent = true;
        }
    }

    @Override
    public void endElement(String name2, String nsPrefix, String nsURI) throws Exception {
        if (!HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        if ("schema".equals(name2)) {
            this.myInsideSchema = false;
        } else if ("complexType".equals(name2)) {
            this.myCurrentComplexTypeName = null;
        } else if ("simpleType".equals(name2)) {
            this.myCurrentSimpleTypeName = null;
        } else if ("element".equals(name2)) {
            this.myCurrentElementName = null;
        } else if ("restriction".equals(name2)) {
            this.myInsideRestriction = false;
        } else if ("extension".equals(name2)) {
            this.myInsideExtension = false;
        } else if ("simpleContent".equals(name2) || "complexContent".equals(name2)) {
            this.myInsideContent = false;
        }
    }

    @Override
    public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) throws Exception {
        if (!StringUtil.isEmptyOrSpaces((String)nsURI) && !HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        if ("base".equals(key)) {
            if (this.myCurrentComplexTypeName != null && this.myInsideContent && (this.myInsideExtension || this.myInsideRestriction)) {
                this.putTypeDataToMap(value2, this.myCurrentComplexTypeName);
            } else if (this.myCurrentSimpleTypeName != null && this.myInsideRestriction) {
                this.putTypeDataToMap(value2, this.myCurrentSimpleTypeName);
            }
        } else if (!this.myInsideSchema && ("name".equals(key) || "ref".equals(key))) {
            if (SIGN.equals(this.myCurrentElementName) && !this.myInsideContent && !this.myInsideExtension && !this.myInsideRestriction && this.myCurrentComplexTypeName == null && this.myCurrentSimpleTypeName == null) {
                this.myCurrentElementName = value2;
            } else if (SIGN.equals(this.myCurrentComplexTypeName) && !this.myInsideContent && !this.myInsideExtension && !this.myInsideRestriction && this.myCurrentSimpleTypeName == null) {
                this.myCurrentComplexTypeName = value2;
            } else if (SIGN.equals(this.myCurrentSimpleTypeName) && !this.myInsideContent && !this.myInsideExtension && !this.myInsideRestriction && this.myCurrentComplexTypeName == null) {
                this.myCurrentSimpleTypeName = value2;
            }
        }
    }

    private void putTypeDataToMap(String value2, String typeName) {
        boolean isAnonymous = SIGN.equals(typeName);
        if (isAnonymous && this.myCurrentElementName != null) {
            this.myMap.putValue((Object)this.createSchemaTypeInfo(value2, true), (Object)this.createSchemaTypeInfo(this.myCurrentElementName, false));
        } else {
            this.myMap.putValue((Object)this.createSchemaTypeInfo(value2, true), (Object)this.createSchemaTypeInfo(typeName, true));
        }
    }

    private SchemaTypeInfo createSchemaTypeInfo(String value2, boolean isType) {
        int separatorIdx = value2.indexOf(58);
        String ns = separatorIdx <= 0 ? SIGN : value2.substring(0, separatorIdx);
        String element2 = separatorIdx <= 0 ? value2 : value2.substring(separatorIdx + 1);
        String nsUri = this.myNameSpaceHelper.getNamespaces().get(ns);
        nsUri = nsUri == null ? ns : nsUri;
        return new SchemaTypeInfo(element2, isType, nsUri);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/xml/index/XsdComplexTypeInfoBuilder", "parse"));
    }

    private static final class NameSpaceHelper
    extends NanoXmlUtil.EmptyValidator {
        public static final String XMLNS = "xmlns";
        public static final String XMLNS_ = "xmlns:";
        private boolean myInSchema;
        private final Map<String, String> myNamespaces = new HashMap<String, String>();

        private NameSpaceHelper() {
        }

        @Override
        public void attributeAdded(String key, String value2, String systemId2, int lineNr) {
            super.attributeAdded(key, value2, systemId2, lineNr);
            if (this.myInSchema && key.startsWith(XMLNS)) {
                if (key.length() == XMLNS.length()) {
                    this.myNamespaces.put(XsdComplexTypeInfoBuilder.SIGN, value2);
                } else if (key.startsWith(XMLNS_)) {
                    String prefix = key.substring(XMLNS_.length());
                    this.myNamespaces.put(prefix, value2);
                }
            }
        }

        @Override
        public void elementStarted(String name2, String systemId2, int lineNr) {
            super.elementStarted(name2, systemId2, lineNr);
            this.myInSchema = "schema".equals(name2) || name2.endsWith(":schema");
        }

        public Map<String, String> getNamespaces() {
            return this.myNamespaces;
        }
    }
}

