/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class AddDtdDeclarationFix
implements LocalQuickFix {
    @PropertyKey(resourceBundle="messages.XmlBundle")
    private final @PropertyKey(resourceBundle="messages.XmlBundle") String myMessageKey;
    private final String myElementDeclarationName;
    private final String myReference;

    public AddDtdDeclarationFix(@PropertyKey(resourceBundle="messages.XmlAnalysisBundle") @PropertyKey(resourceBundle="messages.XmlAnalysisBundle") String messageKey, @NotNull String elementDeclarationName, @NotNull PsiReference reference2) {
        if (elementDeclarationName == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(0);
        }
        if (reference2 == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(1);
        }
        this.myMessageKey = messageKey;
        this.myElementDeclarationName = elementDeclarationName;
        this.myReference = reference2.getCanonicalText();
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlAnalysisBundle.message((String)this.myMessageKey, (Object[])new Object[]{this.myReference});
        if (string == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(4);
        }
        PsiElement element2 = descriptor2.getPsiElement();
        PsiFile containingFile = element2.getContainingFile();
        @NonNls Object prefixToInsert = "";
        @NonNls Object suffixToInsert = "";
        int UNDEFINED_OFFSET = -1;
        int anchorOffset = -1;
        PsiElement anchor2 = PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{XmlElementDecl.class, XmlAttlistDecl.class, XmlEntityDecl.class, XmlConditionalSection.class});
        if (anchor2 != null) {
            anchorOffset = anchor2.getTextRange().getStartOffset();
        }
        if (anchorOffset == -1 && containingFile.getLanguage() == XMLLanguage.INSTANCE) {
            XmlFile file2 = (XmlFile)containingFile;
            XmlProlog prolog = file2.getDocument().getProlog();
            assert (prolog != null);
            XmlDoctype doctype = prolog.getDoctype();
            XmlMarkupDecl markupDecl = doctype != null ? doctype.getMarkupDecl() : null;
            if (doctype == null) {
                XmlTag rootTag = file2.getDocument().getRootTag();
                prefixToInsert = "<!DOCTYPE " + (rootTag != null ? rootTag.getName() : "null");
                suffixToInsert = ">\n";
            }
            if (markupDecl == null) {
                prefixToInsert = (String)prefixToInsert + " [\n";
                suffixToInsert = "]" + (String)suffixToInsert;
                anchorOffset = doctype != null ? doctype.getTextRange().getEndOffset() - 1 : prolog.getTextRange().getEndOffset();
            }
        }
        if (anchorOffset == -1) {
            anchorOffset = element2.getTextRange().getStartOffset();
        }
        OpenFileDescriptor openDescriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile(), anchorOffset);
        Editor editor2 = FileEditorManager.getInstance((Project)project).openTextEditor(openDescriptor, true);
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template t = templateManager.createTemplate("", "");
        if (!((String)prefixToInsert).isEmpty()) {
            t.addTextSegment((String)prefixToInsert);
        }
        t.addTextSegment("<!" + this.myElementDeclarationName + " " + this.myReference + " ");
        t.addEndVariable();
        t.addTextSegment(">\n");
        if (!((String)suffixToInsert).isEmpty()) {
            t.addTextSegment((String)suffixToInsert);
        }
        templateManager.startTemplate(editor2, t);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDeclarationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/AddDtdDeclarationFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/AddDtdDeclarationFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

