/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlEnumeratedType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.xml.util.InclusionProvider;
import com.intellij.xml.util.XmlIncludeHandler;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlPsiUtil {
    private static final Key<CachedValue<PsiElement>> PARSED_DECL_KEY = Key.create((String)"PARSED_DECL_KEY");
    @NonNls
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";

    public static boolean processXmlElements(XmlElement element2, PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag) {
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag, false);
    }

    public static boolean processXmlElements(XmlElement element2, PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag, boolean wideFlag) {
        if (element2 == null) {
            return true;
        }
        PsiFile baseFile = element2.isValid() ? element2.getContainingFile() : null;
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag, wideFlag, baseFile);
    }

    public static boolean processXmlElements(XmlElement element2, PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag, boolean wideFlag, PsiFile baseFile) {
        return XmlPsiUtil.processXmlElements(element2, processor2, deepFlag, wideFlag, baseFile, true);
    }

    public static boolean processXmlElements(XmlElement element2, PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag, boolean wideFlag, PsiFile baseFile, boolean processIncludes) {
        return new XmlElementProcessor(baseFile, processor2).processXmlElements((PsiElement)element2, deepFlag, wideFlag, processIncludes);
    }

    public static boolean processXmlElementChildren(XmlElement element2, PsiElementProcessor<? super PsiElement> processor2, boolean deepFlag) {
        XmlElementProcessor p = new XmlElementProcessor(element2.getContainingFile(), processor2);
        for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (p.processElement(child2, deepFlag, false, true)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static XmlElement findElement(@NotNull XmlElement parent, final @NotNull IElementType.Predicate predicate2) {
        if (parent == null) {
            XmlPsiUtil.$$$reportNull$$$0(0);
        }
        if (predicate2 == null) {
            XmlPsiUtil.$$$reportNull$$$0(1);
        }
        final Ref result2 = new Ref();
        parent.processElements((PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof XmlElement && predicate2.matches(element2.getNode().getElementType())) {
                    result2.set((Object)((XmlElement)element2));
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlPsiUtil$1", "execute"));
            }
        }, (PsiElement)parent);
        return (XmlElement)result2.get();
    }

    private static PsiElement parseEntityRef(PsiFile targetFile, XmlEntityRef ref) {
        PsiElement element2;
        XmlEntityDecl entityDecl;
        XmlEntityDecl.EntityContextType type = XmlPsiUtil.getContextType(ref);
        XmlEntityDecl entityDecl2 = ref.resolve(targetFile);
        if (entityDecl2 != null) {
            return XmlPsiUtil.parseEntityDecl(entityDecl2, targetFile, type, ref);
        }
        XmlEntityRef e = ref;
        while (e != null) {
            if (e.getUserData(XmlElement.INCLUDING_ELEMENT) != null) {
                PsiFile f = (e = (PsiElement)e.getUserData(XmlElement.INCLUDING_ELEMENT)).getContainingFile();
                if (f == null || (entityDecl = ref.resolve(targetFile)) == null) continue;
                return XmlPsiUtil.parseEntityDecl(entityDecl, targetFile, type, ref);
            }
            if (e instanceof PsiFile) {
                PsiFile refFile = (PsiFile)e;
                entityDecl = ref.resolve(refFile);
                if (entityDecl == null) break;
                return XmlPsiUtil.parseEntityDecl(entityDecl, targetFile, type, ref);
            }
            e = e.getParent();
        }
        if ((element2 = (PsiElement)ref.getUserData(XmlElement.DEPENDING_ELEMENT)) instanceof XmlFile && (entityDecl = ref.resolve((PsiFile)element2)) != null) {
            return XmlPsiUtil.parseEntityDecl(entityDecl, targetFile, type, ref);
        }
        return null;
    }

    private static XmlEntityDecl.EntityContextType getContextType(XmlEntityRef ref) {
        XmlEntityDecl.EntityContextType type = XmlEntityDecl.EntityContextType.GENERIC_XML;
        for (XmlEntityRef temp = ref; temp != null; temp = temp.getContext()) {
            if (temp instanceof XmlAttributeDecl) {
                type = XmlEntityDecl.EntityContextType.ATTRIBUTE_SPEC;
                break;
            }
            if (temp instanceof XmlElementDecl) {
                type = XmlEntityDecl.EntityContextType.ELEMENT_CONTENT_SPEC;
                break;
            }
            if (temp instanceof XmlAttlistDecl) {
                type = XmlEntityDecl.EntityContextType.ATTLIST_SPEC;
                break;
            }
            if (temp instanceof XmlEntityDecl) {
                type = XmlEntityDecl.EntityContextType.ENTITY_DECL_CONTENT;
                break;
            }
            if (temp instanceof XmlEnumeratedType) {
                type = XmlEntityDecl.EntityContextType.ENUMERATED_TYPE;
                break;
            }
            if (!(temp instanceof XmlAttributeValue)) continue;
            type = XmlEntityDecl.EntityContextType.ATTR_VALUE;
            break;
        }
        return type;
    }

    private static PsiElement parseEntityDecl(XmlEntityDecl entityDecl, PsiFile targetFile, XmlEntityDecl.EntityContextType type, XmlEntityRef entityRef) {
        CachedValue value2 = (CachedValue)entityRef.getUserData(PARSED_DECL_KEY);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)entityDecl.getProject()).createCachedValue(() -> {
                PsiElement res2 = entityDecl.parse(targetFile, type, entityRef);
                if (res2 == null) {
                    return new CachedValueProvider.Result(null, new Object[]{targetFile});
                }
                if (!entityDecl.isInternalReference()) {
                    XmlEntityCache.copyEntityCaches(res2.getContainingFile(), targetFile);
                }
                return new CachedValueProvider.Result((Object)res2, new Object[]{res2.getUserData(XmlElement.DEPENDING_ELEMENT), entityDecl, targetFile, entityRef});
            }, false);
            value2 = (CachedValue)((XmlEntityRefImpl)entityRef).putUserDataIfAbsent(PARSED_DECL_KEY, value2);
        }
        return (PsiElement)value2.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "predicate";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/util/XmlPsiUtil";
        objectArray[2] = "findElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class XmlElementProcessor {
        private final PsiElementProcessor<? super PsiElement> processor;
        private final PsiFile targetFile;
        private final Set<String> visitedEntities;

        XmlElementProcessor(PsiFile _targetFile, @NotNull PsiElementProcessor<? super PsiElement> _processor) {
            if (_processor == null) {
                XmlElementProcessor.$$$reportNull$$$0(0);
            }
            this.visitedEntities = new HashSet<String>();
            this.processor = _processor;
            this.targetFile = _targetFile;
        }

        private boolean processXmlElements(PsiElement element2, boolean deepFlag, boolean wideFlag, boolean processIncludes) {
            if (deepFlag && !this.processor.execute(element2)) {
                return false;
            }
            PsiElement startFrom = element2.getFirstChild();
            if (element2 instanceof XmlEntityRef) {
                XmlEntityRef ref = (XmlEntityRef)element2;
                if (!this.visitedEntities.add(ref.getText())) {
                    return true;
                }
                for (PsiElement newElement = XmlPsiUtil.parseEntityRef(this.targetFile, ref); newElement != null; newElement = newElement.getNextSibling()) {
                    if (this.processElement(newElement, deepFlag, wideFlag, processIncludes)) continue;
                    return false;
                }
                return true;
            }
            if (element2 instanceof XmlConditionalSection) {
                XmlConditionalSection xmlConditionalSection = (XmlConditionalSection)element2;
                if (!xmlConditionalSection.isIncluded(this.targetFile)) {
                    return true;
                }
                startFrom = xmlConditionalSection.getBodyStart();
            } else if (processIncludes && XmlIncludeHandler.isXInclude(element2)) {
                PsiElement[] tags;
                if (IdempotenceChecker.isLoggingEnabled()) {
                    IdempotenceChecker.logTrace("Processing xinclude " + element2.getText());
                }
                for (PsiElement psiElement : tags = InclusionProvider.getIncludedTags((XmlTag)element2)) {
                    if (IdempotenceChecker.isLoggingEnabled()) {
                        IdempotenceChecker.logTrace("Processing included tag " + psiElement);
                    }
                    if (this.processElement(psiElement, deepFlag, wideFlag, true)) continue;
                    return false;
                }
            }
            for (PsiElement child2 = startFrom; child2 != null; child2 = child2.getNextSibling()) {
                if (this.processElement(child2, deepFlag, wideFlag, processIncludes) || wideFlag) continue;
                return false;
            }
            return true;
        }

        private boolean processElement(PsiElement child2, boolean deepFlag, boolean wideFlag, boolean processIncludes) {
            if (deepFlag ? !this.processXmlElements(child2, true, wideFlag, processIncludes) : (child2 instanceof XmlEntityRef ? !this.processXmlElements(child2, false, wideFlag, processIncludes) : (child2 instanceof XmlConditionalSection ? !this.processXmlElements(child2, false, wideFlag, processIncludes) : (processIncludes && XmlIncludeHandler.isXInclude(child2) ? !this.processXmlElements(child2, false, wideFlag, true) : !this.processor.execute(child2))))) {
                return false;
            }
            if (this.targetFile != null && child2 instanceof XmlEntityDecl) {
                XmlEntityDecl xmlEntityDecl = (XmlEntityDecl)child2;
                XmlEntityCache.cacheParticularEntity(this.targetFile, xmlEntityDecl);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_processor", "com/intellij/xml/util/XmlPsiUtil$XmlElementProcessor", "<init>"));
        }
    }
}

