/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaType {
    _string,
    _number,
    _integer,
    _object,
    _array,
    _boolean,
    _null,
    _any,
    _string_number;


    public String getName() {
        return this.name().substring(1);
    }

    public String getDefaultValue() {
        switch (this) {
            case _string: {
                return "\"\"";
            }
            case _number: 
            case _integer: 
            case _string_number: {
                return "0";
            }
            case _object: {
                return "{}";
            }
            case _array: {
                return "[]";
            }
            case _boolean: {
                return "false";
            }
            case _null: {
                return "null";
            }
        }
        return "";
    }

    public boolean isSimple() {
        switch (this) {
            case _string: 
            case _number: 
            case _integer: 
            case _boolean: 
            case _null: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static JsonSchemaType getType(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            JsonSchemaType.$$$reportNull$$$0(0);
        }
        if (value2.isNull()) {
            return _null;
        }
        if (value2.isBooleanLiteral()) {
            return _boolean;
        }
        if (value2.isStringLiteral()) {
            return value2.isNumberLiteral() ? _string_number : _string;
        }
        if (value2.isArray()) {
            return _array;
        }
        if (value2.isObject()) {
            return _object;
        }
        if (value2.isNumberLiteral()) {
            return JsonSchemaType.isInteger(value2.getDelegate().getText()) ? _integer : _number;
        }
        return null;
    }

    public static boolean isInteger(@NotNull String text2) {
        if (text2 == null) {
            JsonSchemaType.$$$reportNull$$$0(1);
        }
        return JsonSchemaType.getIntegerValue(text2) != null;
    }

    @Nullable
    public static Number getIntegerValue(@NotNull String text2) {
        if (text2 == null) {
            JsonSchemaType.$$$reportNull$$$0(2);
        }
        try {
            return Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            try {
                return BigInteger.valueOf(Long.parseLong(text2));
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    public String getDescription() {
        if (this == _any) {
            return "*";
        }
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInteger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntegerValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

