/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestEnumValuesFix
implements LocalQuickFix,
BatchQuickFix {
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public SuggestEnumValuesFix(JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message("replace.with.allowed.value", new Object[0]);
        if (string == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        boolean isJsonPropName;
        if (project == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(3);
        }
        PsiElement initialElement = descriptor2.getPsiElement();
        PsiElement element2 = this.myQuickFixAdapter.adjustValue(initialElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(element2.getContainingFile().getVirtualFile());
        boolean whitespaceBefore = false;
        PsiElement prevPrev = null;
        PsiElement prev2 = element2.getPrevSibling();
        if (prev2 instanceof PsiWhiteSpace) {
            whitespaceBefore = true;
            prevPrev = prev2.getPrevSibling();
        }
        boolean shouldAddWhitespace = this.myQuickFixAdapter.fixWhitespaceBefore(initialElement, element2);
        PsiElement parent = element2.getParent();
        boolean bl = isJsonPropName = parent instanceof JsonProperty && ((JsonProperty)parent).getNameElement() == element2;
        if (isJsonPropName) {
            WriteAction.run(() -> element2.replace((PsiElement)new JsonElementGenerator(project).createStringLiteral("")));
        } else {
            WriteAction.run(() -> element2.delete());
        }
        EditorEx editor2 = EditorUtil.getEditorEx(fileEditor);
        assert (editor2 != null);
        if ((shouldAddWhitespace |= prevPrev != null && PsiUtilCore.getElementType((PsiElement)prevPrev.getNextSibling()) != TokenType.WHITE_SPACE) && whitespaceBefore) {
            WriteAction.run(() -> {
                int offset = editor2.getCaretModel().getOffset();
                editor2.getDocument().insertString(offset, " ");
                editor2.getCaretModel().moveToOffset(offset + 1);
            });
        }
        if (isJsonPropName) {
            editor2.getCaretModel().moveToOffset(((JsonProperty)parent).getNameElement().getTextOffset() + 1);
        }
        CodeCompletionHandlerBase.createHandler(CompletionType.BASIC).invokeCompletion(project, editor2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        Editor editor2;
        if (project == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(4);
        }
        if (psiElementsToIgnore == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(6);
        }
        if ((editor2 = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
            HintManager.getInstance().showErrorHint(editor2, JsonBundle.message("sorry.this.fix.is.not.available.in.batch.mode", new Object[0]));
        } else {
            Messages.showErrorDialog((Project)project, (String)JsonBundle.message("sorry.this.fix.is.not.available.in.batch.mode", new Object[0]), (String)JsonBundle.message("not.applicable.in.batch.mode", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

