/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Urls;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsView;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaConfigurable
extends NamedConfigurable<UserDefinedJsonSchemaConfiguration> {
    private final Project myProject;
    @NotNull
    private final String mySchemaFilePath;
    @NotNull
    private final UserDefinedJsonSchemaConfiguration mySchema;
    @Nullable
    private final TreeUpdater myTreeUpdater;
    @NotNull
    private final Function<? super String, String> myNameCreator;
    private JsonSchemaMappingsView myView;
    private @NlsContexts.ConfigurableName String myDisplayName;
    @Nls
    private String myError;

    public JsonSchemaConfigurable(Project project, @NotNull String schemaFilePath, @NotNull UserDefinedJsonSchemaConfiguration schema2, @Nullable TreeUpdater updateTree, @NotNull Function<? super String, String> nameCreator) {
        if (schemaFilePath == null) {
            JsonSchemaConfigurable.$$$reportNull$$$0(0);
        }
        if (schema2 == null) {
            JsonSchemaConfigurable.$$$reportNull$$$0(1);
        }
        if (nameCreator == null) {
            JsonSchemaConfigurable.$$$reportNull$$$0(2);
        }
        super(true, () -> {
            if (updateTree != null) {
                updateTree.updateTree(true);
            }
        });
        this.myProject = project;
        this.mySchemaFilePath = schemaFilePath;
        this.mySchema = schema2;
        this.myTreeUpdater = updateTree;
        this.myNameCreator = nameCreator;
        this.myDisplayName = this.mySchema.getName();
    }

    @NotNull
    public UserDefinedJsonSchemaConfiguration getSchema() {
        UserDefinedJsonSchemaConfiguration userDefinedJsonSchemaConfiguration = this.mySchema;
        if (userDefinedJsonSchemaConfiguration == null) {
            JsonSchemaConfigurable.$$$reportNull$$$0(3);
        }
        return userDefinedJsonSchemaConfiguration;
    }

    public void setDisplayName(String name2) {
        this.myDisplayName = name2;
    }

    public UserDefinedJsonSchemaConfiguration getEditableObject() {
        return this.mySchema;
    }

    public String getBannerSlogan() {
        return this.mySchema.getName();
    }

    public JComponent createOptionsPanel() {
        if (this.myView == null) {
            this.myView = new JsonSchemaMappingsView(this.myProject, this.myTreeUpdater, (s, force) -> {
                int lastSlash;
                if ((force.booleanValue() || this.isGeneratedName()) && ((lastSlash = Math.max(s.lastIndexOf(47), s.lastIndexOf(92))) > 0 || force.booleanValue())) {
                    int dot;
                    String substring = lastSlash > 0 ? s.substring(lastSlash + 1) : s;
                    int n = dot = lastSlash > 0 ? substring.lastIndexOf(46) : -1;
                    if (dot != -1) {
                        substring = substring.substring(0, dot);
                    }
                    this.setDisplayName((String)this.myNameCreator.fun((Object)substring));
                    this.updateName();
                }
            });
            this.myView.setError(this.myError, true);
        }
        return this.myView.getComponent();
    }

    private boolean isGeneratedName() {
        return this.myDisplayName.equals(this.mySchema.getName()) && this.myDisplayName.equals(this.mySchema.getGeneratedName());
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.json.schema";
    }

    public boolean isModified() {
        if (this.myView == null) {
            return false;
        }
        if (!FileUtil.toSystemDependentName((String)this.mySchema.getRelativePathToSchema()).equals(this.myView.getSchemaSubPath())) {
            return true;
        }
        if (this.mySchema.getSchemaVersion() != this.myView.getSchemaVersion()) {
            return true;
        }
        return !Comparing.equal(this.myView.getData(), this.mySchema.getPatterns());
    }

    public void apply() throws ConfigurationException {
        if (this.myView == null) {
            return;
        }
        this.doValidation();
        this.mySchema.setName(this.myDisplayName);
        this.mySchema.setSchemaVersion(this.myView.getSchemaVersion());
        this.mySchema.setPatterns(this.myView.getData());
        this.mySchema.setRelativePathToSchema(this.myView.getSchemaSubPath());
    }

    public static boolean isValidURL(@NotNull String url) {
        if (url == null) {
            JsonSchemaConfigurable.$$$reportNull$$$0(4);
        }
        return JsonFileResolver.isHttpPath(url) && Urls.parse((String)url, (boolean)false) != null;
    }

    private void doValidation() throws ConfigurationException {
        VirtualFile vFile;
        String filename;
        String schemaSubPath = this.myView.getSchemaSubPath();
        if (StringUtil.isEmptyOrSpaces((String)schemaSubPath)) {
            throw new ConfigurationException((String)(!StringUtil.isEmptyOrSpaces((String)this.myDisplayName) ? this.myDisplayName + ": " : "") + JsonBundle.message("schema.configuration.error.empty.path", new Object[0]));
        }
        if (JsonFileResolver.isHttpPath(schemaSubPath)) {
            filename = schemaSubPath;
            if (!JsonSchemaConfigurable.isValidURL(schemaSubPath)) {
                throw new ConfigurationException((String)(!StringUtil.isEmptyOrSpaces((String)this.myDisplayName) ? this.myDisplayName + ": " : "") + JsonBundle.message("schema.configuration.error.invalid.url", new Object[0]));
            }
            vFile = JsonFileResolver.urlToFile(schemaSubPath);
            if (vFile == null) {
                throw new ConfigurationException((String)(!StringUtil.isEmptyOrSpaces((String)this.myDisplayName) ? this.myDisplayName + ": " : "") + JsonBundle.message("schema.configuration.error.invalid.url.resource", new Object[0]));
            }
        } else {
            File file2;
            File subPath = new File(schemaSubPath);
            File file3 = file2 = subPath.isAbsolute() ? subPath : new File(this.myProject.getBasePath(), schemaSubPath);
            if (!file2.exists() || (vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2)) == null) {
                throw new ConfigurationException((String)(!StringUtil.isEmptyOrSpaces((String)this.myDisplayName) ? this.myDisplayName + ": " : "") + JsonBundle.message("schema.configuration.error.file.does.not.exist", new Object[0]));
            }
            filename = file2.getName();
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myDisplayName)) {
            throw new ConfigurationException(filename + ": " + JsonBundle.message("schema.configuration.error.empty.name", new Object[0]));
        }
        if (vFile instanceof HttpVirtualFile) {
            return;
        }
        String error = JsonSchemaReader.checkIfValidJsonSchema(this.myProject, vFile);
        if (error != null) {
            this.logErrorForUser(error);
            throw new RuntimeConfigurationWarning(error);
        }
    }

    private void logErrorForUser(@NotNull @NlsContexts.NotificationContent String error) {
        if (error == null) {
            JsonSchemaConfigurable.$$$reportNull$$$0(5);
        }
        JsonSchemaReader.ERRORS_NOTIFICATION.createNotification(error, MessageType.WARNING).notify(this.myProject);
    }

    public void reset() {
        if (this.myView == null) {
            return;
        }
        this.myView.setItems(this.mySchemaFilePath, this.mySchema.getSchemaVersion(), this.mySchema.getPatterns());
        this.setDisplayName(this.mySchema.getName());
    }

    public UserDefinedJsonSchemaConfiguration getUiSchema() {
        UserDefinedJsonSchemaConfiguration info2 = new UserDefinedJsonSchemaConfiguration();
        info2.setApplicationDefined(this.mySchema.isApplicationDefined());
        if (this.myView != null && this.myView.isInitialized()) {
            info2.setName(this.getDisplayName());
            info2.setSchemaVersion(this.myView.getSchemaVersion());
            info2.setPatterns(this.myView.getData());
            info2.setRelativePathToSchema(this.myView.getSchemaSubPath());
        } else {
            info2.setName(this.mySchema.getName());
            info2.setSchemaVersion(this.mySchema.getSchemaVersion());
            info2.setPatterns(this.mySchema.getPatterns());
            info2.setRelativePathToSchema(this.mySchema.getRelativePathToSchema());
        }
        return info2;
    }

    public void disposeUIResources() {
        if (this.myView != null) {
            Disposer.dispose((Disposable)this.myView);
        }
    }

    public void setError(@Nls String error, boolean showWarning) {
        this.myError = error;
        if (this.myView != null) {
            this.myView.setError(error, showWarning);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCreator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidURL";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logErrorForUser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

