/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaDialog;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaDriver;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.intellij.plugins.relaxNG.validation.RngValidateHandler;
import org.jetbrains.annotations.NotNull;

public class ConvertSchemaAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertSchemaAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files2 != null && project != null) {
            SchemaType type = ConvertSchemaAction.getInputType(project, files2);
            e.getPresentation().setEnabled(type != null);
            if (type == SchemaType.XML) {
                e.getPresentation().setText(RelaxngBundle.message("relaxng.convert-schema.action.title.xml-files", files2.length));
            } else {
                e.getPresentation().setText(RelaxngBundle.message("relaxng.convert-schema.action.title.non-xml", new Object[0]));
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    private static SchemaType getInputType(Project project, VirtualFile ... files2) {
        if (files2.length == 0) {
            return null;
        }
        VirtualFile file2 = files2[0];
        FileType type = file2.getFileType();
        if (type == XmlFileType.INSTANCE) {
            XmlDocument document;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getRootTag() != null) {
                XmlTag rootTag = document.getRootTag();
                assert (rootTag != null);
                String uri = rootTag.getNamespace();
                if ("http://relaxng.org/ns/structure/1.0".equals(uri) && files2.length == 1) {
                    return SchemaType.RNG;
                }
            }
            if (files2.length > 1) {
                for (VirtualFile virtualFile2 : files2) {
                    if (virtualFile2.getFileType() == XmlFileType.INSTANCE && ConvertSchemaAction.getInputType(project, virtualFile2) == null) continue;
                    return null;
                }
            }
            return SchemaType.XML;
        }
        if (type == DTDFileType.INSTANCE && files2.length == 1) {
            return SchemaType.DTD;
        }
        if (type == RncFileType.getInstance() && files2.length == 1) {
            return SchemaType.RNC;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertSchemaAction.$$$reportNull$$$0(1);
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (file2 != null && project != null) {
            VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            assert (files2 != null);
            SchemaType type = ConvertSchemaAction.getInputType(project, files2);
            ConvertSchemaDialog dialog2 = new ConvertSchemaDialog(project, type, file2);
            if (!dialog2.showAndGet()) {
                return;
            }
            RngValidateHandler.saveFiles(files2);
            ConvertSchemaSettings settings = dialog2.getSettings();
            IdeaErrorHandler errorHandler2 = new IdeaErrorHandler(project);
            new IdeaDriver(settings, project).convert(type, errorHandler2, files2);
            VirtualFile output2 = LocalFileSystem.getInstance().findFileByIoFile(new File(settings.getOutputDestination()));
            if (output2 != null) {
                output2.refresh(false, true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/intellij/plugins/relaxNG/convert/ConvertSchemaAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

