/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.MultiInputFormat;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.input.parse.compact.CompactParseInputFormat;
import com.thaiopensource.relaxng.input.parse.sax.SAXParseInputFormat;
import com.thaiopensource.relaxng.input.xml.XmlInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.output.dtd.DtdOutputFormat;
import com.thaiopensource.relaxng.output.rnc.RncOutputFormat;
import com.thaiopensource.relaxng.output.rng.RngOutputFormat;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.util.UriOrFile;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdeaDriver {
    private static final int DEFAULT_LINE_LENGTH = 72;
    private static final int DEFAULT_INDENT = 2;
    private final ConvertSchemaSettings settings;
    private final Project myProject;

    public IdeaDriver(ConvertSchemaSettings settings, Project project) {
        this.settings = settings;
        this.myProject = project;
    }

    public void convert(SchemaType inputType, IdeaErrorHandler errorHandler2, VirtualFile ... inputFiles) {
        if (inputFiles.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            String name2;
            int ext;
            SchemaCollection sc;
            InputFormat inFormat = IdeaDriver.getInputFormat(inputType);
            if (inputFiles.length > 1 && !(inFormat instanceof MultiInputFormat)) {
                throw new IllegalArgumentException();
            }
            VirtualFile inputFile = inputFiles[0];
            SchemaType type = this.settings.getOutputType();
            String outputType = StringUtil.toLowerCase((String)type.toString());
            ArrayList<CallSite> inputParams = new ArrayList<CallSite>();
            if (inputType != SchemaType.DTD) {
                Charset charset = inputFile.getCharset();
                inputParams.add((CallSite)((Object)("encoding=" + charset.name())));
            }
            ArrayList outputParams = new ArrayList();
            this.settings.addAdvancedSettings(inputParams, outputParams);
            String input = inputFile.getPath();
            String uri = UriOrFile.toUri((String)input);
            try {
                if (inFormat instanceof MultiInputFormat) {
                    MultiInputFormat format2 = (MultiInputFormat)inFormat;
                    String[] uris = new String[inputFiles.length];
                    for (int i2 = 0; i2 < inputFiles.length; ++i2) {
                        uris[i2] = UriOrFile.toUri((String)inputFiles[i2].getPath());
                    }
                    sc = format2.load(uris, ArrayUtilRt.toStringArray(inputParams), outputType, (ErrorHandler)((Object)errorHandler2));
                } else {
                    sc = inFormat.load(uri, ArrayUtilRt.toStringArray(inputParams), outputType, (ErrorHandler)((Object)errorHandler2));
                }
            }
            catch (IOException e) {
                errorHandler2.fatalError(new SAXParseException(e.getMessage(), null, uri, -1, -1, e));
                return;
            }
            File destination = new File(this.settings.getOutputDestination());
            final File outputFile = destination.isDirectory() ? new File(destination, ((ext = (name2 = new File(input).getName()).lastIndexOf(46)) > 0 ? name2.substring(0, ext) : name2) + "." + outputType) : destination;
            try {
                int indent = this.settings.getIndent();
                int length = this.settings.getLineLength();
                LocalOutputDirectory od = new LocalOutputDirectory(sc.getMainUri(), outputFile, "." + outputType, this.settings.getOutputEncoding(), length > 0 ? length : 72, indent > 0 ? indent : 2){

                    public OutputDirectory.Stream open(String sourceUri, String encoding) throws IOException {
                        String s = this.reference(null, sourceUri);
                        File file2 = new File(outputFile.getParentFile(), s);
                        if (file2.exists()) {
                            String msg = RelaxngBundle.message("relaxng.convert-schema.dialog.file-exists.message", file2.getAbsolutePath());
                            int choice = Messages.showYesNoDialog((Project)IdeaDriver.this.myProject, (String)msg, (String)RelaxngBundle.message("relaxng.convert-schema.dialog.file-exists.title", new Object[0]), (Icon)Messages.getWarningIcon());
                            if (choice == 0) {
                                return super.open(sourceUri, encoding);
                            }
                            if (choice == 1) {
                                throw new CanceledException();
                            }
                        }
                        return super.open(sourceUri, encoding);
                    }
                };
                OutputFormat of = IdeaDriver.getOutputFormat(this.settings.getOutputType());
                of.output(sc, (OutputDirectory)od, ArrayUtilRt.toStringArray(outputParams), StringUtil.toLowerCase((String)inputType.toString()), (ErrorHandler)((Object)errorHandler2));
            }
            catch (IOException e) {
                errorHandler2.fatalError(new SAXParseException(e.getMessage(), null, UriOrFile.fileToUri((File)outputFile), -1, -1, e));
            }
        }
        catch (CanceledException inFormat) {
        }
        catch (SAXParseException e) {
            errorHandler2.error(e);
        }
        catch (MalformedURLException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
        catch (InputFailedException inputFailedException) {
        }
        catch (InvalidParamsException invalidParamsException) {
        }
        catch (OutputFailedException outputFailedException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private static OutputFormat getOutputFormat(SchemaType outputType) {
        switch (outputType) {
            case DTD: {
                return new DtdOutputFormat();
            }
            case RNC: {
                return new RncOutputFormat();
            }
            case RNG: {
                return new RngOutputFormat();
            }
            case XSD: {
                return new XsdOutputFormat();
            }
        }
        assert (false) : "Unsupported output type: " + outputType;
        return null;
    }

    private static InputFormat getInputFormat(SchemaType type) {
        switch (type) {
            case DTD: {
                return new DtdInputFormat();
            }
            case RNC: {
                return new CompactParseInputFormat();
            }
            case RNG: {
                return new SAXParseInputFormat();
            }
            case XML: {
                return new XmlInputFormat();
            }
        }
        assert (false) : "Unsupported input type: " + type;
        return null;
    }

    private static class CanceledException
    extends RuntimeException {
        private CanceledException() {
        }
    }
}

