/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.Include;
import org.intellij.plugins.relaxNG.model.annotation.CommonAnnotationHolder;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineRenderer;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineSearcher;
import org.intellij.plugins.relaxNG.model.annotation.OverridingDefineRenderer;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngDomElement;
import org.jetbrains.annotations.NotNull;

public final class ModelAnnotator
implements Annotator,
DomElementsAnnotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ModelAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ModelAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof CommonElement) {
            ((CommonElement)psiElement).accept(new MyAnnotator(CommonAnnotationHolder.create(holder)));
        }
    }

    public void annotate(DomElement element2, DomElementAnnotationHolder holder) {
        if (element2 instanceof RngDomElement) {
            ((RngDomElement)element2).accept(new MyAnnotator(CommonAnnotationHolder.create(holder)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/relaxNG/model/annotation/ModelAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyAnnotator<T>
    extends CommonElement.Visitor {
        private final CommonAnnotationHolder<T> myHolder;

        MyAnnotator(CommonAnnotationHolder<T> holder) {
            this.myHolder = holder;
        }

        public void visitDefine(Define define) {
            Object element2 = define.getPsiElement();
            if (element2 != null) {
                XmlFile xmlFile = (XmlFile)element2.getContainingFile();
                SmartList result2 = new SmartList();
                final OverriddenDefineSearcher searcher2 = new OverriddenDefineSearcher(define, xmlFile, (List<? super Define<?, ?>>)result2);
                PsiElementProcessor.FindElement<XmlFile> processor2 = new PsiElementProcessor.FindElement<XmlFile>((List)result2){
                    final /* synthetic */ List val$result;
                    {
                        this.val$result = list2;
                    }

                    public boolean execute(@NotNull XmlFile file2) {
                        Grammar grammar;
                        if (file2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((grammar = GrammarFactory.getGrammar(file2)) == null) {
                            return true;
                        }
                        grammar.acceptChildren(searcher2);
                        return this.val$result.size() == 0 || super.execute((PsiElement)file2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/model/annotation/ModelAnnotator$MyAnnotator$1", "execute"));
                    }
                };
                RelaxIncludeIndex.processBackwardDependencies(xmlFile, (PsiElementProcessor<? super XmlFile>)processor2);
                if (processor2.isFound()) {
                    this.createGutterAnnotation(define, new OverriddenDefineRenderer(define));
                }
            }
        }

        private void createGutterAnnotation(CommonElement t, @NotNull GutterIconRenderer renderer2) {
            if (renderer2 == null) {
                MyAnnotator.$$$reportNull$$$0(0);
            }
            this.myHolder.createAnnotation(HighlightSeverity.INFORMATION, t, null, renderer2);
        }

        @Override
        public void visitInclude(Include inc) {
            Define[] overrides;
            for (Define define : overrides = inc.getOverrides()) {
                Map<String, Set<Define>> map2;
                Grammar grammar;
                PsiFile file2 = inc.getInclude();
                if (!(file2 instanceof XmlFile) || (grammar = GrammarFactory.getGrammar((XmlFile)file2)) == null || (map2 = DefinitionResolver.getAllVariants(grammar)) == null) continue;
                Set<Define> set2 = map2.get(define.getName());
                if (set2 == null || set2.size() == 0) {
                    this.myHolder.createAnnotation(HighlightSeverity.ERROR, define, RelaxngBundle.message("relaxng.annotator.definition-doesnt-override-anything-from", file2.getName()), null);
                    continue;
                }
                String message2 = RelaxngBundle.message("relaxng.annotator.overrides.x.in.y", define.getName(), file2.getName());
                this.createGutterAnnotation(define, new OverridingDefineRenderer(message2, set2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/intellij/plugins/relaxNG/model/annotation/ModelAnnotator$MyAnnotator", "createGutterAnnotation"));
        }
    }
}

