/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncInclude;
import org.jetbrains.annotations.NotNull;

public class RelaxIncludeProvider
extends FileIncludeProvider {
    @Override
    @NotNull
    public String getId() {
        return "relax-ng";
    }

    @Override
    public boolean acceptFile(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            RelaxIncludeProvider.$$$reportNull$$$0(0);
        }
        return (type = file2.getFileType()) == XmlFileType.INSTANCE || type == RncFileType.getInstance();
    }

    @Override
    public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            RelaxIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)XmlFileType.INSTANCE);
        fileTypeSink.consume((Object)RncFileType.getInstance());
    }

    @Override
    public FileIncludeInfo @NotNull [] getIncludeInfos(@NotNull FileContent content2) {
        ArrayList infos;
        if (content2 == null) {
            RelaxIncludeProvider.$$$reportNull$$$0(2);
        }
        if (content2.getFileType() == XmlFileType.INSTANCE) {
            CharSequence inputDataContentAsText = content2.getContentAsText();
            if (CharArrayUtil.indexOf((CharSequence)inputDataContentAsText, (CharSequence)"http://relaxng.org/ns/structure/1.0", (int)0) == -1) {
                if (FileIncludeInfo.EMPTY == null) {
                    RelaxIncludeProvider.$$$reportNull$$$0(3);
                }
                return FileIncludeInfo.EMPTY;
            }
            infos = new ArrayList();
            NanoXmlUtil.parse(CharArrayUtil.readerFromCharSequence((CharSequence)content2.getContentAsText()), (IXMLBuilder)new RngBuilderAdapter(infos));
        } else if (content2.getFileType() == RncFileType.getInstance()) {
            infos = new ArrayList();
            content2.getPsiFile().acceptChildren((PsiElementVisitor)new RncElementVisitor(){

                @Override
                public void visitElement(RncElement element2) {
                    element2.acceptChildren(this);
                }

                @Override
                public void visitInclude(RncInclude include) {
                    String path2 = include.getFileReference();
                    if (path2 != null) {
                        infos.add(new FileIncludeInfo(path2));
                    }
                }
            });
        } else {
            if (FileIncludeInfo.EMPTY == null) {
                RelaxIncludeProvider.$$$reportNull$$$0(4);
            }
            return FileIncludeInfo.EMPTY;
        }
        FileIncludeInfo[] fileIncludeInfoArray = infos.toArray(FileIncludeInfo.EMPTY);
        if (fileIncludeInfoArray == null) {
            RelaxIncludeProvider.$$$reportNull$$$0(5);
        }
        return fileIncludeInfoArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/resolve/RelaxIncludeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/resolve/RelaxIncludeProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeInfos";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RngBuilderAdapter
    implements NanoXmlBuilder {
        boolean isRNG;
        boolean isInclude;
        private final ArrayList<? super FileIncludeInfo> myInfos;

        RngBuilderAdapter(ArrayList<? super FileIncludeInfo> infos) {
            this.myInfos = infos;
        }

        @Override
        public void startElement(String name2, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            boolean isRngTag = "http://relaxng.org/ns/structure/1.0".equals(nsURI);
            if (!this.isRNG) {
                if (isRngTag) {
                    this.isRNG = true;
                } else {
                    throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
                }
            }
            this.isInclude = isRngTag && "include".equals(name2);
        }

        @Override
        public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) throws Exception {
            if (this.isInclude && "href".equals(key)) {
                this.myInfos.add((FileIncludeInfo)new FileIncludeInfo(value2));
            }
        }

        @Override
        public void endElement(String name2, String nsPrefix, String nsURI) throws Exception {
            this.isInclude = false;
        }
    }
}

