/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.SuitableRoot;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ&\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020\u0016J&\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u0007Rl\u0010\u0005\u001aZ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \b*,\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRT\u0010\r\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011RT\u0010\u0012\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u0013 \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0015\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u0013 \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "parentToSuitableRoot", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/builtInWebServer/SuitableRoot;", "getParentToSuitableRoot$intellij_platform_builtInServer_impl", "()Lcom/github/benmanes/caffeine/cache/LoadingCache;", "pathToExistShortTermCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "getPathToExistShortTermCache$intellij_platform_builtInServer_impl", "()Lcom/github/benmanes/caffeine/cache/Cache;", "pathToInfoCache", "Lorg/jetbrains/builtInWebServer/PathInfo;", "getPathToInfoCache$intellij_platform_builtInServer_impl", "virtualFileToPathInfo", "Lcom/intellij/openapi/vfs/VirtualFile;", "clearCache", "", "doFindByRelativePath", "path", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "doFindByRelativePath$intellij_platform_builtInServer_impl", "findVirtualFile", "cacheResult", "getPath", "file", "getPathInfo", "child", "getResolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "Companion", "intellij.platform.builtInServer.impl"})
public final class WebServerPathToFileManager {
    private final Cache<String, PathInfo> pathToInfoCache;
    private final Cache<VirtualFile, PathInfo> virtualFileToPathInfo;
    private final Cache<String, Boolean> pathToExistShortTermCache;
    private final LoadingCache<String, List<SuitableRoot>> parentToSuitableRoot;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final Cache<String, PathInfo> getPathToInfoCache$intellij_platform_builtInServer_impl() {
        return this.pathToInfoCache;
    }

    public final Cache<String, Boolean> getPathToExistShortTermCache$intellij_platform_builtInServer_impl() {
        return this.pathToExistShortTermCache;
    }

    public final LoadingCache<String, List<SuitableRoot>> getParentToSuitableRoot$intellij_platform_builtInServer_impl() {
        return this.parentToSuitableRoot;
    }

    private final void clearCache() {
        this.pathToInfoCache.invalidateAll();
        this.virtualFileToPathInfo.invalidateAll();
        this.pathToExistShortTermCache.invalidateAll();
        this.parentToSuitableRoot.invalidateAll();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path2, boolean cacheResult, @NotNull PathQuery pathQuery) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        PathInfo pathInfo = this.getPathInfo(path2, cacheResult, pathQuery);
        return pathInfo != null ? pathInfo.getOrResolveVirtualFile() : null;
    }

    public static /* synthetic */ VirtualFile findVirtualFile$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, PathQuery pathQuery, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            pathQuery = WebServerPathToFileManagerKt.getDefaultPathQuery();
        }
        return webServerPathToFileManager.findVirtualFile(string, bl, pathQuery);
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path2, boolean cacheResult) {
        return WebServerPathToFileManager.findVirtualFile$default(this, path2, cacheResult, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path2) {
        return WebServerPathToFileManager.findVirtualFile$default(this, path2, false, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path2, boolean cacheResult, @NotNull PathQuery pathQuery) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        PathInfo pathInfo = (PathInfo)this.pathToInfoCache.getIfPresent((Object)path2);
        if (pathInfo == null || !pathInfo.isValid()) {
            if (Intrinsics.areEqual((Object)((Boolean)this.pathToExistShortTermCache.getIfPresent((Object)path2)), (Object)false)) {
                return null;
            }
            pathInfo = this.doFindByRelativePath$intellij_platform_builtInServer_impl(path2, pathQuery);
            if (cacheResult) {
                if (pathInfo != null && pathInfo.isValid()) {
                    this.pathToInfoCache.put((Object)path2, (Object)pathInfo);
                } else {
                    this.pathToExistShortTermCache.put((Object)path2, (Object)false);
                }
            }
        }
        return pathInfo;
    }

    public static /* synthetic */ PathInfo getPathInfo$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, PathQuery pathQuery, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            pathQuery = WebServerPathToFileManagerKt.getDefaultPathQuery();
        }
        return webServerPathToFileManager.getPathInfo(string, bl, pathQuery);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path2, boolean cacheResult) {
        return WebServerPathToFileManager.getPathInfo$default(this, path2, cacheResult, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path2) {
        return WebServerPathToFileManager.getPathInfo$default(this, path2, false, null, 6, null);
    }

    @Nullable
    public final String getPath(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PathInfo pathInfo = this.getPathInfo(file2);
        return pathInfo != null ? pathInfo.getPath() : null;
    }

    @Nullable
    public final PathInfo getPathInfo(@NotNull VirtualFile child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
        PathInfo result2 = (PathInfo)this.virtualFileToPathInfo.getIfPresent((Object)child2);
        if (result2 == null) {
            Object v1;
            block3: {
                Stream stream = WebServerRootsProvider.Companion.getEP_NAME().extensions();
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"WebServerRootsProvider.EP_NAME.extensions()");
                Sequence sequence = SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<WebServerRootsProvider, PathInfo>(this, child2){
                    final /* synthetic */ WebServerPathToFileManager this$0;
                    final /* synthetic */ VirtualFile $child;

                    @Nullable
                    public final PathInfo invoke(WebServerRootsProvider it) {
                        return it.getPathInfo(this.$child, WebServerPathToFileManager.access$getProject$p(this.this$0));
                    }
                    {
                        this.this$0 = webServerPathToFileManager;
                        this.$child = virtualFile2;
                        super(1);
                    }
                }));
                boolean bl = false;
                Sequence sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    PathInfo it = (PathInfo)e;
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            result2 = v1;
            if (result2 != null) {
                this.virtualFileToPathInfo.put((Object)child2, (Object)result2);
            }
        }
        return result2;
    }

    @Nullable
    public final PathInfo doFindByRelativePath$intellij_platform_builtInServer_impl(@NotNull String path2, @NotNull PathQuery pathQuery) {
        PathInfo result2;
        block3: {
            Object v1;
            boolean bl;
            Sequence sequence;
            block2: {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
                List list2 = WebServerRootsProvider.Companion.getEP_NAME().getExtensionList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"WebServerRootsProvider.EP_NAME.extensionList");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<WebServerRootsProvider, PathInfo>(this, path2, pathQuery){
                    final /* synthetic */ WebServerPathToFileManager this$0;
                    final /* synthetic */ String $path;
                    final /* synthetic */ PathQuery $pathQuery;

                    @Nullable
                    public final PathInfo invoke(WebServerRootsProvider it) {
                        return it.resolve(this.$path, WebServerPathToFileManager.access$getProject$p(this.this$0), this.$pathQuery);
                    }
                    {
                        this.this$0 = webServerPathToFileManager;
                        this.$path = string;
                        this.$pathQuery = pathQuery;
                        super(1);
                    }
                }));
                bl = false;
                Sequence sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    PathInfo it = (PathInfo)e;
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    v1 = e;
                    break block2;
                }
                v1 = null;
            }
            PathInfo pathInfo = v1;
            if (pathInfo == null) {
                return null;
            }
            result2 = pathInfo;
            VirtualFile virtualFile2 = result2.getFile();
            if (virtualFile2 == null) break block3;
            sequence = virtualFile2;
            bl = false;
            boolean bl4 = false;
            Sequence it = sequence;
            boolean bl5 = false;
            this.virtualFileToPathInfo.put((Object)it, (Object)result2);
        }
        return result2;
    }

    @NotNull
    public final FileResolver getResolver(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        CharSequence charSequence = path2;
        boolean bl = false;
        return charSequence.length() == 0 ? (FileResolver)WebServerPathToFileManagerKt.access$getEMPTY_PATH_RESOLVER$p() : (FileResolver)WebServerPathToFileManagerKt.access$getRELATIVE_PATH_RESOLVER$p();
    }

    public WebServerPathToFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.pathToInfoCache = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.virtualFileToPathInfo = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        this.pathToExistShortTermCache = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(5L, TimeUnit.SECONDS).build();
        this.parentToSuitableRoot = Caffeine.newBuilder().maximumSize(16384L).expireAfterAccess(10L, TimeUnit.MINUTES).build(new CacheLoader(this){
            final /* synthetic */ WebServerPathToFileManager this$0;

            @Nullable
            public final List<SuitableRoot> load(String path2) {
                SmartList suitableRoots = new SmartList();
                String moduleQualifier = null;
                boolean $i$f$runReadAction = false;
                Module[] modules2 = (Module[])ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ parentToSuitableRoot.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)WebServerPathToFileManager.access$getProject$p(this.this$0.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                        return (T)moduleManager.getModules();
                    }
                });
                for (RootProvider rootProvider : RootProvider.values()) {
                    Module[] moduleArray = modules2;
                    int n = moduleArray.length;
                    for (int j = 0; j < n; ++j) {
                        Module module;
                        Module module2 = module = moduleArray[j];
                        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                        if (module2.isDisposed()) continue;
                        for (VirtualFile root2 : rootProvider.getRoots(ProjectUtil.getRootManager((Module)module))) {
                            if (root2.findChild(path2) == null) continue;
                            if (moduleQualifier == null) {
                                moduleQualifier = DefaultWebServerRootsProviderKt.getModuleNameQualifier(WebServerPathToFileManager.access$getProject$p(this.this$0), module);
                            }
                            suitableRoots.add((Object)new SuitableRoot(root2, moduleQualifier));
                        }
                    }
                }
                return (List)suitableRoots;
            }
            {
                this.this$0 = webServerPathToFileManager;
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this.project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        Intrinsics.checkNotNullExpressionValue((Object)((VFileContentChangeEvent)vFileEvent).getFile(), (String)"event.file");
                        for (WebServerRootsProvider rootsProvider : (WebServerRootsProvider[])WebServerRootsProvider.Companion.getEP_NAME().getExtensions()) {
                            VirtualFile file2;
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file2)) continue;
                            this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    this.clearCache();
                    break;
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.clearCache();
            }
        });
        this.project.getMessageBus().connect().subscribe(AdditionalLibraryRootsListener.TOPIC, (Object)new AdditionalLibraryRootsListener(){

            public final void libraryRootsChanged(@Nullable String $noName_0, @NotNull Collection<? extends VirtualFile> $noName_1, @NotNull Collection<? extends VirtualFile> $noName_2, @NotNull String $noName_3) {
                Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                Intrinsics.checkNotNullParameter($noName_2, (String)"<anonymous parameter 2>");
                Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"<anonymous parameter 3>");
                this.clearCache();
            }
        });
    }

    public static final /* synthetic */ Project access$getProject$p(WebServerPathToFileManager $this) {
        return $this.project;
    }

    @JvmStatic
    @NotNull
    public static final WebServerPathToFileManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final WebServerPathToFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(WebServerPathToFileManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (WebServerPathToFileManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

