/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H&J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H&J6\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0018H&J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$H&J\u0012\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u0018H&J\u0012\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$H&J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018H\u0016JB\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H&J \u0010,\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMap;", "", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "hasNameMappings", "", "getHasNameMappings", "()Z", "outFile", "", "getOutFile", "()Ljava/lang/String;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findSourceIndex", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "sourceUrl", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceMappings", "sourceIndex", "getRawSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSourceContent", "getSourceLineByRawLocation", "rawLine", "rawColumn", "getSourceMappingsInLine", "", "sourceLine", "processSourceMappingsInLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "intellij.platform.scriptDebugger.backend"})
public interface SourceMap {
    @Nullable
    public String getOutFile();

    @NotNull
    public Url[] getSources();

    @NotNull
    public Mappings getGeneratedMappings();

    public boolean getHasNameMappings();

    @NotNull
    public SourceResolver getSourceResolver();

    @NotNull
    public Mappings findSourceMappings(int var1);

    public int findSourceIndex(@NotNull Url var1, @Nullable VirtualFile var2, @Nullable Lazy<? extends SourceFileResolver> var3, boolean var4);

    @Nullable
    public Mappings findSourceMappings(@NotNull Url var1, @Nullable VirtualFile var2, @Nullable Lazy<? extends SourceFileResolver> var3, boolean var4);

    public int getSourceLineByRawLocation(int var1, int var2);

    public int findSourceIndex(@NotNull VirtualFile var1, boolean var2);

    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(int var1, int var2);

    public boolean processSourceMappingsInLine(int var1, int var2, @NotNull MappingsProcessorInLine var3);

    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(@NotNull Url var1, int var2, @Nullable VirtualFile var3, @Nullable Lazy<? extends SourceFileResolver> var4, boolean var5);

    @Nullable
    public String getRawSource(@NotNull MappingEntry var1);

    @Nullable
    public String getSourceContent(@NotNull MappingEntry var1);

    @Nullable
    public String getSourceContent(int var1);

    @Metadata(mv={1, 5, 1}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Mappings findSourceMappings(@NotNull SourceMap $this, @NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
            Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
            int sourceIndex = $this.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
            return sourceIndex >= 0 ? $this.findSourceMappings(sourceIndex) : null;
        }

        public static int getSourceLineByRawLocation(@NotNull SourceMap $this, int rawLine, int rawColumn) {
            MappingEntry mappingEntry = $this.getGeneratedMappings().get(rawLine, rawColumn);
            return mappingEntry != null ? mappingEntry.getSourceLine() : -1;
        }

        public static boolean processSourceMappingsInLine(@NotNull SourceMap $this, int sourceIndex, int sourceLine, @NotNull MappingsProcessorInLine mappingProcessor) {
            Intrinsics.checkNotNullParameter((Object)mappingProcessor, (String)"mappingProcessor");
            return mappingProcessor.processIterable($this.getSourceMappingsInLine(sourceIndex, sourceLine));
        }

        @NotNull
        public static Iterable<MappingEntry> getSourceMappingsInLine(@NotNull SourceMap $this, @NotNull Url sourceUrl, int sourceLine, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
            Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
            int sourceIndex = $this.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
            return sourceIndex >= 0 ? $this.getSourceMappingsInLine(sourceIndex, sourceLine) : (Iterable<MappingEntry>)CollectionsKt.emptyList();
        }
    }
}

