/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppIcon;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresNoReadLock;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.StringKt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.InstallPluginService;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0003J\"\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0014J(\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001cH\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/ide/InstallPluginService;", "Lorg/jetbrains/ide/RestService;", "()V", "isAvailable", "", "()Z", "setAvailable", "(Z)V", "trustedHosts", "", "", "trustedPredefinedHosts", "", "checkCompatibility", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "pluginIds", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "getServiceName", "installPlugin", "isHostTrusted", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "Lio/netty/handler/codec/http/HttpRequest;", "productInfo", "writeIDEInfo", "", "out", "Ljava/io/OutputStream;", "intellij.platform.builtInServer.impl"})
public final class InstallPluginService
extends RestService {
    private boolean isAvailable = true;
    private final List<String> trustedHosts;
    private final Set<String> trustedPredefinedHosts;

    @Override
    @NotNull
    protected String getServiceName() {
        return "installPlugin";
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return HttpRequestHandler.OriginCheckResult.ASK_CONFIRMATION;
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    public final void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                pluginId = RestService.Companion.getStringParameter("pluginId", urlDecoder);
                passedPluginIds = RestService.Companion.getStringParameter("pluginIds", urlDecoder);
                action = RestService.Companion.getStringParameter("action", urlDecoder);
                var7_7 = pluginId;
                var8_8 = false;
                var9_10 = false;
                if (var7_7 == null || StringsKt.isBlank((CharSequence)var7_7) != false) {
                    var7_7 = passedPluginIds;
                    var8_8 = false;
                    var9_10 = false;
                    if (var7_7 == null || StringsKt.isBlank((CharSequence)var7_7) != false) {
                        return (String)this.productInfo(request, context);
                    }
                }
                var8_9 = pluginId;
                var9_10 = false;
                var10_11 = false;
                if (var8_9 == null || StringsKt.isBlank((CharSequence)var8_9) != false) {
                    v0 = this.getGson().fromJson(passedPluginIds, new TypeToken<List<? extends String>>(){}.getType());
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"gson.fromJson(passedPlug\u2026ist<String?>?>() {}.type)");
                    v1 = (List)v0;
                } else {
                    v1 = CollectionsKt.listOf((Object)pluginId);
                }
                pluginIds = v1;
                v2 = action;
                if (v2 == null) break block8;
                var8_9 = v2;
                switch (var8_9.hashCode()) {
                    case 1957569947: {
                        if (!var8_9.equals("install")) ** break;
                        break;
                    }
                    case -1762427576: {
                        if (!var8_9.equals("checkCompatibility")) ** break;
                        v3 = (String)this.checkCompatibility(request, context, pluginIds);
                        break block9;
                    }
                }
                v3 = (String)this.installPlugin(request, context, pluginIds);
                break block9;
            }
            v3 = (String)this.productInfo(request, context);
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @RequiresNoReadLock
    private final Void checkCompatibility(FullHttpRequest request2, ChannelHandlerContext context2, List<String> pluginIds2) {
        void $this$mapTo$iv$iv2;
        List $this$map$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = pluginIds2;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        PluginId pluginId = $this$forEach$iv$iv$iv.iterator();
        while (pluginId.hasNext()) {
            PluginId pluginId2;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = pluginId.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PluginId.findId((String)it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PluginId it$iv$iv = pluginId2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void id2;
            pluginId = (PluginId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = id2;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"id");
            Pair pair = TuplesKt.to((Object)v0.getIdString(), (Object)(MarketplaceRequests.getLastCompatiblePluginUpdate$default(MarketplaceRequests.Companion.getInstance(), (PluginId)id2, null, null, 6, null) != null ? 1 : 0));
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        boolean $this$mapTo$iv$iv2 = false;
        List info2 = $this$map$iv;
        boolean bl = false;
        List compatibleUpdatesInfo = info2.size() != 1 ? info2 : CollectionsKt.listOf((Object)TuplesKt.to((Object)"compatible", (Object)((Pair)info2.get(0)).getSecond()));
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        JsonWriter writer = RestService.Companion.createJsonWriter((OutputStream)out);
        writer.beginObject();
        Iterable $this$forEach$iv = compatibleUpdatesInfo;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            void pluginId3;
            Pair it = (Pair)element$iv;
            boolean bl6 = false;
            Pair pair = it;
            element$iv$iv = (String)pair.component1();
            boolean value2 = (Boolean)pair.component2();
            writer.name((String)pluginId3).value(value2);
        }
        writer.endObject();
        writer.close();
        RestService.Companion.send(out, (HttpRequest)request2, context2);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Void installPlugin(FullHttpRequest request2, ChannelHandlerContext context2, List<String> pluginIds2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = pluginIds2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginId pluginId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PluginId.findId((String)it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PluginId it$iv$iv = pluginId;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List plugins2 = (List)destination$iv$iv;
        if (this.isAvailable) {
            this.isAvailable = false;
            Project project = RestService.Companion.getLastFocusedOrOpenedProject();
            if (project == null) {
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
                Project project2 = projectManager.getDefaultProject();
                project = project2;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"ProjectManager.getInstance().defaultProject");
            }
            Project effectiveProject = project;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, effectiveProject, plugins2){
                final /* synthetic */ InstallPluginService this$0;
                final /* synthetic */ Project $effectiveProject;
                final /* synthetic */ List $plugins;

                public final void run() {
                    AppIcon.getInstance().requestAttention(this.$effectiveProject, true);
                    PluginsAdvertiser.installAndEnable(this.$effectiveProject, CollectionsKt.toSet((Iterable)this.$plugins), true, installPlugin.1.INSTANCE);
                    this.this$0.setAvailable(true);
                }
                {
                    this.this$0 = installPluginService;
                    this.$effectiveProject = project;
                    this.$plugins = list2;
                }
            }, effectiveProject.getDisposed());
        }
        RestService.Companion.sendOk(request2, context2);
        return null;
    }

    private final Void productInfo(FullHttpRequest request2, ChannelHandlerContext context2) {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        this.writeIDEInfo((OutputStream)out);
        RestService.Companion.send(out, (HttpRequest)request2, context2);
        return null;
    }

    private final void writeIDEInfo(OutputStream out) {
        JsonWriter writer = RestService.Companion.createJsonWriter(out);
        writer.beginObject();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        String appName = applicationInfoEx.getFullApplicationName();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        BuildNumber build2 = buildNumber;
        if (!PlatformUtils.isIdeaUltimate()) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String productName = applicationNamesInfo.getProductName();
            String string = appName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appName");
            String string2 = productName + " (" + productName + ')';
            String string3 = productName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"productName");
            appName = StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
            appName = StringUtil.trimStart((String)appName, (String)"JetBrains ");
        }
        writer.name("name").value(appName);
        writer.name("buildNumber").value(build2.asString());
        writer.endObject();
        writer.close();
    }

    @Override
    protected boolean isHostTrusted(@NotNull FullHttpRequest request2, @NotNull QueryStringDecoder urlDecoder) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        String origin = NettyKt.getOrigin((HttpRequest)((HttpRequest)request2));
        try {
            string = origin == null ? null : StringKt.nullize$default((String)new URI(origin).getHost(), (boolean)false, (int)1, null);
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        String originHost = string;
        String hostName = NettyKt.getHostName((HttpRequest)((HttpRequest)request2));
        if (hostName != null && !NetUtils.isLocalhost((String)hostName)) {
            RestService.LOG.error("Expected 'request.hostName' to be localhost. hostName='" + hostName + "', origin='" + origin + '\'');
        }
        return originHost != null && (this.trustedPredefinedHosts.contains(originHost) || this.trustedHosts.contains(originHost) || NetUtils.isLocalhost((String)originHost)) || super.isHostTrusted(request2, urlDecoder);
    }

    public InstallPluginService() {
        String string = System.getProperty("idea.api.install.hosts.trusted", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"idea\u2026stall.hosts.trusted\", \"\")");
        this.trustedHosts = StringsKt.split$default((CharSequence)string, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        this.trustedPredefinedHosts = SetsKt.setOf((Object[])new String[]{"marketplace.jetbrains.com", "plugins.jetbrains.com", "package-search.services.jetbrains.com", "package-search.jetbrains.com"});
    }
}

