/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.ide.ToolboxInnerHandler;
import org.jetbrains.ide.ToolboxRestService;
import org.jetbrains.ide.ToolboxRestServiceKt;
import org.jetbrains.ide.ToolboxServiceHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/ide/ToolboxRestService;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "isMethodSupported", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "isSupported", "Companion", "intellij.platform.builtInServer.impl"})
public final class ToolboxRestService
extends RestService {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected String getServiceName() {
        return "toolbox";
    }

    @Override
    public boolean isSupported(@NotNull FullHttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        String string = request2.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.uri()");
        String requestUri = StringsKt.substringBefore$default((String)string, (char)'?', null, (int)2, null);
        if (ToolboxRestServiceKt.access$findToolboxHandlerByUri(requestUri) == null) {
            return false;
        }
        return super.isSupported(request2);
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method2) {
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        return Intrinsics.areEqual((Object)method2, (Object)HttpMethod.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        void toolboxRequest;
        Object $this$runCatching2;
        Object t2;
        JsonReader requestJson22;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Channel channel2 = context2.channel();
        String token2 = System.getProperty("toolbox.notification.token");
        if (token2 == null || Intrinsics.areEqual((Object)request2.headers().get("Authorization"), (Object)("toolbox " + token2)) ^ true) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
            Channel channel3 = channel2;
            Intrinsics.checkNotNullExpressionValue((Object)channel3, (String)"channel");
            RestService.Companion.sendStatus(httpResponseStatus, false, channel3);
            return null;
        }
        try {
            long l;
            JsonObject jsonObject;
            Closeable closeable = (Closeable)RestService.Companion.createJsonReader(request2);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                JsonReader it = (JsonReader)closeable;
                boolean bl3 = false;
                it = JsonParser.parseReader((JsonReader)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            requestJson22 = it;
            String string = urlDecoder.path();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlDecoder.path()");
            ToolboxServiceHandler handler2 = ToolboxRestServiceKt.access$findToolboxHandlerByUri(string);
            if (handler2 == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                Channel channel4 = channel2;
                Intrinsics.checkNotNullExpressionValue((Object)channel4, (String)"channel");
                RestService.Companion.sendStatus(httpResponseStatus, false, channel4);
                return null;
            }
            JsonReader jsonReader = requestJson22;
            Intrinsics.checkNotNullExpressionValue((Object)jsonReader, (String)"requestJson");
            ToolboxInnerHandler toolboxRequest2 = ToolboxRestServiceKt.access$wrapHandler(handler2, (JsonElement)jsonReader);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
            Responses.addCommonHeaders((HttpResponse)((HttpResponse)response));
            response.headers().remove((CharSequence)HttpHeaderNames.ACCEPT_RANGES);
            response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
            response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            HttpHeaders httpHeaders = response.headers();
            CharSequence charSequence = (CharSequence)HttpHeaderNames.LAST_MODIFIED;
            Calendar calendar = Calendar.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
            httpHeaders.set(charSequence, (Object)new Date(calendar.getTimeInMillis()));
            channel2.writeAndFlush((Object)response).get();
            JsonReader $this$castSafelyTo$iv = requestJson22;
            boolean $i$f$castSafelyTo = false;
            JsonReader jsonReader2 = $this$castSafelyTo$iv;
            if (!(jsonReader2 instanceof JsonObject)) {
                jsonReader2 = null;
            }
            if ((jsonObject = (JsonObject)jsonReader2) != null && (jsonObject = jsonObject.get("heartbeatMillis")) != null) {
                l = jsonObject.getAsLong();
            } else {
                String string2 = System.getProperty("toolbox.heartbeat.millis", "5000");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"tool\u2026eartbeat.millis\", \"5000\")");
                String string3 = string2;
                boolean bl4 = false;
                l = Long.parseLong(string3);
            }
            long heartbeatDelay = l;
            requestJson22 = TuplesKt.to((Object)toolboxRequest2, (Object)heartbeatDelay);
        }
        catch (Throwable t2) {
            LOG.warn("Failed to process parameters of " + request2 + ". " + t2.getMessage(), t2);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
            Channel channel5 = channel2;
            Intrinsics.checkNotNullExpressionValue((Object)channel5, (String)"channel");
            RestService.Companion.sendStatus(httpResponseStatus, false, channel5);
            return null;
        }
        Object object = requestJson22;
        ToolboxInnerHandler toolboxInnerHandler = (ToolboxInnerHandler)object.component1();
        long heartbeatDelay = ((Number)object.component2()).longValue();
        object = this;
        boolean requestJson22 = false;
        try {
            t2 = Result.Companion;
            $this$runCatching2 = (ToolboxRestService)((Object)object);
            boolean bl = false;
            $this$runCatching2 = channel2.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
            bl = false;
            t2 = Result.constructor-impl((Object)$this$runCatching2);
        }
        catch (Throwable $this$runCatching2) {
            Result.Companion bl = Result.Companion;
            boolean bl5 = false;
            t2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
        }
        object = this;
        requestJson22 = false;
        try {
            t2 = Result.Companion;
            $this$runCatching2 = (ToolboxRestService)((Object)object);
            boolean bl = false;
            $this$runCatching2 = channel2.config().setOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            bl = false;
            t2 = Result.constructor-impl((Object)$this$runCatching2);
        }
        catch (Throwable $this$runCatching3) {
            Result.Companion bl = Result.Companion;
            boolean bl6 = false;
            t2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching3));
        }
        object = this;
        requestJson22 = false;
        try {
            t2 = Result.Companion;
            $this$runCatching2 = (ToolboxRestService)((Object)object);
            boolean bl = false;
            Boolean bl7 = channel2.config().setOption(ChannelOption.SO_TIMEOUT, (Object)((int)heartbeatDelay * 2));
            boolean bl8 = false;
            t2 = Result.constructor-impl((Object)bl7);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl = false;
            t2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Disposable disposable2 = Disposer.newDisposable((String)"toolbox-service-request");
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable(\"toolbox-service-request\")");
        Disposable lifetime = disposable2;
        ScheduledFuture heartbeat2 = context2.executor().scheduleWithFixedDelay(new Runnable(channel2, lifetime){
            final /* synthetic */ Channel $channel;
            final /* synthetic */ Disposable $lifetime;

            public final void run() {
                try {
                    this.$channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)" ", (Charset)Charsets.UTF_8)).get();
                }
                catch (Throwable t) {
                    ToolboxRestService.access$getLOG$cp().debug("Failed to write next heartbeat. " + t.getMessage(), t);
                    Disposer.dispose((Disposable)this.$lifetime);
                }
            }
            {
                this.$channel = channel2;
                this.$lifetime = disposable2;
            }
        }, heartbeatDelay, heartbeatDelay, TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)lifetime, (Disposable)new Disposable(heartbeat2){
            final /* synthetic */ ScheduledFuture $heartbeat;

            public final void dispose() {
                this.$heartbeat.cancel(false);
            }
            {
                this.$heartbeat = scheduledFuture;
            }
        });
        CompletableFuture callback2 = new CompletableFuture();
        AppExecutorUtil.getAppExecutorService().submit(new Runnable((ToolboxInnerHandler)toolboxRequest, lifetime, callback2){
            final /* synthetic */ ToolboxInnerHandler $toolboxRequest;
            final /* synthetic */ Disposable $lifetime;
            final /* synthetic */ CompletableFuture $callback;

            public final void run() {
                this.$toolboxRequest.handleToolboxRequest(this.$lifetime, (Function1<? super JsonElement, Unit>)((Function1)new Function1<JsonElement, Unit>(this){
                    final /* synthetic */ execute.5 this$0;

                    public final void invoke(@NotNull JsonElement r) {
                        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                        this.this$0.$callback.complete(r);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$toolboxRequest = toolboxInnerHandler;
                this.$lifetime = disposable2;
                this.$callback = completableFuture;
            }
        });
        channel2.closeFuture().addListener(new GenericFutureListener(lifetime){
            final /* synthetic */ Disposable $lifetime;

            public final void operationComplete(Future<? super Void> it) {
                Disposer.dispose((Disposable)this.$lifetime);
            }
            {
                this.$lifetime = disposable2;
            }
        });
        ((CompletableFuture)callback2.exceptionally((Function)execute.7.INSTANCE)).thenAcceptAsync(new Consumer(this, heartbeat2, lifetime, channel2){
            final /* synthetic */ ToolboxRestService this$0;
            final /* synthetic */ ScheduledFuture $heartbeat;
            final /* synthetic */ Disposable $lifetime;
            final /* synthetic */ Channel $channel;

            public final void accept(@Nullable JsonElement json) {
                boolean bl;
                Object $this$runCatching2;
                Object object;
                ToolboxRestService toolboxRestService = this.this$0;
                boolean bl2 = false;
                try {
                    object = Result.Companion;
                    $this$runCatching2 = toolboxRestService;
                    boolean bl3 = false;
                    this.$heartbeat.cancel(false);
                    $this$runCatching2 = this.$heartbeat.await();
                    bl3 = false;
                    object = Result.constructor-impl((Object)$this$runCatching2);
                }
                catch (Throwable $this$runCatching2) {
                    Result.Companion bl3 = Result.Companion;
                    bl = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
                }
                if (Disposer.isDisposed((Disposable)this.$lifetime)) {
                    toolboxRestService = this.this$0;
                    bl2 = false;
                    try {
                        object = Result.Companion;
                        $this$runCatching2 = toolboxRestService;
                        boolean bl4 = false;
                        $this$runCatching2 = this.$channel.close();
                        bl4 = false;
                        object = Result.constructor-impl((Object)$this$runCatching2);
                    }
                    catch (Throwable $this$runCatching3) {
                        Result.Companion bl4 = Result.Companion;
                        bl = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching3));
                    }
                    return;
                }
                toolboxRestService = this.this$0;
                bl2 = false;
                try {
                    object = Result.Companion;
                    $this$runCatching2 = toolboxRestService;
                    boolean bl5 = false;
                    $this$runCatching2 = (Void)this.$channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)$this$runCatching2.getGson().toJson(json), (Charset)Charsets.UTF_8)).get();
                    bl5 = false;
                    object = Result.constructor-impl((Object)$this$runCatching2);
                }
                catch (Throwable $this$runCatching4) {
                    Result.Companion bl5 = Result.Companion;
                    bl = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching4));
                }
                toolboxRestService = this.this$0;
                bl2 = false;
                try {
                    object = Result.Companion;
                    $this$runCatching2 = toolboxRestService;
                    boolean bl6 = false;
                    Void void_ = (Void)this.$channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).get();
                    boolean bl7 = false;
                    object = Result.constructor-impl((Object)void_);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    bl = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Disposer.dispose((Disposable)this.$lifetime);
            }
            {
                this.this$0 = toolboxRestService;
                this.$heartbeat = scheduledFuture;
                this.$lifetime = disposable2;
                this.$channel = channel2;
            }
        }, (Executor)AppExecutorUtil.getAppExecutorService());
        return null;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolboxRestService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/ide/ToolboxRestService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        private static /* synthetic */ void getLOG$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

