/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BinaryRequestHandler;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.socket.SocketClient;

public final class RpcBinaryRequestHandler
extends BinaryRequestHandler
implements ExceptionHandler,
ClientListener {
    private static final Logger LOG = Logger.getInstance(RpcBinaryRequestHandler.class);
    private static final UUID ID = UUID.fromString("69957EEB-AFB8-4036-A9A8-00D2D022F9BD");
    private final NotNullLazyValue<ClientManager> clientManager = NotNullLazyValue.atomicLazy(() -> {
        ClientManager result2 = new ClientManager(this, this, null);
        Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
        assert (serverDisposable != null);
        Disposer.register((Disposable)serverDisposable, (Disposable)result2);
        this.rpcServer = new JsonRpcServer(result2);
        return result2;
    });
    private JsonRpcServer rpcServer;

    public static JsonRpcServer getRpcServerInstance() {
        return ((RpcBinaryRequestHandler)BinaryRequestHandler.EP_NAME.findExtension(RpcBinaryRequestHandler.class)).getServer();
    }

    @NotNull
    private JsonRpcServer getServer() {
        this.clientManager.getValue();
        JsonRpcServer jsonRpcServer = this.rpcServer;
        if (jsonRpcServer == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(0);
        }
        return jsonRpcServer;
    }

    @NotNull
    public UUID getId() {
        UUID uUID = ID;
        if (uUID == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(1);
        }
        return uUID;
    }

    @NotNull
    public ChannelHandler getInboundHandler(@NotNull ChannelHandlerContext context2) {
        if (context2 == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(2);
        }
        SocketClient client2 = new SocketClient(context2.channel());
        context2.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client2);
        ((ClientManager)this.clientManager.getValue()).addClient(client2);
        this.connected(client2, null);
        return new MyDecoder(client2);
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e) {
        if (e == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(3);
        }
        LOG.error(e);
    }

    @Override
    public void connected(@NotNull Client client2, @Nullable Map<String, List<String>> parameters2) {
        if (client2 == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void disconnected(@NotNull Client client2) {
        if (client2 == null) {
            RpcBinaryRequestHandler.$$$reportNull$$$0(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInboundHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exceptionCaught";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disconnected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDecoder
    extends MessageDecoder {
        private State state;
        private final SocketClient client;

        MyDecoder(SocketClient client2) {
            if (client2 == null) {
                MyDecoder.$$$reportNull$$$0(0);
            }
            this.state = State.LENGTH;
            this.client = client2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void messageReceived(@NotNull ChannelHandlerContext context2, @NotNull ByteBuf input) {
            if (context2 == null) {
                MyDecoder.$$$reportNull$$$0(1);
            }
            if (input == null) {
                MyDecoder.$$$reportNull$$$0(2);
            }
            block9: while (true) {
                switch (this.state) {
                    case LENGTH: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 4, context2);
                        if (buffer == null) {
                            return;
                        }
                        this.state = State.CONTENT;
                        this.contentLength = buffer.readInt();
                    }
                    case CONTENT: {
                        CharSequence content2 = this.readChars(input);
                        if (content2 == null) {
                            return;
                        }
                        try {
                            RpcBinaryRequestHandler.this.rpcServer.messageReceived(this.client, content2);
                            continue block9;
                        }
                        catch (Throwable e) {
                            ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).getExceptionHandler().exceptionCaught(e);
                            continue block9;
                        }
                        finally {
                            this.contentLength = 0;
                            this.state = State.LENGTH;
                            continue block9;
                        }
                    }
                }
            }
        }

        public void channelInactive(ChannelHandlerContext context2) {
            Client client2 = (Client)((Object)context2.channel().attr(ClientManagerKt.getCLIENT()).get());
            if (client2 != null) {
                ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).disconnectClient(context2.channel(), client2, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$MyDecoder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "messageReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum State {
        LENGTH,
        CONTENT;

    }
}

