/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.MessageChannelHandler;
import org.jetbrains.io.webSocket.WebSocketClient;

public abstract class WebSocketHandshakeHandler
extends HttpRequestHandler
implements ClientListener,
ExceptionHandler {
    private static final Logger LOG = Logger.getInstance(WebSocketHandshakeHandler.class);
    private final NotNullLazyValue<ClientManager> clientManager = NotNullLazyValue.atomicLazy(() -> {
        ClientManager result2 = new ClientManager(this, this, null);
        Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
        assert (serverDisposable != null);
        Disposer.register((Disposable)serverDisposable, (Disposable)result2);
        this.serverCreated(result2);
        return result2;
    });

    public boolean isSupported(@NotNull FullHttpRequest request2) {
        if (request2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(0);
        }
        return request2.method() == HttpMethod.GET && "WebSocket".equalsIgnoreCase(request2.headers().getAsString((CharSequence)HttpHeaderNames.UPGRADE)) && request2.uri().length() > 2;
    }

    protected void serverCreated(@NotNull ClientManager server) {
        if (server == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e) {
        if (e == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(2);
        }
        NettyUtil.log((Throwable)e, (Logger)LOG);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        if (urlDecoder == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(3);
        }
        if (request2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(5);
        }
        this.handleWebSocketRequest(context2, request2, urlDecoder);
        return true;
    }

    private void handleWebSocketRequest(final @NotNull ChannelHandlerContext context2, @NotNull FullHttpRequest request2, final @NotNull QueryStringDecoder uriDecoder) {
        WebSocketServerHandshakerFactory factory2;
        WebSocketServerHandshaker handshaker;
        if (context2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(6);
        }
        if (request2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(7);
        }
        if (uriDecoder == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(8);
        }
        if ((handshaker = (factory2 = new WebSocketServerHandshakerFactory("ws://" + request2.headers().getAsString((CharSequence)HttpHeaderNames.HOST) + uriDecoder.path(), null, false, NettyUtil.MAX_CONTENT_LENGTH)).newHandshaker((HttpRequest)request2)) == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)context2.channel());
            return;
        }
        if (!context2.channel().isOpen()) {
            return;
        }
        final WebSocketClient client2 = new WebSocketClient(context2.channel(), handshaker);
        context2.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client2);
        handshaker.handshake(context2.channel(), request2).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) {
                if (future2.isSuccess()) {
                    ClientManager clientManager = (ClientManager)WebSocketHandshakeHandler.this.clientManager.getValue();
                    clientManager.addClient(client2);
                    MessageChannelHandler messageChannelHandler = new MessageChannelHandler(clientManager, WebSocketHandshakeHandler.this.getMessageServer());
                    BuiltInServer.Companion.replaceDefaultHandler(context2, (ChannelHandler)messageChannelHandler);
                    ChannelHandlerContext messageChannelHandlerContext = context2.pipeline().context((ChannelHandler)messageChannelHandler);
                    context2.pipeline().addBefore(messageChannelHandlerContext.name(), "webSocketFrameAggregator", (ChannelHandler)new WebSocketFrameAggregator(NettyUtil.MAX_CONTENT_LENGTH));
                    messageChannelHandlerContext.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client2);
                    WebSocketHandshakeHandler.this.connected(client2, uriDecoder.parameters());
                }
            }
        });
    }

    @NotNull
    protected abstract MessageServer getMessageServer();

    @Override
    public void connected(@NotNull Client client2, @Nullable Map<String, List<String>> parameters2) {
        if (client2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlDecoder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uriDecoder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/webSocket/WebSocketHandshakeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "serverCreated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "exceptionCaught";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "handleWebSocketRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "connected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

