/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.clientlogin;

import com.google.api.client.googleapis.auth.clientlogin.AuthKeyValueParser;
import com.google.api.client.googleapis.auth.clientlogin.ClientLoginResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Key;
import com.google.api.client.util.StringUtils;
import com.google.api.client.util.Strings;
import java.io.IOException;

@Beta
public final class ClientLogin {
    public HttpTransport transport;
    public GenericUrl serverUrl = new GenericUrl("https://www.google.com");
    @Key(value="source")
    public String applicationName;
    @Key(value="service")
    public String authTokenType;
    @Key(value="Email")
    public String username;
    @Key(value="Passwd")
    public String password;
    @Key
    public String accountType;
    @Key(value="logintoken")
    public String captchaToken;
    @Key(value="logincaptcha")
    public String captchaAnswer;

    public Response authenticate() throws IOException {
        GenericUrl url = this.serverUrl.clone();
        url.appendRawPath("/accounts/ClientLogin");
        HttpRequest request = this.transport.createRequestFactory().buildPostRequest(url, new UrlEncodedContent(this));
        request.setParser(AuthKeyValueParser.INSTANCE);
        request.setContentLoggingLimit(0);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            return response.parseAs(Response.class);
        }
        HttpResponseException.Builder builder = new HttpResponseException.Builder(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
        ErrorInfo details = response.parseAs(ErrorInfo.class);
        String detailString = details.toString();
        StringBuilder message = HttpResponseException.computeMessageBuffer(response);
        if (!Strings.isNullOrEmpty(detailString)) {
            message.append(StringUtils.LINE_SEPARATOR).append(detailString);
            builder.setContent(detailString);
        }
        builder.setMessage(message.toString());
        throw new ClientLoginResponseException(builder, details);
    }

    public static String getAuthorizationHeaderValue(String authToken) {
        return "GoogleLogin auth=" + authToken;
    }

    public static final class ErrorInfo {
        @Key(value="Error")
        public String error;
        @Key(value="Url")
        public String url;
        @Key(value="CaptchaToken")
        public String captchaToken;
        @Key(value="CaptchaUrl")
        public String captchaUrl;
    }

    public static final class Response
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        @Key(value="Auth")
        public String auth;

        public String getAuthorizationHeaderValue() {
            return ClientLogin.getAuthorizationHeaderValue(this.auth);
        }

        @Override
        public void initialize(HttpRequest request) {
            request.setInterceptor(this);
        }

        @Override
        public void intercept(HttpRequest request) {
            request.getHeaders().setAuthorization(this.getAuthorizationHeaderValue());
        }
    }
}

